<?php include_once('header.php'); ?>
<?php
/*
	* id
    * date
    * trans id
    * event
    * user
    * ar number
    * status
*/
$_searchOpts = array(
  'ticket_id' 						=> 'ID',
  'ticket_date_entered' 	=> 'Date Entered',
  'ticket_transaction_id'	=> 'Transaction ID',
  'event_title'				=> 'Event',
  'username'					=> 'User',
  'ticket_acknowledgment_receipt'	=> 'AR Number',
  'ticket_status'		=> 'Status'
);
?>
<div class="content">

    <div class="listing">
        <h2>Tickets</h2>
        <?php echo $pagination?>
         <div class="filters">
        <?php echo form_open('tickets/listing/'); ?>
        <span>
          <label>Search Key </label>
          <?php echo form_dropdown('search_item', $_searchOpts,  @issetVal($search_item),' style="width:auto!important"'); ?>
        </span>
        <span>
          <label>Value: </label>
          <input type="text" name="search_value" value="<?php echo @issetVal($search_value)?>" maxlength="100" />
        </span>        
        <button type="submit" class="search-button">Search</button>
        <?php echo form_close();?>
        </div>
        
        <?php if (@issetNE($has_search)) :?>
        <span>
       <!-- Total of <?php echo issetVal($total_search_results,0); ?> results. <?php echo anchor('tickets/listing', 'Clear search items...')?> -->
        </span>
        <?php endif ?>
	    <table width="100%">
            <tr>
                <th>ID</th>
                <th>Date Entered</th>
                <th>Trans ID</th>
				<th>Event</th>
				<th>Section/Row/Seat</th>
				<th>Type</th>
				<th>User</th>
				<th>AR</th>
				<th>Date</th>
                <th>Status</th>
                <th>Void</th>
            </tr>
       
            <?php foreach($tickets as $ticket): ?>
            <tr>
                <td><?php echo $ticket->ticket_id; ?></td>
                <td><?php echo mysqldatetime_to_date($ticket->ticket_date_entered, $format = "m/d/y h:ia") ?></td>
                <td><?php echo anchor('/transactions/view/'.$ticket->ticket_transaction_id, $ticket->ticket_transaction_id);?></td>
                <td><?php echo $ticket->event_title; ?></td>
				<td><?php echo $ticket->section_code; ?>/<?php echo $ticket->ticket_row; ?>/<?php echo $ticket->ticket_seat; ?></td>
				<td><?php echo $ticket->ticket_type_code; ?></td>
				<td><?php if ($ticket->username) echo anchor('users/view/'.$ticket->user_id, $ticket->username);?></td>
				<td><?php echo $ticket->ticket_acknowledgment_receipt; ?></td>
				<td>
				<?php
				  $date_status = false;
				  $date_status_msg = '';
				  switch($ticket->ticket_status) {
				    case 'done':
					  $date_status_msg = 'Printed: ';
					  $date_status = $ticket->ticket_date_printed;
					  break;
					case 'reserved':
					  $date_status_msg = 'Reserved: ';
					  $date_status = $ticket->ticket_date_reserved;
					  break;
					case 'cancelled':case 'reservation_cancelled': case 'voided':
					  $date_status_msg = 'Cancelled: ';
					  $date_status = $ticket->ticket_date_cancelled;
					  break;
				  }
				  if ($date_status)
				    echo $date_status_msg . mysqldatetime_to_date($date_status, $format = "m/d/y");
				?>
				</td>
                <td><?php echo $ticket->ticket_status; ?></td>
                <td>
				<?php if ($ticket->ticket_status == 'done' && $this->session->userdata('user_type')!='Finance' && $this->session->userdata('user_type')!='Manager'):?>
					<?php echo anchor('tickets/void/' . $ticket->ticket_id . '/' . $this->uri->segment(3), 'Void', array('onclick'=>"return confirm('Are you sure you want to void this ticket? This will also adjust the ticket count and make the seat available again.');")); ?></td>
                <?php endif; ?>
            </tr>
            <?php endforeach ?>
        </table>
        <?php echo $pagination?>
    </div>

</div> <!-- content -->

<?php include_once('footer.php'); ?>