<?php include_once('header.php'); ?>

<div class="content">
	<h2>Add Ticket Type</h2>
    <div class="form_page">
        <?php echo (validation_errors()) ? '<div class="errors">Error!  Please review the information below.</div>' : ''; ?>
        
        <?php echo form_open('ticket_types/add/'); ?>

        <div class="half_page">
        	<h3>Ticket Type Info</h3>

            <p>
                <label for="ticket_type_code">Code:</label> 
                <input type="text" name="ticket_type_code" value="<?php echo set_value('ticket_type_code')?>" maxlength="100" />
                <?php echo form_error('ticket_type_code');?>
            </p>
            
            <p>
                <label for="ticket_type_name">Name:</label> 
                <input type="text" name="ticket_type_name" value="<?php echo set_value('ticket_type_name')?>" maxlength="100" />
                <?php echo form_error('ticket_type_name');?>
            </p>
			
			<p>
                <label for="ticket_type_discount_type">Discount Type:</label> 
                <?php echo form_dropdown('ticket_type_discount_type', $this->config->item('discount_types'), set_value('ticket_type_discount_type')); ?>
                <?php echo form_error('ticket_type_discount_type');?>
            </p>
			           
            <p>
                <label for="ticket_type_discount">Discount:</label> 
                <input type="text" name="ticket_type_discount" value="<?php echo set_value('ticket_type_discount')?>" maxlength="100" />
                <?php echo form_error('ticket_type_discount');?>
            </p>
			
			<p>
                <label for="ticket_type_group">Promoter Ticket Type:</label> 
                <input type="checkbox" name="ticket_type_group" value="1"<?php echo set_checkbox('ticket_type_group', '1'); ?> />
                <?php echo form_error('ticket_type_group');?>
            </p>
						
			<p>
                <label for="ticket_type_active">Active:</label> 
                <input type="checkbox" name="ticket_type_active" value="1" <?php echo set_checkbox('ticket_type_group', '1'); ?> checked />
                <?php echo form_error('ticket_type_active');?>
            </p>
		
                
            <p class="submit_button">
            	<label for="submit">&nbsp;</label> 
                <button type="submit">Add Ticket Type</button> or <?php echo anchor('ticket_types/listing', 'Cancel'); ?>
            </p>
		</div>        
        </form>
		
		<div class="clearfix"></div>
    </div>

</div> <!-- content -->

<?php include_once('footer.php'); ?>