<?php include_once('header.php'); ?>

<div class="content">
	<h2>Add Ticket Layout</h2>
    
    <?php if (in_array($this->session->userdata('user_type'), array('Admin','Super Admin','Admin2'))): ?>
    <ul class="crud clearfix">
        <li><?php echo anchor('events/view/'.$event->event_id, 'View Event', array('class' => 'view'))?></li>
        <li><?php echo anchor('events/edit/'.$event->event_id, 'Edit Event', array('class' => 'calendar'))?></li>
        <li><?php echo anchor('events/edit_charges/'.$event->event_id, 'Charges', array('class' => 'money'))?></li>
        <li><?php echo anchor('events/edit_ticket_types/'.$event->event_id, 'Ticket Types', array('class' => 'contract'))?></li>
        <li><?php echo anchor('seatplans/view/'.$event->event_seatplan_id.'/'.$event->event_id, 'Seat Plan', array('class' => 'calendar'))?></li>
        <li><?php echo anchor('prices/listing/'.$event->event_id, 'Prices', array('class' => 'money'))?></li>
        <li><?php echo anchor('ticket_layouts/edit/'.$event->event_id, 'Ticket Layout', array('class' => 'calendar'))?></li>
    </ul>
    <?php endif; ?>
    
    
    <div class="form_page">
        <?php echo (validation_errors()) ? '<div class="errors">Error!  Please review the information below.</div>' : ''; ?>
        
        <?php echo form_open('ticket_layouts/add/'.$this->uri->segment(3)); ?>

		<h3>Ticket Layouts Info</h3>
        <div class="full_page inline_form_fields">
            <p>
                <label for="ticket_logo_1">Logo 1:</label> 
                <?php echo form_dropdown('ticket_logo_1', $logos, set_value('ticket_logo_1')); ?>
                <?php echo form_error('ticket_logo_1');?>
            </p>
			
			<p>
                <label for="ticket_logo_2">Logo 2:</label> 
                <?php echo form_dropdown('ticket_logo_2', $logos, set_value('ticket_logo_2')); ?>
                <?php echo form_error('ticket_logo_2');?>
            </p>
            
			<p>
                <label for="ticket_logo_3">Logo 3:</label> 
                <?php echo form_dropdown('ticket_logo_3', $logos, set_value('ticket_logo_3')); ?>
                <?php echo form_error('ticket_logo_3');?>
            </p>

			<p>
                <label for="ticket_logo_4">Logo 4:</label> 
                <?php echo form_dropdown('ticket_logo_4', $logos, set_value('ticket_logo_4')); ?>
                <?php echo form_error('ticket_logo_4');?>
            </p>
            
            <p>
                <label for="ticket_logo_5">Logo 5:</label> 
                <?php echo form_dropdown('ticket_logo_5', $logos, set_value('ticket_logo_5')); ?>
                <?php echo form_error('ticket_logo_5');?>
            </p>

			<p>
                <label for="ticket_text_1">Line 1:</label> 
                <input type="text" name="ticket_text_1" value="<?php echo set_value('ticket_text_1')?>" maxlength="100" />
                <?php echo form_dropdown('ticket_font_face_1', $this->config->item('ticket_font_faces'), set_value('ticket_font_face_1')); ?>
                <?php echo form_dropdown('ticket_font_size_1', $this->config->item('font_sizes'), set_value('ticket_font_size_1')); ?>
                <?php echo form_error('ticket_text_1');?>
            </p>
			
			<p>
                <label for="ticket_text_2">Line 2:</label> 
                <input type="text" name="ticket_text_2" value="<?php echo set_value('ticket_text_2')?>" maxlength="100" />
                <?php echo form_dropdown('ticket_font_face_2', $this->config->item('ticket_font_faces'), set_value('ticket_font_face_2')); ?>
                <?php echo form_dropdown('ticket_font_size_2', $this->config->item('font_sizes'), set_value('ticket_font_size_2')); ?>
                <?php echo form_error('ticket_text_2');?>
            </p>
            
            <p>
                <label for="ticket_text_3">Line 3:</label> 
                <input type="text" name="ticket_text_3" value="<?php echo set_value('ticket_text_3')?>" maxlength="100" />
                <?php echo form_dropdown('ticket_font_face_3', $this->config->item('ticket_font_faces'), set_value('ticket_font_face_3')); ?>
                <?php echo form_dropdown('ticket_font_size_3', $this->config->item('font_sizes'), set_value('ticket_font_size_3')); ?>
                <?php echo form_error('ticket_text_3');?>
            </p>
            
            <p>
                <label for="ticket_text_4">Line 4:</label> 
                <input type="text" name="ticket_text_4" value="<?php echo set_value('ticket_text_4')?>" maxlength="100" />
                <?php echo form_dropdown('ticket_font_face_4', $this->config->item('ticket_font_faces'), set_value('ticket_font_face_4')); ?>
                <?php echo form_dropdown('ticket_font_size_4', $this->config->item('font_sizes'), set_value('ticket_font_size_4')); ?>
                <?php echo form_error('ticket_text_4');?>
            </p>
            
            <p>
                <label for="ticket_text_5">Line 5:</label> 
                <input type="text" name="ticket_text_5" value="<?php echo set_value('ticket_text_5')?>" maxlength="100" />
                <?php echo form_dropdown('ticket_font_face_5', $this->config->item('ticket_font_faces'), set_value('ticket_font_face_5')); ?>
                <?php echo form_dropdown('ticket_font_size_5', $this->config->item('font_sizes'), set_value('ticket_font_size_5')); ?>
                <?php echo form_error('ticket_text_5');?>
            </p>
            
            <p>
                <label for="ticket_text_6">Line 6:</label> 
                <input type="text" name="ticket_text_6" value="<?php echo set_value('ticket_text_6')?>" maxlength="100" />
                <?php echo form_dropdown('ticket_font_face_6', $this->config->item('ticket_font_faces'), set_value('ticket_font_face_6')); ?>
                <?php echo form_dropdown('ticket_font_size_6', $this->config->item('font_sizes'), set_value('ticket_font_size_6')); ?>
                <?php echo form_error('ticket_text_6');?>
            </p>
            
            <p>
                <label for="ticket_text_7">Line 7:</label> 
                <input type="text" name="ticket_text_7" value="<?php echo set_value('ticket_text_7')?>" maxlength="100" />
                <?php echo form_dropdown('ticket_font_face_7', $this->config->item('ticket_font_faces'), set_value('ticket_font_face_7')); ?>
                <?php echo form_dropdown('ticket_font_size_7', $this->config->item('font_sizes'), set_value('ticket_font_size_7')); ?>
                <?php echo form_error('ticket_text_7');?>
            </p>
                
            <p class="submit_button">
            	<label for="submit">&nbsp;</label> 
                <button type="submit">Save Ticket Layout</button> or <?php echo anchor('ticket_layouts/listing', 'Cancel'); ?>
            </p>
		</div>        
        </form>
		
		<div class="clearfix"></div>
    </div>

</div> <!-- content -->

<?php include_once('footer.php'); ?>