<?php include_once('header.php'); 
	$brh_array = array();
	$get_branch_names = $this->db->query("select branch_id, branch_name from branches");

	foreach ($get_branch_names->result() as $row)
	{
		$brh_array[$row->branch_id] = $row->branch_name;
	}
?>
    <div class="content">
      <div class="listing">
        <h2>Reservation List</h2>
        <?php echo $pagination?>

        <div class="filters">
        <?php echo form_open('reservations/listing/'); ?>
        <span>
          <label> Reservation #: </label>
          <input type="text" name="ticket_transaction_id" value="<?php echo $ticket_transaction_id?>" maxlength="100" />
        </span>
        <span>
          <label> Name: </label>
          <input type="text" name="name" value="<?php echo $name?>" maxlength="100" />
        </span>
		
		<?php if($this->session->userdata('user_type') != 'Seller'){ ?>
        <span>
          <label>Event Name</label>
          <input type="text" name="event_title" value="<?php echo $event_title?>" maxlength="100" />
         </span>
        <span>
          <label>Event Type</label>
          <input type="text" name="event_type" value="<?php echo $event_type?>" maxlength="100" />
         </span>
        <?php } ?>
        <button type="submit" class="search-button">Search</button>
        <?php echo form_close();?>
        </div>

        
        <table width="100%">
          <tr>
            <th width="30">ID</th>
            <th>Name</th>
            <th>Event Title</th>
            <th>Section</th>
            <!--th>Mobile Number</th-->
            <th>Reservation Date</th>
            <th>Expiry Date</th>
            <th>Reservation Branch</th>
			<?php if($this->session->userdata('user_type') != 'Finance'){ ?>
            <th width="150">Action</th>
			<?php } ?>
          </tr>
          <?php foreach($reservations as $reservation): ?>
          <tr>
            <td><?php echo $reservation->transaction_id; ?></td>
            <td><?php echo anchor('reservations/view/'.$reservation->transaction_id, $reservation->customer_firstname .' ' .$reservation->customer_lastname);?></td>
            <td><?php echo $reservation->event_long_title ?></td>
            <td><?php echo $reservation->section_name ?></td>
            <!--td><?php echo $reservation->customer_mobile; ?></td-->
            <td><?php echo date("m/d/Y", strtotime($reservation->transaction_date)); ?></td>
            <td><?php echo date("m/d/Y", strtotime($reservation->ticket_reservation_expiry)); ?></td>
            <td>
            	<?php 
            		if (isset($brh_array[$reservation->transaction_branch_id]))
					{
						echo $brh_array[$reservation->transaction_branch_id];
					}
					
					if ($reservation->transaction_branch_id != $reservation->ticket_branch_id)
					{
						if (isset($brh_array[$reservation->ticket_branch_id]))
						{
							echo " / ";
							echo $brh_array[$reservation->ticket_branch_id];
						}
					}
            	?>
            </td>
			<?php if($this->session->userdata('user_type') != 'Finance'){ ?>
            <td><?php
				if(in_array($this->session->userdata('user_type'), array('Admin','Super Admin','Admin2','Reservation-Admin','Seller'))){
				echo anchor('transactions/ticket_types/claim/'.$reservation->transaction_id, 'Claim').' | '; } ?> <?php echo anchor('reservations/extend/'.$reservation->transaction_id, 'Extend'); ?> | <?php echo anchor('reservations/cancel/'.$reservation->transaction_id.'/expire', 'Cancel'); ?></td>
			<?php } ?>
          </tr>
          <?php endforeach ?>
        </table>
        <?php echo $pagination?> </div>
    </div>
    <!-- content -->
    <?php include_once('footer.php'); ?>