<?php include_once('header.php'); ?>
<script type="text/javascript">
$(function () {
Array.prototype.forEach.call(document.body.querySelectorAll("*[data-mask]"), applyDataMask);




function applyDataMask(field) {
    var mask = field.dataset.mask.split('');
    
    // For now, this just strips everything that's not a number
    function stripMask(maskedData) {
        function isDigit(char) {
            return /\d/.test(char);
        }
        return maskedData.split('').filter(isDigit);
    }
    
    // Replace `_` characters with characters from `data`
    function applyMask(data) {
        return mask.map(function(char) {
            if (char != '_') return char;
            if (data.length == 0) return char;
            return data.shift();
        }).join('')
    }
    
    function reapplyMask(data) {
        return applyMask(stripMask(data));
    }
    
    function changed() {   
        var oldStart = field.selectionStart;
        var oldEnd = field.selectionEnd;
        
        field.value = reapplyMask(field.value);
        
        field.selectionStart = oldStart;
        field.selectionEnd = oldEnd;
    }
    
    field.addEventListener('click', changed)
    field.addEventListener('keyup', changed)
}
});
</script>
<div class="content">
	<h2>Add Promoter</h2>
    <div class="form_page">
        <?php echo (validation_errors()) ? '<div class="errors">Error!  Please review the information below.</div>' : ''; ?>
        
        <?php echo form_open('promoters/add/'); ?>

        <div class="half_page">
        	<h3>Promoter Info</h3>	
			
			<p>
                <label for="promoters_username">Promoter Code:*</label> 
                <input type="text" name="promoters_username" value="<?php echo set_value('promoters_username')?>" maxlength="100" />
                <?php echo form_error('promoters_username');?>
            </p>
            
            <p>
                <label for="promoters_name">Company Name:*</label> 
                <input type="text" name="promoters_name" value="<?php echo set_value('promoters_name')?>" maxlength="100" />
                <?php echo form_error('promoters_name');?>
            </p>

            <p>
                <label for="promoters_signatory">Signatory:*</label> 
                <input type="text" name="promoters_signatory" value="<?php echo set_value('promoters_signatory')?>" maxlength="100" />
                <?php echo form_error('promoters_signatory');?>
            </p>
            
            <p>
                <label for="promoters_position">Position:*</label> 
                <input type="text" name="promoters_position" value="<?php echo set_value('promoters_position')?>" maxlength="100" />
                <?php echo form_error('promoters_position');?>
            </p>
            
			<p>
                <label for="promoters_tin">TIN:*</label> 
                <input type="text" name="promoters_tin" value="<?php echo set_value('promoters_tin')?>" maxlength="100" />
                <?php echo form_error('promoters_tin');?>
            </p>
            <p>
                <label for="promoters_vendor_key">Vendor Key(For SAP):</label> 
                <input type="text" name="promoters_vendor_key" value="2111080" maxlength="100" />
                <?php echo form_error('promoters_vendor_key');?>
            </p>
			
            <!--h3>Login Info</h3>
            <p>
                <label for="promoters_username">Username:</label> 
                <input type="text" name="promoters_username" value="<?php echo set_value('promoters_username')?>" maxlength="100" />
                <?php echo form_error('promoters_username');?>
            </p>
            
            <p>
                <label for="promoters_password">Password:</label> 
                <input type="password" name="promoters_password" value="<?php echo set_value('promoters_password')?>" maxlength="100" />
                <?php echo form_error('promoters_password');?>
            </p-->
            
            
			
            
            <!--h3>Community Tax Certificate</h3>
            <p>
                <label for="promoters_ctc_number">CTC Number:*</label>
				<input type="text" name="promoters_ctc_number" value="<?php echo set_value('promoters_ctc_number')?>" maxlength="100" />
                <?php echo form_error('promoters_ctc_number');?>
            </p>
			
			<p>
                <label for="promoters_ctc_date">CTC Date Issued:</label>
                <input type="text" name="promoters_ctc_date" placeholder="YYYY-MM-DD" value="<?php echo set_value('promoters_ctc_date')?>" maxlength="100" />
                <?php echo form_error('promoters_ctc_date');?>
            </p>
			
			<p>
                <label for="promoters_ctc_place">CTC Place Issued:</label>
                <input type="text" name="promoters_ctc_place" value="<?php echo set_value('promoters_ctc_place')?>" maxlength="100" />
                <?php echo form_error('promoters_ctc_place');?>
            </p-->

            
		</div>
        <div class="half_page float_right">
            
            
            
            
            
            <h3>Contact Info</h3>
            
            <p>
                <label for="promoters_address1">Address 1:</label>
                <input type="text" name="promoters_address1" value="<?php echo set_value('promoters_address1')?>" maxlength="100" />
                <?php echo form_error('promoters_address1');?>
            </p>
			
			<p>
                <label for="promoters_address2">Address 2:</label>
                <input type="text" name="promoters_address2" value="<?php echo set_value('promoters_address2')?>" maxlength="100" />
                <?php echo form_error('promoters_address2');?>
            </p>
			
			<p>
                <label for="promoters_city">City:</label>
                <input type="text" name="promoters_city" value="<?php echo set_value('promoters_city')?>" maxlength="100" />
                <?php echo form_error('promoters_city');?>
            </p>
			
			<p>
                <label for="promoters_zip">Zip Code:</label>
                <input type="text" name="promoters_zip" value="<?php echo set_value('promoters_zip')?>" maxlength="100" />
                <?php echo form_error('promoters_zip');?>
            </p>
			
			<p>
                <label for="promoters_country">Country:*</label>
                <input type="text" name="promoters_country" value="<?php echo set_value('promoters_country')?>" maxlength="100" />
                <?php echo form_error('promoters_country');?>
            </p>
            
			<p>
                <label for="promoters_phone1">Work Phone 1:</label>
                <input type="text" name="promoters_phone1" value="<?php echo set_value('promoters_phone1')?>" maxlength="100" />
                <?php echo form_error('promoters_phone1');?>
            </p>
			
			<p>
                <label for="promoters_phone2">Work Phone 2:</label>
                <input type="text" name="promoters_phone2" value="<?php echo set_value('promoters_phone2')?>" maxlength="100" />
                <?php echo form_error('promoters_phone2');?>
            </p>
			
			<p>
                <label for="promoters_fax">Fax Number:</label>
                <input type="text" name="promoters_fax" value="<?php echo set_value('promoters_fax')?>" maxlength="100" />
                <?php echo form_error('promoters_fax');?>
            </p>
			
			<p>
                <label for="promoters_mobile">Mobile Number:*</label>
                <input type="text" name="promoters_mobile" value="<?php echo set_value('promoters_mobile')?>" maxlength="100" />
                <?php echo form_error('promoters_mobile');?>
            </p>
			
			<p>
                <label for="promoters_email">Email Address:*</label>
                <input type="text" name="promoters_email" value="<?php echo set_value('promoters_email')?>" maxlength="100" />
                <?php echo form_error('promoters_email');?>
            </p>
			
			<p>
                <label for="promoters_website">Website Address:</label>
                <input type="text" name="promoters_website" value="<?php echo set_value('promoters_website')?>" maxlength="100" />
                <?php echo form_error('promoters_website');?>
            </p>
            
            
               
            <p class="submit_button">
            	<label for="submit">&nbsp;</label> 
                <button type="submit">Add Promoter</button> or <?php echo anchor('promoters/listing', 'Cancel'); ?>
            </p>
						
		</div>        
        </form>
		
		<div class="clearfix"></div>
    </div>

</div> <!-- content -->

<?php include_once('footer.php'); ?>