<?php include_once('header.php'); ?>
<script>
	$(function() {
		$( "#date_from" ).datepicker({ 
				minDate: new Date(2012, 3 - 1, 4),
				minDate: 'Today',
				dateFormat: 'yy-mm-dd',
			}
		);		
		
		
		$( "#date_to" ).datepicker({ 
				minDate: new Date(2012, 3 - 1, 4),
				minDate: 'Today',
				dateFormat: 'yy-mm-dd',
			}
		);
	});

 
</script>
<div class="content">
	<h2><?php echo $event->event_title?></h2>
        
	<?php if (in_array($this->session->userdata('user_type'), array('Admin','Super Admin','Event','Admin2'))): ?>
    <ul class="crud clearfix">
		<?php include_once("inc.eventsmenu.php"); ?> 
    </ul>
    <?php endif; ?>
    
    <div class="form_page">
        <?php echo (validation_errors()) ? '<div class="errors">Error!  Please review the information below.</div>' : ''; ?>
        
        <?php echo form_open('promo_codes/edit/'.$promo_code->promo_code_id); ?>

        <div class="half_page">
        	<h3>Promo Code Info</h3> 
             
            <p>
                <label for="promo_code_name">Name:</label> 
                <input type="text" name="promo_code_name" value="<?php echo set_value('promo_code_name',$promo_code->promo_code_name)?>" maxlength="100" />
                <?php echo form_error('promo_code_name');?>
            </p>
            
            <p>
                <label for="promo_code_code">Promo Code:</label> 
                <input type="text" name="promo_code_code" value="<?php echo set_value('promo_code_code',$promo_code->promo_code_code)?>" maxlength="100" />
                <?php echo form_error('promo_code_code');?>
            </p>
			<p>
                <label for="promo_code_qty">Quantity:</label> 
                <input type="text" name="promo_code_qty" value="<?php echo set_value('promo_code_qty',$promo_code->promo_code_qty)?>" maxlength="100" />
                <?php echo form_error('promo_code_qty');?>
            </p>
			<p>
                <label for="ticket_type">Ticket Type:</label> 
				<?php echo form_dropdown('ticket_type', $ticket_types, set_value('ticket_type', $promo_code->promo_code_ticket_type),'id="ticket_type"'); ?>
                <?php echo form_error('ticket_type');?>
            </p>
			<p>
                <label for="date_from">Date From:</label> 
                <input type="text" name="date_from" id="date_from" value="<?php echo set_value('date_from',$promo_code->promo_code_date_from)?>" maxlength="100" />
                <?php echo form_error('date_from');?>
            </p>
			<p class="form_caption">
                <label for="caption">&nbsp;</label> 
                <small>Date Format: YYYY-MM-DD</small><br>
            </p>
		 
			<p>
                <label for="date_to">Date To:</label> 
                <input type="text" name="date_to" id="date_to" value="<?php echo set_value('date_to',$promo_code->promo_code_date_to)?>" maxlength="100" />
                <?php echo form_error('date_to');?>
            </p>
			
			<p class="form_caption">
                <label for="caption">&nbsp;</label> 
                <small>Date Format: YYYY-MM-DD</small><br>
            </p>
            <p>
                <label for="promo_code_prices[]">Prices:</label> 
                <?php echo form_dropdown('promo_code_prices[]', $prices, set_value('promo_code_prices[]',unserialize($promo_code->promo_code_prices)), 'multiple="multiple" class="multiple_select"'); ?>
                <?php echo form_error('promo_code_prices[]');?>
            </p>
            
            <p>
                <label for="promo_code_price_caption">&nbsp;</label> 
                <small>CTRL+click to select multiple sections</small>
            </p>
                
            <p class="submit_button">
            	<label for="submit">&nbsp;</label> 
                <button type="submit">Save Changes</button> or <?php echo anchor('promo_codes/listing', 'Cancel'); ?>
            </p>
		</div>
       
        </form>
		
		<div class="clearfix"></div>
    </div>

</div> <!-- content -->

<?php include_once('footer.php'); ?>
