<?php include_once('header.php'); ?>

<div class="content">
	<h2><?php echo $event->event_title?></h2>
    
    <?php if (in_array($user_type, array('Admin','Super Admin','Event','Admin2'))): ?>
    <ul class="crud clearfix">
		<?php include_once("inc.eventsmenu.php"); ?> 
    </ul>
    <?php endif; ?>
    
    <div class="form_page">
        <?php echo (validation_errors()) ? '<div class="errors">Error!  Please review the information below.</div>' : ''; ?>
        
        <?php echo form_open('prices/add/'.$event->event_id); ?>

        <div class="half_page">
        	<h3>Price Info</h3>
            <p>
                <label for="event_name">Event:</label> 
                <input type="text" name="event_name" value="<?php echo $event->event_title?>" disabled="true" class="disabled" maxlength="100" />
            </p>
            
            <p>
                <label for="seatplan_name">Seat Plan:</label> 
                <input type="text" name="seatplan_name" value="<?php echo $event->seatplan_name?>" disabled="true" class="disabled" maxlength="100" />
            </p>
            
            <p>
                <label for="price_name">Price Name:</label> 
                <input type="text" name="price_name" value="<?php echo set_value('price_name')?>" maxlength="100" />
                <?php echo form_error('price_name');?>
            </p>
            
			
            <p>
                <label for="price_price">Price Amount:</label> 
                <input type="text" name="price_price" value="<?php echo set_value('price_price')?>" maxlength="100" />
                <?php echo form_error('price_price');?>
            </p>
            <p>
                <label for="price_package">Package:</label> 
                <input type="text" name="price_package" value="<?php echo set_value('price_package')?>" maxlength="2" style="width:50px" />
                <?php echo form_error('price_package');?>
            </p>
 
            <p>
                <label for="price_sections[]">Sections:</label> 
                <?php echo form_dropdown('price_sections[]', $sections, set_value('price_sections[]'), 'multiple="multiple" class="multiple_select"'); ?>
                <?php echo form_error('price_sections[]');?>
            </p>
            
            <p>
                <label for="price_sections_caption">&nbsp;</label> 
                <small>CTRL+click to select multiple sections</small>
            </p>
                
            <p class="submit_button">
            	<label for="submit">&nbsp;</label> 
                <button type="submit">Add Price</button> or <?php echo anchor('prices/listing', 'Cancel'); ?>
            </p>
		</div>
        <div class="half_page float_right seatplan_image">
        	<h3>Seat Plan</h3>
        	<img src="<?php echo base_url() . 'uploads/' . $event->seatplan_image ?>" />
        </div>    
        </form>
		
		<div class="clearfix"></div>
    </div>

</div> <!-- content -->

<?php include_once('footer.php'); ?>