<?php include_once('header.php'); ?>

<script>
	$(document).ready(function() {
		var $calendar = $('#calendar');
		$calendar.datepicker({
			minDate: 1,
			onSelect: function (dateText, inst) {
				addOrRemoveDate(dateText);
			},
			beforeShowDay: function (date) {
				var year = date.getFullYear();
				// months and days are inserted into the array in the form, e.g "01/01/2009", but here the format is "1/1/2009"
				var month = padNumber(date.getMonth() + 1);
				var day = padNumber(date.getDate());
				// This depends on the datepicker's date format
				var dateString = month + "/" + day + "/" + year;

				var gotUsedDate = jQuery.inArray(dateString, used_dates);
				var gotDate = jQuery.inArray(dateString, dates);
				if (gotUsedDate >= 0) {
					// Enable date so it can be deselected. Set style to be highlighted
					return [false, ""];
				}else{
					if(gotDate >= 0){
						return [true, "ui-highlight"];
					}
					$("#calendar_text").val(dates);
				}
				// Dates not in the array are left enabled, but with no extra style
				return [true, ""];
			}
		});
	});
	// Maintain array of dates
	var dates = new Array();
	var used_dates = new Array(); 
	
	<?php if($price_date->price_event_date_dates != FALSE){ ?>
	dates = [<?php echo "'".str_replace(",","','",$price_date->price_event_date_dates)."'" ?>];
	<?php } ?>
	
	<?php if($used_dates != FALSE){ ?>
	used_dates = [<?php echo "'".str_replace(",","','",$used_dates)."'" ?>];
	<?php } ?>
	
	function addDate(date) {
    if (jQuery.inArray(date, dates) < 0) 
        dates.push(date);
	}

	function removeDate(index) {
		dates.splice(index, 1);
	}

	// Adds a date if we don't have it yet, else remove it
	function addOrRemoveDate(date) {
		var index = jQuery.inArray(date, dates);
		if (index >= 0) 
			removeDate(index);
		else 
			addDate(date);
	}

	// Takes a 1-digit number and inserts a zero before it
	function padNumber(number) {
		var ret = new String(number);
		if (ret.length == 1) 
			ret = "0" + ret;
		return ret;
	}
	
</script>

<style>
	.ui-highlight .ui-state-default{background: #3399F3 !important;border-color: #008ae6 !important;color: white !important;font-weight:900;}
</style>


<div class="content">
	<h2><?php echo $event->event_title?></h2>
    
    <?php if (in_array($this->session->userdata('user_type'), array('Admin','Super Admin','Event','Admin2'))): ?>
    <ul class="crud clearfix">
		<?php include_once("inc.eventsmenu.php"); ?> 
    </ul>
    <?php endif; ?>
    
    <div class="form_page" style="margin-top: 20px;">
        <?php echo (validation_errors()) ? '<div class="errors">Error!  Please review the information below.</div>' : ''; ?>
        
        <?php echo form_open('price_event_dates/edit/'.$price_date->price_event_date_id); ?>
		<div class="half_page">
        	<h3>Price Info</h3>
            <p>
                <label for="event_name">Event:</label> 
                <input type="text" name="event_name" value="<?php echo $event->event_title?>" disabled="true" class="disabled" maxlength="100" />
            </p>
                   
            <p>
                <label for="price_event_date_name">Price Date Name:</label> 
                <input type="text" name="price_event_date_name" value="<?php echo set_value('price_event_date_name',$price_date->price_event_date_name)?>" maxlength="100" />
                <?php echo form_error('price_event_date_name');?>
            </p>
			
            <p>
                <label for="price_event_date_price_id[]">Prices:</label> 
                <?php echo form_dropdown('price_event_date_price_id[]', $prices, set_value('price_event_date_price_id[]',unserialize($price_date->price_event_date_price_id)), 'multiple="multiple" class="multiple_select"'); ?>
                <?php echo form_error('price_event_date_price_id[]');?>
            </p>
			
			<p>
                <label for="price_event_date_price_id_caption">&nbsp;</label> 
                <small>CTRL+click to select multiple prices</small>
            </p>
			
            <p>
                <label for="price_event_date_date">Price Dates:</label> 
                <input type="text" style="display:none;" name="price_event_date_date" id="calendar_text" value="<?php echo set_value('price_event_date_date')?>" />
				<div style="display: inline-block" id='calendar' data-language='en'></div>	
				
                <?php echo form_error('price_event_date_date');?>
            </p>
                
            <p class="submit_button">
            	<label for="submit">&nbsp;</label> 
                <button type="submit">Edit Price Date</button> or <?php echo anchor('price_event_dates/listing', 'Cancel'); ?>
            </p>
		</div>	
        </form>
		
		<div class="clearfix"></div>
    </div>

</div> <!-- content -->

<?php include_once('footer.php'); ?>