<?php include_once('header.php'); ?>
<div class="content">
	<h2><?php echo $page_title; ?></h2>
    <div class="form_page">
        <?php echo (validation_errors()) ? '<div class="errors">Error!  Please review the information below.</div>' : ''; ?>
        
        <?php echo form_open($form_url, "target=_blank"); ?>

        <div class="half_page">
        	<h3>Online Transactions</h3>
			
			<p>
                <label for="date_from">From:</label> 
                <input type="text" name="date_from" value="<?php echo set_value('date_from', date('Y-m-d'))?>" maxlength="100" />
                <?php echo form_error('date_from');?>
            </p>
            
            <p class="form_caption">
                <label for="caption">&nbsp;</label> 
                <small>Date Format: YYYY-MM-DD</small>
            </p>
            
            <p>
                <label for="date_to">To:</label> 
                <input type="text" name="date_to" value="<?php echo set_value('date_to', date('Y-m-d'))?>" maxlength="100" />
                <?php echo form_error('date_to');?>
            </p>
			
			<p class="form_caption">
                <label for="caption">&nbsp;</label> 
                <small>Date Format: YYYY-MM-DD</small>
            </p>
			
			<p>
				<label for="event_id">Select Specific Event:</label>
				<?php 
				$events = $this->reports->get_events_dropdown_for_otc();
				echo form_dropdown('event_id', $events, set_value('event_id')); 
				echo form_error('event_id');
				?>
			</p>
			<?php 
			if ($this->session->userdata('user_branch_id') == 1)
			{
			?>
				<p>
					<label for="branch_id">Select Branch:</label>
					<?php 
					$branches = $this->reports->get_branches_dropdown_for_mw();
					echo form_dropdown('branch_id', $branches, '');
					echo form_error('branch_id');
					?>
				</p>
			<?php
			}
			else
			{
			?>
				<p>
					<label for="branch_id">Branch:</label>
					<?php 
					$branch = $this->reports->get_branch($this->session->userdata('user_branch_id'));
					echo $branch->branch_name;
					echo form_error('branch_id');
					?>
				</p>
			<?php
			}
			?>
			<p>
				<label for="user_id">Select Seller:</label>
				<?php 
				$sellers = $this->reports->get_users_by_branch_otc($this->session->userdata('user_branch_id'));
				echo form_dropdown('user_id', $sellers, '');
				echo form_error('user_id');
				?>
			</p>
			
            <p class="submit_button">
            	<label for="submit">&nbsp;</label> 
                <button type="submit" value="view" name="view" id="view">View Reports</button> or <?php echo anchor('', 'Cancel'); ?>
         
				<br />
				<label for="submit">&nbsp;</label>
				<button type="submit" value="dl" name="dl" id="dl">Download Report as CSV</button>
 
            </p>
		</div>        
        </form>
        
        <div class="clearfix"></div>
    </div>

</div> <!-- content -->

<?php include_once('footer.php'); ?>