<?php include_once('header.php'); ?>

<script type="text/javascript">
 
$(document).ready(function() {
 
    //Select all anchor tag with rel set to tooltip
    $('span[rel=tooltip]').mouseover(function(e) {
         
        //Grab the title attribute's value and assign it to a variable
        var tip = $(this).attr('title');    
         
        //Remove the title attribute's to avoid the native tooltip from the browser
        $(this).attr('title','');
         
        //Append the tooltip template and its value
        $(this).append('<div id="tooltip"><div class="tipBody">' + tip + '</div></div>');     
         
        //Set the X and Y axis of the tooltip
        $('#tooltip').css('top', e.pageY + 10 );
        $('#tooltip').css('left', e.pageX + 20 );
         
        //Show the tooltip with faceIn effect
        $('#tooltip').fadeIn('500');
        $('#tooltip').fadeTo('10',0.8);
         
    }).mousemove(function(e) {
        //Keep changing the X and Y axis for the tooltip, thus, the tooltip move along with the mouse
        $('#tooltip').css('top', e.pageY + 10 );
        $('#tooltip').css('left', e.pageX + 20 );
         
    }).mouseout(function() {
        //Put back the title attribute's value
        $(this).attr('title',$('.tipBody').html());
     
        //Remove the appended tooltip template
        $(this).children('div#tooltip').remove(); 
    });
 
});
 


</script>
<style type="text/css">
#tooltip {
    position:absolute;
    z-index:9999;
    color:#fff;
    font-size:12px;
	font-weight: bolder;
    width:180px;
}
#tooltip .tipBody {
	border-radius: 5px 5px; -moz-border-radius: 5px; -webkit-border-radius: 5px;
    background-color:#000;
    padding:5px;
	text-align: center;
}
</style>

<div class="content">

    <div class="listing">
        <h2>Events</h2>

        <?php if (in_array($this->session->userdata('user_type'), array('Admin','Super Admin','Admin2'))): ?>
        
        <span class="listing_crud">
		<?php
			echo anchor('events/all', 'All');
		?>
		&nbsp;
		<?php
			echo anchor('events/active', 'Active');
		?>
		&nbsp;
		<?php
			echo anchor('events/inactive', 'Inactive');
		?>
		&nbsp;
		<?php
			echo anchor('events/current', 'Current');
		?>
		&nbsp; | &nbsp;
		<?php echo anchor('events/add', 'Add Event')?>
		</span>
		<?php endif; ?>
        
        <div class="filters">
        <?php echo form_open('events/test'); ?>
        <span>
          <label>Title: </label>
          <input type="text" name="event_title" value="<?php echo $event_title?>" maxlength="100" />
        </span>
        <span>
          <label> Date: </label>
          <input type="text" name="event_date_time" value="<?php echo $event_date_time?>" maxlength="100" />
        </span>
        <span>
          <label>Event Venue</label>
          <input type="text" name="venue_name" value="<?php echo $venue_name?>" maxlength="100" />
         </span>
        <span>
          <label>Recommended</label>
          <?php echo form_dropdown('event_recommended', array(''=>'', 'no'=>'No', 'yes'=>'Yes'),  @issetVal($event_recommended),' style="width:auto!important"'); ?>          
         </span>
         <!--
        <span>
          <label>Event Status</label>
          <?php echo form_dropdown('event_active', array('1'=>'Active','0'=>'Not Active'),  @issetVal($event_active),' style="width:auto!important"'); ?>          
         </span>
        -->
        <button type="submit" class="search-button">Search</button>
        <?php echo form_close();?>
        </div>
		
		<div class="posters">
			<?php $count = 0; ?>
			<?php foreach($events as $event): ?>
				<?php if ($event->event_recommended == 'yes'): ?>
					<div class="poster">
						<?php echo anchor('events/view/'.$event->event_id, '<img src="'.base_url().'uploads/'.$event->event_image.'" />'); ?>
					</div>
					<?php $count++; ?>
				<?php endif; ?>
				
				<?php if ($count == 5) break; ?>
				
			<?php endforeach; ?>
			<span class="clearfix"></span> 
        </div>
		
        <table width="100%">
            <tr>
           		<th></th>
           		<th>ID</th>
                <th>Title</th>
                <th>Code</th>
				<th>Date</th>
				<!--<th>Performers</th>-->
				<th>Venue</th>
                <?php if (in_array($this->session->userdata('user_type'), array('Admin','Super Admin','Admin2'))): ?>
                <th>Active</th>
                <th>Reco</th>
                <th>Action</th>
                <?php endif; ?>
            </tr>
			<?php $count = 0; 
			ksort($event_array);
			 
			
			?>
            <?php foreach($events as $event): ?>
			
			<?php 
			
			$cap = 0;
			$reg = 0;
 			
			if (isset($event_array[$event->event_id]['event_tix_qty']['cap'])){
			
				$cap = $event_array[$event->event_id]['event_tix_qty']['cap'] ; 
				
			}else{
				$cap = 1; 
			}
			 
			
			if (isset($event_array[$event->event_id]['event_tix_qty']['reg']))
			{
				$reg = $event_array[$event->event_id]['event_tix_qty']['reg']; 
 			}
			else 
			{
				$reg = 0; 
			}
		
		 
			// $cap =  number_format($cap,2);
			// echo $event->event_id . '/' . $reg . '/' . $cap . '<br>';
			
			$percent = ($reg / $cap) * 100;
			
			
			?>
			
			
			
            <tr>
 				
				<?php if($percent == 100){?>
				
					<td nowrap="nowrap" style="background-color:red"></td>
				
				<?php } ?>
				
				<?php if($percent >= 71 && $percent <= 99){?>
				
					<td nowrap="nowrap" style="background-color:orange"></td>
				
				<?php } ?>
				
				<?php if($percent >= 36 && $percent <= 70){?>
				
					<td nowrap="nowrap" style="background-color:yellow"></td>
				
				<?php } ?>
				
				
				<?php if($percent >= 0 && $percent <= 35){?>
				
					<td nowrap="nowrap" style="background-color:green"></td>
				
				<?php } ?>
				
				
				<?php if($cap == 1 || $reg == 0){?>
				
					<!--<td nowrap="nowrap" style="background-color:white"></td>-->
				
				<?php } ?>
				
				
            	<td nowrap="nowrap"><?php echo $event->event_id; ?></td>
                <td nowrap="nowrap"><?php echo anchor('events/view/'.$event->event_id, $event->event_title); ?></td>
                <td nowrap="nowrap"><?php echo $event->event_code; ?></td>
                <td nowrap="nowrap"><?php echo mysqldatetime_to_date($event->event_date_time, $format = "M d, Y h:ia"); ?></td>
                <!--<td><?php echo $event->event_performers; ?></td>-->
				<?php $substr_venue = $event->venue_name; ?>
                <td><span rel="tooltip" title="<?php echo $substr_venue ?>"><?php echo substr($substr_venue,0,5). "..." ?></span></td>
                <?php if (in_array($this->session->userdata('user_type'), array('Admin','Super Admin','Admin2'))): ?>
                <td align="center"><?php echo ($event->event_active == 1) ? 'Yes' : 'No'; ?></td>	
                <td><?php echo ($event->event_recommended == 'yes') ? 'Yes' : 'No'; ?></td>	
                <td nowrap="nowrap">
					<?php echo anchor('events/edit/'.$event->event_id, 'Edit'); ?> |
					<?php echo anchor('events/delete/' .$event->event_id, 'Delete', array('onclick'=>"return confirm('Are you sure you want to delete this event?');")); ?> |
                    
                    <?php if ($event->event_recommended === 'yes') :?>					
						<?php echo anchor('events/unrecommend/' .$event->event_id, 'Unrecommend', array('onclick'=>"return confirm('Are you sure you want to remove this event from the Recommended List?');"));?>                  
                    <?php else : ?>                
						<?php echo anchor('events/recommend/' .$event->event_id, 'Recommend', array('onclick'=>"return confirm('Are you sure you want to add this event to the Recommended List');")); ?>
                    <?php endif; ?>
                    
                    
                    
                </td>
                <?php endif; ?>
            </tr>
			<?php $count++; ?>
			<?php //if ($count == 50) break; ?>
            <?php endforeach ?>
        </table>
    </div>

</div> <!-- content -->

<?php include_once('footer.php'); ?>