<?php include_once('header.php'); ?>

<script type="text/javascript">
 
$(document).ready(function() {
 
    //Select all anchor tag with rel set to tooltip
    $('span[rel=tooltip]').mouseover(function(e) {
         
        //Grab the title attribute's value and assign it to a variable
        var tip = $(this).attr('title');    
         
        //Remove the title attribute's to avoid the native tooltip from the browser
        $(this).attr('title','');
         
        //Append the tooltip template and its value
        $(this).append('<div id="tooltip"><div class="tipBody">' + tip + '</div></div>');     
         
        //Set the X and Y axis of the tooltip
        $('#tooltip').css('top', e.pageY + 10 );
        $('#tooltip').css('left', e.pageX + 20 );
         
        //Show the tooltip with faceIn effect
        $('#tooltip').fadeIn('500');
        $('#tooltip').fadeTo('10',0.8);
         
    }).mousemove(function(e) {
        //Keep changing the X and Y axis for the tooltip, thus, the tooltip move along with the mouse
        $('#tooltip').css('top', e.pageY + 10 );
        $('#tooltip').css('left', e.pageX + 20 );
         
    }).mouseout(function() {
        //Put back the title attribute's value
        $(this).attr('title',$('.tipBody').html());
     
        //Remove the appended tooltip template
        $(this).children('div#tooltip').remove(); 
    });
 
});
 
</script>
<style type="text/css">
#tooltip {
    position:absolute;
    z-index:9999;
    color:#fff;
    font-size:12px;
	font-weight: bolder;
    width:180px;
}
#tooltip .tipBody {
	border-radius: 5px 5px; -moz-border-radius: 5px; -webkit-border-radius: 5px;
    background-color:#000;
    padding:5px;
	text-align: center;
}
</style>

<div class="content">
	<h3 style="color: red;">In compliance with IT security policy , the system will be undergoing a security update.
Users with password below 8 characters are advised to change their passwords.</h3>
	
	
    <div class="listing">
        <h2>Events</h2>

        <?php if (in_array($this->session->userdata('user_type'), array('Admin','Super Admin','Admin2','Event'))): ?>
        
        <span class="listing_crud">
		<?php
			echo anchor('events/all', 'All');
		?>
		&nbsp;
		<?php
			echo anchor('events/active', 'Active');
		?>
		&nbsp;
		<?php
			echo anchor('events/inactive', 'Inactive');
		?>
		&nbsp;
		<?php
			echo anchor('events/current', 'Current');
		?>
		
		<?php 
		if (in_array($user_type, array('Admin','Super Admin'))){
		echo ' | ';
		echo anchor('events/add', 'Add Event');
		}
		
		?>
		</span>
		<?php endif; ?>
        
        <div class="filters">
        <?php echo form_open('events'); ?>
		<span>
          <label>Title: </label>
          <input type="text" name="event_title" value="<?php echo $event_title?>" maxlength="100" />
        </span>
		<span>
          <label>ID: </label>
          <input type="text" name="event_id" value="<?php echo $event_id?>" maxlength="100" />
        </span>
        <span>
          <label> Date: </label>
          <input type="text" name="event_date_time" value="<?php echo $event_date_time?>" maxlength="100" />
        </span>
        <span>
          <label>Event Venue</label>
          <input type="text" name="venue_name" value="<?php echo $venue_name?>" maxlength="100" />
         </span>
		 <?php if (in_array($this->session->userdata('user_type'), array('Admin','Super Admin','Admin2','Finance'))){ ?>
		 <span>
          <label>Promoter</label>
          <input type="text" name="promoter_name" value="" maxlength="100" />
         </span>
		 <?php } ?>
        <span>
          <label>Recommended</label>
          <?php echo form_dropdown('event_recommended', array(''=>'', 'no'=>'No', 'yes'=>'Yes'),  @issetVal($event_recommended),' style="width:auto!important"'); ?>          
         </span>
         <!--
        <span>
          <label>Event Status</label>
          <?php echo form_dropdown('event_active', array('1'=>'Active','0'=>'Not Active'),  @issetVal($event_active),' style="width:auto!important"'); ?>          
         </span>
        -->
        <button type="submit" class="search-button">Search</button>
        <?php echo form_close();?>
        </div>
		
		<div class="posters">
			<?php $count = 0; ?>
			<?php foreach($events as $event): ?>
				<?php if ($event->event_recommended == 'yes'): ?>
					<div class="poster">
						<?php echo anchor('events/view/'.$event->event_id, '<img src="'.base_url().'uploads/images/'.$event->event_image.'" />'); ?>
					</div>
					<?php $count++; ?>
				<?php endif; ?>
				
				<?php if ($count == 5) break; ?>
				
			<?php endforeach; ?>
			<span class="clearfix"></span> 
        </div>
		
        <table width="100%">
            <tr>
           		<th>ID</th>
                <th>Title</th>
                <th>Code</th>
				<th>Date</th>
				<!--<th>Performers</th>-->
				<th>Venue</th>
				
                <?php if (in_array($this->session->userdata('user_type'), array('Admin','Super Admin','Admin2','Finance'))): ?>
				<th>Promoter</th>
                <th>Active</th>
				 <?php endif; ?>
				  <?php if (in_array($this->session->userdata('user_type'), array('Admin','Super Admin','Admin2'))): ?>
                <th>Reco</th>
				
                <th>Action</th>
               <?php endif; ?>
            </tr>
			<?php $count = 0; ?>
            <?php foreach($events as $event): ?>
            <tr>
            	<td nowrap="nowrap"><?php echo $event->event_id; ?></td>
                <td nowrap="nowrap"><?php echo anchor('events/view/'.$event->event_id, $event->event_title); ?></td>
                <td nowrap="nowrap"><?php echo $event->event_code; ?></td>
                <td nowrap="nowrap"><?php echo mysqldatetime_to_date($event->event_date_time, $format = "M d, Y h:ia"); ?></td>
                <!--<td><?php echo $event->event_performers; ?></td>-->
				<?php $substr_venue = $event->venue_name; ?>
                <td><span rel="tooltip" title="<?php echo $substr_venue ?>"><?php echo substr($substr_venue,0,5). "..." ?></span></td>
				
                <?php if (in_array($this->session->userdata('user_type'), array('Admin','Super Admin','Event','Admin2','Finance'))): ?>
				<?php $substr_promoter = $event->promoter_name; ?>
                <td><span rel="tooltip" title="<?php echo $substr_promoter ?>"><?php echo substr($substr_promoter,0,5). "..." ?></span></td>
				
				<td align="center"><?php echo ($event->event_active == 1) ? 'Yes' : 'No'; ?></td>	
				<?php if (in_array($this->session->userdata('user_type'), array('Admin','Super Admin','Event','Admin2'))) { ?>
				
                
                <td><?php echo ($event->event_recommended == 'yes') ? 'Yes' : 'No'; ?></td>	
				
				
				
				
                <td nowrap="nowrap">
					<?php if (in_array($this->session->userdata('user_type'), array('Admin2'))){
						echo anchor('events/edit/'.$event->event_id, 'Edit');
					}else { ?>
					
					
					<?php echo anchor('events/edit/'.$event->event_id, 'Edit'); ?> |
					<?php echo anchor('events/delete/' .$event->event_id, 'Delete', array('onclick'=>"return confirm('Are you sure you want to delete this event?');")); ?> |
                    
                    <?php if ($event->event_recommended === 'yes') :?>					
						<?php echo anchor('events/unrecommend/' .$event->event_id, 'Unrecommend', array('onclick'=>"return confirm('Are you sure you want to remove this event from the Recommended List?');"));?>                  
                    <?php else : ?>                
						<?php echo anchor('events/recommend/' .$event->event_id, 'Recommend', array('onclick'=>"return confirm('Are you sure you want to add this event to the Recommended List');")); ?>
                    <?php endif; ?>
                    <?php } ?>
                    
                    
                </td>
				<?php } ?>
                <?php endif; ?>
            </tr>
			<?php $count++; ?>
			<?php //if ($count == 50) break; ?>
            <?php endforeach ?>
        </table>
    </div>

</div> <!-- content -->

<?php include_once('footer.php'); ?>