<?php include_once('header.php'); ?>
	<script>
	$(document).ready(function() {
		var $calendar = $('#calendar');
		$calendar.datepicker({
			minDate: 1,
			onSelect: function (dateText, inst) {
				addOrRemoveDate(dateText);
			},
			beforeShowDay: function (date) {
				var year = date.getFullYear();
				// months and days are inserted into the array in the form, e.g "01/01/2009", but here the format is "1/1/2009"
				var month = padNumber(date.getMonth() + 1);
				var day = padNumber(date.getDate());
				// This depends on the datepicker's date format
				var dateString = month + "/" + day + "/" + year;

				
				var gotUsedDate = jQuery.inArray(dateString, used_dates);
				var gotDate = jQuery.inArray(dateString, dates);
				if(gotUsedDate >= 0){
					if (gotDate >= 0) {
						// Enable date so it can be deselected. Set style to be highlighted
						$("#calendar_text").val(dates);
						return [true, "ui-highlight"];
					}else{
						$("#calendar_text").val(dates);
					}
				}else{
					// Dates not in the array are left enabled, but with no extra style
					return [false, ""];
				}
				return [true, ""];
				
			}
		});
	});
	// Maintain array of dates
	var dates = new Array();
	var used_dates = new Array(); 

	<?php if($event->events_valid_dates != ""){ ?>
	dates = [<?php echo "'".str_replace(",","','",$event->events_valid_dates)."'" ?>];
	<?php } ?>
	<?php if($used_dates != FALSE){ ?>
	used_dates = [<?php echo "'".str_replace(",","','",$used_dates)."'" ?>];
	<?php } ?>
	
	function addDate(date) {
    if (jQuery.inArray(date, dates) < 0) 
        dates.push(date);
	}

	function removeDate(index) {
		dates.splice(index, 1);
	}

	// Adds a date if we don't have it yet, else remove it
	function addOrRemoveDate(date) {
		var index = jQuery.inArray(date, dates);
		if (index >= 0) 
			removeDate(index);
		else 
			addDate(date);
	}

	// Takes a 1-digit number and inserts a zero before it
	function padNumber(number) {
		var ret = new String(number);
		if (ret.length == 1) 
			ret = "0" + ret;
		return ret;
	}
	
	</script>
	<style>
	.ui-highlight .ui-state-default{background: #3399F3 !important;border-color: #008ae6 !important;color: white !important;font-weight:900;}
	</style>
<div class="content">
	<h2><?php echo $event->event_title ?></h2>
    
    <?php if (in_array($this->session->userdata('user_type'), array('Admin','Super Admin','Event'))): ?>
    <ul class="crud clearfix">
		<?php include_once("inc.eventsmenu.php"); ?> 
    </ul>
	</br>
    <?php endif; ?>
        
    <div class="form_page clearfix">
        <?php echo (validation_errors()) ? '<div class="errors">Error!  Please review the information below.</div>' : ''; ?>
        
        <?php echo form_open('events/date_validity/'.$event->event_id); ?>

		<div class="half_page">
        	
        
        	<h3>Event Date Validity</h3>
			
 			<p>
				<label for="events_valid_dates">Select valid dates</label>
				<input type="text" style="display:none;" id="calendar_text" name="events_valid_dates" value="<?php echo set_value('events_valid_dates',$event->events_valid_dates )?>" placeholder="Format: mm/dd/yyyy,mm/dd/yyyy,..." />
				
				<div style="display: inline-block" id='calendar' data-language='en'></div>
				
				<?php echo form_error('events_valid_dates');?>
			</p>

		 <p class="submit_button">
            	<label for="submit">&nbsp;</label> 
                <button type="submit">Save</button> or <?php echo anchor('events/view/'.$event->event_id, 'Cancel'); ?>
            </p> 	           
                     
        </div>
		      
        </form>
		
		<div class="clearfix"></div>
    </div>

</div> <!-- content -->

<?php include_once('footer.php'); ?>