<?php include_once('header.php'); ?>

<div class="content">
	<h2>Edit branch</h2>
    <div class="form_page">
        <?php echo (validation_errors()) ? '<div class="errors">Error!  Please review the information below.</div>' : ''; ?>
        
        <?php echo form_open('branches/edit/'.$branch->branch_id); ?>

        <div class="half_page">
        	
            <h3>Branch Info</h3>
            <p>
                <label for="branch_name">Name:</label> 
                <input type="text" name="branch_name" value="<?php echo set_value('branch_name', $branch->branch_name)?>" maxlength="100" />
                <?php echo form_error('branch_name');?>
            </p>
            
            <p>
                <label for="branch_category">Category:</label> 
                <?php echo form_dropdown('branch_category', $this->config->item('branch_categories'), set_value('branch_category', $branch->branch_category)); ?>
                <?php echo form_error('branch_category');?>
            </p>
            
            <p>
                <label for="branch_address">Address 1:</label> 
                <input type="text" name="branch_address" value="<?php echo set_value('branch_address', $branch->branch_address)?>" maxlength="100" />
                <?php echo form_error('branch_address');?>
            </p>
            
            <p>
                <label for="branch_address2">Address 2:</label> 
                <input type="text" name="branch_address2" value="<?php echo set_value('branch_address2', $branch->branch_address2)?>" maxlength="100" />
                <?php echo form_error('branch_address2');?>
            </p>
            
            <p>
                <label for="branch_city">City:</label> 
                <input type="text" name="branch_city" value="<?php echo set_value('branch_city', $branch->branch_city)?>" maxlength="100" />
                <?php echo form_error('branch_city');?>
            </p>
            
            <p>
                <label for="branch_zip">ZIP:</label> 
                <input type="text" name="branch_zip" value="<?php echo set_value('branch_zip', $branch->branch_zip)?>" class="input100" maxlength="100" />
                <?php echo form_error('branch_zip');?>
            </p>
            
            <p>
                <label for="branch_tin">TIN:</label> 
                <input type="text" name="branch_tin" value="<?php echo set_value('branch_tin', $branch->branch_tin)?>" maxlength="100" />
                <?php echo form_error('branch_tin');?>
            </p>
            
            <p>
                <label for="ar_printing">Enable AR Printing:</label> 
                <input type="checkbox" name="ar_printing" value="1"<?php echo set_checkbox('ar_printing', '1', ($branch->ar_printing == '1')); ?> />
                <?php echo form_error('ar_printing');?>
            </p>
            
            <p>
                <label for="or_printing">Enable AR Printing:</label> 
                <input type="checkbox" name="or_printing" value="1"<?php echo set_checkbox('or_printing', '1', ($branch->or_printing == '1')); ?> />
                <?php echo form_error('or_printing');?>
            </p>
                
            <p class="submit_button">
            	<label for="submit">&nbsp;</label> 
                <button type="submit">Save Changes</button> or <?php echo anchor('branches/listing', 'Cancel'); ?>
            </p>
		</div> 
		
		<div class="half_page float_right">
            <div class="listing">
                <h3>Contacts</h3>
                <span class="listing_crud"><?php echo anchor('contacts/add/branch/'.$branch->branch_id, 'Add Contacts')?></span>
                <table width="100%">
                    <tr>
                        <th>Name</th>
                        <th>Work Phone Number</th>
                        <th>Action</th>
                    </tr>
                 <?php foreach($contacts as $contact): ?>
                    <tr>
                        <td><?php echo $contact->contact_firstname; ?><?php echo ' '?><?php echo $contact->contact_lastname; ?></td>
                        <td><?php echo $contact->contact_phone; ?></td>
                        <td><?php echo anchor('contacts/edit/'.$contact->contact_id.'/branch/'.$branch->branch_id, 'Edit'); ?> | <?php echo anchor('contacts/delete/'.$contact->contact_id.'/branch/'.$branch->branch_id, 'Delete', array('onclick'=>"return confirm('Are you sure you want to delete this Contact?');")); ?></td>
                    </tr>
                    <?php endforeach ?>
                </table>
            </div>
		</div>       
        </form>
		
		<div class="clearfix"></div>
    </div>

</div> <!-- content -->

<?php include_once('footer.php'); ?>
