<?php include_once('header.php'); ?>

<script type="text/javascript">
 
$(document).ready(function() {
 
    //Select all anchor tag with rel set to tooltip
    $('span[rel=tooltip]').mouseover(function(e) {
         
        //Grab the title attribute's value and assign it to a variable
        var tip = $(this).attr('title');    
         
        //Remove the title attribute's to avoid the native tooltip from the browser
        $(this).attr('title','');
         
        //Append the tooltip template and its value
        $(this).append('<div id="tooltip"><div class="tipBody">' + tip + '</div></div>');     
         
        //Set the X and Y axis of the tooltip
        $('#tooltip').css('top', e.pageY + 10 );
        $('#tooltip').css('left', e.pageX + 20 );
         
        //Show the tooltip with faceIn effect
        $('#tooltip').fadeIn('500');
        $('#tooltip').fadeTo('10',0.8);
         
    }).mousemove(function(e) {
        //Keep changing the X and Y axis for the tooltip, thus, the tooltip move along with the mouse
        $('#tooltip').css('top', e.pageY + 10 );
        $('#tooltip').css('left', e.pageX + 20 );
         
    }).mouseout(function() {
        //Put back the title attribute's value
        $(this).attr('title',$('.tipBody').html());
     
        //Remove the appended tooltip template
        $(this).children('div#tooltip').remove(); 
    });
 
});
 
</script>
<style type="text/css">
#tooltip {
    position:absolute;
    z-index:9999;
    color:#fff;
    font-size:12px;
	font-weight: bolder;
    width:180px;
}
#tooltip .tipBody {
	border-radius: 5px 5px; -moz-border-radius: 5px; -webkit-border-radius: 5px;
    background-color:#000;
    padding:5px;
	text-align: center;
}
</style>

<div class="content">

	
	
    <div class="listing">
        <h2>Events</h2>

        <?php if (in_array($this->session->userdata('user_type'), array('Admin','Super Admin','Admin2','Event'))): ?>
        
      
		<?php endif; ?>
        
        <!--div class="filters">
        <?php echo form_open('events'); ?>
        <!--span>
          <label>Title: </label>
          <input type="text" name="event_title" value="<?php echo $event_title?>" maxlength="100" />
        </span-->

         <!--
        <span>
          <label>Event Status</label>
          <?php echo form_dropdown('event_active', array('1'=>'Active','0'=>'Not Active'),  @issetVal($event_active),' style="width:auto!important"'); ?>          
         </span>
        -->
        <!--button type="submit" class="search-button">Search</button-->
        <?php echo form_close();?>
        <!--/div-->
		

		
        <table width="100%">
            <tr>
           		<th>ID</th>
                <th>Title</th>
                <th>Last Sent</th>
				<th>Edit Emails</th>
				<th>Send</th>

            </tr>
			<?php $count = 0; ?>
            <?php foreach($events as $event): ?>
            <tr>
            	<td nowrap="nowrap"><?php echo $event->event_id; ?></td>
                <td nowrap="nowrap"><?php echo anchor('events/view/'.$event->event_id, $event->event_title); ?></td>
                <td nowrap="nowrap"><?php echo $event->last_sent_date; ?></td>
				<td nowrap="nowrap"><?php
				if (in_array($user_type, array('Admin','Super Admin','Admin2'))){ 
					echo anchor('auto_email/edit_email/'.$event->auto_email_id.'/'.$event->event_id, 'Edit Emails'); 
				}
				?></td>
                <td nowrap="nowrap"><?php
				if (in_array($user_type, array('Admin','Super Admin','Admin2'))){ 
					echo anchor('auto_email/auto_email_ASR_by_event_id/'.$event->event_id, '<button class="search-button">Send ASR</button>'); 
				}
				?></td>
                
               
            </tr>
			<?php $count++; ?>
			<?php //if ($count == 50) break; ?>
            <?php endforeach ?>
        </table>
    </div>

</div> <!-- content -->

<?php include_once('footer.php'); ?>