<?php include_once('header.php'); ?>

<div class="content">
	<h2>Online Transactions</h2>
    <div class="form_page">
		<?php echo validation_errors(); ?>

		<div class="half_page listing">
			<h3>By Transaction</h3>
			<p>Use this to print all tickets bought in a particular transaction</p>
			<?php echo form_open('transactions/online/transaction'); ?>
			<span>
			  <label>Transaction Barcode: </label>
			  <input type="text" name="barcode" maxlength="100" />
			</span>
			<button type="submit" class="search-button">Search</button>
			<?php echo form_close();?>
			
			<?php if (isset($transactions)): ?>
				<?php  if (count($transactions) > 0): ?>
				<table width="100%">
					<tr>
						<th>Trans Date</th>
						<th>Trans ID</th>
						<th>Tickets</th>
						<th>Print</th>
					</tr>
					<?php foreach($transactions as $transaction): ?>
						<tr>
							<td><?php echo date("m/d/y", strtotime($transaction->transaction_date)); ?></td>
							<td><?php echo $transaction->transaction_id; ?></td>
							<td><?php echo $transaction->ticket_count; ?></td>
							<td><a href="<?php echo base_url() . 'tickets/output_all/'.$transaction->transaction_id.'/'.$transaction->transaction_barcode; ?>">Print Tickets</a></td>
						</tr>
					<?php endforeach; ?>
				</table>
				<?php else: ?>
					<?php if (count($transactions_tickets) > 0) { ?>
					<div class="errors">Tickets for this transaction were already redeemed.</div>
					<?php } else { ?>
					<div class="errors">Unable to find transaction.</div>
					<?php } ?>
				<?php endif; ?>
			<?php endif;?>
		</div>
		
		<div class="half_page listing float_right">
			<h3>By Ticket</h3>
			<p>Use this to scan claim tickets individually</p>
			<?php echo form_open('transactions/online/ticket'); ?>
			<span>
			  <label>Ticket Barcode: </label>
			  <input type="text" name="barcode" maxlength="100" />
			</span>
			<button type="submit" class="search-button">Search</button>
			<?php echo form_close();?>
			
			<?php if (isset($tickets)): ?>
				<?php if (count($tickets) > 0): ?>
				<table width="100%">
					<tr>
						<th>Trans Date</th>
						<th>Trans ID</th> 
						<th>Row</th>
						<th>Seat</th>
						<th>Print</th>
					</tr>
					<?php foreach($tickets as $ticket): ?>
						<tr>
							<td><?php echo date("m/d/y", strtotime($ticket->ticket_date_entered)); ?></td>
							<td><?php echo $ticket->ticket_transaction_id; ?></td>
							<td><?php echo $ticket->ticket_row; ?></td>
							<td><?php echo $ticket->ticket_seat; ?></td>
							<td><a href="<?php echo base_url() . 'tickets/output_single/'.$ticket->ticket_id.'/'.$ticket->ticket_barcode; ?>">Print Ticket</a></td>
						</tr>
					<?php endforeach; ?>
				</table>
				<?php else: ?>
					<?php if (count($tickets_detail) > 0) { ?>
					<div class="errors">Ticket was already redeemed.</div>
					<?php } else { ?>
					<div class="errors">Unable to find ticket.</div>
					<?php } ?>					
				<?php endif; ?>
			<?php endif; ?>
		</div>
		<div class="clearfix"></div>
    </div>

</div> <!-- content -->
<?php include_once('footer.php'); ?>