<?php include_once('header.php'); ?>

<div class="content">
	<h2>Add Customer</h2>
    <div class="form_page">
        <?php echo (validation_errors()) ? '<div class="errors">Error!  Please review the information below.</div>' : ''; ?>
        
        <?php echo form_open('transactions/customer_info/'); ?>
		
		<div id="listing_detail" class="half_page listing" style="width: 98%;">
			<h3>Summary (Please review your ticket selection.)</h3>
      		<table width="100%">
				<tr>
					<th>Section</th>
					<th>Row</th>
					<th>Seat</th>
					<th>Type</th>
					<th>Amount</th>
				</tr>
				<?php 
				$tamount = 0;
				$fee = 0;
				$rfee = 0;
				$tpay = 0;
				foreach($tickets as $ticket): 
					if ($ticket->ticket_type_discount_type == 'Amount'):
						$rfee = $ticket->event_reservation_fee;
						$fee += $rfee;
						$amount = ceil($price->price_price - $ticket->ticket_type_discount); 
						elseif ($ticket->ticket_type_discount_type == 'Percentage'): 
							$amount= ceil($ticket->price_price - (($ticket->price_price * $ticket->ticket_type_discount)/100)); 
							$rfee = $ticket->event_reservation_fee;
							$fee += $rfee;
						endif; 
						$tamount += $amount; ?>
					<tr>
						<td><?php echo $price->price_name; ?> - <?php echo $ticket->section_name; ?></td>
						<?php if ($ticket->ticket_row == "") { ?>
						<td colspan=2 style="text-align:center"><?php echo $ticket->ticket_row; echo $ticket->ticket_seat; ?></td>
						<?php } else { ?>
						<td align=center><?php echo $ticket->ticket_row;?></td>
						<td align=center><?php echo $ticket->ticket_seat; ?></td>
						<?php } ?>
						<td><?php echo $ticket->ticket_type_name; ?></td>
						<td><?php echo number_format($amount, 2); ?></td>
						
					</tr>
				<?php endforeach; ?>
				<tr>
					<th colspan="4">Total</th>
					<?php 
					if ($ticket->ticket_status == 'reserved')
					{
						$tpay = $tamount + $fee; ?>
						<th><?php echo number_format($tpay, 2); ?></th>
					<?php }
					else 
					{ ?>
						<th><?php echo number_format($tamount, 2); ?></th>
					<?php } ?>	
				</tr>
				
				<?php 
				if ($rfee != 0)
				{
				?>
				<tr>
					<?php //if ($ticket->ticket_status == 'reserved')
						//{ 
							//echo $ticket->ticket_status; ?>
						<td><?php echo "Reservation Fee"; ?></td>
						<td colspan="3" style="font-style:italic;text-align:center;" align="center"><?php echo "Php ". $rfee ." per ticket"; ?></td>
						<td><?php echo number_format($fee, 2); ?></td>
						<?php //} ?>
				</tr>
				
				<tr>
					<th colspan="4">Grand Total</th>
					<?php 
					if ($ticket->ticket_status == 'reserved')
					{
						$tpay = $tamount + $fee; ?>
						<th><?php echo number_format($tpay, 2); ?></th>
					<?php }
					else 
					{ ?>
						<th><?php echo number_format($tamount, 2); ?></th>
					<?php } ?>	
				</tr>
				
				<?php } ?>
            </table>
			<div class="clearfix"></div>
			<?php
			if ($ticket->ticket_status == 'reserved')
			{
				$tpay = $tamount + $fee;
				$total_amount = number_format($tpay, 2, '.', '');
			}
			else
			{
				$total_amount = number_format($tamount, 2, '.', '');
			}
			?>
            </p>
		</div>
        <div class="half_page">
        	<h3>Customers Info</h3>

			<p>
                <label for="customer_mobile">Mobile Number:</label> 
                <input type="text" name="customer_mobile" value="<?php echo set_value('customer_mobile')?>" maxlength="100" />
                <?php echo form_error('customer_mobile');?>
            </p>	
			
			 <p class="form_caption">
                <label for="caption">&nbsp;</label> 
                <small>eg. 09195671234</small>
            </p>			
            
            <p>
                <label for="customer_firstname">First Name:</label> 
                <input type="text" name="customer_firstname" value="<?php echo set_value('customer_firstname')?>" maxlength="100" />
                <?php echo form_error('customer_firstname');?>
            </p>
			
			<p>
                <label for="customer_lastname">Last Name:</label> 
                <input type="text" name="customer_lastname" value="<?php echo set_value('customer_lastname')?>" maxlength="100" />
                <?php echo form_error('customer_lastname');?>
            </p>
							
			
			
			<p>
                <label for="customer_age_bracket">Age:</label> 
                <?php echo form_dropdown('customer_age_bracket', $this->config->item('age'), set_value('customer_age_bracket')); ?>
                <?php echo form_error('customer_age_bracket');?>
            </p>
					
            <p>
                <label for="customer_gender">Gender:</label>
                <?php echo form_dropdown('customer_gender', $this->config->item('gender'), set_value('customer_gender')); ?>
                <?php echo form_error('customer_gender');?>
            </p>
			
			<p>
                <label for="customer_marital_status">Marital Status:</label> 
                <?php echo form_dropdown('customer_marital_status', $this->config->item('marital_status'), set_value('customer_marital_status')); ?>
                <?php echo form_error('customer_marital_status');?>
            </p>
					
			<p>
                <label for="customer_notes">Notes :</label> 
                <textarea name="customer_notes" cols="5" rows="2"><?php echo set_value('customer_notes')?></textarea>
                <?php echo form_error('customer_notes');?>
            </p>
            
            
        </div>
            
        <div class="half_page float_right">    
            <h3>Contact Info</h3>
            <p>
                <label for="customer_address1">Address 1:</label> 
                <input type="text" name="customer_address1" value="<?php echo set_value('customer_address1')?>" maxlength="100" />
                <?php echo form_error('customer_address1');?>
            </p>
			
			<p>
                <label for="customer_address2">Address 2:</label> 
                <input type="text" name="customer_address2" value="<?php echo set_value('customer_address2')?>" maxlength="100" />
                <?php echo form_error('customer_address2');?>
            </p>

			<p>
                <label for="customer_city">City:</label> 
                <input type="text" name="customer_city" value="<?php echo set_value('customer_city')?>" maxlength="100" />
                <?php echo form_error('customer_city');?>
            </p>
            
            <p>
                <label for="customer_zip">Zip Code:</label> 
                <input type="text" name="customer_zip" value="<?php echo set_value('customer_zip')?>" maxlength="10" />
                <?php echo form_error('customer_zip');?>
            </p>
			
			<p>
                <label for="customer_nationality">Country:</label> 
                <input type="text" name="customer_nationality" value="<?php echo set_value('customer_nationality')?>" maxlength="100" />
                <?php echo form_error('customer_nationality');?>
            </p>
            
            <p>
                <label for="customer_phone">Phone Number:</label> 
                <input type="text" name="customer_phone" value="<?php echo set_value('customer_phone')?>" maxlength="100" />
                <?php echo form_error('customer_phone');?>
            </p>
			
			<p>
                <label for="customer_email">Email Address:</label> 
                <input type="text" name="customer_email" value="<?php echo set_value('customer_email')?>" maxlength="100" />
                <?php echo form_error('customer_email');?>
            </p>
			
            <p class="submit_button">
            	<label for="submit">&nbsp;</label> 
                <button type="submit">Add Customer</button> or <?php echo anchor('events/view/' . $event->event_id, 'Cancel'); ?>
            </p>
            
            <p>
            
		</div>        
        
		<div class="content">
        
		</div>
        
        <script type="text/javascript">
			$(document).ready(function() 
			{
				$('input[name=customer_mobile]').blur(function() 
				{
					var mobile = $('input[name=customer_mobile]').val()

					$.post('<?php echo base_url() ?>customers/get/', {customer_mobile: mobile},
					function(data){
						$("input[name=customer_firstname]").val(data.customer_firstname);
						$("input[name=customer_lastname]").val(data.customer_lastname);
						$("input[name=customer_age_bracket]").val(data.customer_age_bracket);
						$("input[name=customer_gender]").val(data.customer_gender);
						$("input[name=customer_marital_status]").val(data.customer_marital_status);
						$("input[name=customer_notes]").val(data.customer_notes);
						
						$("input[name=customer_address1]").val(data.customer_address1);
						$("input[name=customer_address2]").val(data.customer_address2);
						$("input[name=customer_city]").val(data.customer_city);
						$("input[name=customer_zip]").val(data.customer_zip);
						$("input[name=customer_nationality]").val(data.customer_nationality);
						$("input[name=customer_phone]").val(data.customer_phone);
						$("input[name=customer_email]").val(data.customer_email);					
					}, 'json');

				});
		
			});
			
		</script>
        
        </form>
        
        <div class="clearfix"></div>
    </div>

</div> <!-- content -->

<?php include_once('footer.php'); ?>