<?php include_once('header.php'); ?>

<div class="content">
	<h2>Transaction Details</h2>
     <div id="listing_detail" class="clearfix form_page">
        <?php echo validation_errors(); ?>
        
        <?php echo form_open('transactions/cancel/'.$transaction->transaction_id)?>
 		
        
        <div class="half_page">
        	<h3>Transaction Info</h3>
            
            <ul class="details">
                <li class="clearfix">
                    <dl>
                        <dt>Transaction ID:</dt>
                        <dd><?php echo $transaction->transaction_id ?></dd>
                    </dl>
                </li>
                <li class="clearfix">
                    <dl>
                        <dt>Transaction Date:</dt>
                        <dd><?php echo date("D M d, Y  H:i:s", strtotime($transaction->transaction_date)); ?></dd>
                    </dl>
                </li>
                <li class="clearfix">
                    <dl>
                        <dt>Event:</dt>
                        <dd><?php echo $event->event_title; ?></dd>
                    </dl>
                </li>
            </ul>
            
        	<!--h3>Customer Info</h3>
            
            <ul class="details">
                <li class="clearfix">
                    <dl>
                        <dt>Customer:</dt>
                        <dd><?php echo $customer->customer_firstname ?> <?php echo $customer->customer_lastname ?></dd>
                    </dl>
                </li>
                <li class="clearfix">
                    <dl>
                        <dt>Mobile:</dt>
                        <dd><?php echo $customer->customer_mobile ?></dd>
                    </dl>
                </li>
            </ul-->
	
			
		</div> 
        
        <div class="half_page listing float_right">  
		  
        	<h3>Tickets</h3>
			
      		<table width="100%">
                <tr>
                	<th width="10"></th>
                    <th width="10">#</th>
                    <th>Section</th>
                    <th>Row</th>
                    <th>Seat</th>
                </tr>
                <?php $count = 1; ?>
                <?php foreach($tickets as $ticket): ?>
                    <tr>
                        <td><input type="checkbox" name="tickets[]" value="<?php echo $ticket->ticket_id; ?>"<?php echo set_checkbox('tickets[]',  $ticket->ticket_id, TRUE); ?> /></td>
                        <td><?php echo $count; ?></td>
                        <td><?php echo $ticket->price_name; ?> - <?php echo $ticket->section_name; ?></td>
                        <td><?php echo $ticket->ticket_row; ?></td>
                        <td><?php echo $ticket->ticket_seat; ?></td>
                    </tr>
                    <?php $count++; ?>
                <?php endforeach; ?>
            </table>
           <?php echo form_error('tickets[]');?>
            
            <?php if ($user_type == 'Seller' or $user_type == 'Reservation'): ?>
                <div style="display: none" id="manager_login_box">
                
                    <h3>Manager Login</h3>
                    <p>
                        <label for="username">Username:</label> 
                        <input type="text" name="username" value="<?php echo set_value('username')?>" maxlength="100" />
                        <?php echo form_error('username');?>
                    </p>
                    
                    <p>
                        <label for="password">Password:</label> 
                        <input type="password" name="password" value="<?php echo set_value('password')?>" maxlength="100" />
                        <?php echo form_error('password');?>
                    </p>
                    
                    
                    <p>
                        <label for="comment">Comment:</label> 
                        <input type="text" name="comment" value="<?php echo set_value('comment')?>" maxlength="100" />
                        <small>Please don't forget to state the reason for cancellation.</small>
                        <?php echo form_error('comment');?>
                    </p>
                
                    <p class="submit_button">
                        <button type="submit">Cancel Selected Tickets</button> or <?php echo anchor('transactions/listing', 'Go Back'); ?>
                    </p>
                </div>
                <div id="login_box_button">
                    <button type="button">Cancel Selected Tickets</button> or <?php echo anchor('transactions/listing', 'Go Back'); ?>
                </div>
                <script>
                    <?php if (validation_errors()): ?>
                    (function($){  
                        $(document).ready(function() {
                            $("#manager_login_box").show("fast");
                            $("#login_box_button").hide("fast");
                        });
                        
                    })(jQuery);
                    <?php endif; ?>
                    $("#login_box_button button").click(function () {
                        $("#manager_login_box").fadeIn("slow");
                        $("#login_box_button").hide("fast");
                    });
                </script>
                
                
            <?php else: ?>
            	<p class="submit_button">
                    <button type="submit">Cancel Selected Tickets</button> or <?php echo anchor('transactions/listing', 'Go Back'); ?>
                </p>
            <?php endif; ?>
            
        </div>
        
        <div class="clearfix"></div>
    </div>

	</form>

</div> <!-- content -->

<?php include_once('footer.php'); ?>