<?php include_once('header.php'); ?>
<script type="text/javascript" src="<?php echo $views_dir ?>js/jquery.setup_seats.js?<?php echo rand();?>"></script>
<?php
$col_from = ($this->input->post('col_from')) ? $this->input->post('col_from') : '';
$col_to = ($this->input->post('col_to')) ? $this->input->post('col_to') : '';
$col_increment = ($this->input->post('col_increment')) ? $this->input->post('col_increment') : '';
$row_from = ($this->input->post('row_from')) ? $this->input->post('row_from') : '';
$row_to = ($this->input->post('row_to')) ? $this->input->post('row_to') : '';
$row_increment = ($this->input->post('row_increment')) ? $this->input->post('row_increment') : '';
$col_aisles = ($this->input->post('col_aisles')) ? $this->input->post('col_aisles') : '';
$row_aisles = ($this->input->post('row_aisles')) ? $this->input->post('row_aisles') : '';
$seat_numbering = ($this->input->post('seat_numbering')) ? $this->input->post('seat_numbering') : '';

$seat_config = unserialize($section->section_seat_config);

$selected_seat_class = (strcmp($row_from, $row_to) > 0) ? 'selected_seat_down' : 'selected_seat';
?>
<script type="text/javascript">
	(function($){  
		$(document).ready(function() {
			$(".seats_matrix input:checked").parent().addClass("<?php echo $selected_seat_class ?>");
			
			$(":checkbox").click(function(){ 
				if($(this).attr("checked")) { 
					$('input[name="name[]"]').attr("checked", "checked");
					$(this).parent().addClass("<?php echo $selected_seat_class ?>");
				} else { 
					$('input[name="name[]"]').removeAttr("checked");
					$(this).parent().removeClass("<?php echo $selected_seat_class ?>");
				} 
			});
		});
		
	})(jQuery);
</script>

<div class="content">
	<h2>Setup Seats</h2>
    
    <?php echo form_open('sections/setup_seats/'.$section->section_id.'/'.$seatplan_id . '/' . $event->event_id); ?>
	
	<style type="text/css">
		#float_always {
			position: absolute;
			top: 100px;
			background-color: transparent;
			width: auto;
			float: left;
			left: 70%;
			opacity: 0.8;
			color: #fff;
		}
		#float_always .section_capacity_content{
			position: relative;
			float: right;
			background-color: #111;
			width: 200px;
			padding: 10px;
		}
		#section_capacity_need, #section_capacity_selected{
			font-size: 12px;
			font-weight: bolder;
		}
		#section_capacity_need{
			color: green;
		}
		#section_capacity_error{
			position: relative;
			margin: 0 auto;
			padding: 5px auto; 
			width: 100%;
			font-size: 20px;
			font-weight: bolder;
			text-align: center;
			background-color: red;
			color: #FFF;
			border-color: #C6D880;
			height: 30px;
			padding-top: 16px !important;
		}
	</style>
	
	<div id="float_always">
		<!--<div id="section_capacity_error"></div>-->
		<div class="section_capacity_content">
			<span class="section_capacity_need_header">Seat Capacity:</span>
			<span id="section_capacity_need"><?php echo $section->section_capacity; ?></span>
			<br/>
			<span class="section_capacity_need_header">Seat Selected:</span>
			<span id="section_capacity_selected"></span>
		</div>
	</div>
	
	
	
	<h2><?php echo $event->event_title; ?></h2>
    <?php if ($this->session->userdata('user_type') == 'Admin' or $this->session->userdata('user_type') == 'Super Admin' and isset($event->event_title)): ?>
    <ul class="crud clearfix">
		<?php include_once("inc.eventsmenu.php"); ?> 
    </ul>
    <?php endif; ?>
    
    
	
	
	
	
	
	
	
	
	
	
	 <div class="form_page">
	
	    	<h3><?php echo $section->section_name; ?></h3>
    <span class="seats_controls">
    	<?php echo validation_errors() ?>
    	<table width="500" border="0">
        	<tr>
            	<td></td>
                <td>From</td>
                <td>To</td>
                <td>Incr.</td>
                <td>&nbsp;</td>
                <td></td>
                <td>From</td>
                <td>To</td>
                <td>Incr.</td>
                <td>&nbsp;</td>
                <td></td>
                <td>Row</td>
                <td>Col</td>
                <td></td>
            </tr>
            <tr>
            	<td><a href="javascript:;" class="vtip" title="Row value can be a number or a letter">Row</a></td>
                <td><input type="text" name="row_from" value="<?php echo set_value('row_from', 'A')?>" maxlength="100" /></td>
                <td><input type="text" name="row_to" value="<?php echo set_value('row_to', 'Z')?>" maxlength="100" /></td>
                <td><input type="text" name="row_increment" value="<?php echo set_value('row_increment', 1)?>" maxlength="100" /></td>
                <td></td>
            	<td><a href="javascript:;" class="vtip" title="Seat value can be a number or a letter">Seat</a></td>
                <td><input type="text" name="col_from" value="<?php echo set_value('col_from', 1)?>" maxlength="100" /></td>
                <td><input type="text" name="col_to" value="<?php echo set_value('col_to', 20)?>" maxlength="100" /></td>
                <td><input type="text" name="col_increment" value="<?php echo set_value('col_increment', 1)?>" /></td>
                <td></td>
                <td><a href="javascript:;" class="vtip" title="Aisle value can be a number or a letter.  For multiple aisles, <br />use a comma-separated value (no space after the comma).">Aisles</a></td>
                <td><input type="text" name="row_aisles" value="<?php echo set_value('row_aisles')?>" maxlength="100" /></td>
                <td><input type="text" name="col_aisles" value="<?php echo set_value('col_aisles')?>" maxlength="100" /></td>
                <td><button type="submit">GO</button></td>
            </tr>
        </table>
		
    </span>
	<?php if ($this->form_validation->run() != FALSE): ?>
    <div class="form_page">
        
        <div class="seats_matrix">
	        
            <table>
            	<tr>
                	<td class="seat_col_head"></td>
					<?php foreach (range($col_from, $col_to, $col_increment) as $col_head_key => $col_head_val): ?>
                     
    	            	<td class="seat_col_head"><?php echo $col_head_val?></td>
                        
						<?php if (in_array($col_head_val, explode(',', $col_aisles))): ?>
                        	<td class="seat_col_head"></td>
                        <?php endif; ?>
                        
        	        <?php endforeach; ?>
            	</tr>
                
                
            	<?php foreach (range($row_from, $row_to, $row_increment) as $row_head_key => $row_head_val): ?>
                     
                    <tr>
                        <td class="seat_row_head"><?php echo $row_head_val ?></td>
                        <?php foreach (range($col_from, $col_to, $col_increment) as $col_head_key2 => $col_head_val2): ?>
                                        
                        	<td><input type="checkbox" name="seat[R<?php echo $row_head_key?>][]" value="<?php echo $col_head_key2?>|<?php echo $row_head_val?>|<?php echo $col_head_val2?>" checked="checked" /></td>
                            
                            <?php if (in_array($col_head_val2, explode(',', $col_aisles))): ?>
                            	<td></td>
                            <?php endif; ?>

                        <?php endforeach; ?>
                    </tr>
                    
                    <?php if (in_array($row_head_val, explode(',', $row_aisles))): ?>
                    	<tr><td></td></tr>
                    <?php endif; ?>
                    
                <?php endforeach; ?>
                
            </table>
            <input type="submit" name="save" value="Save Seats" class="save" />
            
            
        </div>    
        </form>
        <div class="clearfix"></div>
    </div>
	<?php endif; ?>
	
	  </div>

</div> <!-- content -->

<?php include_once('footer.php'); ?>

