<?php include_once('header.php'); ?>

<div class="content">
    <h2><?php echo (isset($event->event_title)) ? $event->event_title : 'Edit Section'?></h2>
    
    <?php if (in_array($this->session->userdata('user_type'), array('Admin','Super Admin','Admin2')) and isset($event->event_title)): ?>
	<ul class="crud clearfix">
		<?php include_once("inc.eventsmenu.php"); ?> 
    </ul>
    <?php endif; ?>
    <div class="form_page">
        <?php echo (validation_errors()) ? '<div class="errors">Error!  Please review the information below.</div>' : ''; ?>
       
        <?php echo form_open('sections/edit/'.$section->section_id.'/'.$seatplan->seatplan_id); ?>
        
        <div class="full_page seatplan_image_full">
        	<h3><?php echo $seatplan->seatplan_name ?> </h3>
        	<?php echo anchor('uploads/'.$seatplan->seatplan_image, '<img id="imgseatplan" src="'.base_url().'uploads/'.$seatplan->seatplan_image.'"/>')?>
            
            <p>Click and drag on the seatplan's image to tag the section.</p>
        </div>
        <div class="full_page">
            
            <h3>Edit Section</h3>
            <p>
                <label for="section_code">Code:</label> 
                <input type="text" name="section_code" value="<?php echo set_value('section_code', $section->section_code)?>" class="input100" maxlength="15" />
                <?php echo form_error('section_code');?>
            </p>
            
            <p>
                <label for="section_name">Name:</label> 
                <input type="text" name="section_name" value="<?php echo set_value('section_name', $section->section_name)?>" maxlength="100" />
                <?php echo form_error('section_name');?>
            </p>
            
            <p>
                <label for="section_type">Type:</label> 
                <?php echo form_dropdown('section_type', $this->config->item('section_types'), set_value('section_type', $section->section_type), 'class="select150"'); ?>
                <?php echo form_error('section_type');?>
            </p>
 
             <p>
                <label for="section_capacity">Capacity:</label> 
                <input type="text" name="section_capacity" value="<?php echo set_value('section_capacity', $section->section_capacity)?>"" class="input100" maxlength="100" />
                <?php echo form_error('section_capacity');?>
            </p>
			<?php if (strtolower($section->section_type) == "reserved") { ?>
            <p>
                <label for="section_available">Available:</label> 
                <input type="text" name="section_available" value="<?php echo set_value('section_available', $section->section_available)?>" class="input100" maxlength="100" />
                <?php echo form_error('section_available');?>
            </p>
            <?php } ?>
            <p>
                <label for="section_stage_location">Stage Location:</label> 
                <?php echo form_dropdown('section_stage_location', $this->config->item('stage_locations'), set_value('section_stage_location', $section->section_stage_location), 'class="select150"'); ?>
                <?php echo form_error('section_stage_location');?>
            </p>
                            
            <p>
            	<label for="submit">&nbsp;</label> 
                <button type="submit">Save Changes</button> or <?php echo anchor('seatplans/view/'.$seatplan->seatplan_id, 'Cancel'); ?>
            </p>
            <input type="hidden" name="section_coords" value="<?php echo set_value('section_coords', $section->section_coords)?>" />
            
		</div>

        </form>
        
        <div class="clearfix"></div>
    </div>

</div> <!-- content -->
<?php include_once('footer.php'); ?>
<script type="text/javascript">
$(document).ready(function(){
  var imgFormCoords = $('form input[name="section_coords"]')[0];
  var imgSel = $('img#imgseatplan').imgAreaSelect({
    instance:true,
    handles:true,
  	onSelectEnd: function (img, sel){
      imgFormCoords.value = $.toJSON(sel);
      return false;
    }
  });  
  if (imgFormCoords.value)
  {
    var coords = $.evalJSON(imgFormCoords.value);
    imgSel.setSelection(coords.x1,coords.y1,coords.x2,coords.y2);
    imgSel.setOptions({ show: true });
    imgSel.update();
  }
});
</script>