<?php include_once('header.php'); ?>
<script type="text/javascript">
    $(function() {
        $('.seatplan_image a').lightBox();
    });
</script>
<div class="content">
	<h2><?php echo (isset($event->event_title)) ? $event->event_title : 'Add Section'?></h2>
    
    <?php if ((in_array($this->session->userdata('user_type'), array('Admin','Super Admin','Event','Admin2')) and isset($event->event_title))): ?>
    <ul class="crud clearfix">
		<?php include_once("inc.eventsmenu.php"); ?> 
    </ul>
    <?php endif; ?>
    
    <div class="form_page">
        <?php echo (validation_errors()) ? '<div class="errors">Error!  Please review the information below.</div>' : ''; ?>
       
        <?php echo form_open('sections/add/'.$seatplan->seatplan_id); ?>
        <div class="half_page seatplan_image">
        	<h3><?php echo $seatplan->seatplan_name ?></h3>
        	<?php echo anchor('uploads/'.$seatplan->seatplan_image, '<img  id="imgseatplan" src="'.base_url().'uploads/'.$seatplan->seatplan_image.'" />')?>
            <span>Click and drag on the seatplan's image to tag the section.</span>
        </div>
        <div class="half_page float_right">
            <h3>Add Section</h3>
            <p>
                <label for="section_code">Code:</label> 
                <input type="text" name="section_code" value="<?php echo set_value('section_code')?>" class="input100" maxlength="15"/>
                <?php echo form_error('section_code');?>
            </p>
            
            <p>
                <label for="section_name">Name:</label> 
                <input type="text" name="section_name" value="<?php echo set_value('section_name')?>" maxlength="100" />
                <?php echo form_error('section_name');?>
            </p>

            <p>
                <label for="section_type">Type:</label> 
                <?php echo form_dropdown('section_type', $this->config->item('section_types'), set_value('section_type'), 'class="select150"'); ?>
                <?php echo form_error('section_type');?>
            </p>

            <p>
                <label for="section_capacity">Capacity:</label> 
                <input type="text" name="section_capacity" value="<?php echo set_value('section_capacity')?>" class="input100" maxlength="100" />
                <?php echo form_error('section_capacity');?>
            </p>
            
            <p>
                <label for="section_stage_location">Stage Location:</label> 
                <?php echo form_dropdown('section_stage_location', $this->config->item('stage_locations'), set_value('section_stage_location'), 'class="select150"'); ?>
                <?php echo form_error('section_stage_location');?>
            </p>
                            
            <p>
            	<label for="submit">&nbsp;</label> 
	            <input type="hidden" name="section_coords" value="<?php echo set_value('section_coords')?>" />
               
                <button type="submit">Add Section</button> or <?php echo anchor('seatplans/view/'.$seatplan->seatplan_id, 'Go back'); ?>
            </p>
            
		</div>

        </form>
        
        <div class="clearfix"></div>
    </div>

</div> <!-- content -->

<?php include_once('footer.php'); ?>
<script type="text/javascript">
$(document).ready(function(){
  var imgFormCoords = $('form input[name="section_coords"]')[0];
  var imgSel = $('img#imgseatplan').imgAreaSelect({
    instance:true,
    handles:true,
  	onSelectEnd: function (img, sel){
      imgFormCoords.value = $.toJSON(sel);
      return false;
    }
  });  
});
</script>