<?php include_once('header.php'); ?>

<div class="content">
	<h2><?php echo (isset($event->event_title)) ? $event->event_title : 'Edit Seatplan' ?></h2>
    
    <?php if (in_array($this->session->userdata('user_type'), array('Admin','Super Admin','Event','Admin2')) and isset($event->event_title)): ?>
    <ul class="crud clearfix">
		<?php include_once("inc.eventsmenu.php"); ?> 
    </ul>
    <?php endif; ?>
    
    <div class="form_page">
        <?php echo (validation_errors()) ? '<div class="errors">Error!  Please review the information below.</div>' : ''; ?>
        <?php echo (isset($upload_error)) ? '<div class="errors">'.$upload_error.'</div>' : ''; ?>
        
        <?php echo form_open_multipart('seatplans/edit/'.$seatplan->seatplan_id); ?>

        <div class="half_page">
        	
            <h3>Seat Plan Info</h3>
            <p>
                <label for="seatplan_name">Seat Plan Name:</label> 
                <input type="text" name="seatplan_name" value="<?php echo set_value('seatplan_name', $seatplan->seatplan_name)?>" maxlength="100" />
                <?php echo form_error('seatplan_name');?>
            </p>
            
            <p>
                <label for="venue_id">Venue:</label> 
                <?php echo form_dropdown('venue_id', $venues, set_value('venue_id', $seatplan->seatplan_venue_id)); ?>
                <?php echo form_error('venue_id');?>
            </p>
            
            <p>
                <label for="seatplan_photo">Seatplan Photo:</label> 
                <input type="file" name="seatplan_photo" />
                <?php echo form_error('seatplan_photo');?>
            </p>
            
            <p>
                <label for="caption">&nbsp;</label> 
                <small>Leave blank if you're not changing the photo</small>
            </p>
            
            <p>
                <label for="seatplan_active">Status</label> 
                <input type="checkbox" name="seatplan_active" value="1"<?php echo set_checkbox('seatplan_active', '1', ($seatplan->seatplan_active == '1') ? TRUE : FALSE); ?> /> Active
                <?php echo form_error('seatplan_active');?>
            </p>

                            
            <p class="submit_button">
            	<label for="submit">&nbsp;</label> 
                <button type="submit">Save Changes</button> or <?php echo anchor('seatplans/view/'.$seatplan->seatplan_id, 'Go back'); ?>
            </p>
		</div>        
        </form>
		
        <div class="clearfix"></div>
    </div>

</div> <!-- content -->

<?php include_once('footer.php'); ?>