<?php include_once('header.php'); ?>
<div class="content">
	<h2>Reservation Details</h2>
    <div id="listing_detail" class="clearfix form_page">
		<?php echo (validation_errors()) ? '<div class="errors">Error!  Please review the information below.</div>' : ''; ?>
        
    	<?php echo form_open('reservations/extend/'.$transaction->transaction_id)?>
        
 		<div class="half_page">  
        	<h3>Transaction Info</h3>
            
            <ul class="details">
                <li class="clearfix">
                    <dl>
                        <dt>Reservation ID:</dt>
                        <dd><?php echo $transaction->transaction_id ?></dd>
                    </dl>
                </li>
                <li class="clearfix">
                    <dl>
                        <dt>Transaction Date:</dt>
                        <dd><?php echo $transaction->transaction_date ?></dd>
                    </dl>
                </li>
                <li class="clearfix">
                    <dl>
                        <dt>Event:</dt>
                        <dd><?php echo $event->event_title ?></dd>
                    </dl>
                </li>

            </ul>
            
        	<h3>Customer Info</h3>
            
            <ul class="details">
                <li class="clearfix">
                    <dl>
                        <dt>Customer:</dt>
                        <dd><?php echo $customer->customer_firstname ?> <?php echo $customer->customer_lastname ?></dd>
                    </dl>
                </li>
                <!--li class="clearfix">
                    <dl>
                        <dt>Mobile:</dt>
                        <dd><?php echo $customer->customer_mobile ?></dd>
                    </dl>
                </li-->
            </ul>
			
        	
        </div>
        
        <div class="half_page listing float_right">
        	<h3>Tickets</h3>
			
      		<table width="100%">
                <tr>
                    <th>Section</th>
                    <th>Row</th>
                    <th>Seat</th>
                    <th>Expire</th>
                </tr>
                <?php foreach($tickets as $ticket): ?>
                    <tr>
                        <td><?php echo $ticket->price_name; ?> - <?php echo $ticket->section_name; ?></td>
                        <td><?php echo $ticket->ticket_row; ?></td>
                        <td><?php echo $ticket->ticket_seat; ?></td>
                        <td><?php echo $ticket->ticket_reservation_expiry; ?></td>
                    </tr>
                <?php endforeach; ?>
            </table>
			<div style="display: none" id="manager_login_box" class="form_page">
            
            	<h3>Manager Login</h3>
                <p>
                    <label for="username">Username:</label> 
                    <input type="text" name="username" value="<?php echo set_value('username')?>" maxlength="100" />
                    <?php echo form_error('username');?>
                </p>
                
                <p>
                    <label for="password">Password:</label> 
                    <input type="password" name="password" value="<?php echo set_value('password')?>" maxlength="100" />
                    <?php echo form_error('password');?>
                </p>
                
                <?php if (in_array($user_type, array('Admin','Super Admin','Admin2'))): ?>
                <p>
                    <label for="no_of_days">Extend for:</label> 
                    <input type="text" name="no_of_days" style="text-align:center; width:20px !important" value="<?php echo set_value('no_of_days', $event->event_reservation_expire) ?>" maxlength="2" /><strong> day/s from today</strong>
                    <?php echo form_error('no_of_days');?>
                </p>
                <?php endif; ?>
                
                <p>
                    <label for="comment">Comment:</label> 
                    <input type="text" name="comment" value="<?php echo set_value('comment')?>" maxlength="100" />
                    <?php echo form_error('comment');?>
                </p>
            
                <p class="submit_button">
                    <button type="submit">Extend Reservation</button> or <?php echo anchor('reservations/listing', 'Go Back'); ?>
                </p>
            </div>
            <div id="login_box_button">
	        	<button type="button">Extend Reservation</button> or <?php echo anchor('reservations/listing', 'Go Back'); ?>
            </div>
            <script>
				<?php if (validation_errors()): ?>
				(function($){  
					$(document).ready(function() {
						$("#manager_login_box").show("fast");
						$("#login_box_button").hide("fast");
					});
					
				})(jQuery);
				<?php endif; ?>
				$("#login_box_button button").click(function () {
					$("#manager_login_box").fadeIn("slow");
					$("#login_box_button").hide("fast");
				});
			</script>
		</div> 
        

        
        <div class="clearfix"></div>
    </div>
	<input type="hidden" name="event_reservation_days" value="<?php echo $event->event_reservation_expire?>" />
	</form>
</div> <!-- content -->

<?php include_once('footer.php'); ?>
