<?php include_once('header.php'); ?>
<div class="content">
	<h2><?php echo $page_title; ?></h2>
    <div class="form_page">
        <?php echo (validation_errors()) ? '<div class="errors">Error!  Please review the information below.</div>' : ''; ?>
        
        <?php echo form_open($form_url, "target=_blank"); ?>

        <div class="half_page">
			<small>Advance Sales Report will use "AS OF date" if DATE FROM field remains blank.</small>
			<br><br>
			 
			<p>
                <label for="reports_date">DATE FROM:</label> 
                <input type="text" name="reports_date_from" value="<?php echo set_value('reports_date_from', '')?>" maxlength="100" />
                <?php echo form_error('reports_date_from');?>
            </p>
			<p class="form_caption">
                <label for="caption">&nbsp;</label> 
                <small>Date Format: YYYY-MM-DD</small><br>
            </p>
			 
			<p>
                <label for="reports_date">DATE TO / AS OF:</label> 
                <input type="text" name="reports_date" value="<?php echo set_value('reports_date', date('Y-m-d'))?>" maxlength="100" />
                <?php echo form_error('reports_date');?>
            </p>
			
			<p class="form_caption">
                <label for="caption">&nbsp;</label> 
                <small>Date Format: YYYY-MM-DD</small><br>
            </p>
			
			<?php
			if ($eventgroup == 'conso') 
			{
				$this->db->select('e.event_long_title, count(e.event_id) ecount');
				$this->db->groupby('e.event_long_title');
				$query = $this->db->get('events e')->result();
				// $result = $query->result();
				
				$elist = array(0);
				if ($query) 
				{
					// transform result into an associative array
					foreach($query as $r) {
						$array[htmlspecialchars($r->event_long_title)] = $r->event_long_title . " ($r->ecount)" ;
					}
					$elist = $array;
					 
				}

			?>
			<p>
                <label for="event_id">Select Event Title:</label>
                <?php echo form_dropdown('event_long_title', $elist, set_value('event_long_title')); ?>
                <?php echo form_error('event_long_title');?>
            </p>		
			<?php 
			} 
			else 
			{ 
				if ($eventgroup != 'summary')
				{
				?>
			<p>
                <label for="event_id">Select Specific Event:</label>
				<?php $events = $this->reports->get_event_title(); ?> 
                <?php echo form_dropdown('event_id', $events, set_value('event_id')); ?>
                <?php echo form_error('event_id');?>
            </p>		
            <?php } } ?>

            <p class="submit_button">
            	<label for="submit">&nbsp;</label> 
                <button type="submit" name="view" value="view">View Reports</button> or <?php echo anchor('', 'Cancel'); ?>
                <label for="submit">&nbsp;</label> 
                <!--<button type="submit" name="dl" value="dl">Download Report as CSV</button>-->
            </p>
		</div>        
        </form>
        
        <div class="clearfix"></div>
    </div>

</div> <!-- content -->

<?php include_once('footer.php'); ?>