<?php include_once('header.php'); ?>

<div class="content">
	<h2><?php echo $page_title; ?></h2>
    <div class="form_page">
        <?php echo (validation_errors()) ? '<div class="errors">Error!  Please review the information below.</div>' : ''; ?>
        
        <?php echo form_open($form_url, "target=_blank"); ?>

        <div class="half_page">
        	<h3>Advance Sales Report (per Event) Filtering</h3>
			
			<p>
                <label for="reports_date">AS OF:</label> 
                <input type="text" name="reports_date" value="<?php echo set_value('reports_date', date('Y-m-d'))?>" maxlength="100" />
                <?php echo form_error('reports_date');?>
            </p>
			
			<p class="form_caption">
                <label for="caption">&nbsp;</label> 
                <small>Date Format: YYYY-MM-DD</small>
            </p>
			
			<?php if (isset($elist)) {?>
			<p>
                <label for="event_id">Select Event Title:</label>
				<?php // $events = $this->reports->get_event_long_title(); ?> 
                <?php echo form_dropdown('event_long_title', $elist, set_value('event_long_title')); ?>
                <?php echo form_error('event_long_title');?>
            </p>		
			<?php } else { ?>
			<p>
                <label for="event_id">Select Specific Event:</label>
				<?php $events = $this->reports->get_event_title(); ?> 
                <?php echo form_dropdown('event_id', $events, set_value('event_id')); ?>
                <?php echo form_error('event_id');?>
            </p>		
            <?php } ?>
            <p class="submit_button">
            	<label for="submit">&nbsp;</label> 
                <button type="submit">View Reports</button> or <?php echo anchor('', 'Cancel'); ?>
            </p>
		</div>        
        </form>
        
        <div class="clearfix"></div>
    </div>

</div> <!-- content -->

<?php include_once('footer.php'); ?>