<?php include_once('header.php'); ?>
<script type="text/javascript">
$(function () {
Array.prototype.forEach.call(document.body.querySelectorAll("*[data-mask]"), applyDataMask);




function applyDataMask(field) {
    var mask = field.dataset.mask.split('');
    
    // For now, this just strips everything that's not a number
    function stripMask(maskedData) {
        function isDigit(char) {
            return /\d/.test(char);
        }
        return maskedData.split('').filter(isDigit);
    }
    
    // Replace `_` characters with characters from `data`
    function applyMask(data) {
        return mask.map(function(char) {
            if (char != '_') return char;
            if (data.length == 0) return char;
            return data.shift();
        }).join('')
    }
    
    function reapplyMask(data) {
        return applyMask(stripMask(data));
    }
    
    function changed() {   
        var oldStart = field.selectionStart;
        var oldEnd = field.selectionEnd;
        
        field.value = reapplyMask(field.value);
        
        field.selectionStart = oldStart;
        field.selectionEnd = oldEnd;
    }
    
    field.addEventListener('click', changed)
    field.addEventListener('keyup', changed)
}
});
</script>
<div class="content">
	<h2>Edit Promoter</h2>
    <div class="form_page">
        <?php echo (validation_errors()) ? '<div class="errors">Error!  Please review the information below.</div>' : ''; ?>
        
        <?php echo form_open('promoters/edit/'.$promoter->promoter_id); ?>
		

        <div class="half_page">
        
        	<h3>Promoter Info</h3>
			
			<p>
                <label for="promoter_username">Promoter Username:*</label> 
                <input type="text" name="promoter_username" value="<?php echo set_value('promoter_username', $promoter->promoter_username)?>" maxlength="100" />
                <?php echo form_error('promoter_username');?>
            </p>	
			
			<p>
                <label for="promoter_name">Company Name:*</label> 
                <input type="text" name="promoter_name" value="<?php echo set_value('promoter_name', $promoter->promoter_name)?>" maxlength="100" />
                <?php echo form_error('promoter_name');?>
            </p>
			
			<p>
                <label for="promoter_signatory">Signatory:*</label> 
                <input type="text" name="promoter_signatory" value="<?php echo set_value('promoter_signatory', $promoter->promoter_signatory)?>" maxlength="100" />
                <?php echo form_error('promoter_signatory');?>
            </p>
			
			<p>
                <label for="promoter_position">Position:*</label> 
                <input type="text" name="promoter_position" value="<?php echo set_value('promoter_position', $promoter->promoter_position)?>" maxlength="100" />
                <?php echo form_error('promoter_position');?>
            </p>
			<p>
                <label for="promoter_tin">TIN:*</label> 
                <input type="text" name="promoter_tin" value="<?php echo set_value('promoter_tin', $promoter->promoter_tin)?>"  maxlength="100" />
                <?php echo form_error('promoter_tin');?>
            </p>
            <p>
                <label for="promoter_vendor_key">Vendor Key:</label> 
                <input type="text" name="promoter_vendor_key" value="<?php echo set_value('promoter_vendor_key', $promoter->promoter_vendor_key)?>" maxlength="100" />
                <?php echo form_error('promoter_vendor_key');?>
            </p>
			<p>
			<label for="promoter_vendor_key">Active:*</label> 
			<input type="checkbox" name="promoter_active" value="1"<?php echo set_checkbox('promoter_active', '1', ($promoter->promoter_active == '1') ? TRUE : FALSE); ?> /> 
			</p>
		    
        	
            
            
			<!--h3>Community Tax Certificate</h3>
			<p>
                <label for="promoter_ctc_number">CTC Number:*</label> 
                <input type="text" name="promoter_ctc_number" value="<?php echo set_value('promoter_ctc_number', $promoter->promoter_ctc_number)?>" maxlength="100" />
                <?php echo form_error('promoter_ctc_number');?>
            </p>
			
			<p>
                <label for="promoter_ctc_date">CTC Date Issued:</label> 
                <input type="text" name="promoter_ctc_date" value="<?php echo set_value('promoter_ctc_date', $promoter->promoter_ctc_date)?>" /maxlength="100" >
                <?php echo form_error('promoter_ctc_date');?>
            </p>
			
			<p>
                <label for="promoter_ctc_place">CTC Place Issued:</label> 
                <input type="text" name="promoter_ctc_place" value="<?php echo set_value('promoter_ctc_place', $promoter->promoter_ctc_place)?>" maxlength="100" />
                <?php echo form_error('promoter_ctc_place');?>
            </p-->
            
        </div>
			
        <div class="half_page float_right">
        
        	<h3>Contact Info</h3>
			<p>
                <label for="promoter_address1">Address 1:</label> 
                <input type="text" name="promoter_address1" value="<?php echo set_value('promoter_address1', $promoter->promoter_address1)?>" maxlength="100" />
                <?php echo form_error('promoter_address1');?>
            </p>
			
			<p>
                <label for="promoter_address2">Address 2:</label> 
                <input type="text" name="promoter_address2" value="<?php echo set_value('promoter_address2', $promoter->promoter_address2)?>" maxlength="100" />
                <?php echo form_error('promoter_address2');?>
            </p>
			
			<p>
                <label for="promoter_city">City:</label> 
                <input type="text" name="promoter_city" value="<?php echo set_value('promoter_city', $promoter->promoter_city)?>" maxlength="100" />
                <?php echo form_error('promoter_city');?>
            </p>
			
			<p>
                <label for="promoter_zip">Zip Code:</label> 
                <input type="text" name="promoter_zip" value="<?php echo set_value('promoter_zip', $promoter->promoter_zip)?>" maxlength="100" />
                <?php echo form_error('promoter_zip');?>
            </p>
			
			<p>
                <label for="promoter_country">Country:</label> 
                <input type="text" name="promoter_country" value="<?php echo set_value('promoter_country', $promoter->promoter_country)?>" maxlength="100" />
                <?php echo form_error('promoter_country');?>
            </p>
			
			<p>
                <label for="promoter_phone1">Work Phone 1:</label> 
                <input type="text" name="promoter_phone1" value="<?php echo set_value('promoter_phone1', $promoter->promoter_phone1)?>" maxlength="100" />
                <?php echo form_error('promoter_phone1');?>
            </p>
			
			<p>
                <label for="promoter_phone2">Work Phone 2:</label> 
                <input type="text" name="promoter_phone2" value="<?php echo set_value('promoter_phone2', $promoter->promoter_phone2)?>" maxlength="100" />
                <?php echo form_error('promoter_phone2');?>
            </p>
			
			<p>
                <label for="promoter_fax">Fax Number:</label> 
                <input type="text" name="promoter_fax" value="<?php echo set_value('promoter_fax', $promoter->promoter_fax)?>" maxlength="100" />
                <?php echo form_error('promoter_fax');?>
            </p>
			
			<p>
                <label for="promoter_mobile">Mobile Number:</label> 
                <input type="text" name="promoter_mobile" value="<?php echo set_value('promoter_mobile', $promoter->promoter_mobile)?>" maxlength="100" />
                <?php echo form_error('promoter_mobile');?>
            </p>
			
			<p>
                <label for="promoter_email">Email Address:</label> 
                <input type="text" name="promoter_email" value="<?php echo set_value('promoter_email', $promoter->promoter_email)?>" maxlength="100" />
                <?php echo form_error('promoter_email');?>
            </p>
			
			<p>
                <label for="promoter_website">Website Address:</label> 
                <input type="text" name="promoter_website" value="<?php echo set_value('promoter_website', $promoter->promoter_website)?>" maxlength="100" />
                <?php echo form_error('promoter_website');?>
            </p>
            
            
            <p class="submit_button">
            	<label for="submit">&nbsp;</label> 
                <button type="submit">Save Changes</button> or <?php echo anchor('promoters/listing', 'Cancel'); ?>
            </p>		
		</div> 
	  
        </form>
		
		<div class="clearfix"></div>
    </div>

</div> <!-- content -->

<?php include_once('footer.php'); ?>