<?php
		$in = 72; // inch
		$right_panel_width = 2.5 * $in;
		$right_text_height = 80;
		$left_panel_width = 1.5 * $in;
		$line_top_margin = 29; // start of lines
		$line_text_margin = 0;
		$logo_height = 20;
		$logo_width = 0;
		$logo_count = 0;
		$logo_margin = 5;
		$text_margin = 2;
		$left_container_width = 88;
		$left_text_margin = 1;

		

		$transaction_id = $transaction->transaction_id;
		
		if ($transaction_id == '') show_404();

		// get data
		// $transaction = $this->transactions_model->get($transaction_id);
		// $tickets = $this->tickets->get_tickets_by_transaction($transaction_id, '', $type);
		
		$ticket_layout = $this->tickets->ticket_layouts_model->get($tickets[0]->ticket_event_id);
		$branch = $this->branches_model->get($transaction->transaction_branch_id);
		$payments = $this->payments_model->get_payments($transaction_id);
		if (count($payments) == 0)
		{
			$payment_type = 'CASH';
		}
		else
		{
			$payment_type = (count($payments) > 1) ? 'Multi' : $payments[0]->payment_type_code;
		}
			
		if ($ticket_layout->logo1 and file_exists($_SERVER["DOCUMENT_ROOT"] . '/uploads/' . $ticket_layout->logo1))
		{
			$logo1 = getimagesize('uploads/'.$ticket_layout->logo1);
 			$logo1_width = floor($logo1[0]*$logo_height/$logo1[1]);
			$logo_width += $logo1_width + $logo_margin;
		}
		
		if ($ticket_layout->logo2 and file_exists($_SERVER["DOCUMENT_ROOT"] . '/uploads/' . $ticket_layout->logo2))
		{
			$logo2 = getimagesize('uploads/'.$ticket_layout->logo2);
			$logo2_width = floor($logo2[0]*$logo_height/$logo2[1]);
			$logo_width += $logo2_width + $logo_margin;
		}
		
		if ($ticket_layout->logo3 and file_exists($_SERVER["DOCUMENT_ROOT"] . '/uploads/' . $ticket_layout->logo3))
		{
			$logo3 = getimagesize('uploads/'.$ticket_layout->logo3);
			$logo3_width = floor($logo3[0]*$logo_height/$logo3[1]);
			$logo_width += $logo3_width + $logo_margin;
		}
		
		if ($ticket_layout->logo4 and file_exists($_SERVER["DOCUMENT_ROOT"] . '/uploads/' . $ticket_layout->logo4))
		{
			$logo4 = getimagesize('uploads/'.$ticket_layout->logo4);
			$logo4_width = floor($logo4[0]*$logo_height/$logo4[1]);
			$logo_width += $logo4_width + $logo_margin;
		}
		
		if ($ticket_layout->logo5 and file_exists($_SERVER["DOCUMENT_ROOT"] . '/uploads/' . $ticket_layout->logo5))
		{
			$logo5 = getimagesize('uploads/'.$ticket_layout->logo5);
			$logo5_width = floor($logo5[0]*$logo_height/$logo5[1]);
			$logo_width += $logo5_width + $logo_margin;
		}
		$logo_left_margin = floor(($right_panel_width - $logo_width)/2);
		$logo_left_margin = ($logo_left_margin > 0) ? $logo_left_margin : 0;
		$logo_left_margin += $left_panel_width;	
		
		// include pdf libraries
		require(BASEPATH.'application/libraries/tfpdf/tfpdf.php');
		
        $pdf = new tFPDF('L', 'pt', array($in * 4, $in * 2));
		$pdf->AddFont('Arial','','arial.ttf',true);
		$pdf->AddFont('Arial','B','arialbd.ttf',true);
		$pdf->AddFont('Courier','','cour.ttf',true);
		$pdf->AddFont('Courier','B','courbd.ttf',true);
		$pdf->AddFont('Times','','times.ttf',true);
		$pdf->AddFont('Times','B','timesbd.ttf',true);
		
		$pdf->SetDrawColor(207, 207, 207);
			
		$count = 0;
		// echo "<PRE>"; print_r($tickets); echo "</PRE>";
		foreach ($tickets as $ticket)
		{

			if ($ticket->ticket_acknowledgment_receipt > 0)
			{
				$receipt_number = $ticket->ticket_acknowledgment_receipt;
			}
			else
			{
				if ($ticket->ticket_type_discount_type == 'Percentage' and $ticket->ticket_type_discount == 100)
				{
					$receipt_number = 'COMPLIMENTARY';
				}
				else
				{
					// get receipt number
					$receipt_number = $this->branches_model->get_last_receipt_number($branch->branch_id);
					
					// update transactions table
					$this->tickets->update_acknowledgment_receipt($ticket->ticket_id, $receipt_number);
				}
			}

			
			$pdf->AddPage();
			$pdf->SetAutoPageBreak('Auto', 0);
			error_log("Marker: PDF Page Creation $transaction_id -> ". $ticket->ticket_id);
			
				// get section serial number
			$serial_number = $this->prices_model->get_serial_number($ticket->ticket_price_id);

			
			// left pane

			// $pdf->Image('uploads/ticket4x2.jpg', 0, 0, 0, 0);

			$left_top = 42 + $in * 2 * $count;
			$left = 5; // originally 11
			$left_container_width = 88;
			// $left_container_width = 75;

			// EK BARCODE
			if (($ticket->events_config_ekbarcode_active == 1) && ($ticket->ek_barcode != '')) {
				if ($ticket->ek_days_valid > 0) {
					
					$expdate_only = date("d M Y", strtotime("+" . $ticket->ek_days_valid . " days"));
					// $expdate = "Date Expiry: " . $expdate_only;
					$expdate = $expdate_only;
					$date_h = "DATE EXPIRY";
				} else {
					$expdate = "00-00-0000";
					$expdate = " ";
					$date_h = "";
					$expdate_only = "";
				}

				$barcode_hash = strtoupper($ticket->ek_barcode);
				$transaction_barcode = base_url()."resources/barcode/ek_barcode.php?text=$barcode_hash&rot=270&fs=0";
				$transaction_barcode_h = base_url()."resources/barcode/ek_barcode.php?text=$barcode_hash&fs=0";
				// $barcode_size = getimagesize($transaction_barcode);

				$barcode_w = $left_container_width;
				$barcode_h = 20;
				$adjust_h = 20;
				$left_top -= $adjust_h;
				// $pdf->Image($transaction_barcode, 416, 180, 0, 30, 'PNG');
				// $pdf->Image($transaction_barcode, $left+$left_container_width-2, $left_top, $barcode_h+5 , $barcode_w+30, 'PNG');
				// $pdf->Image($transaction_barcode, $left+$left_container_width+185, $left_top, $barcode_w , $barcode_h, 'PNG');
				
				// barcode text
				$size = 6;
				$pdf->SetXY($left, $left_top); 
				$pdf->SetFont('Arial', '', $size);
				$pdf->Cell($left_container_width, $size, $barcode_hash, 0, 0, 'L');
				$pdf->SetXY($left, $left_top); 
				if ($ticket->ek_days_valid > 0) {
					$pdf->Cell($left_container_width+10, $size, $expdate_only, 0, 0, 'R');
				}

				// left-side
				$left_top += 6;
				// $pdf->SetXY($left, $left_top); 
				$pdf->Image($transaction_barcode_h, $left+3, $left_top, $barcode_w, $barcode_h, 'PNG');
				
				
				
				// transaction ID beside barcode
				$pdf->SetXY($left, $left_top); 
				$pdf->SetFont('Arial', 'B', $size);
				$text = '   TN: ' . sprintf('%05s', $transaction->transaction_id);
				// $pdf->Cell($left_container_width+10, $size, $text , 0, 0, 'R');

				// $size = 6;
				// $pdf->SetFont('Arial', 'B', $size);
				$pdf->SetXY($left, $left_top+7); 
				$text = strtoupper($ticket->ticket_type_code);
				// $text .= ($payment_type) ? '/' . strtoupper($payment_type) : '';
				// $pdf->Cell($left_container_width+10, $size, $text , 0, 0, 'R');
				
				$left_top += $size + $left_text_margin;
				// right-side
				// $pdf->Image($transaction_barcode_h, 185, 85 + $in * 2 * $count, $barcode_w, $barcode_h, 'PNG');
				$size = 7;
				$pdf->SetXY(185, 83 + $in * 2 * $count); 
				$pdf->SetFont('Arial', '', $size);
				$pdf->Cell($left_container_width, $size, $date_h, 0, 0, 'R');
				
				$size = 14;
				$pdf->SetXY(185, 90 + $in * 2 * $count); 
				$pdf->SetFont('Arial', 'B', $size);
				// $pdf->Cell($left_container_width, $size, $barcode_hash, 0, 0, 'R');
				if ($ticket->ek_days_valid > 0) {
					$pdf->Cell($left_container_width, $size, $expdate, 1, 0, 'R');
				}
				$pdf->SetFont('Arial', 'B', $size);
				$pdf->SetXY(185, 97 + $in * 2 * $count);
				
				// $pdf->Cell($left_container_width, $size, $expdate, 0, 0, 'R');
				
				 $left_top += $adjust_h;
			} 
			
			$left_top -=5;
			$size = 4;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			$pdf->Cell($left_container_width, $size, 'EVENT', 0, 0, 'L');
			$left_top += $size + $left_text_margin;
			
			$size = 7;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', 'B', $size);
			$pdf->Cell($left_container_width, $size, strtoupper($ticket->event_code), 0, 0, 'L');
			$left_top += $size + $left_text_margin;

			
			$size = 4;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			$pdf->Cell($left_container_width, $size, 'SECTION', 0, 0, 'L');
			$left_top += $size + $left_text_margin;
			
			$size = 6; $left_top -= 4;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', 'B', $size);
			$pdf->Cell($left_container_width, $size, '#'.sprintf('%05s', $ticket->ticket_id), 0, 0, 'R');
			// $left_top += $size + $left_text_margin;
			$left_top += 4;

			$size = 7;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', 'B', $size);
			$pdf->Cell($left_container_width, $size, strtoupper($ticket->section_name), 0, 0, 'L');
			$left_top += $size + $left_text_margin;
			
			// $nobarcode = (empty($transaction_barcode));
			$nobarcode = true;
			if ($nobarcode) {
				$size = 4;
				$pdf->SetXY($left, $left_top); 
				$pdf->SetFont('Arial', '', $size);
				$pdf->Cell($left_container_width, $size, 'ROW - SEAT', 0, 0, 'L');
			} 
			$left_top += $size + $left_text_margin;
			
			$size = 6; $left_top -= 4;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', 'B', $size);
			$pdf->Cell($left_container_width, $size, sprintf('%05s', $serial_number), 0, 0, 'R');
			// $left_top += $size + $left_text_margin;
			$left_top += 4;
			if ($nobarcode) {
				$size = 7;
				$pdf->SetXY($left, $left_top); 
				$pdf->SetFont('Arial', 'B', $size);
				$ticket_row = ($ticket->ticket_row) ? $ticket->ticket_row . ' - ' : '';
				$pdf->Cell($left_container_width, $size, strtoupper($ticket_row . $ticket->ticket_seat), 0, 0, 'L');
			}
			$left_top += $size + $left_text_margin;

			$size = 4;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			$pdf->Cell($left_container_width, $size, 'TICKET PRICE', 0, 0, 'L');
			$left_top += $size + $left_text_margin;
		
			$size = 5; $left_top -= 6;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', 'B', $size);
			$text = strtoupper($ticket->ticket_type_code);
			$text .= ($payment_type) ? '/' . strtoupper($payment_type) : '';
			$pdf->Cell($left_container_width, $size, $text , 0, 0, 'R');
			$left_top += $size + $left_text_margin;
			
			if ($ticket->ticket_type_discount_type == 'Amount')
			{
				$ticket_price = ceil($ticket->price_price - $ticket->ticket_type_discount);
			}
            elseif ($ticket->ticket_type_discount_type == 'Percentage')
			{
            	$ticket_price= ceil($ticket->price_price - (($ticket->price_price * $ticket->ticket_type_discount)/100));
			}
			
			$size = 7;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', 'B', $size);
			$pdf->Cell($left_container_width, $size, 'Php **' . number_format($ticket_price) . '**', 0, 0, 'L');
			$left_top += $size + $left_text_margin;
			
			$size = 4;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			if ($receipt_number != 'COMPLIMENTARY') {
				$pdf->Cell($left_container_width, $size, 'ACK RECEIPT NO.', 0, 0, 'L');
			}
			
			$pdf->SetXY($left, $left_top); 
			$pdf->Cell($left_container_width, $size, 'TRANSACTION ID.', 0, 0, 'R');
			$left_top += $size + $left_text_margin;
			
			$size = 5; $left_top -= 6;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', 'B', $size);
			// $pdf->Cell($left_container_width, $size, $text , 0, 0, 'R');
			$left_top += $size + $left_text_margin;

			$size = 7;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', 'B', $size);
			$pdf->Cell($left_container_width, $size, sprintf('%07s', $receipt_number), 0, 0, 'L');

			$pdf->SetXY($left, $left_top); 
			$text = sprintf('%05s', $transaction->transaction_id);
			$pdf->Cell($left_container_width, $size, $text , 0, 0, 'R');
			$left_top += $size + $left_text_margin;
			
			$isweb = '';
			if ($transaction->transaction_user_id == $this->config->item('online_seller_id')) {
				$isweb = 'WEB';
			}

			$size = 4; // $left_top += 2;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			$pdf->Cell($left_container_width, $size, $isweb, 0, 0, 'R');
			$left_top += $size + $left_text_margin;

			// line for transaction date 
			// $size = 4; $left_top += 2;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			$pdf->Cell($left_container_width, $size, mysqldatetime_to_date($ticket->transaction_date, $format = "m-d-Y"), 0, 0, 'L');
			
			$size = 4;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			if ($isweb == 'WEB') {
				$pdf->Cell($left_container_width, $size, $serial, 0, 0, 'R');
			} else {
				$pdf->Cell($left_container_width, $size, $transaction->terminal_code, 0, 0, 'R');
			}
			if ($receipt_number != 'COMPLIMENTARY') {
				$pdf->SetXY($left, $left_top); 
				// $pdf->Cell($left_container_width, $size, 'AR NO.', 0, 0, 'R');
			}
			$left_top += $size + $left_text_margin;
				
			$size = 4;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			$pdf->Cell($left_container_width, $size, mysqldatetime_to_date($ticket->transaction_date, $format = "h:i:sA"), 0, 0, 'L');
			
			$size = 4;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			$pdf->Cell($left_container_width, $size, strtoupper($ticket->username), 0, 0, 'R');
			
			if ($receipt_number != 'COMPLIMENTARY') {
				$pdf->SetXY($left, $left_top); 
//				$pdf->Cell($left_container_width, $size, sprintf('%07s', $receipt_number), 0, 0, 'R');
			}
			$left_top += $size + $left_text_margin;
			
			// right pane
			
			// reset the left margin
			$left_margin = $logo_left_margin;
			
			if (($ticket->events_config_ekbarcode_active == 1) && ($ticket->ek_barcode != '')) {
				// reset the top margin
				$top = 5;
			} else {
				if ($ticket_layout->logo1 and isset($logo1))
				{
					$pdf->Image('uploads/'.$ticket_layout->logo1, $left_margin, 5 + $in * 2 * $count, 0, $logo_height);
					$left_margin += $logo1_width + $logo_margin;
				}
				
				if ($ticket_layout->logo2 and isset($logo2))
				{
					$pdf->Image('uploads/'.$ticket_layout->logo2, $left_margin, 5 + $in * 2 * $count, 0, $logo_height);
					$left_margin += $logo2_width + $logo_margin;
				}
				
				if ($ticket_layout->logo3 and isset($logo3))
				{	
					$pdf->Image('uploads/'.$ticket_layout->logo3, $left_margin, 5 + $in * 2 * $count, 0, $logo_height);
					$left_margin += $logo3_width + $logo_margin;
				}
				
				if ($ticket_layout->logo4 and isset($logo4))
				{	
					$pdf->Image('uploads/'.$ticket_layout->logo4, $left_margin, 5 + $in * 2 * $count, 0, $logo_height);
					$left_margin += $logo4_width + $logo_margin;
				}
				
				if ($ticket_layout->logo5 and isset($logo5))
				{	
					$pdf->Image('uploads/'.$ticket_layout->logo5, $left_margin, 5 + $in * 2 * $count, 0, $logo_height);
				}
				
				// reset the top margin
				$top = $line_top_margin;
			}
			
			// line 1
			//if ($ticket_layout->ticket_text_1)
			//{
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont($ticket_layout->ticket_font_face_1, '', $ticket_layout->ticket_font_size_1);
				$pdf->Cell($in * 2.5, $ticket_layout->ticket_font_size_1, $ticket_layout->ticket_text_1, 0, 0, 'C');
				$top += $ticket_layout->ticket_font_size_1 + $text_margin;
			//}
			
			// line 2
			//if ($ticket_layout->ticket_text_2)
			//{
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont($ticket_layout->ticket_font_face_2, '', $ticket_layout->ticket_font_size_2);
				$pdf->Cell($in * 2.5, $ticket_layout->ticket_font_size_2, $ticket_layout->ticket_text_2, 0, 0, 'C');
				$top += $ticket_layout->ticket_font_size_2 + $text_margin;
			//}
			
			// line 3
			//if ($ticket_layout->ticket_text_3)
			//{
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont($ticket_layout->ticket_font_face_3, 'B', $ticket_layout->ticket_font_size_3);
				$pdf->Cell($in * 2.5, $ticket_layout->ticket_font_size_3, $ticket_layout->ticket_text_3, 0, 0, 'C');
				$top += $ticket_layout->ticket_font_size_3 + $text_margin;
			//}
			
			// line 4
			//if ($ticket_layout->ticket_text_4)
			//{
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont($ticket_layout->ticket_font_face_4, 'B', $ticket_layout->ticket_font_size_4);
				$pdf->Cell($in * 2.5, $ticket_layout->ticket_font_size_4, $ticket_layout->ticket_text_4, 0, 0, 'C');
				$top += $ticket_layout->ticket_font_size_4 + $text_margin;
			//}
			
			// line 5
			//if ($ticket_layout->ticket_text_5)
			//{
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont($ticket_layout->ticket_font_face_5, '', $ticket_layout->ticket_font_size_5);
				$pdf->Cell($in * 2.5, $ticket_layout->ticket_font_size_5, $ticket_layout->ticket_text_5, 0, 0, 'C');
				$top += $ticket_layout->ticket_font_size_5 + $text_margin;
			//}
			
			// line 6
			//if ($ticket_layout->ticket_text_6)
			//{
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont($ticket_layout->ticket_font_face_6, '', $ticket_layout->ticket_font_size_6);
				$pdf->Cell($in * 2.5, $ticket_layout->ticket_font_size_6, $ticket_layout->ticket_text_6, 0, 0, 'C');
				$top += $ticket_layout->ticket_font_size_6 + $text_margin;
			//}

			// line 7
			// if ($ticket_layout->ticket_text_7)
			// {
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont($ticket_layout->ticket_font_face_7, '', $ticket_layout->ticket_font_size_7);
				$pdf->Cell($in * 2.5, $ticket_layout->ticket_font_size_7, $ticket_layout->ticket_text_7, 0, 0, 'C');
				$top += $ticket_layout->ticket_font_size_7 + $text_margin;
			// }

			if (($ticket->events_config_ekbarcode_active == 1) && ($ticket->ek_barcode != '')) {
				// barcode text
				$size = 6;
				$top -= $size;
				$pdf->SetXY(113, $top + $in * 2 * $count); 
				$pdf->SetFont('Arial', '', $size);
				$pdf->Cell($left_container_width, $size, $barcode_hash, 0, 0, 'L');
				$top += $size;

				$pdf->Image($transaction_barcode_h, 116, $top + $in * 2 * $count, $barcode_w, $barcode_h, 'PNG');
			}

			// row - seat
			$pdf->SetXY(113, 90 + $in * 2 * $count); 
			$pdf->SetFont('Arial', '', 4);
			$pdf->Cell(50, 4, 'ROW - SEAT', 0, 0, 'L');
			
			$pdf->SetXY(113, 95 + $in * 2 * $count); 
			$pdf->SetFont('Arial', 'B', 8);
			$ticket_row = ($ticket->ticket_row) ? $ticket->ticket_row . ' - ' : '';
			$pdf->Cell($in * 2.5, 8, strtoupper($ticket_row . $ticket->ticket_seat), 0, 0, 'L');
			
			// section
			$pdf->SetXY(113, 106 + $in * 2 * $count); 
			$pdf->SetFont('Arial', '', 4);
			$pdf->Cell($in * 2.5, 4, 'SECTION', 0, 0, 'L');
			
			$pdf->SetXY(113, 110 + $in * 2 * $count); 
			$pdf->SetFont('Arial', 'B', 8);
			$pdf->Cell($in * 2.5, 8, strtoupper($ticket->section_name), 0, 0, 'L');
			
			// receipt
			//$pdf->SetXY(180, 106 + $in * 2 * $count); 
			//$pdf->SetFont('Arial', '', 4);
			//$pdf->Cell($in * 2.5, 4, 'ACK RECEIPT #', 0, 0, 'L');
			
			//$pdf->SetXY(180, 110 + $in * 2 * $count); 
			//$pdf->SetFont('Arial', '', 8);
			//$pdf->Cell($in * 2.5, 8, sprintf('%07s', $receipt_number), 0, 0, 'L');
			
			// price
			$pdf->SetXY(180, 106 + $in * 2 * $count); 
			$pdf->SetFont('Arial', '', 4);
			// $pdf->Cell(30, 4, 'PRICE', 0, 0, 'L');
			// $pdf->Cell($left_container_width, 4, 'PRICE', 0, 0, 'L');
			
			// $pdf->SetXY(220, 106 + $in * 2 * $count); 
			$pdf->SetFont('Arial', '', 4);
			$text = "PRICE ". strtoupper($ticket->ticket_type_code);
			$text .= ($payment_type) ? '/' . strtoupper($payment_type) : '';
			// $pdf->Cell(20, 4, $text, 0, 0, 'R');
			$pdf->Cell($left_container_width, 4, $text, 0, 0, 'R');
			
			$pdf->SetXY(180, 110 + $in * 2 * $count); 
			$pdf->SetFont('Arial', 'B', 8);
			// $pdf->Cell($in * 2.5, 8, 'Php **' . number_format($ticket_price) . '**', 0, 0, 'L');
			$pdf->Cell($left_container_width, 8, 'Php **' . number_format($ticket_price) . '**', 0, 0, 'R');
			
	
			// barcode
			// $pdf->SetXY(247, 88 + $in * 2 * $count); 
			// $pdf->Cell(34, 34, '', 1, 1, 'L');
			
			// others			
			$pdf->SetXY(113, 121 + $in * 2 * $count); 
			$pdf->SetFont('Arial', '', 4);
			$pdf->Cell($in * 2.5, 5, sprintf('%05s', $serial_number) . '   ' .  strtoupper($transaction->terminal_code) . '   ' . strtoupper($ticket->username) . '   ' . mysqldatetime_to_date($ticket->transaction_date, $format = "m-d-Y h:iA") . '   TN: ' . sprintf('%05s', $transaction->transaction_id) , 0, 0, 'L');
			
			// para sa BIR
			$pdf->SetXY(113, 125 + $in * 2 * $count); 
			$pdf->SetFont('Arial', '', 4);
			if ($receipt_number == 'COMPLIMENTARY')
			{
				$pdf->Cell($in * 2.5, 5, 'COMPLIMENTARY - NOT FOR SALE     ' . strtoupper($this->config->item('company_name')) . '  ' . strtoupper($branch->branch_city), 0, 0, 'L');
			}
			else
			{
				$pdf->Cell($in * 2.5, 5, 'AR No. ' . sprintf('%07s', $receipt_number) . '  ' . strtoupper($this->config->item('company_name')) . '  ' . strtoupper($branch->branch_city) . '  TIN: ' . $branch->branch_tin  , 0, 0, 'L');
			}
		}
	
		$pdf->Output();
		$pdf->Close(); 
		

?>