<?php 
	include_once('header.php'); 

	$brh_array = array();
	$get_branch_names = $this->db->query("select branch_id, branch_name from branches");

	foreach ($get_branch_names->result() as $row)
	{
		$brh_array[$row->branch_id] = $row->branch_name;
	}
?>

<div class="content">

    <div class="listing">
        <h2><?php echo "$customer->customer_firstname $customer->customer_lastname"?></h2>
        <?php echo $pagination?>

        <div class="filters">        
        <?php echo form_open('online_transactions/listing_by_customer/'); ?>
        <span>
          <label>Trans ID: </label>
          <input type="text" name="transaction_id" value="<?php echo $transaction_id?>" maxlength="100" />
        </span>
        <span>
          <label>Name: </label>
          <input type="text" name="name" value="<?php echo $name?>" maxlength="100" />
        </span>
        <span>
          <label>Mobile Number: </label>
          <input type="text" name="customer_mobile" value="<?php echo $customer_mobile?>" maxlength="100" />
         </span>
        
        <button type="submit" class="search-button">Search</button>
        <?php echo form_close();?>
        </div>
                    
        <table width="100%">
            <tr>
                <th style="text-align:center;">#</th>
                <th width="30">TransID</th>
                <th>Name</th>
                <th>Mobile Number</th>
				<th>Transaction Date</th>
				<th>Transaction Branch</th>
                <th width="150">Status</th>
                <th width="100">Action</th>
            </tr>
            <?php $x=$offset+1; foreach($transactions as $transaction): ?>
            <tr>
                
                <th><?php echo $x++; ?></th>
                <td style="text-align:center;"><?php echo $transaction->transaction_id; ?></td>
				<?php if ($transaction->customer_firstname and $transaction->customer_lastname): ?>
                <td><?php echo anchor('online_transactions/view/'.$transaction->transaction_id, $transaction->customer_firstname . ' ' . $transaction->customer_lastname);?></td>
				<?php else: ?>
				<td><?php echo anchor('online_transactions/view/'.$transaction->transaction_id, $transaction->customer_mobile);?></td>
				<?php endif; ?>
                <td><?php echo $transaction->customer_mobile; ?></td>
				<td><?php echo date("M d, Y  H:i:sa", strtotime($transaction->transaction_date)); ?></td>
				<td>
					<?php 
						if (isset($brh_array[$transaction->transaction_branch_id]))
						{
							echo $brh_array[$transaction->transaction_branch_id];
						}
						
						if ($transaction->transaction_branch_id != $transaction->ticket_branch_id)
						{
							if (isset($brh_array[$transaction->ticket_branch_id]))
							{
								echo " / ";
								echo $brh_array[$transaction->ticket_branch_id];
							}
						}
					?>
				</td>
                <td>
                	<?php
					$arrStat = explode(",", $transaction->concat_tixstatus);
					$arrStat[] = $transaction->transaction_status;

					// if (($transaction->transaction_status == 'done' || $transaction->transaction_status == 'paid') )
					if (in_array('done',$arrStat) || in_array('paid',$arrStat))
					{
						if (in_array($user_type, array('Admin','Super Admin','Admin2','Manager','Seller','Reservation')))
						{
							echo anchor('transactions/void/'.$transaction->transaction_id, 'Void Tickets');
						}
						if (($transaction->transaction_status == 'done') && (in_array($user_type, array('Admin','Super Admin','Admin2','Manager'))))
						{
							echo ' | ' . anchor('transactions/cancel/'.$transaction->transaction_id, 'Cancel Tickets'); 
						}
					}
					else 
					{
						echo strtoupper($transaction->transaction_status);
					}
					?>
                    <!--| <a href="javascript:;">Reprint Tickets</a>-->
                </td>
				<td>
					<?php echo anchor('online_transactions/edit_details/'.$transaction->transaction_id, 'Edit Details'); ?>
				</td>
            </tr>
            <?php endforeach ?>
        </table>
        <?php echo $pagination?>
    </div>

</div> <!-- content -->
<?php include_once('footer.php'); ?>