<?php include_once('header.php'); ?>

<div class="content">
	<h2><?php echo $page_title?></h2>
    <div class="form_page">
        <?php echo (validation_errors()) ? '<div class="errors">Error!  Please review the information below.</div>' : ''; ?>
        
        <?php echo form_open_multipart('news/edit/' . $news->news_id ); ?>

        <div class="half_page">
        	
            <h3>News Data</h3>
            <p>
                <label for="news_title">Title:</label> 
                <input type="text" name="news_title" value="<?php echo set_value('news_title', $news->news_title)?>" maxlength="100" />
                <?php echo form_error('news_title');?>
            </p>
            
            <p>
                <label for="news_dateposted">Posting Date:</label> 
                <input type="text"  class="frm_date" name="news_dateposted" value="<?php echo out_date( set_value('news_dateposted', $news->news_dateposted) )?>" maxlength="100" />
                <?php echo form_error('news_dateposted');?>
            </p>
            
            <p>
                <label for="news_content">Content:</label> 
                <textarea name="news_content"><?php echo set_value('news_content', $news->news_content);?></textarea>
                <?php echo form_error('news_content');?>
            </p>

            <p>
                <input type="checkbox" name="news_status" value="active" <?php echo $news->news_status == 'active' ? 'checked="checked"':''?>/>
                <label for="news_status">Is Active </label> 
                <?php echo form_error('news_status');?>
            </p>
                            
            <p class="submit_button">
            	<label for="submit">&nbsp;</label> 
                <button type="submit">Edit News</button> or <?php echo anchor('news/listing', 'Cancel'); ?>
            </p>
		</div>        
        </form>
		
		<div class="clearfix"></div>
    </div>

</div> <!-- content -->

<?php include_once('footer.php'); ?>