<?php include_once('header.php'); ?>
<div class="content">
	<h2><?php echo $page_title; ?></h2>
    <div class="form_page">
        <?php echo (validation_errors()) ? '<div class="errors">Error!  Please review the information below.</div>' : ''; ?>
        
        <?php echo form_open($form_url, "target=_blank"); ?>

        <div class="half_page">
			<h3>Ticket List Info</h3>
			<br>
			<p>
                <label for="date_from">DATE FROM:</label> 
                <input type="text" name="date_from" value="<?php echo set_value('date_from', '')?>" maxlength="100" />
                <?php echo form_error('date_from');?>
            </p>
			<p class="form_caption">
                <label for="caption">&nbsp;</label> 
                <small>OPTIONAL / Date Format: YYYY-MM-DD</small><br>
            </p>
			
			<p>
                <label for="date_to">DATE TO / AS OF:</label> 
                <input type="text" name="date_to" value="<?php echo set_value('date_to', date('Y-m-d'))?>" maxlength="100" />
                <?php echo form_error('date_to');?>
            </p>
			
			<p class="form_caption">
                <label for="caption">&nbsp;</label> 
                <small>Date Format: YYYY-MM-DD</small><br>
            </p>
			
			
			<p>
                <label for="event_id">Select Specific Event:</label>
				<?php

				if($ticket_list_type == 'conso'){
				
				$events = $this->new_reports->get_event_title_conso(); 
				
				}else{
				
				$events = $this->new_reports->get_event_title(); 
				}
				
				
				
				?> 
                <?php echo form_dropdown('event_id', $events, set_value('event_id')); ?>
                <?php echo form_error('event_id');?>
            </p>
			 	
			<p>
                		<label for="branch_id">Select Status:</label>
						<?php $stats = array('done','voided','paid_online','paid','reserved','unredeemed');
						foreach ($stats as $st) $status[$st] = $st;
						
						?> 
                		<?php echo form_dropdown('status', $status, ''); ?>
                		<?php echo form_error('status');?>
			</p>
			
			<p>
                		<label for="ticket_types">Select Ticket Type:</label> 
                		<?php echo form_dropdown('ticket_types', $ticket_types, ''); ?>
                		<?php echo form_error('ticket_types');?>
			</p>
			
			
			
            <p class="submit_button">
            	<label for="submit">&nbsp;</label> 
                <button type="submit" name="view" value="view">View Reports</button>
				or <?php echo anchor('', 'Cancel'); ?>
                <label for="submit">&nbsp;</label> 
                <button type="submit" name="dl" value="dl">Download Report as CSV</button>
			
            </p>
		</div>        
        </form>
        
        <div class="clearfix"></div>
    </div>

</div> <!-- content -->

<?php include_once('footer.php'); ?>