<root>
<?php
	$this->load->helper("xml");
	$enableNewSize = $this->config->item("enable_ticket_4x3");
	
	// size of qrcode - width x height
	$qrsize = 50;
	
	// modify with +/- value to adjust QR code position
	$qr_adjust_y = 0;
	
	// if value is 0, by default, 15% of barcode width should be the height. 
	// To override, replace value with positive value
	$bcode128_replace_h = 0;
	
	// modify with +/- value to adjust top position of background image for main section
	$main_section_bg_adjust_y = 0;
	
	// if value is 0, by default, height of background image for main section is set to floor($printable_height * (2/3))
	// To override, replace value with positive value
	$main_section_bg_h = 90;
	
	// space after bg
	// $space_after_main_bg = 1;
	$space_after_main_bg = $qr_adjust_y ;
	// you can make space after bg similar to adjustment of QR y-position
	
	
	$ticket = array ("w" => 4, "h" => 3);
	$in = 72;
	
 	$ticket["sections"] = array(
			array("w" => (1.5 / $ticket["w"]), "h" => (2 / $ticket["h"])),
			array("w" => (2.5 / $ticket["w"]), "h" => (2 / $ticket["h"])),  
			array("w" => (1.5 / $ticket["w"]), "h" => (1 / $ticket["h"])),
			array("w" => (2.5 / $ticket["w"]), "h" => (1 / $ticket["h"])),
		);
 
	// above ticket dimensions are only for reference
	
	// page array holds printable data in points/pixel unit; 
	// based on test printout, there seems to be a default top margin of about 5px, thus we shaved 5pt from all sides
	$page = array(
			"w" => 278,
			"h" => 206,
			"p" => 5,
			"ls" => 1,
		);
	// p = padding; w = width; h = height; ls = line spacing;
 	$page["sections"] = array(
			array("w" => floor($ticket["sections"][0]["w"]*$page["w"]), "h" => floor($ticket["sections"][0]["h"]*$page["h"])),
			array("w" => floor($ticket["sections"][1]["w"]*$page["w"]), "h" => floor($ticket["sections"][1]["h"]*$page["h"])),
			array("w" => floor($ticket["sections"][2]["w"]*$page["w"]), "h" => floor($ticket["sections"][2]["h"]*$page["h"])),
			array("w" => floor($ticket["sections"][3]["w"]*$page["w"]), "h" => floor($ticket["sections"][3]["h"]*$page["h"])),
		);


	// adjustment of height when there is no background image to display
	// page divided to 4 sections L->R and U->D
	// l = left; t = top;

	// the ticket label on actual ticket has a height of about 25px 
	$printable[0] = array(
		"w" => 100, 
		"h" => 100,
		"l" => 2,
		"t" => 32,
	);
	
	$printable[1] = array(
		"w" => 170, 
		"h" => 135,
		"l" => 6 + $page["sections"][0]["w"],
		"t" => 0,
	);
	
	$printable[2] = array(
		"w" => 100, 
		"h" => 68,
		"l" => $printable[0]["l"],
		"t" => 1 + $page["sections"][0]["h"],
	);
	
	$printable[3] = array(
		"w" => 170, 
		"h" => $printable[2]["h"],
		"l" => $printable[1]["l"],
		"t" => $printable[2]["t"],
	);


	echo "<layout unit=\"pt\" perinch=\"$in\" width=\"". $page["w"]	. "\" height=\"". $page["h"] . "\" transid=\"" . $transaction["id"]. "\" />\n";

	// REFERENCE: x = x-axis/horizontal; y = y-axis/vertical; w = width; h = height;

	$i = 0;
	foreach ($transaction["tickets"] as $tix)
	{
		$i++;
		$barcode_hash = sprintf('%06s',$tix["eid"]) . sprintf('%04s',$tix["bc_prefix"]) . sprintf('%06s',$tix["bc_access"]);
		echo "<ticket id=\"" . $tix['tid']. "\">\n";

		// default values for padding / text display / linespacing
		$ls = $page["ls"];
		$text = "";
		
		/* RULE for $props configuration: 
			- textbox height is equal to font-size + line spacing */
		
// ALL PAGES - PREVIEW: background image
		$quad_id = 0;
		if (!empty($bgimage[$quad_id])) {
			$img = array (
				"type" => "image",
				"x" => 0,
				"y" => 0,
				"w" => 0,
				"h" => $page["h"],
			);
//				"w" => $page["w"],
			
			$image = $bgimage[$quad_id];
			echoItem($img,$image);
		}

		if (false) {
		// <!-- VERTICAL Barcode display 
		$current_y = 0;
		$printable_height = 10;
		$printable_width = $page["sections"][$quad_id]["h"];
		$width_adjustment = 5;
		$img = array (
			"type" => "image",
			"x" => $page["w"]-$printable_height,
			"y" => $current_y + (5 *$width_adjustment),
			"w" => $printable_height,
			"h" => $printable_width-(10 *$width_adjustment),
		);
		$img["format"] = 'PNG';
		$image = base_url()."resources/barcode/vertical_barcode.php?text=$barcode_hash";
		echoItem($img,$image);
		// $current_y += $printable_height + $ls;
		// -->
		}

// SECTION 0 - initialization of generic setting
		$quad_id = 0;

		$current_x = $printable[$quad_id]["l"];
		$current_y = $printable[$quad_id]["t"];
		$printable_width = $printable[$quad_id]["w"];
		$printable_height = 0;
		$props = array(
			"type" => "textarea", // ; // refers to $pdf->Cell
			"x" => $current_x,
			"y" => $current_y,
			"w" => $printable_width,
			"h" => 0,
			"font" => "Arial",
			"size" => 0,
			"style" => "", // B = bold; (empty) = normal;
			"align" => "L",
			"border" => 0,
		);

		
		// <!-- COMPANY NAME
		$printable_height = 6;
		$props["size"] = $printable_height;
		$props["h"] = $printable_height;
		$props["align"] = "C";
		$props["style"] = "B";
		$props["y"] = $current_y;
		$text = strtoupper($this->config->item('company_name'));
		echoItem($props,$text);
		$current_y += $printable_height;
		// -->
		
		// <!-- BRANCH LOCATION
		$props["size"] = $printable_height = 4;
		$props["style"] = "";
		$props["y"] = $current_y;
		$props["h"] = $printable_height + $ls;
		$text = strtoupper($branch["city"]);
		echoItem($props,$text);
		$current_y += $printable_height;
		// -->
		
		// <!-- TIN
		$props["style"] = "";
		$props["y"] = $current_y;
		$props["h"] = $printable_height + $ls;
		$text = 'TIN: ' . $branch["tin"];
		echoItem($props,$text);
		$current_y += $printable_height;
//		$current_y += $printable_height + $ls;
		// -->
		
		// <!-- AR NUM
		$props["style"] = "";
		$props["y"] = $current_y;
		$props["h"] = $printable_height + $ls;
		$arnum = sprintf('%07s', $tix["arnum"]);
		$text = "NOT FOR SALE - ";
		if ($arnum != 'COMPLIMENTARY') {
			$text = "ACK RECEIPT NO.";
			// $text = "ACK TR";
		}
		$arnum = "$text $arnum";
		echoItem($props, $arnum);
		$current_y += $printable_height;
//		$current_y += $printable_height + $ls;
		// -->

		// SKIP LINE
		$current_y += $printable_height + $ls;
		// -->
		
		// <!-- Label: EVENT
		$props["style"] = "";
		$props["y"] = $current_y;
		$props["h"] = $printable_height + $ls;
		$props["align"] = "L";
		$text = "EVENT";
		echoItem($props,$text);
		$current_y += $printable_height + $ls;
		// -->
		
		// Dynamic: EVENTCODE
		$props["size"] = $printable_height = 7;
		$props["style"] = "B";
		$props["y"] = $current_y;
		$props["h"] = $printable_height + $ls;
		$text = strtoupper($tix['evc']);
		echoItem($props,$text);
		$current_y += $printable_height + $ls;
		// -->
		
		// Label: SECTION (left-side)
		$props["size"] = $printable_height = 4;
		$props["style"] = "";
		$props["y"] = $current_y;
		$props["h"] = $printable_height + $ls;
		$text = "SECTION";
		echoItem($props,$text);
		$current_y += $printable_height + $ls;
		// -->
		
		// Dynamic: Ticket ID {right-side}
		$props["size"] = $printable_height = 6;
		$props["style"] = "B";
		$props["align"] = "R";
		$props["h"] = $printable_height + $ls;
		$tix_id = '#'.sprintf('%05s', $tix['tid']);
		$text = $tix_id;
		echoItem($props,$text);
		$current_y = $current_y ;
		// -->

		// Dynamic: SECTION
		$props["y"] = $current_y;
		$props["size"] = $printable_height = 7;
		$props["style"] = "B";
		$props["align"] = "L";
		$props["h"] = $printable_height + $ls;
		$secname = strtoupper($tix['secname']);
		$text = $secname;
		echoItem($props,$text);
		$current_y += $printable_height + $ls;
		// -->

		// Label: ROW - SEAT (left-side)
		$props["y"] = $current_y;
		$props["size"] = $printable_height = 4;
		$props["style"] = "";
		$props["h"] = $printable_height + $ls;
		$text = "ROW - SEAT";
		echoItem($props,$text);
		$current_y += $printable_height + $ls;
		// -->
		
		// Dynamic: Serial Number {right-side}
		$props["size"] = $printable_height = 6;
		$props["style"] = "B";
		$props["align"] = "R";
		$props["h"] = $printable_height + $ls;
		$serial = sprintf('%05s', $tix['serial']);
		$text = $serial;
		echoItem($props,$text);
		$current_y = $current_y ;
		// -->
		
		// Dynamic: ROW - SEAT
		$props["y"] = $current_y;
		$props["size"] = $printable_height = 7;
		$props["h"] = $printable_height + $ls;
		$props["style"] = "B";
		$props["align"] = "L";
		$ticket_row = ($tix['row']) ? $tix['row'] . ' - ' : '';
		$ticket_row_seat = strtoupper($ticket_row . $tix['seat']);
		$text = $ticket_row_seat;
		echoItem($props,$text);
		$current_y += $printable_height + $ls;
		// -->

		// Label: TICKET PRICE (left-side)
		$props["y"] = $current_y;
		$props["size"] = $printable_height = 4;
		$props["h"] = $printable_height + $ls;
		$props["style"] = "";
		$ticket_type = strtoupper($tix['ttcode']);
		$ticket_type .= ($tix['paytype']) ? '/' . strtoupper($tix['paytype']) : '';
		$text = "PRICE $ticket_type";
		echoItem($props,$text);
		$current_y += $printable_height + $ls;
		// -->
		
		if (false) {
			// Dynamic: Ticket Type Code {right-side} (DISABLED)
			$props["size"] = $printable_height = 6;
			$props["h"] = $printable_height + $ls;
			$props["style"] = "B";
			$props["align"] = "R";
			echoItem($props,$text);
			$current_y = $current_y ;
			// -->
		}
		// Label: TRANSACTION ID (right-side)
		$props["align"] = "R";
		$text = "TRANSACTION ID";
		echoItem($props,$text);
		$current_y = $current_y;
		// -->
		
		// Dynamic: TICKET PRICE
		$props["y"] = $current_y;
		$props["size"] = $printable_height = 7;
		$props["h"] = $printable_height + $ls;
		$props["style"] = "B";
		$props["align"] = "L";
		$price = $tix['price'];
		$price = 'Php **' . number_format($price,0) . '**';
		$text = $price;
		echoItem($props,$text);
		$current_y += $printable_height + $ls;
		// -->
		
		// Dynamic: TRANSACTION ID (right-side)
		$props["align"] = "R";
		$transid = sprintf('%05s', $transaction["id"]);
		$text = $transid;
		echoItem($props,$text);
		$current_y = $current_y;
		// -->
if (false) {
		// Label: ACK RECEIPT NO (left-side)
		$props["y"] = $current_y;
		$props["size"] = $printable_height = 4;
		$props["h"] = $printable_height + $ls;
		$props["style"] = "";
		$arnum = sprintf('%07s', $tix["arnum"]);
		if ($arnum != 'COMPLIMENTARY') {
			$text = "ACK RECEIPT NO.";
			echoItem($props,$text);
		}
		$current_y += $printable_height + $ls;
		// -->

		// Label: TRANSACTION ID (right-side)
		$props["align"] = "R";
		$text = "TRANSACTION ID";
		echoItem($props,$text);
		$current_y = $current_y;
		// -->

		// Dynamic: ACK RECEIPT NO (left-side)
		$props["y"] = $current_y;
		$props["size"] = $printable_height = 7;
		$props["h"] = $printable_height + $ls;
		$props["style"] = "B";
		$props["align"] = "L";
		$text =  $arnum;
		echoItem($props,$text);
		$current_y += $printable_height + $ls;
		// -->

		// Dynamic: TRANSACTION ID (right-side)
		$props["align"] = "R";
		$transid = sprintf('%05s', $transaction["id"]);
		$text = $transid;
		echoItem($props,$text);
		$current_y = $current_y;
		// -->
}

		// SKIP LINE
		$props["y"] = $current_y;
		$props["size"] = $printable_height = 4;
		$current_y += $printable_height + $ls;
		// -->

if (true) {
		// Dynamic: Transaction DateTimeStamp - DATETIME (CENTER)
		$props["y"] = $current_y;
		$props["h"] = $printable_height;
		$props["style"] = "";
		$props["align"] = "C";
		$text =  mysqldatetime_to_date($transaction["datetime"], $format = "m-d-Y h:i:sA");
		echoItem($props,$text);
		$current_y += $printable_height;
		// -->
		
		
		// Dynamic: Web Purchase / Transaction Terminal (CENTER)
		$props["y"] = $current_y;
		$isweb = '';
		if ($transaction["uid"] == $this->config->item('online_seller_id')) {
			$isweb = 'WEB';
		}
		$text = $isweb;
		$termcode = strtoupper($tix['termcode']);
		$printer = strtoupper($tix["printer"]);
		$text .= ($isweb) ? " / $termcode" : $termcode;
		$text .= " / $printer";
		echoItem($props,$text);
		$current_y = $current_y;
		// -->
}
if (false) {
		// Dynamic: Transaction DateTimeStamp - DATE (left-side)
		$props["y"] = $current_y;
		$props["h"] = $printable_height + $ls;
		$props["style"] = "";
		$props["align"] = "L";
		$text =  mysqldatetime_to_date($transaction["datetime"], $format = "m-d-Y");
		echoItem($props,$text);
		$current_y += $printable_height + $ls;
		// -->

		// Dynamic: Web Purchase / Transaction Terminal (right-side)
		$props["align"] = "R";

		$isweb = '';
		if ($transaction["uid"] == $this->config->item('online_seller_id')) {
			$isweb = 'WEB';
		}
		$text = $isweb;
		$termcode = strtoupper($tix['termcode']);
		$text .= ($isweb) ? '/' . $termcode : '';
		echoItem($props,$text);
		$current_y = $current_y;
		// -->

		// Dynamic: Transaction DateTimeStamp - TIME (left-side)
		$props["y"] = $current_y;
		$props["style"] = "";
		$props["align"] = "L";
		$text =  mysqldatetime_to_date($transaction["datetime"], $format = "h:i:sA");
		echoItem($props,$text);
		$current_y += $printable_height + $ls;
		// -->

		// Dynamic: Ticket Username/Printer  (right-side)
		$props["align"] = "R";
		$printer = strtoupper($tix["printer"]);
		$text = $printer;
		echoItem($props,$text);
		$current_y = $current_y;
		// -->

}

// SECTION 1 - INITIALIZATION
		$quad_id = 1;

		$current_x = $printable[$quad_id]["l"];
		$current_y = $printable[$quad_id]["t"];
		$printable_width = $printable[$quad_id]["w"];
		$printable_height = 0;
		
		$props = array(
			"type" => "textarea", // ; // refers to $pdf->Cell
			"x" => $current_x,
			"y" => $current_y,
			"w" => $printable_width,
			"h" => 0,
			"font" => "Arial",
			"size" => 0,
			"style" => "", // B = bold; (empty) = normal;
			"align" => "L",
			"border" => 0,
		);

// SECTION 1A - HORIZONTAL BARCODE #1
		if (false) {
			// <!-- IMAGE: barcode display
			$width_adjustment = 5;
			$img = array (
				"type" => "image",
				"x" => $current_x + (5 *$width_adjustment),
				"y" => $current_y,
				"w" => $printable_width-(10 *$width_adjustment),
				"h" => 0,
			);
			$printable_height = ($bcode128_replace_h > 0) ? $bcode128_replace_h : ($img["w"] * .15);
			$img["h"] = $printable_height;
			$img["format"] = 'PNG';
			$image = base_url()."resources/barcode/ek_barcode.php?text=$barcode_hash";
			echoItem($img,$image);
			$current_y += $printable_height;
			// -->
		}
		
		

// SECTION 1B - UPPER PART - IMAGE: Ticket Background Image - 2/3 space of SECTION 1

		$printable_height = $page["sections"][$quad_id]["h"];
		$printable_height = floor($printable_height * (2/3));
		if (!empty($bgimage[$quad_id])) {
				
			$img = array (
				"type" => "image",
				"x" => $current_x,
				"y" => ($current_y + $main_section_bg_adjust_y),
				"w" => $printable_width,
				"h" => ($main_section_bg_h > 0) ? $main_section_bg_h : $printable_height,
			);
			$image = base_url().$bgimage[$quad_id];
			echoItem($img,$image);
		}
		
		$current_y = $img["y"];
		$current_y += $printable_height + $space_after_main_bg;

// SECTION 1C - UPPER PART - TEXT DETAILS - 2/3 space of SECTION 1
		// start of line based on previous design
		$tmp_y = $current_y;
		$current_y = 29;
		$props["align"] = "C";
		
		foreach($layout[$quad_id] as $line) {
			$text = "";
			foreach($line as $k=>$v) {
				if ($k != 'text') {
					$props[$k] = $v;
				} else {
					$text = "$v";
				}
			}
			$props["y"] = $current_y;
			$printable_height = $props["size"];
			$props["h"] = $printable_height + $ls;
			echoItem($props,$text);
			$current_y += $printable_height + $ls;
		}

// SECTION 1D - LOWER PART - TICKET DETAILS - 1/3 space of SECTION 1
		$props["w"] = $printable_width-$qrsize;
		$font_size_small = 4;
		$font_size_big = 7;

		$current_y = $tmp_y;
		$val_pos = 40;
		$props["font"] = "Arial";
		$props["align"] = "L";

		// Label: ROW - SEAT
		$props["x"] = $current_x;
		$props["y"] = $current_y;
		$props["size"] = $printable_height = $font_size_small;
		$props["h"] = $printable_height;
		$props["style"] = "";
		$text = "ROW - SEAT";
		echoItem($props,$text);
		$props["x"] = $current_x + $val_pos;
				
		// Dynamic: ROW - SEAT
		$props["y"] = $current_y;
		$props["size"] = $printable_height = $font_size_big;
		$props["h"] = $printable_height;
		$props["align"] = "L";
		$props["style"] = "B";
		$text = $ticket_row_seat;
		echoItem($props,$text);
		$current_y += $printable_height;

		// Label: SECTION {left-side}
		$props["x"] = $current_x;
		$props["y"] = $current_y;
		$props["size"] = $printable_height = $font_size_small;
		$props["h"] = $printable_height;
		$props["style"] = "";
		$text = "SECTION";
		echoItem($props,$text);
		$props["x"] = $current_x + $val_pos;


		// Dynamic: SECTION
		$props["y"] = $current_y;
		$props["size"] = $printable_height = $font_size_big;
		$props["h"] = $printable_height;
		$props["style"] = "B";
		$props["align"] = "L";
		$text = $secname;
		echoItem($props,$text);
		$props["x"] = $current_x;
	
		// Label: Price - Dynamic Ticket Type Code 
		$current_y += $printable_height;
		$props["y"] = $current_y;
		$props["size"] = $printable_height = $font_size_small;
		$props["h"] = $printable_height;
		$props["style"] = "";
		$text = "TICKET PRICE $ticket_type";
		echoItem($props,$text);
		
		// Dynamic: Ticket Price
		$current_y += $printable_height;
		$props["x"] = $current_x + $val_pos;
		$props["y"] = $current_y;
		$props["size"] = $printable_height = $font_size_big;
		$props["h"] = $printable_height;
		$props["style"] = "B";
		$text = $price;
		echoItem($props,$text);
		$current_y += $printable_height;
		$props["x"] = $current_x;
		
		// Dynamic: Barcode Display
		$props["y"] = $current_y;
		$props["size"] = $printable_height = $font_size_small;
		$props["h"] = $printable_height;
		$props["align"] = "R";
		$props["style"] = "";
		$text = $barcode_hash;
		echoItem($props,$text);
		$current_y += $printable_height + $ls;

		// Dynamic: ARNum + TransID + TixID
		$props["y"] = $current_y;
		$props["h"] = $printable_height;
		$text = "$arnum / $transid / $tix_id";
		echoItem($props,$text);
		$current_y = $current_y;

// SECTION 1E - BOTTOM BARCODE 
		if (false) {
			// <!-- #2 HORIZONTAL Barcode display 
			$width_adjustment = 5;
			$img = array (
				"type" => "image",
				"x" => $current_x + (5 *$width_adjustment),
				"y" => $current_y,
				"w" => $printable_width-(10 *$width_adjustment),
				"h" => $printable_height,
			);
			$printable_height = ($img["w"] * .15);
			$img["h"] = $printable_height;
			$current_y = $page["sections"][$quad_id]["h"] - $printable_height;
			$img["y"] = $current_y;

			$img["format"] = 'PNG';
			$image = base_url()."resources/barcode/ek_barcode.php?text=$barcode_hash";
			echoItem($img,$image);
			$current_y += $printable_height + $ls;
			// -->
		}
// SECTION 1F - OVERLAPPING HORIZONTAL BARCODE #1 FOR THE TOP AREA
		if (false) {
			// <!-- IMAGE: barcode display
			$width_adjustment = 5;
			$img = array (
				"type" => "image",
				"x" => $current_x + (5 *$width_adjustment),
				"y" => 0,
				"w" => $printable_width-(10 *$width_adjustment),
				"h" => 0,
			);
			$printable_height = ($img["w"] * .15);
			$img["h"] = $printable_height;
			$img["format"] = 'PNG';
			$image = base_url()."resources/barcode/ek_barcode.php?text=$barcode_hash";
			echoItem($img,$image);
			$current_y += $printable_height + $ls;
			// -->
		}
// SECTION 1F - QR CODE
		if (true) {
//				"x" => $page["w"] - $qrsize,
//				"x" => $current_x + $printable_width - $qrsize - 1,
			$img = array (
				"type" => "image",
				"x" => $current_x + $printable_width - $qrsize - 1,
				"y" => $page["sections"][1]["h"] - $qrsize + $qr_adjust_y,
				"w" => $qrsize,
				"h" => $qrsize,
			);
			$img["format"] = 'PNG';
			$image = base_url()."resources/phpqrcode/on-the-fly.php?data=$barcode_hash";
			//	$image = "http://localhost:8080/qrcode/on-the-fly.php?data=$barcode_hash";
			echoItem($img,$image);
			// -->
		}

// SECTION 2 - INITIALIZATION
		$quad_id = 2;

		$current_x = $printable[$quad_id]["l"];
		$current_y = $printable[$quad_id]["t"];
		$printable_width = $printable[$quad_id]["w"];
		$printable_height = 0;
		
		$props = array(
			"type" => "textarea", // ; // refers to $pdf->Cell
			"x" => $current_x,
			"y" => $current_y,
			"w" => $printable_width,
			"h" => 0,
			"font" => "Arial",
			"size" => 0,
			"style" => "", // B = bold; (empty) = normal;
			"align" => "C",
			"border" => 0,
		);


// SECTION 2A - IMAGE: Ticket Background Image

		if (!empty($bgimage[$quad_id])) {
			$printable_height = $printable[$quad_id]["h"];
				
			$img = array (
				"type" => "image",
				"x" => $current_x,
				"y" => $current_y,
				"w" => $printable_width,
				"h" => $printable_height,
			);
			$image = base_url().$bgimage[$quad_id];
			echoItem($img,$image);
			$current_y = $current_y;
		}

// SECTION 2B - TEXT DETAILS		
		foreach($layout[$quad_id] as $line) {
			$text = "";
			foreach($line as $k=>$v) {
				if ($k != 'text') {
					$props[$k] = $v;
				} else {
					$text = $v;
				}
			}
			$props["y"] = $current_y;
			$printable_height = $props["size"];
			$props["h"] = $printable_height + $ls;
			echoItem($props,$text);
			$current_y += $printable_height + $ls;
		}
// SECTION 2C - QR CODE
		if (false) {
			$img = array (
				"type" => "image",
				"x" => $current_x,
				"y" => $page["h"] - $qrsize,
				"w" => $qrsize,
				"h" => $qrsize,
			);
			$img["format"] = 'PNG';
			$image = base_url()."resources/phpqrcode/on-the-fly.php?data=$barcode_hash";
			//	$image = "http://localhost:8080/qrcode/on-the-fly.php?data=$barcode_hash";
			echoItem($img,$image);
			// -->
		}
		
// SECTION 3 - INITIALIZATION
		$quad_id = 3;

		$current_x = $printable[$quad_id]["l"];
		$current_y = $printable[$quad_id]["t"];
		$printable_width = $printable[$quad_id]["w"];
		$printable_height = 0;
		
		$props = array(
			"type" => "textarea", // ; // refers to $pdf->Cell
			"x" => $current_x,
			"y" => $current_y,
			"w" => $printable_width,
			"h" => 0,
			"font" => "Arial",
			"size" => 0,
			"style" => "", // B = bold; (empty) = normal;
			"align" => "C",
			"border" => 0,
		);


// SECTION 3A - IMAGE: Ticket Background Image
		if (!empty($bgimage[$quad_id])) {
			$printable_height = $printable[$quad_id]["h"];
				
			$img = array (
				"type" => "image",
				"x" => $current_x,
				"y" => $current_y,
				"w" => $printable_width,
				"h" => $printable_height,
			);
			$image = base_url().$bgimage[$quad_id];
			echoItem($img,$image);
			$current_y = $current_y;
		}

// SECTION 3B - TEXT DETAILS
		
		foreach($layout[$quad_id] as $line) {
			$text = "";
			foreach($line as $k=>$v) {
				if ($k != 'text') {
					$props[$k] = $v;
				} else {
					$text = $v;
				}
			}
			$props["y"] = $current_y;
			$printable_height = $props["size"];
			$props["h"] = $printable_height + $ls;
			echoItem($props,$text);
			$current_y += $printable_height + $ls;
		}
		
// SECTION 3C - QR CODE
		if (false) {
			$img = array (
				"type" => "image",
				"x" => $page["w"] - $qrsize,
				"y" => $page["h"] - $qrsize,
				"w" => $qrsize,
				"h" => $qrsize,
			);
			$img["format"] = 'PNG';
			$image = base_url()."resources/phpqrcode/on-the-fly.php?data=$barcode_hash";
//			$image = "http://localhost:8080/qrcode/on-the-fly.php?data=$barcode_hash";
			echoItem($img,$image);
			// -->
		}
// SECTION 3D - OVERLAPPING HORIZONTAL BARCODE FOR BOTTOM PAGE AREA
		if (true) {
			// <!-- IMAGE: barcode display
			$current_x = $printable[3]["l"] ;
			$printable_width = 72*1.5;
			$width_adjustment = (72 * 0.5);
			$img = array (
				"type" => "image",
				"x" => $current_x  + ($width_adjustment * 2),
				"y" => 0,
				"w" => $printable_width,
				"h" => 0,
			);
			$printable_height = ($bcode128_replace_h > 0) ? $bcode128_replace_h : ($img["w"] * .15);
$printable_height = 10;
			$img["h"] = $printable_height;
			$img["y"] = $page["h"] - ($printable_height * 1);
			$img["w"] = $printable_width;
			$img["x"] = ($page["w"] * 6 / 10);
			$img["w"] = ($page["w"] - $img["x"] - 15);
			// $img["w"] = 72 * (1.5);
			$img["format"] = 'PNG';
			$image = base_url()."resources/barcode/ek_barcode.php?text=$barcode_hash";
			echoItem($img,$image);
			$img["y"] = 0;
			echoItem($img,$image);
			$current_y += $printable_height + $ls;
			// -->
		}

		echo "</ticket>";
	}

?>
</root>