<root>
<?php
	$this->load->helper("xml");
	$enableNewSize = $this->config->item("enable_ticket_4x3");

	$ticket = array ("w" => 4, "h" => 3);
	$in = 72;
	
 	$ticket["sections"] = array(
			array("w" => (1.5 / $ticket["w"]), "h" => (2 / $ticket["h"])),
			array("w" => (2.5 / $ticket["w"]), "h" => (2 / $ticket["h"])),  
			array("w" => (1.5 / $ticket["w"]), "h" => (1 / $ticket["h"])),
			array("w" => (2.5 / $ticket["w"]), "h" => (1 / $ticket["h"])),
		);
 
	// above ticket dimensions are only for reference
	
	// page array holds printable data in points/pixel unit; 
	// based on test printout, there seems to be a default top margin of about 5px, thus we shaved 5pt from all sides
	$page = array(
			"w" => 278,
			"h" => 206,
			"p" => 5,
			"ls" => 1,
		);
	// p = padding; w = width; h = height; ls = line spacing;
 	$page["sections"] = array(
			array("w" => floor($ticket["sections"][0]["w"]*$page["w"]), "h" => floor($ticket["sections"][0]["h"]*$page["h"])),
			array("w" => floor($ticket["sections"][1]["w"]*$page["w"]), "h" => floor($ticket["sections"][1]["h"]*$page["h"])),
			array("w" => floor($ticket["sections"][2]["w"]*$page["w"]), "h" => floor($ticket["sections"][2]["h"]*$page["h"])),
			array("w" => floor($ticket["sections"][3]["w"]*$page["w"]), "h" => floor($ticket["sections"][3]["h"]*$page["h"])),
		);


	// adjustment of height when there is no background image to display
	// page divided to 4 sections L->R and U->D
	// l = left; t = top;

	// the ticket label on actual ticket has a height of about 25px 
	$printable[0] = array(
		"w" => 100, 
		"h" => 100,
		"l" => 0,
		"t" => 30,
	);
	
	$printable[1] = array(
		"w" => 160, 
		"h" => 135,
		"l" => 3 + $page["sections"][0]["w"],
		"t" => 0,
	);
	
	$printable[2] = array(
		"w" => 100, 
		"h" => 68,
		"l" => 0,
		"t" => 1 + $page["sections"][0]["h"],
	);
	
	$printable[3] = array(
		"w" => 170, 
		"h" => $printable[2]["h"],
		"l" => $printable[1]["l"],
		"t" => $printable[2]["t"],
	);


	echo "<layout unit=\"pt\" perinch=\"$in\" width=\"". $page["w"]	. "\" height=\"". $page["h"] . "\" transid=\"" . $transaction["id"]. "\" />\n";

	// REFERENCE: x = x-axis/horizontal; y = y-axis/vertical; w = width; h = height;

	$i = 0;
	foreach ($transaction["tickets"] as $tix)
	{
		$i++;
		$barcode_hash = sprintf('%06s',$tix["eid"]) . sprintf('%04s',$tix["bc_prefix"]) . sprintf('%06s',$tix["bc_access"]);
		echo "<ticket id=\"" . $tix['tid']. "\">\n";

		// default values for padding / text display / linespacing
		$ls = $page["ls"];
		$text = "";
		
		/* RULE for $props configuration: 
			- textbox height is equal to font-size + line spacing */
		
// ALL PAGES - PREVIEW: background image
		$quad_id = 0;
		if (!empty($bgimage[$quad_id])) {
			$img = array (
				"type" => "image",
				"w" => $page["w"],
				"h" => $page["h"],
				"x" => 0,
				"y" => 0,
			);
			
			$image = xml_convert($bgimage[$quad_id]);
			echoItem($img,$image);
		}

		if (true) {
		// <!-- VERTICAL Barcode display 
		$current_y = 0;
		$printable_height = 10;
		$printable_width = $page["sections"][$quad_id]["h"];
		$width_adjustment = 5;
		$img = array (
			"type" => "image",
			"y" => $current_y + (5 *$width_adjustment),
			"x" => $page["w"]-$printable_height,
			"w" => $printable_height,
			"h" => $printable_width-(10 *$width_adjustment),
		);
		$img["format"] = 'PNG';
		$image = xml_convert(base_url()."resources/barcode/vertical_barcode.php?text=$barcode_hash");
		echoItem($img,$image);
		// $current_y += $printable_height + $ls;
		// -->
		}

// SECTION 0 - initialization of generic setting
		$quad_id = 0;

		$current_x = $printable[$quad_id]["l"];
		$current_y = $printable[$quad_id]["t"];
		$printable_width = $printable[$quad_id]["w"];
		$printable_height = 0;
		$props = array(
			"type" => "textarea", // ; // refers to $pdf->Cell
			"x" => $current_x,
			"y" => $current_y,
			"w" => $printable_width,
			"h" => 0,
			"font" => "Arial",
			"size" => 0,
			"style" => "", // B = bold; (empty) = normal;
			"align" => "L",
			"border" => 0,
		);

		
		// <!-- COMPANY NAME
		$printable_height = 6;
		$props["size"] = $printable_height;
		$props["align"] = "C";
		$props["style"] = "B";
		$props["y"] = $current_y;
		$text = strtoupper($this->config->item('company_name'));
		echoItem($props,$text);
		$current_y += $printable_height + $ls;
		// -->
		
		// <!-- BRANCH LOCATION
		$props["size"] = $printable_height = 4;
		$props["style"] = "";
		$props["y"] = $current_y;
		$props["h"] = $printable_height + $ls;
		$text = strtoupper($branch["city"]);
		echoItem($props,$text);
		$current_y += $printable_height + $ls;
		// -->
		
		// <!-- TIN
		$props["style"] = "";
		$props["y"] = $current_y;
		$props["h"] = $printable_height + $ls;
		$text = 'TIN: ' . $branch["tin"];
		echoItem($props,$text);
		$current_y += $printable_height + $ls;
		// -->

		// SKIP LINE
		$current_y += $printable_height + $ls;
		// -->
		
		// <!-- Label: EVENT
		$props["style"] = "";
		$props["y"] = $current_y;
		$props["h"] = $printable_height + $ls;
		$props["align"] = "L";
		$text = "EVENT";
		echoItem($props,$text);
		$current_y += $printable_height + $ls;
		// -->
		
		// Dynamic: EVENTCODE
		$props["size"] = $printable_height = 7;
		$props["style"] = "B";
		$props["y"] = $current_y;
		$props["h"] = $printable_height + $ls;
		$text = strtoupper($tix['evc']);
		echoItem($props,$text);
		$current_y += $printable_height + $ls;
		// -->
		
		// Label: SECTION (left-side)
		$props["size"] = $printable_height = 4;
		$props["style"] = "";
		$props["y"] = $current_y;
		$props["h"] = $printable_height + $ls;
		$text = "SECTION";
		echoItem($props,$text);
		$current_y += $printable_height + $ls;
		// -->
		
		// Dynamic: Ticket ID {right-side}
		$props["size"] = $printable_height = 6;
		$props["style"] = "B";
		$props["align"] = "R";
		$props["h"] = $printable_height + $ls;
		$tix_id = '#'.sprintf('%05s', $tix['tid']);
		$text = $tix_id;
		echoItem($props,$text);
		$current_y = $current_y ;
		// -->

		// Dynamic: SECTION
		$props["y"] = $current_y;
		$props["size"] = $printable_height = 7;
		$props["style"] = "B";
		$props["align"] = "L";
		$props["h"] = $printable_height + $ls;
		$secname = strtoupper($tix['secname']);
		$text = $secname;
		echoItem($props,$text);
		$current_y += $printable_height + $ls;
		// -->

		// Label: ROW - SEAT (left-side)
		$props["y"] = $current_y;
		$props["size"] = $printable_height = 4;
		$props["style"] = "";
		$props["h"] = $printable_height + $ls;
		$text = "ROW - SEAT";
		echoItem($props,$text);
		$current_y += $printable_height + $ls;
		// -->
		
		// Dynamic: Serial Number {right-side}
		$props["size"] = $printable_height = 6;
		$props["style"] = "B";
		$props["align"] = "R";
		$props["h"] = $printable_height + $ls;
		$serial = sprintf('%05s', $tix['serial']);
		$text = $serial;
		echoItem($props,$text);
		$current_y = $current_y ;
		// -->
		
		// Dynamic: ROW - SEAT
		$props["y"] = $current_y;
		$props["size"] = $printable_height = 7;
		$props["h"] = $printable_height + $ls;
		$props["style"] = "B";
		$props["align"] = "L";
		$ticket_row = ($tix['row']) ? $tix['row'] . ' - ' : '';
		$ticket_row_seat = strtoupper($ticket_row . $tix['seat']);
		$text = $ticket_row_seat;
		echoItem($props,$text);
		$current_y += $printable_height + $ls;
		// -->

		// Label: TICKET PRICE (left-side)
		$props["y"] = $current_y;
		$props["size"] = $printable_height = 4;
		$props["h"] = $printable_height + $ls;
		$props["style"] = "";
		$ticket_type = strtoupper($tix['ttcode']);
		$ticket_type .= ($tix['paytype']) ? '/' . strtoupper($tix['paytype']) : '';
		$text = "PRICE $ticket_type";
		echoItem($props,$text);
		$current_y += $printable_height + $ls;
		// -->
		
		if (false) {
			// Dynamic: Ticket Type Code {right-side} (DISABLED)
			$props["size"] = $printable_height = 6;
			$props["h"] = $printable_height + $ls;
			$props["style"] = "B";
			$props["align"] = "R";
			echoItem($props,$text);
			$current_y = $current_y ;
			// -->
		}
		
		// Dynamic: TICKET PRICE
		$props["y"] = $current_y;
		$props["size"] = $printable_height = 7;
		$props["h"] = $printable_height + $ls;
		$props["style"] = "B";
		$props["align"] = "L";
		$price = $tix['price'];
		$price = 'Php **' . number_format($price,0) . '**';
		$text = $price;
		echoItem($props,$text);
		$current_y += $printable_height + $ls;
		// -->

		// Label: ACK RECEIPT NO (left-side)
		$props["y"] = $current_y;
		$props["size"] = $printable_height = 4;
		$props["h"] = $printable_height + $ls;
		$props["style"] = "";
		$arnum = sprintf('%07s', $tix["arnum"]);
		if ($arnum != 'COMPLIMENTARY') {
			$text = "ACK RECEIPT NO.";
			echoItem($props,$text);
		}
		$current_y += $printable_height + $ls;
		// -->

		// Label: TRANSACTION ID (right-side)
		$props["align"] = "R";
		$text = "TRANSACTION ID";
		echoItem($props,$text);
		$current_y = $current_y;
		// -->

		// Dynamic: ACK RECEIPT NO (left-side)
		$props["y"] = $current_y;
		$props["size"] = $printable_height = 7;
		$props["h"] = $printable_height + $ls;
		$props["style"] = "B";
		$props["align"] = "L";
		$text =  $arnum;
		echoItem($props,$text);
		$current_y += $printable_height + $ls;
		// -->

		// Dynamic: TRANSACTION ID (right-side)
		$props["align"] = "R";
		$transid = sprintf('%05s', $transaction["id"]);
		$text = $transid;
		echoItem($props,$text);
		$current_y = $current_y;
		// -->

		// SKIP LINE
		$props["y"] = $current_y;
		$props["size"] = $printable_height = 4;
		$current_y += $printable_height + $ls;
		// -->

		// Dynamic: Transaction DateTimeStamp - DATE (left-side)
		$props["y"] = $current_y;
		$props["h"] = $printable_height + $ls;
		$props["style"] = "";
		$props["align"] = "L";
		$text =  mysqldatetime_to_date($transaction["datetime"], $format = "m-d-Y");
		echoItem($props,$text);
		$current_y += $printable_height + $ls;
		// -->

		// Dynamic: Web Purchase / Transaction Terminal (right-side)
		$props["align"] = "R";

		$isweb = '';
		if ($transaction["uid"] == $this->config->item('online_seller_id')) {
			$isweb = 'WEB';
		}
		$text = $isweb;
		$termcode = strtoupper($tix['termcode']);
		$text .= ($isweb) ? '/' . $termcode : '';
		echoItem($props,$text);
		$current_y = $current_y;
		// -->

		// Dynamic: Transaction DateTimeStamp - TIME (left-side)
		$props["y"] = $current_y;
		$props["style"] = "";
		$props["align"] = "L";
		$text =  mysqldatetime_to_date($transaction["datetime"], $format = "h:i:sA");
		echoItem($props,$text);
		$current_y += $printable_height + $ls;
		// -->

		// Dynamic: Ticket Username/Printer  (right-side)
		$props["align"] = "R";
		$printer = strtoupper($tix["printer"]);
		$text = $printer;
		echoItem($props,$text);
		$current_y = $current_y;
		// -->


// SECTION 1 - INITIALIZATION
		$quad_id = 1;

		$current_x = $printable[$quad_id]["l"];
		$current_y = $printable[$quad_id]["t"];
		$printable_width = $printable[$quad_id]["w"];
		$printable_height = 0;
		
		$props = array(
			"type" => "textarea", // ; // refers to $pdf->Cell
			"x" => $current_x,
			"y" => $current_y,
			"w" => $printable_width,
			"h" => 0,
			"font" => "Arial",
			"size" => 0,
			"style" => "", // B = bold; (empty) = normal;
			"align" => "L",
			"border" => 0,
		);

// SECTION 1A - HORIZONTAL BARCODE #1
		if (false) {
			// <!-- IMAGE: barcode display
			$width_adjustment = 5;
			$img = array (
				"type" => "image",
				"x" => $current_x + (5 *$width_adjustment),
				"y" => $current_y,
				"w" => $printable_width-(10 *$width_adjustment),
				"h" => 0,
			);
			$printable_height = ($img["w"] * .15);
			$img["h"] = $printable_height;
			$img["format"] = 'PNG';
			$image = xml_convert(base_url()."resources/barcode/ek_barcode.php?text=$barcode_hash");
			echoItem($img,$image);
			$current_y += $printable_height + $ls;
			// -->
		}
		
		

// SECTION 1B - UPPER PART - IMAGE: Ticket Background Image - 2/3 space of SECTION 1

		$printable_height = $page["sections"][$quad_id]["h"];
		$printable_height = floor($printable_height * (2/3));
		if (!empty($bgimage[$quad_id])) {
				
			$img = array (
				"type" => "image",
				"w" => $printable_width,
				"h" => $printable_height,
				"x" => $current_x,
				"y" => $current_y,
			);
			$image = xml_convert(base_url().$bgimage[$quad_id]);
			echoItem($img,$image);
		}
		$current_y += $printable_height + $ls;

// SECTION 1C - UPPER PART - TEXT DETAILS - 2/3 space of SECTION 1
		// start of line based on previous design
		$tmp_y = $current_y;
		$current_y = 29;
		$props["align"] = "C";
		
		foreach($layout[$quad_id] as $line) {
			$text = "";
			foreach($line as $k=>$v) {
				if ($k != 'text') {
					$props[$k] = $v;
				} else {
					$text = $v;
				}
			}
			$props["y"] = $current_y;
			$printable_height = $props["size"];
			$props["h"] = $printable_height + $ls;
			echoItem($props,$text);
			$current_y += $printable_height + $ls;
		}
		
// SECTION 1D - LOWER PART - 1/3 space of SECTION 1
		$current_y = $tmp_y;
		$props["font"] = "Arial";
		$props["align"] = "L";

		// Label: ROW - SEAT
		$props["y"] = $current_y;
		$props["size"] = $printable_height = 4;
		$props["h"] = $printable_height + $ls;
		$props["style"] = "";
		$text = "ROW - SEAT";
		echoItem($props,$text);
		$current_y  =$current_y;
		
		// Right-side: Barcode Display
		$props["y"] = $current_y;
		$props["h"] = $printable_height + $ls;
		$props["align"] = "R";
		$text = $barcode_hash;
		echoItem($props,$text);
		$current_y += $printable_height + $ls;

		// Right-side: ARNum + TransID + TixID
		$props["y"] = $current_y;
		$props["h"] = $printable_height + $ls;
		$text = "$arnum / $transid / $tix_id";
		echoItem($props,$text);
		$current_y = $current_y;
		
		
		// Dynamic: ROW - SEAT
		$props["y"] = $current_y;
		$props["size"] = $printable_height = 8;
		$props["h"] = $printable_height + $ls;
		$props["align"] = "L";
		$props["style"] = "B";
		$text = $ticket_row_seat;
		echoItem($props,$text);
		$current_y += $printable_height + $ls;

		// Label: SECTION {left-side}
		$props["y"] = $current_y;
		$props["size"] = $printable_height = 4;
		$props["h"] = $printable_height + $ls;
		$props["style"] = "";
		$text = "SECTION";
		echoItem($props,$text);

		// Dynamic: Price - Ticket Type Code {right-side}
		$props["align"] = "R";
		$text = "PRICE ". $ticket_type;
		echoItem($props,$text);
		$current_y += $printable_height + $ls;

		// Dynamic: SECTION
		$props["y"] = $current_y;
		$props["size"] = $printable_height = 8;
		$props["h"] = $printable_height + $ls;
		$props["style"] = "B";
		$props["align"] = "L";
		$text = $secname;
		echoItem($props,$text);

		// Dynamic: Ticket Price (right-side)
		$props["align"] = "R";
		$text = $price;
		echoItem($props,$text);
		$current_y += $printable_height + $ls;
		
// SECTION 1E - BOTTOM BARCODE 
		if (true) {
			// <!-- #2 HORIZONTAL Barcode display 
			$width_adjustment = 5;
			$img = array (
				"type" => "image",
				"x" => $current_x + (5 *$width_adjustment),
				"y" => $current_y,
				"w" => $printable_width-(10 *$width_adjustment),
				"h" => $printable_height,
			);
			$printable_height = ($img["w"] * .15);
			$img["h"] = $printable_height;
			$current_y = $page["sections"][$quad_id]["h"] - $printable_height;
			$img["y"] = $current_y;

			$img["format"] = 'PNG';
			$image = xml_convert(base_url()."resources/barcode/ek_barcode.php?text=$barcode_hash");
			echoItem($img,$image);
			$current_y += $printable_height + $ls;
			// -->
		}
// SECTION 1F - OVERLAPPING TOP HORIZONTAL BARCODE #1
		if (true) {
			// <!-- IMAGE: barcode display
			$width_adjustment = 5;
			$img = array (
				"type" => "image",
				"x" => $current_x + (5 *$width_adjustment),
				"y" => 0,
				"w" => $printable_width-(10 *$width_adjustment),
				"h" => 0,
			);
			$printable_height = ($img["w"] * .15);
			$img["h"] = $printable_height;
			$img["format"] = 'PNG';
			$image = xml_convert(base_url()."resources/barcode/ek_barcode.php?text=$barcode_hash");
			echoItem($img,$image);
			$current_y += $printable_height + $ls;
			// -->
		}

// SECTION 2 - INITIALIZATION
		$quad_id = 2;

		$current_x = $printable[$quad_id]["l"];
		$current_y = $printable[$quad_id]["t"];
		$printable_width = $printable[$quad_id]["w"];
		$printable_height = 0;
		
		$props = array(
			"type" => "textarea", // ; // refers to $pdf->Cell
			"x" => $current_x,
			"y" => $current_y,
			"w" => $printable_width,
			"h" => 0,
			"font" => "Arial",
			"size" => 0,
			"style" => "", // B = bold; (empty) = normal;
			"align" => "C",
			"border" => 0,
		);


// SECTION 2A - IMAGE: Ticket Background Image

		if (!empty($bgimage[$quad_id])) {
			$printable_height = $printable[$quad_id]["h"];
				
			$img = array (
				"type" => "image",
				"w" => $printable_width,
				"h" => $printable_height,
				"x" => $current_x,
				"y" => $current_y,
			);
			$image = xml_convert(base_url().$bgimage[$quad_id]);
			echoItem($img,$image);
			$current_y = $current_y;
		}

// SECTION 2B - TEXT DETAILS		
		foreach($layout[$quad_id] as $line) {
			$text = "";
			foreach($line as $k=>$v) {
				if ($k != 'text') {
					$props[$k] = $v;
				} else {
					$text = $v;
				}
			}
			$props["y"] = $current_y;
			$printable_height = $props["size"];
			$props["h"] = $printable_height + $ls;
			echoItem($props,$text);
			$current_y += $printable_height + $ls;
		}
// SECTION 2C - QR CODE
		$qrsize = 30;
		if (true) {
			$img = array (
				"type" => "image",
				"x" => $current_x,
				"y" => $page["h"] - $qrsize,
				"w" => $qrsize,
				"h" => $qrsize,
			);
			$img["format"] = 'PNG';
			$image = base_url()."resources/phpqrcode/on-the-fly.php?data=$barcode_hash";
			//	$image = "http://localhost:8080/qrcode/on-the-fly.php?data=$barcode_hash";
			echoItem($img,$image);
			// -->
		}
		
// SECTION 3 - INITIALIZATION
		$quad_id = 3;

		$current_x = $printable[$quad_id]["l"];
		$current_y = $printable[$quad_id]["t"];
		$printable_width = $printable[$quad_id]["w"];
		$printable_height = 0;
		
		$props = array(
			"type" => "textarea", // ; // refers to $pdf->Cell
			"x" => $current_x,
			"y" => $current_y,
			"w" => $printable_width,
			"h" => 0,
			"font" => "Arial",
			"size" => 0,
			"style" => "", // B = bold; (empty) = normal;
			"align" => "C",
			"border" => 0,
		);


// SECTION 3A - IMAGE: Ticket Background Image
		if (!empty($bgimage[$quad_id])) {
			$printable_height = $printable[$quad_id]["h"];
				
			$img = array (
				"type" => "image",
				"w" => $printable_width,
				"h" => $printable_height,
				"x" => $current_x,
				"y" => $current_y,
			);
			$image = xml_convert(base_url().$bgimage[$quad_id]);
			echoItem($img,$image);
			$current_y = $current_y;
		}

// SECTION 3B - TEXT DETAILS
		
		foreach($layout[$quad_id] as $line) {
			$text = "";
			foreach($line as $k=>$v) {
				if ($k != 'text') {
					$props[$k] = $v;
				} else {
					$text = $v;
				}
			}
			$props["y"] = $current_y;
			$printable_height = $props["size"];
			$props["h"] = $printable_height + $ls;
			echoItem($props,$text);
			$current_y += $printable_height + $ls;
		}
		
// SECTION 3C - QR CODE
		if (true) {
			$img = array (
				"type" => "image",
				"x" => $page["w"] - $qrsize,
				"y" => $page["h"] - $qrsize,
				"w" => $qrsize,
				"h" => $qrsize,
			);
			$img["format"] = 'PNG';
			$image = base_url()."resources/phpqrcode/on-the-fly.php?data=$barcode_hash";
//			$image = "http://localhost:8080/qrcode/on-the-fly.php?data=$barcode_hash";
			echoItem($img,$image);
			// -->
		}

		echo "</ticket>";
	}

?>
</root>