<root>
<?php
	$this->load->helper("xml");

	$in = 72; // inch
	
	// ticket array holds data in inch unit;
	if ($this->config->item("enable_ticket_4x3")) {
		$ticket = array ("w" => 4, "h" => 3);
	} else {
		$ticket = array ("w" => 4, "h" => 2);
	}
 	$ticket["sections"] = array(
			array("w" => 1.5, "h" => 2),
			array("w" => 2.5, "h" => 2),  
			array("w" => 1.5, "h" => 1),
			array("w" => 2.5, "h" => 1),
		);
 
	// page array holds data in points/pixel unit; 
	$page = array(
			"w" => $ticket["w"] * $in,
			"h" => $ticket["h"] * $in,
			"p" => 4,
			"ls" => 1,
		);
	// p = padding; w = width; h = height; ls = line spacing;
	
	// page divided to 4 sections L->R and U->D
	$page["sections"][0] = array(
		"w" => $ticket["sections"][0]["w"]*$in, 
		"h" => $ticket["sections"][0]["h"]*$in, 
		"l" => 0, 
		"t" => 40,
	);
	// l = left; t = top;
	
	$page["sections"][1] = array(
		"w" => $ticket["sections"][1]["w"]*$in, 
		"h" => $ticket["sections"][1]["h"]*$in, 
		"l" => $page["sections"][0]["w"], 
		"t" => 0,
	);
	
	$page["sections"][2] = array(
		"w" => $ticket["sections"][2]["w"]*$in, 
		"h" => $ticket["sections"][2]["h"]*$in, 
		"l" => 0, 
		"t" => $page["sections"][0]["h"],
	);
	
	$page["sections"][3] = array(
		"w" => $ticket["sections"][3]["w"]*$in, 
		"h" => $ticket["sections"][3]["h"]*$in, 
		"l" => $page["sections"][2]["w"],
		"t" => $page["sections"][1]["h"],
	);
	
/*  
	$ticket = array (
		"evc" => strtoupper($ticket->event_code),
		"tid" => '#'.sprintf('%05s', $ticket->ticket_id),
		
	);
*/
	// START OF DEFAULT DATA SAMPLE
	$tix_info[] = array (
		"evc" => strtoupper("EVENTCODE"),
		"tid" => 1,
		"serial" => 1,
		"secname" => 'VIP',
		"row" => 'F',
		"seat" => 10,
		"ttcode" => "RP",
		"paytype" => "CASH",
		"price" => 1.0,
		"termcode" => "SMMOA",
		"printer" => "SELLER",
		"arnum" => 20,
		
	);
	// simulate generation of additional 10 tickets
	for($i=0; $i < $count; $i++) {
		$tix_info[] = $tix_info[0];
	}
	
	$transaction = array(
		"id" => 1,
		"datetime" => '2012-02-25 12:00:10',
		'uid' => 1,
		"tickets" => $tix_info,
	);
	
	$branch = array(
		"city" => "CITY",
		"tin" => "1234567890",
	);

	// sampler data for layout if not set
	if(!isset($layout)) {
		$layout[] = array (
			"text" => "LINE 1",
			"font" => "Helvetica",
			"size" => 1,
		);
		
		// simulate 7 layouts
		for($i=0; $i < 7; $i++) {
			$s = ((8 + $i) % 7) + 5;
			$layout[] = $layout[0];
			$layout[$i]["size"] = $s;
			$layout[$i]["text"] = "LINE ".$s;
		}
	}
	
	// END OF DATE SAMPLE
	
	
	echo "<layout unit=\"pt\" perinch=\"$in\" width=\"". $page["w"]	. "\" height=\"". $page["h"] . "\" transid=\"" . $transaction["id"]. "\" />\n";

	$i = 0;
	// x = x-axis/horizontal; y = y-axis/vertical; w = width; h = height;
	foreach ($transaction["tickets"] as $tix)
	{	
		$img = array (
			"type" => "image",
			"x" => 0,
			"y" => 0,
			"w" => 0,
			"h" => 0,
			"format" => 'JPG',
		);
		$i++;
		$barcode_hash = sprintf('%06s',$i) . "1234567890";

		echo "<ticket id=\"" . $tix['tid']. "\">\n";
		if (isset($preview) && ($preview)) {
			// for barcode display
			$image = xml_convert(BASEPATH.'application/views/images/ticket_bg.jpg');
			// $img["y"] = "-20";
			// $img["w"] = $page["w"];
			$img["h"] = 2*$in;
			echoItem($img,$image);
		}

		// default values for padding / text display / linespacing
		$padding = $page["p"];
		$ls = $page["ls"];
		$text = "";
		
		/* RULE for $props configuration: 
			- textbox height is equal to font-size + line spacing */
		
		// SECTION 0 - initialization
		$props = array(
			"type" => "textarea", // ; // refers to $pdf->Cell
			"x" => $page["sections"][0]["l"] + $padding,
			"y" => $page["sections"][0]["t"],
			"w" => ($page["sections"][0]["w"] - ($padding *2)),
			"h" => 0,
			"font" => "Arial",
			"size" => 0,
			"style" => "", // B = bold; (empty) = normal;
			"align" => "L",
			"border" => 0,
		);
		
		// for barcode display
		$img = array (
			"type" => "image",
			"x" => $props["x"],
			"y" => $props["y"],
			"w" => $props["w"],
			"h" => 20,
		);
		$img["format"] = 'PNG';
		$image = xml_convert(base_url()."resources/barcode/ek_barcode.php?text=$barcode_hash");
		echoItem($img,$image);

		
		// Label: EVENT
		$props["y"] += $img["h"] + $ls;
		$props["size"] = 4;
		$props["h"] = $props["size"] + $ls;
		$text = "EVENT";
		echoItem($props,$text);

		// Dynamic: EVENTCODE
		$props["y"] += $props["h"];
		$props["size"] = 7;
		$props["style"] = "B";
		$props["h"] = $props["size"] + $ls;
		$text = strtoupper($tix['evc']);
		echoItem($props,$text);
		
		// Label: SECTION (left-side)
		$props["y"] += $props["h"];
		$props["size"] = 4;
		$props["style"] = "";
		$props["h"] = $props["size"] + $ls;
		$text = "SECTION";
		echoItem($props,$text);
		
		// Dynamic: Ticket ID {right-side}
		$props["size"] = 6;
		$props["style"] = "B";
		$props["align"] = "R";
		$props["h"] = $props["size"] + $ls;
		$text = '#'.sprintf('%05s', $tix['tid']);
		echoItem($props,$text);

		// Dynamic: SECTION
		$props["y"] += 5; // SECTION Label: font-size + ls = 5
		$props["size"] = 7;
		$props["style"] = "B";
		$props["align"] = "L";
		$props["h"] = $props["size"] + $ls;
		$secname = strtoupper($tix['secname']);
		$text = $secname;
		echoItem($props,$text);

		// Label: ROW - SEAT (left-side)
		$props["y"] += $props["h"];
		$props["size"] = 4;
		$props["style"] = "";
		$props["h"] = $props["size"] + $ls;
		$text = "ROW - SEAT";
		echoItem($props,$text);
		
		// Dynamic: Serial Number {right-side}
		$props["size"] = 6;
		$props["style"] = "B";
		$props["align"] = "R";
		$props["h"] = $props["size"] + $ls;
		$serial = sprintf('%05s', $tix['serial']);
		$text = $serial;
		echoItem($props,$text);
		
		// Dynamic: ROW - SEAT
		$props["y"] += 5; // SECTION Label: font-size + ls = 5
		$props["size"] = 7;
		$props["style"] = "B";
		$props["align"] = "L";
		$props["h"] = $props["size"] + $ls;
		$ticket_row = ($tix['row']) ? $tix['row'] . ' - ' : '';
		$ticket_row_seat = strtoupper($ticket_row . $tix['seat']);
		$text = $ticket_row_seat;
		echoItem($props,$text);

		// Label: TICKET PRICE (left-side)
		$props["y"] += $props["h"];
		$props["size"] = 4;
		$props["style"] = "";
		$props["h"] = $props["size"] + $ls;
		$text = "TICKET PRICE";
		echoItem($props,$text);
		
		// Dynamic: Ticket Type Code {right-side}
		$props["size"] = 6;
		$props["style"] = "B";
		$props["align"] = "R";
		$props["h"] = $props["size"] + $ls;
		$ticket_type = strtoupper($tix['ttcode']);
		$ticket_type .= ($tix['paytype']) ? '/' . strtoupper($tix['paytype']) : '';
		$text = $ticket_type;
		echoItem($props,$text);
		
		// Dynamic: TICKET PRICE
		$props["y"] += 5; // SECTION Label: font-size + ls = 5
		$props["size"] = 7;
		$props["style"] = "B";
		$props["align"] = "L";
		$props["h"] = $props["size"] + $ls;
		$price = $tix['price'];
		$price = 'Php **' . number_format($price,0) . '**';
		$text = $price;
		echoItem($props,$text);

		// Label: ACK RECEIPT NO (left-side)
		$props["y"] += $props["h"];
		$props["size"] = 4;
		$props["style"] = "";
		$props["h"] = $props["size"] + $ls;
		$arnum = sprintf('%07s', $tix["arnum"]);
		if ($arnum != 'COMPLIMENTARY') {
			$text = "ACK RECEIPT NO.";
			echoItem($props,$text);
		}

		// Label: TRANSACTION ID (right-side)
		$props["align"] = "R";
		$text = "TRANSACTION ID";
		echoItem($props,$text);

		// Dynamic: ACK RECEIPT NO (left-side)
		$props["y"] += $props["h"]; 
		$props["size"] = 7;
		$props["style"] = "B";
		$props["align"] = "L";
		$props["h"] = $props["size"] + $ls;
		$text =  $arnum;
		echoItem($props,$text);

		// Dynamic: TRANSACTION ID (right-side)
		$props["align"] = "R";
		$transid = sprintf('%05s', $transaction["id"]);
		$text = $transid;
		echoItem($props,$text);

		// SKIP LINE
		$props["y"] += $props["h"]; 
		$props["size"] = 4;
		$props["h"] = $props["size"] + $ls;

		// Dynamic: Transaction DateTimeStamp - DATE (left-side)
		$props["y"] += $props["h"]; 
		$props["style"] = "";
		$props["align"] = "L";
		$props["h"] = $props["size"] + $ls;
		$text =  mysqldatetime_to_date($transaction["datetime"], $format = "m-d-Y");
		echoItem($props,$text);

		// Dynamic: Web Purchase / Transaction Terminal (right-side)
		$props["align"] = "R";

		$isweb = '';
		if ($transaction["uid"] == $this->config->item('online_seller_id')) {
			$isweb = 'WEB';
		}
		$text = $isweb;
		$termcode = strtoupper($tix['termcode']);
		$text .= ($isweb) ? '/' . $termcode : '';
		echoItem($props,$text);

		// Dynamic: Transaction DateTimeStamp - TIME (left-side)
		$props["y"] += $props["h"]; 
		$props["style"] = "";
		$props["align"] = "L";
		$props["h"] = $props["size"] + $ls;
		$text =  mysqldatetime_to_date($transaction["datetime"], $format = "h:i:sA");
		echoItem($props,$text);

		// Dynamic: Ticket Username/Printer  (right-side)
		$props["align"] = "R";
		$printer = strtoupper($tix["printer"]);
		$text = $printer;
		echoItem($props,$text);

		// SECTION 1 - initialization
		$props = array(
			"type" => "textarea", // ; // refers to $pdf->Cell
			"x" => $page["sections"][1]["l"] + $padding,
			"y" => $page["sections"][1]["t"],
			"w" => ($page["sections"][1]["w"] - ($padding *2)),
			"h" => 0,
			"font" => "Arial",
			"size" => 0,
			"style" => "", // B = bold; (empty) = normal;
			"align" => "L",
			"border" => 0,
		);

		
		// SECTION 1A - UPPER PART - 2/3
		
		// IMAGE: Ticket Background Image - 2/3 space of SECTION 1
		$img = array (
			"type" => "image",
			"x" => $page["sections"][1]["l"],
			"y" => $page["sections"][1]["t"],
			"w" => $page["sections"][1]["w"],
			"h" => ($page["sections"][1]["h"] * 2/3),
		);

		switch($i % 4) {
			case 0: 
				$img["format"] = 'PNG';
				$image = xml_convert(base_url()."resources/barcode/ek_barcode.php?text=$barcode_hash");
				break;
			case 1: 
				$img["format"] = 'JPG';
				$image = xml_convert(base_url()."uploads/tmp/SoftBG.jpg");
				break;
			case 2: 
				$img["format"] = 'JPG';
				$image = xml_convert(base_url()."uploads/tmp/TextImage.jpg");
				break;
			case 3: 
				$img["format"] = 'JPG';
				$image = xml_convert(base_url()."uploads/tmp/TicketDisplay.jpg");
				break;
		}
		echoItem($img,$image);

		$props["align"] = "C";
		// $props["y"] = $page["sections"][1]["t"] + $padding;
		
		// start of line based on previous design
		$props["y"] = 29;
		
		foreach($layout as $line) {
			$text = "";
			foreach($line as $k=>$v) {
				if ($k != 'text') {
					$props[$k] = $v;
				} else {
					$text = $v;
				}
			}
			$props["h"] = $props["size"] + $ls;
			echoItem($props,$text);
			$props["y"] += $props["h"]; 
		}
		
		
		$props["y"] = $page["sections"][1]["t"];
		// $props["w"] = ($page["sections"][0]["w"] - ($padding *2));
		// $tmp = $props["w"];
		$props["w"] -= 20;
		// SECTION 1B - LOWER PART - 1/3
		$props["font"] = "Arial";
		$props["align"] = "L";
		$props["y"] += $img["h"] + $ls;
		// adjust line
		// $ls = 3;

		// Label: ROW - SEAT
		$props["size"] = 4;
		$props["style"] = "";
		$props["h"] = $props["size"] + $ls;
		$text = "ROW - SEAT";
		echoItem($props,$text);

		// Dynamic: ROW - SEAT
		$props["y"] += $props["h"]; 
		$props["size"] = 8;
		$props["style"] = "B";
		$props["h"] = $props["size"] + $ls;
		$text = $ticket_row_seat;
		echoItem($props,$text);

		// Label: SECTION {left-side}
		$props["y"] += $props["h"];
		$props["size"] = 4;
		$props["style"] = "";
		$props["h"] = $props["size"] + $ls;
		$text = "SECTION";
		echoItem($props,$text);

		// Dynamic: Price - Ticket Type Code {right-side}
		$props["align"] = "R";
		$text = "PRICE ". $ticket_type;
		echoItem($props,$text);

		// Dynamic: SECTION
		$props["y"] += $props["h"];
		$props["size"] = 8;
		$props["style"] = "B";
		$props["align"] = "L";
		$props["h"] = $props["size"] + $ls;
		$text = $secname;
		echoItem($props,$text);

		// Dynamic: Ticket Price (right-side)
		$props["align"] = "R";
		$text = $price;
		echoItem($props,$text);
		
		// SKIP LINE
 		$props["size"] = 3;
		$props["y"] += $props["h"]; 
		$props["h"] = $props["size"] + $ls;
		
		$props["w"] += 20;
		$props["style"] = "";
		$props["align"] = "L";
		$props["size"] = 4;
		
		$props["y"] += $props["h"]; 
		$props["h"] = $props["size"] + $ls;
		$text = $serial . '   ' .  $termcode . '   ' . $printer . '   ' . mysqldatetime_to_date($transaction["datetime"], $format = "m-d-Y h:iA") . '   TN: ' . $transid;
		echoItem($props,$text);
		
		if ($arnum == 'COMPLIMENTARY') {
			$text = 'COMPLIMENTARY - NOT FOR SALE     ' . strtoupper($this->config->item('company_name')) . '  ' . strtoupper($branch["city"]);
		} else {
			$text = 'AR No. ' . $arnum . '  ' . strtoupper($this->config->item('company_name')) . '  ' . strtoupper($branch["city"]) . '  TIN: ' . $branch["tin"];
		}
		$props["y"] += $props["h"]; 
		$props["h"] = $props["size"] + $ls;
		echoItem($props,$text);

		echo "</ticket>";
	}
?>
</root>