<?php include_once('header.php'); ?>
    <script type="text/javascript">
    $(function() {
        $('.event_image a').lightBox();
		$('.event_image_thumb a').lightBox();
    });
</script>
    <div class="content">
		<h2><?php echo "EK Tickets: ".$event->event_title ?></h2>
		<ul class="crud form_crud">
			<li><?php echo anchor('ektickets/listing', 'Go back to EK Tickets listing', array('class' => 'back'))?></li>
		</ul>
      <div id="listing_detail" class="clearfix">
        <div class="half_page">
          <h3>Ticket Prices</h3>
		  
          <div class="listing ticket_prices">
		  	<?php if ($this->session->userdata('logged_in')): ?>
		  	<ul class="crud listing_crud seller_crud">
				<li><?php echo anchor("ektickets/sections/".$event->event_id, 'Sell Tickets', array('class'=>'money')); ?></li>
				<li><?php // echo anchor('transactions/sections/reserve', 'Reserve Tickets', array('class'=>'calendar')); ?></li>
			</ul>
			<?php endif; ?>
            <table width="100%">
              <tr>
                <th width="33%">Section</th>
                <th width="33%" class="align_center">Price</th>
                <th class="align_center">Available</th>

              </tr>
              <?php foreach($prices as $price): ?>
              <tr>
				<?php
				$price_id = $price->price_id;
				$available = (isset($prices_ek[$price_id])) ? $prices_ek[$price_id] : 0;
				?>
                <td><?php echo $price->price_name; ?></td>
                <td class="align_center"><?php echo number_format($price->price_price)?></td>
                <td class="align_center">
					<?php echo $available; ?>
				</td>
              </tr>
              <?php endforeach; ?>
            </table>

          </div>
		  
		  <h3>Seat Plan</h3>
          <div class="clearfix event_image"> <a href="<?php echo base_url() . 'uploads/' . $event->seatplan_image ?>"><img src="<?php echo base_url() . 'uploads/' . $event->seatplan_image ?>" title="" /></a> </div>
        </div>
        <div class="half_page float_right">
          <h3>Event Info</h3>
          <ul class="details">
          	<li class="clearfix">
              <dl>
                <dt>Event Code:</dt>
                <dd><?php echo $event->event_code ?></dd>
              </dl>
            </li>
            <li class="clearfix">
              <dl>
                <dt>Performers:</dt>
                <dd><?php echo anchor(prep_url($event->event_performers_website), $event->event_performers)?></dd>
              </dl>
            </li>
            <li class="clearfix">
              <dl>
                <dt>Venue:</dt>
                <dd><?php echo $event->venue_name ?></dd>
              </dl>
            </li>
            <li class="clearfix">
              <dl>
                <dt>Date and Time:</dt>
                <dd><?php echo mysqldatetime_to_date($event->event_date_time, $format = "M d, Y h:ia"); ?></dd>
              </dl>
            </li>
            <li class="clearfix">
              <dl>
                <dt>Promoter:</dt>
                <dd><?php echo $event->promoter_name ?></dd>
              </dl>
            </li>
            <li class="clearfix">
              <dl>
                <dt>Event Type:</dt>
                <dd><?php echo $event->event_type ?></dd>
              </dl>
            </li>
          </ul>


          <h3>Description</h3>
          <span class="event_image_thumb"> <a href="<?php echo base_url() . 'uploads/' . $event->event_image ?>"><img src="<?php echo base_url() . 'uploads/' . $event->event_image ?>" /></a> </span> <?php echo nl2br($event->event_description) ?> </div>
          
        <span class="clearfix"></span>  
      </div>
    </div>
    <!-- content -->
    <?php include_once('footer.php'); ?>