<?php
//	echo $reports['report_view'] . "<br />";
//	echo $reports['report_dl'] . "<br />";
//	print_r($reports);
	$a = microtime(true);
	$boolAdvanceDisplay = true;
	
	// FOR SPECIFIC BRANCH KEY INQUIRY
	if (is_numeric($branchkey))
	{
		if ($this->session->userdata('eventid') || $this->session->userdata('eventtitle'))
		{
			$reports['event_id'] = $this->session->userdata('eventid');
			$reports['report_view'] = $this->session->userdata('report_view');
			$reports['report_dl'] = $this->session->userdata('report_dl');
			$reports['event_long_title'] = $this->session->userdata('eventtitle');
			$reports['reports_date'] = $this->session->userdata('reports_date');
			$reports['reports_date_from'] = $this->session->userdata('reports_date_from');
			$boolAdvanceDisplay = false;			
		}
	}
	else
	{
		$this->session->set_userdata('eventid', $reports['event_id']);
		$this->session->set_userdata('report_view', $reports['report_view']);
		$this->session->set_userdata('report_dl', $reports['report_dl']);
		$this->session->set_userdata('eventtitle', $reports['event_long_title']);
		$this->session->set_userdata('reports_date', $reports['reports_date']);
		$this->session->set_userdata('reports_date_from', $reports['reports_date_from']);
	}
	
	if (!is_numeric($branchkey)) {
		if ($this->session->userdata('user_branch_id') != 1){
			$branchkey = $this->session->userdata('user_branch_id');
			$dlparam = $this->session->userdata('report_dl');
			redirect($form_url."/$branchkey/$dlparam");
		}
	}

	$event_id = $reports['event_id'];
	$event_long_title = $reports['event_long_title'];
	$strReportDateFrom = $reports['reports_date_from'];
	$boolDateRange = false;
	if ($strReportDateFrom != "") {
		$reports_date_from = strtotime($reports['reports_date_from']);
		$strReportDateFrom = date('Y-m-d',$reports_date_from);
		$boolDateRange = true;
	}
	
	$reports_date = strtotime($reports['reports_date']);
	$strReportDate = date('Y-m-d',$reports_date);


	if (empty($event_long_title)) {
		$this->db_archive_a->where('e.event_id', $event_id);
	}
	else {
		$this->db_archive_a->where('e.event_long_title', $event_long_title);
	}
	$this->db_archive_a->join('venues v', 'v.venue_id = e.event_venue_id', 'LEFT');
	$this->db_archive_a->join('promoters pro', 'pro.promoter_id = e.event_promoter_id', 'LEFT');
	$events = $this->db_archive_a->get('events e')->result_array();
	
	$event_ticket_types = array();
	foreach($events as $k=>$v) {
		$event_ids[$k] = $v["event_id"];
		$event_dates[$k] = date('Y-M-d / g:i:s a', strtotime($v["event_date_time"]));
		$event_codes[$k] = $v["event_code"];
		$event_titles[$k] = $v["event_title"];
		$event_venues[$k] = $v["venue_name"];
		$event_promoters[$k] = $v["promoter_name"];
		$event_ticket_types += unserialize($v['event_ticket_types']);
	}
	
	
	$event_venues = array_unique($event_venues);
	$event_promoters = array_unique($event_promoters);
	
	//echo "<!-- GET EVENTS LIST \n";
	//echo $this->db_archive_a->last_query();
	//echo "\n-->\n";


	// PRICE LIST (VIP, PATRON, etc): get price types including creation of section list
	$this->db_archive_a->select('
		pr.price_id
		, pr.price_name
		, pr.price_price
		, pr.price_sections
		, pr.price_event_id
		');
	$this->db_archive_a->where_in('pr.price_event_id', $event_ids);
	$this->db_archive_a->order_by('pr.price_price', 'desc');
	$price_types = $this->db_archive_a->get('prices pr')->result();
	
	//echo "<!-- PRICE LIST (VIP, PATRON, etc): get price types including creation of section list \n";
	//echo $this->db_archive_a->last_query();
	//echo "\n-->\n";


	// LIST OF TICKET SECTIONS FOR IDENTIFICATION
	$arrsubsection = array();
	foreach($price_types as $row) {
		$subsection = unserialize($row->price_sections);
		$row->price_sections = $subsection;	
		$arrsubsection = array_merge($arrsubsection, $subsection);
	}

	// SECTION LIST
	$this->db_archive_a->select('
		s.section_id
		, s.section_capacity
		, s.section_available
		, s.section_type
	');
	$this->db_archive_a->where_in('s.section_id', $arrsubsection);
	$query = $this->db_archive_a->get('sections s')->result();
	
	//echo "<!-- SECTION LIST \n";
	//echo $this->db_archive_a->last_query();
	//echo "\n-->\n";
	
	foreach($query as $section) {
		$data_sectionlist[$section->section_id][0] = $section->section_capacity;
		
		if (strtolower($section->section_type) == "reserved") { 
			$data_sectionlist[$section->section_id][1] = $section->section_available;
		} else {
			$data_sectionlist[$section->section_id][1] = $section->section_capacity;
		}
		
		$data_sectionlist[$section->section_id][2] = 0; // taken/used seats
		// identify section type
		$data_sectionlist[$section->section_id][3] = $section->section_type;
	}
	$this->db_archive_a->select('ticket_section_id, count(ticket_id) as taken');
	$this->db_archive_a->where_in('ticket_section_id', $arrsubsection);
	$this->db_archive_a->where_in('ticket_status', array('reserved','done','selected','paid','paid_online'));
	$this->db_archive_a->group_by('ticket_section_id');
	$query = $this->db_archive_a->get('tickets')->result();
	
	// echo $this->db_archive_a->last_query();
	foreach($query as $section) {
		$tmp_section_type = $data_sectionlist[$section->ticket_section_id][3];
		if (strtolower($tmp_section_type) == "reserved") { 
			// no need to recompute availability
		} else {
			$data_sectionlist[$section->ticket_section_id][1] -= $section->taken;
		}
		$data_sectionlist[$section->ticket_section_id][2] = $section->taken;
	}

	// BRANCH LIST
	$this->db_archive_a->select('br.branch_id, br.branch_name');
	if (!$boolAdvanceDisplay) {
		$this->db_archive_a->where('br.branch_id', $branchkey);
	}
	$this->db_archive_a->order_by('br.branch_name');
	$query = $this->db_archive_a->get('branches br')->result();

//	echo "<!-- BRANCH LIST \n";
//	echo $this->db_archive_a->last_query();
//	echo "\n-->\n";
	
	foreach ($query as $row) {
		$tmp_branchid = $row->branch_id;
		$tmp_branchname = $row->branch_name;
		
		if ($boolAdvanceDisplay) {
			$data_branchlist[$tmp_branchid] = array($tmp_branchid, $tmp_branchname);
		}
		else {
			$branchname = strtoupper($tmp_branchname);
		}
	}


	// USE THE FOLLOWING STATUS CONDITION
	$morestatuscondition = array("done","reserved");

	// SUMMARY TABLE: identify all tickets and transactions with DONE status and do data prep for display
	$this->db_archive_a->select('
			t.transaction_branch_id
			, date(t.transaction_date) transdate
			, t.transaction_id
			, p.payment_id
			, tix.ticket_id
			, p.payment_payment_type_id
			, pt.payment_type_type
			, pt.payment_type_name
			, tix.ticket_type_id
			, ttp.ticket_type_group
			, ttp.ticket_type_discount
			, ttp.ticket_type_name
			, ttp.ticket_type_discount_type
			, pr.price_name
			, pr.price_price
			, p.payment_amount
			, p.payment_amount_type
			, t.transaction_status
			, tix.ticket_status
			, tix.ticket_section_id
			, chr.charge_amount
			, chr.charge_type
			, ta.total_payment_type_id
		');
	$this->db_archive_a->from('tickets tix');
	$this->db_archive_a->join('transactions t', 't.transaction_id = tix.ticket_transaction_id', 'LEFT');
	$this->db_archive_a->join('payments p', 't.transaction_id = p.payment_transaction_id', 'LEFT');
	$this->db_archive_a->join('payment_types pt', 'pt.payment_type_id = p.payment_payment_type_id', 'LEFT');
	$this->db_archive_a->join('prices pr', 'tix.ticket_price_id = pr.price_id', 'LEFT');
	$this->db_archive_a->join('ticket_types ttp', 'tix.ticket_type_id = ttp.ticket_type_id', 'LEFT');
	$this->db_archive_a->join('charges chr', 't.transaction_id = chr.charge_transaction_id', 'LEFT');
	$this->db_archive_a->join('total_amount ta', 't.transaction_id = ta.total_transaction_id', 'LEFT');
	$this->db_archive_a->where_in('tix.ticket_event_id', $event_ids);
	$this->db_archive_a->where_in('t.transaction_status', $morestatuscondition);
	$this->db_archive_a->where_in('tix.ticket_status', $morestatuscondition);
	$this->db_archive_a->where('date(t.transaction_date) <= ', $strReportDate);
	if ($boolDateRange) {
		$this->db_archive_a->where('date(t.transaction_date) >= ', $strReportDateFrom);
	}
	
	if (!$boolAdvanceDisplay) {
		$this->db_archive_a->where('t.transaction_branch_id', $branchkey);
	}
	$query = $this->db_archive_a->get();

//	echo "<!-- SUMMARY TABLE: get ticket sales count \n";
//	echo $this->db_archive_a->last_query();
//	echo "\n-->\n";

	// FOR SALES GRID LAYOUT: use query result of ticket sales count to create ticket sales grid
	$data_tixdiscount = array();
	$oc_array = array();
	foreach($query->result() as $row) 
	{	
		$pid = "$row->price_name ($row->price_price)";
		$tixstat = $row->ticket_status;
		$tstat = $row->transaction_status;
		$transdate = $row->transdate;


		if (($tixstat == "reserved") || ($tstat == "reserved")) {
			$reservedcount[$pid][] = $row->ticket_id;
			// $data_tixcountgrid[$pid]["reserved"]["reserved"][] = $row->ticket_id;

			if ($transdate == $strReportDate) {
				$reservedcount[$transdate][] = $row->ticket_id;
				// $data_tixcountgrid[$transdate]["reserved"]["reserved"][] = $row->ticket_id;
			}
		}
		elseif (("$tixstat$tstat" == "donedone") || ($tixstat == "paid_online")) {
			$tgid = $row->ticket_type_group;

			$tmp_group = $tgid."GROUP";
			$paygroup = $row->payment_type_type;
			if (($paygroup != "") && ($tmp_group == "0GROUP")) {
				$payname = $row->payment_type_name;
				$payid = $row->payment_id;
				$payamt = $row->payment_amount;
				$chramount = $row->charge_amount;
				$chrtype = $row->charge_type;
				$taptype = $row->total_payment_type_id;
				
				
				if ($row->payment_amount_type == 'convenience') {
					$oc_array[$payid] = $payamt;
				}
				else {
					$deduct = 0;
					if ($taptype > 0) {
						if (is_numeric($chramount)) { 
							$deduct = $chramount;
						}
					}

					$salesbreakdown[$paygroup][$payname][$payid] = ($payamt - $deduct);
				}

			}
			
			// this is for uncategorized/unidentified ticket type
			$tmp_factor = $row->ticket_type_discount;
			$tmp_ttpname = trim($row->ticket_type_name);
			if ($tmp_ttpname == "") {
				$tmp_ttpname = "Ticket Type ID = $row->ticket_type_id";
				$tmp_factor = 0;
			}
			$tmp_Percentage = false;
			if ($row->ticket_type_discount_type == "Percentage") {
				$tmp_Percentage = true;
				$tmp_factor = (100-$tmp_factor)/100;
			}
			$data_tixdiscount[$tmp_group][$row->ticket_type_id] = array($tmp_ttpname, $tmp_factor, $tmp_Percentage);
			
			$tmp_price = $row->price_price;
			$tmp_discount = $data_tixdiscount[$tmp_group][$row->ticket_type_id][1];

/*
			if ($tmp_discount == 0) {
				// echo "<td>here $tid</td>";
			}
			elseif ($tmp_discount < 1) {
				$tmp_price = ceil($tmp_price * $tmp_discount);
			}
			else {
				$tmp_price = $tmp_price - $tmp_discount;				
			}
*/			
				if ($tmp_Percentage) {
					$tmp_price = ceil($tmp_price * $tmp_factor);
				}
				else {
					$tmp_price = $tmp_price - $tmp_discount;				
				}
			

			if ($transdate == $strReportDate) {
				$data_tixcountgrid[$transdate][$tmp_group][$row->ticket_type_id][$row->ticket_id] = $tmp_price;
			}

			// counting each ticket instead of $row->tixcount per trans_id
			$data_tixcountgrid[$pid][$tmp_group][$row->ticket_type_id][] = $row->ticket_id;
			
			// cannot include other ticket type group
			if ($tmp_group == "0GROUP") {
				
				if ($boolAdvanceDisplay) {
					$tmp_branchid = $row->transaction_branch_id;
					if (!is_numeric($tmp_branchid)) {
						$tmp_branchid = 0;
					}

					if (!isset($data_branchlist[$tmp_branchid])) {
						$data_branchlist[$tmp_branchid] = array($tmp_branchid, "Branch ID $tmp_branchid");
					}

					$data_branchsalesgrid[$tmp_branchid][$pid][$row->ticket_id] = $tmp_price;
					if ($transdate == $strReportDate) {
						$data_branchsalesgrid[$tmp_branchid][$transdate][$row->ticket_id] = $tmp_price;
					}
					
				}
			}
		}
	}
	$onlineconvenience = array_sum($oc_array);
	// DISCOUNT LIST: get ticket types (discount types)	
	$this->db_archive_a->where_in('ticket_type_id', $event_ticket_types);
	$this->db_archive_a->order_by('ticket_type_group','ASC');
	$this->db_archive_a->order_by('ticket_type_id','ASC');			
	$query = $this->db_archive_a->get('ticket_types')->result();

//	echo "<!-- DISCOUNT LIST \n";
//	echo $this->db_archive_a->last_query();
//	echo "\n-->\n";




	
	// ACTUAL PRICE: build actual price grid according to discount and regular prices
	foreach($query as $row) {
		$tmp_group = $row->ticket_type_group."GROUP";
		$tmp_factor = $row->ticket_type_discount;
		if (!isset($data_tixdiscount[$tmp_group][$row->ticket_type_id])) {
			$tmp_Percentage = false;
			if ($row->ticket_type_discount_type == "Percentage") {
				$tmp_Percentage = true;
				$tmp_factor = (100-$tmp_factor)/100;
			}
			
			$data_tixdiscount[$tmp_group][$row->ticket_type_id] = array($row->ticket_type_name, $tmp_factor, $tmp_Percentage);
		}
	}


if (isset($data_tixcountgrid)) {
	foreach($data_tixcountgrid as $kpid=>$vpidarr) {
		if ($kpid != $strReportDate) {
			foreach($vpidarr as $kgid=>$vgidarr ) {
				foreach($vgidarr as $k=>$v) {
					if (is_array($v)) {
						$data_tixcountgrid[$kpid][$kgid][$k] = array_unique($v);
					}
					else {
						$data_tixcountgrid[$kpid][$kgid] = array_unique($vgidarr);
					}
					
				}
			}
		}
	}	
}


	// COMPUTE QUERY TIME
	$b = microtime(true);
	$querytime = $b-$a;


//	echo $reports['report_view'] . "<br />";
//	echo $reports['report_dl'] . "<br />";
	if ($reports['report_view'] != '')
	{
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<title><?php echo $page_title; ?></title>
<style type="text/css">
	body {
		font-family:Arial; font-size:12px;
	}
	table {
		border-collapse:collapse; 
	}
	
	.fields_header { 
		background-color:#CCCCCC; 
		border-width:1px;
	}
	th {
		text-align: left;		
	}
	#subtotal {
		padding-top: 10px;
	}
	.center {
		text-align: center;
	}
	.numalign {
		text-align: right;
	}
	a {
		text-decoration:none;
	}
	a:hover {
		text-decoration:underline;
	}
</style>
</head>
<BODY>
	<hr color="#000000" />
	<!-- REPORT HEADER -->
	<table width=100% cellpadding=2 cellspacing=2>
	<tr>
		<td width=150>
			<b>TITLE OF EVENT</b> </td>
		<td width="20">:</td>
		<td valign="top">
			<?php echo implode($event_titles,"<br>\n"); ?>
		</td>
		<td width=150>
		<b>EVENT CODE</b></td>
		<td width="20">:</td>
		<td valign="top">
			<?php echo implode($event_codes,"<br>\n"); ?>
		</td>
	</tr>
	<tr>
		<td>
		<b>VENUE</b> </td>
		<td width="20">:</td>
		<td>
			<?php echo implode($event_venues,"<br>\n"); ?>
		</td>
		<td>
		<b>SHOW DATE(S)</b> </td>
		<td width="20">:</td>
		<td>
			<?php echo implode($event_dates,"<br>\n"); ?>
		</td>
	</tr>
	<tr>
		<td>
		<b>PROMOTER</b> </td>
		<td width="20">:</td>
		<td>
			<?php echo implode($event_promoters,"<br>\n"); ?>
		</td>
		<td>
		<b>GENERATED BY</b> </td>
		<td width="20">:</td>
		<td>
		<?php echo $this->session->userdata('username') . ' (' . $this->session->userdata('firstname') . ' ' . $this->session->userdata('lastname') . ')'; ?></td>
	</tr>
	<tr>
		<td>
		<?php 
		if ($boolDateRange) {
			echo "<b>DATE RANGE</b>";
		}
		else {
			echo "<b>AS OF</b>";
		}
		?>
		</td>
		<td width="20">:</td>
		<td>
		<?php 
		if ($boolDateRange) {
			echo date('Y-M-d ',$reports_date_from); 
			echo "until ";
			echo date('Y-M-d ',$reports_date); 
		}
		else {
			echo date('Y-M-d ',$reports_date); 
		}
		?>
		</td>
		<td><b>RUNDATE AND TIME</b> </td>
		<td width="20">:</td>
		<td>
		<?php echo date('Y-M-d / g:i:s a'); ?></td>
	</tr>				
	</table>

	<hr color="#000000" />
	<center><p><b>
	<?php 
		if (!$boolAdvanceDisplay) {
			$page_title = "$page_title - $branchname";
		}
		echo $page_title; 
	?>
	</b></p></center>

	<!-- table columns for various ticket prices -->
<?php
	$totalcapacity = 0;
	$totalavailability = 0;
	$totalpotential = 0;

	foreach ($price_types as $ptype)
	{
		$pricename = $ptype->price_name;
		$price = $ptype->price_price;
		$pid = "$pricename ($price)";
		$pricesections = $ptype->price_sections;
		
		$pricelist[$pid] = array($pricename, $price);

		if (!isset($seat_capacity[$pid])) {
			$seat_capacity[$pid] = 0;
		}
		
		if (!isset($availability[$pid])) {
			$availability[$pid] = 0;
		}
		
		if (!isset($potential[$pid])) {
			$potential[$pid] = 0;
		}
		
		foreach ($pricesections as $sid) {			
			$capacity = $data_sectionlist[$sid][0];
			$availability[$pid] += $data_sectionlist[$sid][1];
			$seat_capacity[$pid] += $capacity;
			$potential[$pid] += ($capacity * $price);
		}
	}

	$strHeaderHTML = '';
	$price_type_count = 0;

	$tmp_grandT = 0;
	$tmp_resT = 0;
	foreach($pricelist as $k=>$v) {
	
		$pid = $k;
		$countG = 0;
		$countR = 0;
		
	
		if (isset($data_tixcountgrid[$pid])) {
			foreach($data_tixcountgrid[$pid] as $grouparr) {
				foreach($grouparr as $temparr) {
					if (is_array($temparr)) {
						$countG += count($temparr);
					}
				}
			}
		}
		
		$tmp_grand = $countG;
		$tmp_grandT += $countG;
		if (!isset($reservedcount[$pid])) {
			$countR = 0;
		}
		else {
			$countR = count($reservedcount[$pid]);
		}

		$tmp_res = $countR;
		$tmp_resT += $countR;

		$tmp_cap = $seat_capacity[$k];
		// $tmp_ava = number_format($availability[$k]);
		$tmp_pot = number_format($potential[$k]);

		$tmp_ava = $tmp_cap - $tmp_grand - $tmp_res;
		
		$strHeaderHTML .= "<th colspan=3 class=center width=180>
			$v[0] ($tmp_ava) <br>
			Capacity($tmp_cap) / Potential ($tmp_pot)
		</th>";
	
		$price_type_count++;
		
		


	
	
	}

	$scapacity['total'] = array_sum($seat_capacity);
	$availability['total'] = array_sum($availability);
	$potential['total'] = array_sum($potential);
	
	$tmp_cap =$scapacity['total'];
	// $tmp_ava = number_format($availability['total']);
	$tmp_pot = number_format($potential['total']);
	
	$tmp_ava = $tmp_cap - $tmp_grandT - $tmp_resT;

	
	$strHeaderHTML .= "<th colspan=2 class=center width=120>
		TOTAL SALES ($tmp_ava) <br>
		Capacity($tmp_cap) / Potential ($tmp_pot)
	</th>";
	
	$colspan = ($price_type_count * 3) + 5;
	$tblwidth = ($colspan * 80) + 200;
	
?>

	<table border=1 cellpadding=2 cellspacing=0 width="<?php echo $tblwidth;?>">
	<tr>
		<th>&nbsp;</th>
		<?php echo $strHeaderHTML; ?>
		
		<th colspan=2 class=center>
			TOTAL SALES FOR <br>
			<?php echo date('Y-M-d ',$reports_date);?>
		</th>
	</tr>
	<tr>
		<th class=center width=200>Ticket Type Description</th>
		<?php 
		for ($i=0; $i < $price_type_count; $i++) {
		?>
		<th class=center>PRICE</th>
		<th class=center>QTY</th>
		<th class=center>AMOUNT</th>		
		<?php
		}
		?>
		<th class=center>QTY</th>
		<th class=center>AMOUNT</th>		
		<th class=center>QTY</th>
		<th class=center>AMOUNT</th>		
	</tr>

	<!-- TICKET TYPE / SECTION PRICE GRID -->
	
	<?php
	$groupidlist = array_keys($data_tixdiscount);
	sort($groupidlist);
	
	foreach($groupidlist as $groupid) {
		// PER PRICE DISCOUNT GROUP 
		$ttplist = array_keys($data_tixdiscount[$groupid]);
		sort($ttplist);
		foreach ($ttplist as $tid) {
			echo "<tr>";
	
			$discountname = $data_tixdiscount[$groupid][$tid][0];
			$tempwidth = strlen($discountname) * 10;
			echo "<td width=$tempwidth>$discountname</td>";
			$totalcount = 0;
			$totalamount = 0;
			
			foreach ($pricelist as $k=>$v)
			{				
				$pid = $k;
				$reg_price = $v[1]; 
				$price = 0;

				if (!isset($data_tixcountgrid[$pid][$groupid][$tid])) {
					$count = 0;
				}
				else {
					$count = count($data_tixcountgrid[$pid][$groupid][$tid]);
				}
				
				$tmp_discount = 0;
				if (isset($data_tixdiscount[$groupid][$tid][1])) {
					$tmp_discount = $data_tixdiscount[$groupid][$tid][1];
					$boolPercentage = $data_tixdiscount[$groupid][$tid][2];
				}
				
				if ($boolPercentage) {
					$price = ceil($reg_price * $tmp_discount);
				}
				else {
					$price = $reg_price - $tmp_discount;				
				}
				/*
				if ($tmp_discount == 0) {
					$price = $reg_price;
				}
				elseif ($tmp_discount < 1) {
					$price = ceil($reg_price * $tmp_discount);
				}
				else {
					$price = $reg_price - $tmp_discount;				
				}
				*/
				
				$amount = $price * $count;

				if (!isset($arrSubtotal[$pid][$groupid])) {
					$arrSubtotal[$pid][$groupid][0] = 0;;
					$arrSubtotal[$pid][$groupid][1] = 0;;
				}
				
				$arrSubtotal[$pid][$groupid][1] += $amount;
				$arrSubtotal[$pid][$groupid][0] += $count;
				
				$strPrice = number_format($price);
				$strAmount = number_format($amount);
				$strCount = number_format($count);
				
				$tempwidth = strlen($strAmount) * 8;
				
				echo "<td class=numalign width=$tempwidth>$strPrice</td>";
				echo "<td class=numalign width=$tempwidth>$strCount</td>";
				echo "<td class=numalign width=$tempwidth>$strAmount</td>";
				
				$totalcount += $count;
				$totalamount += $amount;
			}

			// TOTAL SALES
			$strCount = number_format($totalcount);
			$strAmount = number_format($totalamount);
			echo "<td class=numalign width=$tempwidth>$strCount</td>";
			echo "<td class=numalign width=$tempwidth>$strAmount</td>";

			// TOTAL SALES ON DAY OF REPORT DATE
			$todaycount = 0;
			$todayamount = 0;			
			if (isset($data_tixcountgrid[$strReportDate][$groupid][$tid])) {
				
				$todaycount = count($data_tixcountgrid[$strReportDate][$groupid][$tid]);
				$todayamount = array_sum($data_tixcountgrid[$strReportDate][$groupid][$tid]);
			}

			if (!isset($arrSubtotal[$strReportDate][$groupid])) {
				$arrSubtotal[$strReportDate][$groupid][0] = 0;;
				$arrSubtotal[$strReportDate][$groupid][1] = 0;;
			}
			
			$arrSubtotal[$strReportDate][$groupid][0] += $todaycount;
			$arrSubtotal[$strReportDate][$groupid][1] += $todayamount;
			
			$strCount = number_format($todaycount);
			$strAmount = number_format($todayamount);
			echo "<td class=numalign width=$tempwidth>$strCount</td>";
			echo "<td class=numalign width=$tempwidth>$strAmount</td>";
			
			echo "</tr>";
		}
	
	?>
	
	
	<!-- SUBTOTAL: PER PRICE GROUP -->
	<?php
		// SUBTOTAL: PER PRICE GROUP
		echo "<tr>";
		echo "<th>SUBTOTAL</th>";
		$totalcount = 0;
		$totalamount = 0;
		foreach ($pricelist as $k=>$v)
		{				
			$pid = $k; 
			$amount = $arrSubtotal[$pid][$groupid][1];
			$count = $arrSubtotal[$pid][$groupid][0];
			$strCount = number_format($count);
			$strAmount = number_format($amount);
			if ($seat_capacity[$pid] != 0) {
				$percent = ($count / $seat_capacity[$pid]) * 100;
			}
			else {
				$percent = 0;
			}
			$strPercent = number_format($percent,2);
			echo "<th class=numalign>$strPercent %</th>";
			echo "<th class=numalign>$strCount</th>";
			echo "<th class=numalign>$strAmount</th>";

			$totalcount += $count;
			$totalamount += $amount;			
		}
		if($groupid == "0GROUP") {
			$totalticketsales = $totalamount;
		}
		
		// TOTAL SALES
		$strCount = number_format($totalcount);
		$strAmount = number_format($totalamount);
		
		echo "<th class=numalign>$strCount</th>";
		echo "<th class=numalign>$strAmount</th>";

		// TOTAL SALES ON DAY OF REPORT DATE
		$amount = $arrSubtotal[$strReportDate][$groupid][1];
		$count = $arrSubtotal[$strReportDate][$groupid][0];
		$strCount = number_format($count);
		$strAmount = number_format($amount);
		echo "<th class=numalign>$strCount</th>";
		echo "<th class=numalign>$strAmount</th>";
		echo "</tr>";

		echo "<tr><td colspan=$colspan>";
		echo "<br><br>";
		echo "</td></tr>";

	}
	?>
	
	
	<!-- GRAND TOTAL -->
	<?php
		
	// GRAND TOTAL
	echo "<tr class=subtotal>";
	echo "<th>GRAND TOTAL</th>";
	$totalcount = 0;
	$totalamount = 0;
	foreach ($pricelist as $k=>$v)
	{				
		$pid = $k;
		$count = 0;
		if (isset($arrSubtotal[$pid]['0GROUP'][1]))
		{
			$amount1 = $arrSubtotal[$pid]['0GROUP'][1];
		}
		else 
		{
			$amount1 = 0;	
		}
		if (isset($arrSubtotal[$pid]['1GROUP'][1]))
		{
			$amount2 = $arrSubtotal[$pid]['1GROUP'][1];
		}
		else 
		{
			$amount2 = 0;	
		}
		$amount = $amount1 + $amount2;
		foreach(array_keys($arrSubtotal[$pid]) as $groupid) {
			//$amount += $arrSubtotal[$pid][$groupid][1];
		}
		
		if (isset($data_tixcountgrid[$pid])) {
			foreach($data_tixcountgrid[$pid] as $grouparr) {
				foreach($grouparr as $temparr) {
					if (is_array($temparr)) {
						$count += count($temparr);
					}
				}
			}
		}

		$strCount = number_format($count);
		if ($seat_capacity[$pid] != 0) {
			$percent = ($count / $seat_capacity[$pid]) * 100;
		}
		else {
			$percent = 0;
		}
		$strPercent = number_format($percent,2);
		$strAmount = number_format($amount);
		echo "<th class=numalign>$strPercent %</th>";
		echo "<th class=numalign>$strCount</th>";
		echo "<th class=numalign>$strAmount</th>";

		$totalcount += $count;
		$totalamount += $amount;
	}
	
	// TOTAL SALES
	$strCount = number_format($totalcount);
	$strAmount = number_format($totalamount);
	
	echo "<th class=numalign>$strCount</th>";
	echo "<th class=numalign>$strAmount</th>";
	
	// TOTAL SALES ON DAY OF REPORT DATE
	$count = 0;
	foreach(array_keys($arrSubtotal[$strReportDate]) as $groupid) {
		$count += $arrSubtotal[$strReportDate][$groupid][0];	
	}
	if (isset($arrSubtotal[$strReportDate]['0GROUP'][1])) 
	{
		$amount1 = $arrSubtotal[$strReportDate]['0GROUP'][1];
	}
	else 
	{
		$amount1 = 0;	
	}
	if (isset($arrSubtotal[$strReportDate]['1GROUP'][1]))
	{
		$amount2 = $arrSubtotal[$strReportDate]['1GROUP'][1];
	}
	else
	{
		$amount2 = 0;
	}
	
	$amount = $amount1 + $amount2;
	$strCount = number_format($count);
	$strAmount = number_format($amount);
	echo "<th class=numalign>$strCount</th>";
	echo "<th class=numalign>$strAmount</th>";
	echo "</tr>";

	echo "<tr><td colspan=$colspan>";
	echo "<br><br>";
	echo "</td></tr>";
	?>

	
	<!-- SECTION: RESERVATION -->
	<?php
	// SECTION: RESERVATION
	echo "<tr class=subtotal>";
	echo "<th>RESERVATION</th>";
	$totalcount = 0;
	$totalamount = 0;
	$groupid = "reserved";
	foreach ($pricelist as $k=>$v)
	{				
		$pid = $k;
		if (!isset($reservedcount[$pid])) {
			$count = 0;
		}
		else {
			$count = count($reservedcount[$pid]);
		}

		$strCount = number_format($count);

		if ($seat_capacity[$pid] != 0) {
			$percent = ($count / $seat_capacity[$pid]) * 100;
		}
		else {
			$percent = 0;
		}
		$strPercent = number_format($percent,2);
		echo "<th class=numalign>$strPercent %</th>";
		echo "<th class=numalign>$strCount</th>";
		echo "<th class=numalign>&nbsp;</th>";

		$totalcount += $count;
	}
	
	// TOTAL SALES
	$strCount = number_format($totalcount);	
	//cecon
	echo "<th class=numalign>$strCount</th>";
	echo "<th class=numalign>&nbsp;</th>";
	
	// TOTAL SALES ON DAY OF REPORT DATE
	if (!isset($reservedcount[$strReportDate])) {
		$count = 0;
	}
	else {
		$count = count($reservedcount[$strReportDate]);
	}

	// $arrSubtotal[$strReportDate][$groupid][0] = $count;
	
	$strCount = number_format($count);
	echo "<th class=numalign>$strCount</th>";
	echo "<th class=numalign>&nbsp;</th>";
	echo "</tr>";

	echo "<tr><td colspan=$colspan>";
	echo "<br><br>";
	echo "</td></tr>";
	?>
	
	<!-- BRANCH SALES BREAKDOWN -->
	<?php	
	if ($boolAdvanceDisplay) {
		echo "<tr><th colspan=$colspan><br>";
		echo "BRANCH SALES BREAKDOWN";
		echo "</th></tr>";

		foreach($data_branchlist as $branch) {
			$bid = $branch[0];
			$bname = $branch[1];
			if (isset($data_branchsalesgrid[$bid])) {
				echo "<tr>";
				echo "<td><a href=$form_url/$bid>$bname</a></td>";
				$totalcount = 0;
				$totalamount = 0;
				foreach ($pricelist as $k=>$v)
				{				
					$pid = $k;
					$count = 0;
					$amount = 0;
					if (isset($data_branchsalesgrid[$bid][$pid])) {
						$count = count($data_branchsalesgrid[$bid][$pid]);
						$amount = array_sum($data_branchsalesgrid[$bid][$pid]);
					}
					
					$strAmount = number_format($amount);
					$strCount = number_format($count);
					if ($seat_capacity[$pid] != 0) {
						$percent = ($count / $seat_capacity[$pid]) * 100;
					}
					else {
						$percent = 0;
					}
					$strPercent = number_format($percent,2);
					echo "<td class=numalign>$strPercent %</td>";
					echo "<td class=numalign>$strCount</td>";
					echo "<td class=numalign>$strAmount</td>";

					if (!isset($grandtotal[$pid])) {
						$grandtotal[$pid] = array(0,0);
					}
					
					$grandtotal[$pid][0] += $count;
					$grandtotal[$pid][1] += $amount;
					$totalcount += $count;
					$totalamount += $amount;			
				}
				
				// TOTAL SALES
				$strCount = number_format($totalcount);
				$strAmount = number_format($totalamount);
				
				echo "<td width=$tempwidth class=numalign>$strCount</td>";
				echo "<td width=$tempwidth class=numalign>$strAmount</td>";

				// TOTAL SALES ON DAY OF REPORT DATE
				$pid = $strReportDate;
				$count = 0;
				$amount = 0;
				
				if (!isset($grandtotal[$pid])) {
					$grandtotal[$pid] = array(0,0);
				}
				
				if (isset($data_branchsalesgrid[$bid][$pid])) {
					$count = count($data_branchsalesgrid[$bid][$pid]);
					$amount = array_sum($data_branchsalesgrid[$bid][$pid]);
					
					$grandtotal[$pid][0] += $count;
					$grandtotal[$pid][1] += $amount;
				}
				$strCount = number_format($count);
				$strAmount = number_format($amount);
				
				echo "<td width=$tempwidth class=numalign>$strCount</td>";
				echo "<td width=$tempwidth class=numalign>$strAmount</td>";
						
				echo "</tr>";
			}
		}
	?>
	<?php
		// SUBTOTAL: BRANCH LIST
		echo "<tr class=subtotal>";
		echo "<th>SUBTOTAL</th>";
		$totalcount = 0;
		$totalamount = 0;
		foreach ($pricelist as $k=>$v)
		{				
			$pid = $k;
			$count = 0;
			$amount = 0;
			if(isset($grandtotal[$pid])) {
				$count = $grandtotal[$pid][0];
				$amount = $grandtotal[$pid][1];
			}
			$strAmount = number_format($amount);
			$strCount = number_format($count);
			if ($seat_capacity[$pid] != 0) {
				$percent = ($count / $seat_capacity[$pid]) * 100;
			}
			else {
				$percent = 0;
			}
			$strPercent = number_format($percent,2);
			echo "<th class=numalign>$strPercent %</th>";
			echo "<th class=numalign>$strCount</th>";
			echo "<th class=numalign>$strAmount</th>";

			$totalcount += $count;
			$totalamount += $amount;			
		}
		// TOTAL SALES
		$strCount = number_format($totalcount);
		$strAmount = number_format($totalamount);

		echo "<th width=$tempwidth class=numalign>$strCount</th>";
		echo "<th width=$tempwidth class=numalign>$strAmount</th>";
		
		// TOTAL SALES ON DAY OF REPORT DATE
		$pid = $strReportDate;
		$count = 0;
		$amount = 0;
		if(isset($grandtotal[$pid])) {
			$count = $grandtotal[$pid][0];
			$amount = $grandtotal[$pid][1];
		}
		$strAmount = number_format($amount);
		$strCount = number_format($count);
		echo "<th width=$tempwidth class=numalign>$strCount</th>";
		echo "<th width=$tempwidth class=numalign>$strAmount</th>";
		echo "</tr>";
	}
	?>
	
	<!-- SALES BREAKDOWN -->
	<?php
		echo "<tr><td colspan=$colspan>";
		echo "<br><br>";
		echo "</td></tr>";

		$tmpcolspan = $colspan-4;
		$total = 0;
		$subtotal = 0;
		$change = 0;
		$rawsubtotal = 0;
		$rawchange = 0;
		$strCashDisplay = "";
		$strSalesBreak = "";
		$strTenderGroup = "";
		$TotalNonCash = 0;
		echo "<tr>";
		echo "<td>&nbsp;</td>";
		echo "<th style='text-align:center'>&nbsp;</th>";
		echo "<th style='text-align:center'>Amount</th>";
		echo "<th style='text-align:center'>&nbsp;</th>";
		echo "<td colspan=$tmpcolspan>&nbsp;</td>";
		echo "</tr>";
		
		$cash = 0;
		if (isset($salesbreakdown)) {
			foreach ($salesbreakdown as $catname=>$tendercat) {
				$catvalue = 0;
				
				foreach ($tendercat as $keyname=>$tendertype) {
					$tendervalue = array_sum($tendertype);
					if (strtoupper($keyname) == "CASH") {
						$cash = $tendervalue;

					}
					else {
						$catvalue += $tendervalue;
						$tendervalue = number_format($tendervalue);

						$strSalesBreak .= "<tr>";
						$strSalesBreak .= "<td>$catname ($keyname)</td>";
						$strSalesBreak .= "<td class=numalign>&nbsp;</td>";
						$strSalesBreak .= "<td class=numalign>$tendervalue</td>";
						$strSalesBreak .= "<td class=numalign>&nbsp;</td>";
						$strSalesBreak .= "<td colspan=$tmpcolspan>&nbsp;</td>";
						$strSalesBreak .= "</tr>";
					}
				}
				if (strtoupper($keyname) != "CASH") {
					$TotalNonCash += $catvalue;
					$catvalue = number_format($catvalue);
					
					$strTenderGroup .= "<tr>";
					$strTenderGroup .= "<td>$catname</td>";
					$strTenderGroup .= "<td class=numalign>&nbsp;</td>";
					$strTenderGroup .= "<td class=numalign>$catvalue</td>";
					$strTenderGroup .= "<td class=numalign>&nbsp;</td>";
					$strTenderGroup .= "<td colspan=$tmpcolspan>&nbsp;</td>";
					$strTenderGroup .= "</tr>";
				}
			}
			$ComputedCashValue = number_format($totalticketsales - $TotalNonCash);
			$strCashDisplay .= "<tr>";
			$strCashDisplay .= "<td>Cash</td>";
			$strCashDisplay .= "<td class=numalign>&nbsp;</td>";
			$strCashDisplay .= "<td class=numalign>$ComputedCashValue</td>";
			$strCashDisplay .= "<td class=numalign>&nbsp;</td>";
			$strCashDisplay .= "<td colspan=$tmpcolspan>&nbsp;</td>";
			$strCashDisplay .= "</tr>";

			$totalticketsales = number_format($totalticketsales);
			$strTotal = "<tr>";
			$strTotal .= "<th>TOTAL</th>";
			$strTotal .= "<td class=numalign>&nbsp;</td>";
			$strTotal .= "<th class=numalign>$totalticketsales</th>";
			$strTotal .= "<td class=numalign>&nbsp;</td>";
			$strTotal .= "<td colspan=$tmpcolspan>&nbsp;</td>";
			$strTotal .= "</tr>";
			
			echo $strCashDisplay;
			echo $strTenderGroup;
			echo $strTotal;
			echo "<tr><td colspan=$colspan>";
			echo "<br>";
			echo "</td></tr>";
			echo $strCashDisplay;
			echo $strSalesBreak;
			echo $strTotal;
		}
	?>
	
	</table>

<?php
	$endtime = microtime(true);
	$difftime = $endtime-$starttime;
	echo "Query time: $querytime. <br>";
	echo "It took <b>$difftime</b> seconds to generate this page.";

?>

</BODY>
</HTML>

<?php 
	}
	else
	{
		//resubmit
		$separator = ';';
		$consoHeader = '';
		$ev_count = count($event_titles, COUNT_RECURSIVE);
		$ve_count = count($event_venues, COUNT_RECURSIVE);
		
		if ($ev_count > 1)
		{
			for ($inc = 0; $inc < $ev_count; $inc++)
			{
				if ($inc == 0)
				{
					$consoHeader .= "TITLE OF EVENT $separator";
					$consoHeader .= $event_titles[$inc] . $separator;
					$consoHeader .= "EVENT CODE $separator";
					$consoHeader .= $event_codes[$inc] . $separator;
					$consoHeader .= PHP_EOL;
				}
				else 
				{
					$consoHeader .= "$separator";
					$consoHeader .= $event_titles[$inc] . $separator;
					$consoHeader .= "$separator";
					$consoHeader .= $event_codes[$inc] . $separator;
					$consoHeader .= PHP_EOL;
				}
			}
			echo $consoHeader;
		}
		else 
		{
			echo "TITLE OF EVENT $separator";
			echo implode($event_titles," ") . $separator;
			echo "EVENT CODE $separator";
			echo implode($event_codes," ") . $separator;
			echo PHP_EOL;
		}
	
		if ($ev_count > $ve_count)
		{
			$loopCount = $ev_count;
		}
		else 
		{
			$loopCount = $ve_count;
		}
		
		$consoHeader = '';
		
		if ($loopCount > 1)
		{
			for ($inc = 0; $inc < $loopCount; $inc++)
			{
				if ($inc == 0)
				{
					$consoHeader .= "VENUE $separator";
					$consoHeader .= str_replace(',', ' ', $event_venues[$inc]) . $separator;
					$consoHeader .= "SHOW DATE(S) $separator";
					$consoHeader .= $event_dates[$inc] . $separator;
					$consoHeader .= PHP_EOL;
				}
				else 
				{
					$consoHeader .= "$separator";
					if (isset($event_venues[$inc]))
					{
						$consoHeader .= str_replace(',', ' ', $event_venues[$inc]);
					}
					$consoHeader .= $separator;
					$consoHeader .= "$separator";
					if (isset($event_dates[$inc]))
					{
						$consoHeader .= $event_dates[$inc];
					}
					$consoHeader .= $separator;
					$consoHeader .= PHP_EOL;
				}
			}
			echo $consoHeader;
		}
		else 
		{
			echo "VENUE $separator";
			echo implode(str_replace(',' , ' ' ,$event_venues)) . $separator;
			//echo 'test' . $separator;
			echo "SHOW DATE(S) $separator";
			echo implode($event_dates," ") . $separator;
			echo PHP_EOL;
		}
		echo "PROMOTER $separator";
		//echo implode($event_promoters," ") . $separator;
		//echo str_replace(',' , ' ' ,implode($event_promoters," ")) . $separator;
		echo implode(str_replace(',' , ' ' ,$event_promoters)) . $separator;
		echo "GENERATED BY $separator";
		echo $this->session->userdata('username') . ' (' . $this->session->userdata('firstname') . ' ' . $this->session->userdata('lastname') . ')' . $separator;
		echo PHP_EOL;
	
		if ($boolDateRange) {
			echo "DATE RANGE $separator";
		}
		else {
			echo "AS OF $separator";
		}
		
		if ($boolDateRange) {
			echo date('Y-M-d ',$reports_date_from); 
			echo "until ";
			echo date('Y-M-d ',$reports_date); 
			echo $separator;
		}
		else {
			echo date('Y-M-d ',$reports_date); 
			echo $separator;
		}
		echo "RUNDATE AND TIME $separator";
		echo date('Y-M-d / g:i:s a') . $separator;
		echo PHP_EOL;
		echo PHP_EOL;

		if (!$boolAdvanceDisplay) {
			$page_title = "$page_title - $branchname";
		}
		echo $page_title . $separator; 
		echo PHP_EOL;
		echo PHP_EOL;
	
	$totalcapacity = 0;
	$totalavailability = 0;
	$totalpotential = 0;

	foreach ($price_types as $ptype)
	{
		$pricename = $ptype->price_name;
		$price = $ptype->price_price;
		$pid = "$pricename ($price)";
		$pricesections = $ptype->price_sections;
		
		$pricelist[$pid] = array($pricename, $price);

		if (!isset($seat_capacity[$pid])) {
			$seat_capacity[$pid] = 0;
		}
		
		if (!isset($availability[$pid])) {
			$availability[$pid] = 0;
		}
		
		if (!isset($potential[$pid])) {
			$potential[$pid] = 0;
		}
		
		foreach ($pricesections as $sid) {			
			$capacity = $data_sectionlist[$sid][0];
			$availability[$pid] += $data_sectionlist[$sid][1];
			$seat_capacity[$pid] += $capacity;
			$potential[$pid] += ($capacity * $price);
		}
	}

	$strHeaderHTML = '';
	$price_type_count = 0;

	foreach($pricelist as $k=>$v) {
		$tmp_cap = $seat_capacity[$k];
		$tmp_ava = $availability[$k];
		$tmp_pot = $potential[$k];

		$strHeaderHTML .= "$v[0] ($tmp_ava) Capacity($tmp_cap) / Potential ($tmp_pot) $separator $separator $separator";
	
		$price_type_count++;
	}
	$scapacity['total'] = array_sum($seat_capacity);
	$availability['total'] = array_sum($availability);
	$potential['total'] = array_sum($potential);
	
	$tmp_cap = $scapacity['total'];
	$tmp_ava = $availability['total'];
	$tmp_pot = $potential['total'];
	
	$strHeaderHTML .= "TOTAL SALES ($tmp_ava) Capacity($tmp_cap) / Potential ($tmp_pot)$separator $separator";
	
	$colspan = ($price_type_count * 3) + 5;
	$tblwidth = ($colspan * 80) + 200;
	
	echo $separator;
	echo $strHeaderHTML;
	echo "TOTAL SALES FOR ";
	echo date('Y-M-d ',$reports_date) . $separator;
	echo PHP_EOL;
	echo PHP_EOL;
	
	echo "Ticket Type Description $separator";
	 
		for ($i=0; $i < $price_type_count; $i++) {
	
		echo "PRICE $separator";
		echo "QTY $separator";
		echo "AMOUNT $separator";	
		
		}

	echo "QTY $separator";
	echo "AMOUNT $separator";	
	echo "QTY $separator";
	echo "AMOUNT $separator";	
	echo PHP_EOL;

	
	$groupidlist = array_keys($data_tixdiscount);
	sort($groupidlist);
	
	foreach($groupidlist as $groupid) {
		// PER PRICE DISCOUNT GROUP 
		$ttplist = array_keys($data_tixdiscount[$groupid]);
		sort($ttplist);
		foreach ($ttplist as $tid) {
			//echo "<tr>";
	
			$discountname = $data_tixdiscount[$groupid][$tid][0];
			$tempwidth = strlen($discountname) * 10;
			echo "$discountname $separator";
			$totalcount = 0;
			$totalamount = 0;
			
			foreach ($pricelist as $k=>$v)
			{				
				$pid = $k;
				$reg_price = $v[1]; 
				$price = 0;

				if (!isset($data_tixcountgrid[$pid][$groupid][$tid])) {
					$count = 0;
				}
				else {
					$count = count($data_tixcountgrid[$pid][$groupid][$tid]);
				}
				
				$tmp_discount = 0;
				if (isset($data_tixdiscount[$groupid][$tid][1])) {
					$tmp_discount = $data_tixdiscount[$groupid][$tid][1];
					$boolPercentage = $data_tixdiscount[$groupid][$tid][2];
				}
				
				if ($boolPercentage) {
					$price = ceil($reg_price * $tmp_discount);
				}
				else {
					$price = $reg_price - $tmp_discount;				
				}
				/*
				if ($tmp_discount == 0) {
					$price = $reg_price;
				}
				elseif ($tmp_discount < 1) {
					$price = ceil($reg_price * $tmp_discount);
				}
				else {
					$price = $reg_price - $tmp_discount;				
				}
				*/
				
				$amount = $price * $count;

				if (!isset($arrSubtotal[$pid][$groupid])) {
					$arrSubtotal[$pid][$groupid][0] = 0;;
					$arrSubtotal[$pid][$groupid][1] = 0;;
				}
				
				$arrSubtotal[$pid][$groupid][1] += $amount;
				$arrSubtotal[$pid][$groupid][0] += $count;
				
				$strPrice = $price;
				$strAmount = $amount;
				$strCount = $count;
				
				$tempwidth = strlen($strAmount) * 8;
				
				echo "$strPrice $separator";
				echo "$strCount $separator";
				echo "$strAmount $separator";
				
				$totalcount += $count;
				$totalamount += $amount;
			}

			// TOTAL SALES
			$strCount = $totalcount;
			$strAmount = $totalamount;
			echo "$strCount $separator";
			echo "$strAmount $separator";

			// TOTAL SALES ON DAY OF REPORT DATE
			$todaycount = 0;
			$todayamount = 0;			
			if (isset($data_tixcountgrid[$strReportDate][$groupid][$tid])) {
				
				$todaycount = count($data_tixcountgrid[$strReportDate][$groupid][$tid]);
				$todayamount = array_sum($data_tixcountgrid[$strReportDate][$groupid][$tid]);
			}

			if (!isset($arrSubtotal[$strReportDate][$groupid])) {
				$arrSubtotal[$strReportDate][$groupid][0] = 0;;
				$arrSubtotal[$strReportDate][$groupid][1] = 0;;
			}
			
			$arrSubtotal[$strReportDate][$groupid][0] += $todaycount;
			$arrSubtotal[$strReportDate][$groupid][1] += $todayamount;
			
			$strCount = $todaycount;
			$strAmount = $todayamount;
			echo "$strCount $separator";
			echo "$strAmount $separator";
			
			echo PHP_EOL;
		}
	
	
		// SUBTOTAL: PER PRICE GROUP
		//echo "<tr>";
		echo "SUBTOTAL $separator";
		$totalcount = 0;
		$totalamount = 0;
		foreach ($pricelist as $k=>$v)
		{				
			$pid = $k; 
			$amount = $arrSubtotal[$pid][$groupid][1];
			$count = $arrSubtotal[$pid][$groupid][0];
			$strCount = $count;
			$strAmount = $amount;
			if ($seat_capacity[$pid] != 0) {
				$percent = ($count / $seat_capacity[$pid]) * 100;
			}
			else {
				$percent = 0;
			}
			$strPercent = $percent;
			echo "$strPercent % $separator";
			echo "$strCount $separator";
			echo "$strAmount $separator";

			$totalcount += $count;
			$totalamount += $amount;			
		}
		if($groupid == "0GROUP") {
			$totalticketsales = $totalamount;
		}
		
		// TOTAL SALES
		$strCount = $totalcount;
		$strAmount = $totalamount;
		
		echo "$strCount $separator";
		echo "$strAmount $separator";

		// TOTAL SALES ON DAY OF REPORT DATE
		$amount = $arrSubtotal[$strReportDate][$groupid][1];
		$count = $arrSubtotal[$strReportDate][$groupid][0];
		$strCount = $count;
		$strAmount = $amount;
		echo "$strCount $separator";
		echo "$strAmount $separator";
		echo PHP_EOL;
		echo PHP_EOL;

	}
	
		
	// GRAND TOTAL
	//echo "<tr class=subtotal>";
	echo "GRAND TOTAL $separator";
	$totalcount = 0;
	$totalamount = 0;
	foreach ($pricelist as $k=>$v)
	{				
		$pid = $k;
		$count = 0;
		if (isset($arrSubtotal[$pid]['0GROUP'][1]))
		{
			$amount1 = $arrSubtotal[$pid]['0GROUP'][1];
		}
		else 
		{
			$amount1 = 0;	
		}
		if (isset($arrSubtotal[$pid]['1GROUP'][1]))
		{
			$amount2 = $arrSubtotal[$pid]['1GROUP'][1];
		}
		else 
		{
			$amount2 = 0;	
		}
		$amount = $amount1 + $amount2;
		if (isset($data_tixcountgrid[$pid])) {
			foreach($data_tixcountgrid[$pid] as $grouparr) {
				foreach($grouparr as $temparr) {
					if (is_array($temparr)) {
						$count += count($temparr);
					}
				}
			}
		}

		$strCount = $count;
		$strAmount = $amount;
		if ($seat_capacity[$pid] != 0) {
			$percent = ($count / $seat_capacity[$pid]) * 100;
		}
		else {
			$percent = 0;
		}
		$strPercent = $percent;
		echo "$strPercent % $separator";
		echo "$strCount $separator";
		echo "$strAmount $separator";

		$totalcount += $strCount;
		$totalamount += $strAmount;
	}
	
	// TOTAL SALES
	$strCount = $totalcount;
	
	echo "$totalcount $separator";
	echo "$totalamount $separator";
	
	
	// TOTAL SALES ON DAY OF REPORT DATE
	$count = 0;
	foreach(array_keys($arrSubtotal[$strReportDate]) as $groupid) {
		$count += $arrSubtotal[$strReportDate][$groupid][0];
	}
	if (isset($arrSubtotal[$strReportDate]['0GROUP'][1])) 
	{
		$amount1 = $arrSubtotal[$strReportDate]['0GROUP'][1];
	}
	else 
	{
		$amount1 = 0;	
	}
	if (isset($arrSubtotal[$strReportDate]['1GROUP'][1]))
	{
		$amount2 = $arrSubtotal[$strReportDate]['1GROUP'][1];
	}
	else
	{
		$amount2 = 0;
	}
	$amount = $amount1 + $amount2;
	
	$strCount = $count;
	$strAmount = $amount;
	echo "$strCount $separator";
	echo "$strAmount $separator";
	echo PHP_EOL;
	echo PHP_EOL;
	
	
	// SECTION: RESERVATION
	//echo "<tr class=subtotal>";
	echo "RESERVATION $separator";
	$totalcount = 0;
	$totalamount = 0;
	$groupid = "reserved";
	foreach ($pricelist as $k=>$v)
	{				
		$pid = $k;
		if (!isset($reservedcount[$pid])) {
			$count = 0;
		}
		else {
			$count = count($reservedcount[$pid]);
		}

		$strCount = $count;

		if ($seat_capacity[$pid] != 0) {
			$percent = ($count / $seat_capacity[$pid]) * 100;
		}
		else {
			$percent = 0;
		}
		$strPercent = $percent;
		echo "$strPercent % $separator";
		echo "$strCount $separator";
		echo " $separator";

		$totalcount += $count;
	}
	
	// TOTAL SALES
	$strCount = $totalcount;	
	
	echo "$strCount $separator";
	echo " $separator";
	
	// TOTAL SALES ON DAY OF REPORT DATE
	if (!isset($reservedcount[$strReportDate])) {
		$count = 0;
	}
	else {
		$count = count($reservedcount[$strReportDate]);
	}

	// $arrSubtotal[$strReportDate][$groupid][0] = $count;
	
	$strCount = $count;
	echo "$strCount $separator";
	echo " $separator";
	echo PHP_EOL;
	echo PHP_EOL;

	
	if ($boolAdvanceDisplay) {
		//echo "<tr><th colspan=$colspan><br>";
		echo "BRANCH SALES BREAKDOWN $separator";
		echo PHP_EOL;

		foreach($data_branchlist as $branch) {
			$bid = $branch[0];
			$bname = $branch[1];
			if (isset($data_branchsalesgrid[$bid])) {
				//echo "<tr>";
				echo "$bname $separator";
				$totalcount = 0;
				$totalamount = 0;
				foreach ($pricelist as $k=>$v)
				{				
					$pid = $k;
					$count = 0;
					$amount = 0;
					if (isset($data_branchsalesgrid[$bid][$pid])) {
						$count = count($data_branchsalesgrid[$bid][$pid]);
						$amount = array_sum($data_branchsalesgrid[$bid][$pid]);
					}
					
					$strAmount = $amount;
					$strCount = $count;
					if ($seat_capacity[$pid] != 0) {
						$percent = ($count / $seat_capacity[$pid]) * 100;
					}
					else {
						$percent = 0;
					}
					$strPercent = $percent;
					echo "$strPercent % $separator";
					echo "$strCount $separator";
					echo "$strAmount $separator";

					if (!isset($grandtotal[$pid])) {
						$grandtotal[$pid] = array(0,0);
					}
					
					$grandtotal[$pid][0] += $count;
					$grandtotal[$pid][1] += $amount;
					$totalcount += $count;
					$totalamount += $amount;			
				}
				
				// TOTAL SALES
				$strCount = $totalcount;
				$strAmount = $totalamount;
				
				echo "$strCount $separator";
				echo "$strAmount $separator";

				// TOTAL SALES ON DAY OF REPORT DATE
				$pid = $strReportDate;
				$count = 0;
				$amount = 0;
				
				if (!isset($grandtotal[$pid])) {
					$grandtotal[$pid] = array(0,0);
				}
				
				if (isset($data_branchsalesgrid[$bid][$pid])) {
					$count = count($data_branchsalesgrid[$bid][$pid]);
					$amount = array_sum($data_branchsalesgrid[$bid][$pid]);
					
					$grandtotal[$pid][0] += $count;
					$grandtotal[$pid][1] += $amount;
				}
				$strCount = $count;
				$strAmount = $amount;
				
				echo "$strCount $separator";
				echo "$strAmount $separator";
						
				echo PHP_EOL;
			}
		}
	
		// SUBTOTAL: BRANCH LIST
		//echo "<tr class=subtotal>";
		echo "SUBTOTAL $separator";
		$totalcount = 0;
		$totalamount = 0;
		foreach ($pricelist as $k=>$v)
		{				
			$pid = $k;
			$count = 0;
			$amount = 0;
			if(isset($grandtotal[$pid])) {
				$count = $grandtotal[$pid][0];
				$amount = $grandtotal[$pid][1];
			}
			$strAmount = $amount;
			$strCount = $count;
			if ($seat_capacity[$pid] != 0) {
				$percent = ($count / $seat_capacity[$pid]) * 100;
			}
			else {
				$percent = 0;
			}
			$strPercent = $percent;
			echo "$strPercent % $separator";
			echo "$strCount $separator";
			echo "$strAmount $separator";

			$totalcount += $count;
			$totalamount += $amount;			
		}
		// TOTAL SALES
		$strCount = $totalcount;
		$strAmount = $totalamount;

		echo "$strCount $separator";
		echo "$strAmount $separator";
		
		// TOTAL SALES ON DAY OF REPORT DATE
		$pid = $strReportDate;
		$count = 0;
		$amount = 0;
		if(isset($grandtotal[$pid])) {
			$count = $grandtotal[$pid][0];
			$amount = $grandtotal[$pid][1];
		}
		$strAmount = $amount;
		$strCount = $count;
		echo "$strCount $separator";
		echo "$strAmount $separator";
		echo PHP_EOL;
	}
	
		echo PHP_EOL;

		$tmpcolspan = $colspan-4;
		$total = 0;
		$subtotal = 0;
		$change = 0;
		$rawsubtotal = 0;
		$rawchange = 0;
		$strCashDisplay = "";
		$strSalesBreak = "";
		$strTenderGroup = "";
		$TotalNonCash = 0;
		//echo "<tr>";
		echo " $separator";
		echo " $separator";
		echo "Amount $separator";
		echo " $separator";
		echo " ";
		for ($inc = 1; $inc <= $tmpcolspan; $inc++)
		{
			echo $separator;
		}
		echo PHP_EOL;
		
		$cash = 0;
		if (isset($salesbreakdown)) {
			foreach ($salesbreakdown as $catname=>$tendercat) {
				$catvalue = 0;
				
				foreach ($tendercat as $keyname=>$tendertype) {
					$tendervalue = array_sum($tendertype);
					if (strtoupper($keyname) == "CASH") {
						$cash = $tendervalue;

					}
					else {
						$catvalue += $tendervalue;
						$tendervalue = $tendervalue;

						$strSalesBreak .= "";
						$strSalesBreak .= "$catname ($keyname) $separator";
						$strSalesBreak .= " $separator";
						$strSalesBreak .= "$tendervalue $separator";
						$strSalesBreak .= " $separator";
						$strSalesBreak .= " ";
							for ($inc = 1; $inc <= $tmpcolspan; $inc++)
							{
								$strSalesBreak .= $separator;
							}
						$strSalesBreak .= PHP_EOL;
					}
				}
				if (strtoupper($keyname) != "CASH") {
					$TotalNonCash += $catvalue;
					$catvalue = $catvalue;
					
					$strTenderGroup .= "";
					$strTenderGroup .= "$catname $separator";
					$strTenderGroup .= " $separator";
					$strTenderGroup .= "$catvalue $separator";
					$strTenderGroup .= " $separator";
					$strTenderGroup .= " ";
							for ($inc = 1; $inc <= $tmpcolspan; $inc++)
							{
								$strTenderGroup .= $separator;
							}
					$strTenderGroup .= PHP_EOL;
				}
			}
			$ComputedCashValue = $totalticketsales - $TotalNonCash;
			$strCashDisplay .= "";
			$strCashDisplay .= "Cash $separator";
			$strCashDisplay .= " $separator";
			$strCashDisplay .= "$ComputedCashValue $separator";
			$strCashDisplay .= " $separator";
			$strCashDisplay .= " ";
							for ($inc = 1; $inc <= $tmpcolspan; $inc++)
							{
								$strCashDisplay .= $separator;
							}
			$strCashDisplay .= PHP_EOL;

			$totalticketsales = $totalticketsales;
			$strTotal = "";
			$strTotal .= "TOTAL $separator";
			$strTotal .= " $separator";
			$strTotal .= "$totalticketsales $separator";
			$strTotal .= " ";
			$strTotal .= " ";
							for ($inc = 1; $inc <= $tmpcolspan; $inc++)
							{
								$strTotal .= $separator;
							}
			$strTotal .= PHP_EOL;
			
			echo $strCashDisplay;
			//echo PHP_EOL;
			echo $strTenderGroup;
			//echo PHP_EOL;
			echo $strTotal;
			echo PHP_EOL;
			//echo PHP_EOL;
			echo $strCashDisplay;
			//echo PHP_EOL;
			echo $strSalesBreak;
			//echo PHP_EOL;
			echo $strTotal;
			//echo PHP_EOL;
		}
	
	$endtime = microtime(true);
	$difftime = $endtime-$starttime;
	echo "Query time: $querytime.  ";
	echo PHP_EOL;
	echo "It took $difftime seconds to generate this page.";

	}
?>