<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Venues_model extends CI_Model
{
	var $venues = 'venues v';
	
	/**
	 * Constructor
	 *
	 * @access	public
	 */
	public function __construct()
	{
		parent::__construct();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_venues
	 *
	 * @access	public
	 */
	function get_venues($type = false)
	{
		$query = $this->db->get($this->venues);
			
		return $query->result();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_venues_dropdown
	 *
	 * @access	public
	 */
	function get_venues_dropdown()
	{
		$this->db->where('venue_active', 1);
		$query = $this->db->get($this->venues);
			
		$result = $query->result();

		if ($result)
		{
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->venue_id] = $r->venue_name;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_venue
	 *
	 * @access	public
	 */
	function get($venue_id)
	{
		$this->db->where('venue_id', $venue_id);
		$query = $this->db->get($this->venues);
		//echo $this->db->last_query();
		
		return $query->row();
	}
	
	// --------------------------------------------------------------------
	function prep_password($password)
	{
		return sha1($this->config->item('encryption_key').$password);
	}
	/**
	 * add
	 *
	 */
	function add()
	{
		$fields = array(
			'venue_type'			=> $this->input->post('venue_type'),
			'venue_name'			=> $this->input->post('venue_name'),			
			'venue_username'		=> $this->input->post('venue_username'),
			'venue_password'		=> $this->prep_password($this->input->post('venue_password')),
			'venue_address1'		=> $this->input->post('venue_address1'),
			'venue_address2'		=> $this->input->post('venue_address2'),
			'venue_city'			=> $this->input->post('venue_city'),
			'venue_zip'				=> $this->input->post('venue_zip'),
			'venue_country'			=> $this->input->post('venue_country'),
			'venue_website'			=> $this->input->post('venue_website'),
			'venue_direction'		=> $this->input->post('venue_direction'),
			'venue_active'			=> 1,		
			'venue_category'		=> $this->input->post('venue_category'),
		);
		
		// insert to db
		$this->db->set($fields);
		$this->db->insert('venues');
		
		return $this->db->insert_id();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * is_venuename_exist
	 *
	 * @access	public
	 */
	function is_venuename_exist($venuename = FALSE)
	{
		// check if venuename exists
		$this->db->where('lower(venue_name)', strtolower($venuename));
		$query = $this->db->get($this->venues);
		
		return ($query->num_rows() > 0) ? true : false;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * edit
	 *
	 */
	function edit($venue_id)
	{
		$fields = array(
			'venue_username'		=> $this->input->post('venue_username'),
			'venue_type'			=> $this->input->post('venue_type'),
			'venue_name'			=> $this->input->post('venue_name'),
			'venue_address1'		=> $this->input->post('venue_address1'),
			'venue_address2'		=> $this->input->post('venue_address2'),
			'venue_city'			=> $this->input->post('venue_city'),
			'venue_zip'				=> $this->input->post('venue_zip'),
			'venue_country'			=> $this->input->post('venue_country'),
			'venue_website'			=> $this->input->post('venue_website'),	
			'venue_direction'		=> $this->input->post('venue_direction'),
			'venue_active'			=> $this->input->post('venue_active'),		
			'venue_category'			=> $this->input->post('venue_category'),		
		);
		
		// optional fields
		if ($this->input->post('venue_password'))
		{
			$fields['venue_password'] = $this->prep_password($this->input->post('venue_password'));
		}
		
		// update db
		$this->db->where('venue_id', $venue_id);
		$this->db->update($this->venues, $fields);
		
		return true;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * delete
	 *
	 */
	function delete($venue_id)
	{
		$this->db->delete('venues', array('venue_id' => $venue_id));
		
		return true;
	}
	function is_username_exist($username = FALSE)
	{
		// check if username exists
		$this->db->where('lower(venue_username)', strtolower($username));
		$query = $this->db->get($this->venues);
		
		return ($query->num_rows() > 0) ? true : false;
	}	
	
	function is_username_exist_update($username = FALSE)
	{
		// check if username exists
		$this->db->where('lower(venue_username)', strtolower($username));
		$query = $this->db->get($this->venues);
		
		if($query->num_rows() > 0) { 
			$this->db->select('venue_username');
			$this->db->where('venue_id', $this->input->post('venue_id'));
			$query2 = $this->db->get($this->venues);
			if($query2->row()->venue_username == $username){
				return false;
			}else{
				return true; 
			} 
		}else{ 
			return false;
		}
	}
			
}
// END venues_model.php
/* Location: ./application/models/venues_model.php */	
