<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Usersessions_model extends CI_Model
{
	
	var $users = 'users u';
	var $usersess = 'user_sessions';
	var $logs = 'logs l';
	
	/**
	 * Constructor
	 *
	 * @access	public
	 */
	public function __construct()
	{
		parent::__construct();
	}
	// --------------------------------------------------------------------
	
	function get_active($searchkey=array(),$offset=false, $limit=false)
	{
		// $this->db->select('u.*');
		$this->db->join('user_sessions us','us.user_id = u.user_id','left');
		if ($limit) $this->db->limit($limit);
		if ($offset) $this->db->offset($offset);

		if (! empty($searchkey) )
		{
			foreach ($searchkey as $key=>$value)
			{
				if ($value)
				switch ($key)
				{
					case 'name':
					//	$this->db->like('CONCAT(customer_lastname,customer_firstname)', $value);
						break;
					default:
  						$this->db->like($key, $value);
						break;
				}
			}
		}


		$this->db->order_by('last_activity','desc');
		$query = $this->db->get('users u');
		
		return $query->result();
	}
	
	function is_active($userid)
	{		
		if (!$userid) return false;	

		$this->db->where('user_id', $userid);
		$query = $this->db->get( $this->usersess );
		
		
		if($query->num_rows() > 0)
			
		// return true;
		return  !! ($query->num_rows() > 0);
	}
	
	function get_activated_session($userid)
	{
		if (!$userid) return false;	
		
		$this->db->where('user_id', $userid);
		$query = $this->db->get( $this->usersess );
		return ($query->result());
		// return  !! ($query->num_rows() > 0);
	}
		
	function start($userid)
	{		
		if (!$userid) return false;
		
		/*$this->db->select('log_date');
		$this->db->where('log_user_id', $userid);
		$this->db->orderby('log_date', desc);
		$this->db->limit(1);
		$query = $this->db->get('logs');
		$row = $query->row();
		
		$logs = $row->log_date;*/
				
		$fields = array(
			'user_id'			=> $userid,
			'ip_address'		=> $this->input->ip_address(),
			'user_agent'		=> substr($this->input->user_agent(), 0, 50),			
			'sessionid'			=> session_id(),
			'login_datetime'	=> date("Y-m-d H:i:s"),
			'last_activity'		=> date("Y-m-d H:i:s"),
		);
		
		$this->db->set($fields);
		$this->db->insert( $this->usersess );
		
		return true;		
	}
	
	function latest_act($userid)
	{
		$this->db->select('log_date, log_ip_address');
		$this->db->where('log_user_id', $userid);
		$this->db->orderby('log_date', 'desc');
		$this->db->limit(1);
		$query = $this->db->get('logs');
		$row = $query->row();
		if ($row) {
			$logs = $row->log_date;
		}
		return $row;
	}
	
	function update($userid)
	{
		$this->db->select('log_date');
		$this->db->where('log_user_id', $userid);
		$this->db->orderby('log_date', asc);
		$this->db->limit(1);
		$query = $this->db->get('logs');
		$row = $query->row();
		
		$logs = $row->log_date;
		
		$this->db->where('user_id', $userid);
		$this->db->update($this->usersess, array('last_activity' => $logs));
	}
	
	function stop($userid)
	{
		// delete the entry
		$this->db->delete($this->usersess, array('user_id' => $userid) );
		
		return true;
	}
	
	function stop2($userid, $ip)
	{
		// delete the entry
		// die($ip);
		$this->db->where('user_id', $userid);
		$this->db->where('ip_address', $ip);
		$this->db->delete('user_sessions'); 
		
		
		return true;
	}
	
}
?>
