<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Upgrade_model extends CI_Model
{
	
	var $transactions = 'transactions t';
	var $tickets = 'tickets ti';
	var $customers = 'customers c';
	var $terminals = 'terminals te';
	var $branches = 'branches b';
	var $users = 'users u';
	var $events = 'events e';
	var $sections = 'sections s';
	var $prices = 'prices p';
	var $promoters = 'promoters p';
	var $venues = 'venues v';
	var $payments = 'payments p';	
	var $payment_types = 'payment_types pt';	
		
	
	/**
	 * Constructor
	 *
	 * @access	public
	 */
	public function __construct()
	{
		parent::__construct();
	}
	// --------------------------------------------------------------------
	
	 
	 /**
	 * get_upgrade info
	 *
	 * @access	public
	 */
	
	function get_payments($transaction_id = false,$upgrade_code = false)
	{
		
		$this->db->join('payments p', 'p.payment_payment_type_id= up.voided_payment_type_id','left');
		$this->db->join('transactions t', 't.transaction_id=up.voided_payment_transaction_id','left');
		$this->db->join('payment_types pt', 'pt.payment_type_id=up.voided_payment_type_id');
		$this->db->where('payment_transaction_id', $transaction_id);
		$this->db->where('voided_payment_code', $upgrade_code);
		$this->db->where('voided_payment_status', 0);
		$query = $this->db->get('upgrade_payments` up');
		
		// if($qty){
			// return $result = $query->num_rows();
		// }else{
			return $query->result();
		// }
	}	
	
	function check_upgrade_code_status($transaction_id = false,$upgrade_code = false)
	{
		$this->db->select('ut.ticket_ids, ut.branch_id, ut.user_id');
		$this->db->join('upgrade_tickets ut', 'up.voided_payment_code=ut.upgrade_code');
		$this->db->group_by('ut.ticket_ids');
		$this->db->where('voided_payment_transaction_id', $transaction_id);
		$this->db->where('voided_payment_code', $upgrade_code);
		$this->db->where('voided_payment_status', '0');
		$query = $this->db->get('upgrade_payments up');
		
		return $query->result();
		
	}	
	
	function search_reservations($searchkey=array(), $offset = false, $limit = false , $event_id = false)
	{
		if (!empty($searchkey) ){
			$this->db->query('set transaction isolation level read uncommitted');
			$this->db->select('t.transaction_id,c.customer_firstname,c.customer_lastname,c.customer_mobile,t.transaction_date,ti.ticket_reservation_expiry,ev.event_long_title,se.section_name,t.transaction_branch_id,ti.ticket_branch_id,count(ti.ticket_id) as ticket_count, ev.event_id');
			$this->db->group_by('t.transaction_id');
			$this->db->where('ti.ticket_status', 'reserved');
			$this->db->where('transaction_status', 'reserved');
			if($this->input->post('mobile')!="")
			$this->db->like('c.customer_mobile', $this->input->post('mobile')); 
			$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left');
			$this->db->join($this->tickets, 't.transaction_id = ti.ticket_transaction_id', 'left');
			$this->db->join('sections se', 'se.section_id=ti.ticket_section_id','left');
			$this->db->join('events ev', 'ev.event_id=ti.ticket_event_id','left');
			$this->db->join('events_config ec', 'ev.event_id=ec.events_config_eventid','left');
			
			foreach ($searchkey as $key=>$value)
			{
				switch ($key)
				{
					case 'name':
						$this->db->like('CONCAT(customer_lastname,customer_firstname)', $value);
						break;
					default:
  					if($this->session->userdata('user_type') == 'Seller' or $this->session->userdata('user_type') == 'Reservation' or $this->session->userdata('user_type') == 'Reservation-Admin'){ 
						$this->db->where($key, $value);
					}else{
						$this->db->like($key, $value);
					}
					
						break;
				}
			}
			
			$query = $this->db->get($this->transactions);
			// return $query->result();
			$row = $query->row();
			
			$branches = $this->get_branch_filter_reservation($event_id);
			if($branches!=""){
				$branches = unserialize($branches);
			}else{
				$branches = "";
			}
				
			// print_r($branches);
			// die();
			
		}
		
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('t.transaction_id,c.customer_firstname,c.customer_lastname,c.customer_mobile,t.transaction_date,ti.ticket_reservation_expiry,ev.event_long_title,se.section_name,t.transaction_branch_id,ti.ticket_branch_id,count(ti.ticket_id) as ticket_count, ev.event_id');
		$this->db->group_by('t.transaction_id');
		$this->db->where('ti.ticket_status', 'reserved');
		$this->db->where('transaction_status', 'reserved');
		if($this->input->post('mobile')!="")
		$this->db->like('c.customer_mobile', $this->input->post('mobile')); 
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left');
		$this->db->join($this->tickets, 't.transaction_id = ti.ticket_transaction_id', 'left');
		$this->db->join('sections se', 'se.section_id=ti.ticket_section_id','left');
		$this->db->join('events ev', 'ev.event_id=ti.ticket_event_id','left');
		$this->db->join('events_config ec', 'ev.event_id=ec.events_config_eventid','left');

		if (!empty($searchkey) )
		{
			
			
			
			if($branches!=""){
				
				// if ((in_array($this->session->userdata('user_branch_id'),$branches))){
					// if(!in_array($this->session->userdata('user_type'), array('Admin','Super Admin','Admin2','Seller'))){
						// $this->db->where('ev.event_id !=', $event_id);
					// }
				
				// }
					// $this->db->where('ev.event_id !=', $event_id);
					foreach ($searchkey as $key=>$value)
						{
							switch ($key)
							{
								case 'name':
									$this->db->like('CONCAT(customer_lastname,customer_firstname)', $value);
									break;
								default:
								if($this->session->userdata('user_type') == 'Sellerss' or $this->session->userdata('user_type') == 'Reservation' or $this->session->userdata('user_type') == 'Reservation-Admin'){ 
									$this->db->where($key, $value);
								}else{
									$this->db->like($key, $value);
								}
								
									break;
							}
					}
				
				
				if ($limit) $this->db->limit($limit);
				if ($offset) $this->db->offset($offset);
				$query = $this->db->get($this->transactions);
				return $query->result();
				
			} else{
				
				foreach ($searchkey as $key=>$value)
						{
							switch ($key)
							{
								case 'name':
									$this->db->like('CONCAT(customer_lastname,customer_firstname)', $value);
									break;
								default:
								if($this->session->userdata('user_type') == 'Sellerss' or $this->session->userdata('user_type') == 'Reservation' or $this->session->userdata('user_type') == 'Reservation-Admin'){ 
									// $this->db->where($key, $value);
								}else{
									$this->db->like($key, $value);
								}
								
									break;
							}
					}
				
				if ($limit) $this->db->limit($limit);
				if ($offset) $this->db->offset($offset);
				// $this->db->where('transaction_id', 1732147);
				$query = $this->db->get($this->transactions);
				// return $query->result();
			} 

			return $query->result();
			
		
		}else{
			$branches = "";
			if($this->session->userdata('user_type') == 'Sellerss' or $this->session->userdata('user_type') == 'Reservation' or $this->session->userdata('user_type') == 'Reservation-Admin'){
				$this->db->where('t.transaction_id', 0);
			}
			/* //coldplay restriction
			if($this->session->userdata('user_type') == 'Admin'){
			
			
			}else{


				$coldplay_users = array('3005','1320');
				if(!in_array($this->session->userdata('user_id'), $coldplay_users)){
						
					$this->db->where('ti.ticket_event_id !=', 5157); 

				}
			
			} */	
			$this->db->order_by('t.transaction_id', 'desc');
			if ($limit) $this->db->limit($limit);
			if ($offset) $this->db->offset($offset);
			$query = $this->db->get($this->transactions);
			return $query->result();
		}

	}
	
	function search_reservations__($searchkey=array(), $offset = false, $limit = false, $event_id = false)
	{
		/* if (!empty($searchkey) ){
			$this->db->query('set transaction isolation level read uncommitted');
			$this->db->select('t.transaction_id,c.customer_firstname,c.customer_lastname,c.customer_mobile,t.transaction_date,ti.ticket_reservation_expiry,ev.event_long_title,se.section_name,t.transaction_branch_id,ti.ticket_branch_id,count(ti.ticket_id) as ticket_count, ev.event_id');
			$this->db->group_by('t.transaction_id');
			$this->db->where('ti.ticket_status', 'reserved');
			$this->db->where('transaction_status', 'reserved');
			if($this->input->post('mobile')!="")
			$this->db->like('c.customer_mobile', $this->input->post('mobile')); 
			$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left');
			$this->db->join($this->tickets, 't.transaction_id = ti.ticket_transaction_id', 'left');
			$this->db->join('sections se', 'se.section_id=ti.ticket_section_id','left');
			$this->db->join('events ev', 'ev.event_id=ti.ticket_event_id','left');
			$this->db->join('events_config ec', 'ev.event_id=ec.events_config_eventid','left');
			
			foreach ($searchkey as $key=>$value)
			{
				switch ($key)
				{
					case 'name':
						$this->db->like('CONCAT(customer_lastname,customer_firstname)', $value);
						break;
					default:
  					if($this->session->userdata('user_type') == 'Seller' or $this->session->userdata('user_type') == 'Reservation' or $this->session->userdata('user_type') == 'Reservation-Admin'){ 
						$this->db->where($key, $value);
					}else{
						$this->db->like($key, $value);
					}
					
						break;
				}
			}
			// $this->db->where('ti.ticket_event_id', $event_id);
			$query = $this->db->get($this->transactions);
			// return $query->result();
			$row = $query->row();
			/* $event_id = "";
			if(isset($row->event_id)){
			$event_id = $row->event_id;
			}else{
				
			} 
			$branches = $this->get_branch_filter_reservation($event_id);
			if($branches!=""){
				$branches = unserialize($branches);
			}else{
				$branches = "";
			}
				
			// print_r($branches);
			// die();
			
		} */
		
		
		$branches = $this->get_branch_filter_reservation($event_id);
			
		if($branches!=""){
			$branches = unserialize($branches);
		}else{
			$branches = "";
		}
		
		
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('t.transaction_id,c.customer_firstname,c.customer_lastname,c.customer_mobile,t.transaction_date,ti.ticket_reservation_expiry,ev.event_long_title,se.section_name,t.transaction_branch_id,ti.ticket_branch_id,count(ti.ticket_id) as ticket_count, ev.event_id');
		$this->db->group_by('t.transaction_id');
		$this->db->where('ti.ticket_status', 'reserved');
		$this->db->where('transaction_status', 'reserved');
		if($this->input->post('mobile')!="")
		$this->db->like('c.customer_mobile', $this->input->post('mobile')); 
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left');
		$this->db->join($this->tickets, 't.transaction_id = ti.ticket_transaction_id', 'left');
		$this->db->join('sections se', 'se.section_id=ti.ticket_section_id','left');
		$this->db->join('events ev', 'ev.event_id=ti.ticket_event_id','left');
		$this->db->join('events_config ec', 'ev.event_id=ec.events_config_eventid','left');

		if (!empty($searchkey) )
		{
			
			
			
			if($branches!=""){
				
				/* if ((in_array($this->session->userdata('user_branch_id'),$branches))){
					if(!in_array($this->session->userdata('user_type'), array('Admin','Super Admin','Admin2'))){
						$this->db->where('ev.event_id !=', $event_id);
					}
				
				} */
					$this->db->where('ev.event_id', $event_id);
					// $this->db->where('ev.event_id !=', $event_id);
					foreach ($searchkey as $key=>$value)
						{
							switch ($key)
							{
								case 'name':
									$this->db->like('CONCAT(customer_lastname,customer_firstname)', $value);
									break;
								default:
								if($this->session->userdata('user_type') == 'Seller' or $this->session->userdata('user_type') == 'Reservation' or $this->session->userdata('user_type') == 'Reservation-Admin'){ 
									$this->db->where($key, $value);
								}else{
									$this->db->like($key, $value);
								}
								
									break;
							}
					}
				
				// $this->db->where('ti.ticket_event_id', $event_id);
				// if ($limit) $this->db->limit($limit);
				// if ($offset) $this->db->offset($offset);
				
				$query = $this->db->get($this->transactions);
				return $query->result();
				
			} else{
				
				foreach ($searchkey as $key=>$value)
						{
							switch ($key)
							{
								case 'name':
									$this->db->like('CONCAT(customer_lastname,customer_firstname)', $value);
									break;
								default:
								if($this->session->userdata('user_type') == 'Seller' or $this->session->userdata('user_type') == 'Reservation' or $this->session->userdata('user_type') == 'Reservation-Admin'){ 
									$this->db->where($key, $value);
								}else{
									$this->db->like($key, $value);
								}
								
									break;
							}
					}
				// $this->db->where('ti.ticket_event_id', $event_id);
				// if ($limit) $this->db->limit($limit);
				// if ($offset) $this->db->offset($offset);
				// $this->db->where('transaction_id', 1732147);
				$query = $this->db->get($this->transactions);
				// return $query->result();
			} 

			return $query->result();
			
		
		}else{
			$branches = "";
			if($this->session->userdata('user_type') == 'Seller' or $this->session->userdata('user_type') == 'Reservation' or $this->session->userdata('user_type') == 'Reservation-Admin'){
				$this->db->where('t.transaction_id', 0);
			}
			/* //coldplay restriction
			if($this->session->userdata('user_type') == 'Admin'){
			
			
			}else{


				$coldplay_users = array('3005','1320');
				if(!in_array($this->session->userdata('user_id'), $coldplay_users)){
						
					$this->db->where('ti.ticket_event_id !=', 5157); 

				}
			
			} */	
			$this->db->order_by('t.transaction_id', 'desc');
			// if ($limit) $this->db->limit($limit);
			// if ($offset) $this->db->offset($offset);
			$query = $this->db->get($this->transactions);
			return $query->result();
		}

	}
	
	/**
	 * search_reservation_list
	 *
	 * @access	public
	 */
	function search_reservations_old($searchkey=array(), $offset = false, $limit = false, $event_id = false)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('t.transaction_id,c.customer_firstname,c.customer_lastname,c.customer_mobile,t.transaction_date,ti.ticket_reservation_expiry,ev.event_long_title,se.section_name,t.transaction_branch_id,ti.ticket_branch_id,count(ti.ticket_id) as ticket_count');
		$this->db->group_by('t.transaction_id');
		$this->db->where('ti.ticket_status', 'reserved');
		$this->db->where('transaction_status', 'reserved');
		if($this->input->post('mobile')!="")
		$this->db->like('c.customer_mobile', $this->input->post('mobile')); 
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left');
		$this->db->join($this->tickets, 't.transaction_id = ti.ticket_transaction_id', 'left');
		$this->db->join('sections se', 'se.section_id=ti.ticket_section_id','left');
		$this->db->join('events ev', 'ev.event_id=ti.ticket_event_id','left');

		if (!empty($searchkey) )
		{
			foreach ($searchkey as $key=>$value)
			{
				switch ($key)
				{
					case 'name':
						$this->db->like('CONCAT(customer_lastname,customer_firstname)', $value);
						break;
					default:
  					if($this->session->userdata('user_type') == 'Seller' or $this->session->userdata('user_type') == 'Reservation' or $this->session->userdata('user_type') == 'Reservation-Admin'){ 
						$this->db->where($key, $value);
					}else{
						$this->db->like($key, $value);
					}
					
						break;
				}
			}
		}else{
		
			if($this->session->userdata('user_type') == 'Seller' or $this->session->userdata('user_type') == 'Reservation' or $this->session->userdata('user_type') == 'Reservation-Admin'){
				$this->db->where('t.transaction_id', 0);
			}
		}
		
		// if($event_id){
			
			$this->db->where('ti.ticket_event_id', $event_id);
		// }
		
		if(!in_array($this->session->userdata('user_type'),array('Admin','Super Admin'))){
		// $this->db->where('ev.event_reservation_claiming', 0);
		}
		
		$this->db->order_by('t.transaction_id', 'desc');
		
		// if ($limit) $this->db->limit($limit);
		// if ($offset) $this->db->offset($offset);
		$query = $this->db->get($this->transactions);
		// echo $this->db->last_query();
		// die();

		return $query->result();
	}
	
	function void($transaction_id,$upgrade_code=false)
	{
		// get the section id first
		$this->db->select('ticket_section_id');
		$this->db->where('ticket_transaction_id', $transaction_id);
		$this->db->limit(1);
		$query = $this->db->get($this->tickets);
		$section = $query->row();
				
		
		$this->db->where('ticket_transaction_id', $transaction_id);
		$this->db->where('ticket_status', 'paid');
		$counts = $this->db->count_all_results('tickets');
		
		if($counts >= 0 )
		{
			$fields = array(
				'transaction_comment'	=> $this->input->post('transaction_comment'),
			);
		}
		else
		{
			/* $fields = array(
				'transaction_status'	=> 'voided',
				'transaction_comment'	=> $this->input->post('transaction_comment'),
				'transaction_details'	=> 'void transaction',
				'transaction_type'		=> 'void transaction',
			); */
		}
			// update transactions table
			/* $this->db->where('transaction_id', $transaction_id);
			$this->db->update($this->transactions, $fields); */
			
		$this->db->select('user_id');
		$this->db->where('username', $this->input->post('username'));
		$query = $this->db->get('users');
		$result = $query->row();
		$user_id = $result->user_id;
		$branch_id = ($this->session->userdata('user_branch_id')) ? $this->session->userdata('user_branch_id') : '';
	
		// $fields = array(
			// 'voided_transaction_id'				=> $transaction_id,
			// 'voided_date'						=> date("Y-m-d H:i:s"),
			// 'voided_user_id'					=> $user_id,
			// 'voided_branch_id'					=> $branch_id, 
		// );	
			
			
		
		$checked = $this->input->post('tickets_');
		// die();
		if(isset($checked)){
		foreach($checked as $tickets_id => $value)
		{
			// update tickets table
			// $this->db->where('ticket_id', $tickets_id);
			// $this->db->update($this->tickets, array('ticket_status' => 'voided'));
				$fields = array(
				'transaction_id'	=> $transaction_id,
				'upgrade_code'		=> $upgrade_code,		
				'ticket_id'			=> $tickets_id,			
				'user_id'			=> $user_id,					
				'branch_id'			=> $branch_id,					
				);
				
				$this->db->set($fields);
				$this->db->insert('upgrade_tickets');
			
		} 
		
		}
		// $ticket_count = $this->db->affected_rows();
		
		// $this->add_voided_details($transaction_id);
		
		$this->void_payment($_POST,$transaction_id,$upgrade_code);	 
		return array($section->ticket_section_id, $ticket_count);
	}
	
	function void_payment($post, $transID, $upgrade_code=false){
		 
		$payments = array();
		foreach($post as $x=>$y){
			
			// echo "$x <br>";
			
			if (strpos($x, 'payment_') !== false) {
				// echo 'true';
				
				$p_name=  explode("_",$x);
				
				$payments[$p_name[1]] = $y;
			}
			
			
		} 
		
		// echo '<pre>';
		// print_r($payments);
		// echo '</pre>';
		
		
		$this->db->where('payment_transaction_id', $transID); 
 		$result = $this->db->get('payments')->result();
	
		$payment = array();
		foreach($result as $z){
			$paym = $payments[$z->payment_id];
			if($payments[$z->payment_id]!="" && $paym != 0){
			$fields = array(
				'voided_payment_code'			=> $upgrade_code,		
				'voided_payment_transaction_id'	=> $transID,		
				'voided_payment_type_id'		=> $z->payment_payment_type_id,		
				'voided_payment_amount'			=> $payments[$z->payment_id]			
				);
				
				$this->db->set($fields);
				$this->db->insert('upgrade_payments');
			}
				// $voided_amount = $z->payment_amount_voided + $payments[$z->payment_id]; 
				// $this->db->set('payment_amount_voided', $voided_amount);
				// $this->db->where('payment_id', $z->payment_id);
				// $this->db->where('payment_transaction_id', $transID);
				// $this->db->update('payments'); 
			
			/* if($z->payment_payment_type_id == 36){
				
				// $voided_amount = $z->payment_amount_voided + $payments[$z->payment_payment_type_id]; 
				// $this->db->set('payment_amount_voided', $voided_amount);
				// $this->db->where('payment_payment_type_id', $z->payment_payment_type_id);
				// $this->db->where('payment_transaction_id', $transID);
				// $this->db->update('payments');
				
				
			}else{
				
				$voided_amount = $z->payment_amount_voided + $payments[$z->payment_id]; 
				/* $this->db->set('payment_amount_voided', $voided_amount);
				$this->db->where('payment_id', $z->payment_id);
				$this->db->where('payment_transaction_id', $transID);
				$this->db->update('payments'); 
				
				
				//for ticket upgrade
				if($this->input->post('transaction_comment')=='Upgrade'){
				
				
				}
				
			} */
			
			
			$this->db->select('user_branch_id');
			$this->db->where('username', $post['username']);
			$query = $this->db->get('users');
			$branch_id = $query->row()->user_branch_id;
			
			
			//for historical ATR sales 
			$voided_amount = $payments[$z->payment_id]; 
			$this->db->set('payment_id',$z->payment_id);
			$this->db->set('payment_amount', 0);
			$this->db->set('payment_amount_voided', $voided_amount);
			$this->db->set('payment_transaction_id', $transID);
			$this->db->set('payment_payment_type_id', $z->payment_payment_type_id);
			$this->db->set('payment_datetime', date("Y-m-d"));
			$this->db->set('payment_branch', $branch_id);

						
			$this->db->insert('historical_payments');
			
			
		}
		
		
		//for online
	  	if($result[0]->payment_payment_type_id == 35){ 
		
			$this->db->where('charge_transaction_id', $transID); 
			$result2 = $this->db->get('charges')->row();
			// echo '<pre>';
			// print_r($post);
			// echo $result2->charge_amount;
			// die();
			
			$charge_per_tix = $result2->charge_amount / $result2->charge_ticket_count;
			$charge = $charge_per_tix * count($post['tickets']);
			$charge = $charge + $result2->charge_amount_voided;
			$this->db->set('charge_amount_voided', 0);
			$this->db->set('date_modified', date("Y-m-d H:i:s"));
			$this->db->where('charge_transaction_id', $transID);
			$this->db->update('charges');
			
			
			//for historical ATR sales 
			$charge_per_tix = $result2->charge_amount / $result2->charge_ticket_count;
			$charge = $charge_per_tix * count($post['tickets']);
			// $charge = $charge + $result2->charge_amount_voided;
		 
			$this->db->set('charge_datetime', date("Y-m-d")); 
			$this->db->set('charge_transaction_id', $transID);
			
			// $this->db->set('charge_amount', $result2->charge_amount);
			// $this->db->set('charge_ticket_count', $result2->charge_ticket_count);
			
			$this->db->set('charge_amount', 0);
			$this->db->set('charge_ticket_count', 0);
			
			$this->db->set('charge_type', 'convenience');
			$this->db->set('charge_amount_voided', 0);
			$this->db->set('charge_branch', $branch_id);
			 
			$this->db->insert('historical_charges');
			
			
		} 		

		
		/* //for online
	  	if($result[0]->payment_payment_type_id == 35){ 
		
			$this->db->where('charge_transaction_id', $transID); 
			$result2 = $this->db->get('charges')->row();
			// echo '<pre>';
			// print_r($post);
			// echo $result2->charge_amount;
			// die();
			
			$charge_per_tix = $result2->charge_amount / $result2->charge_ticket_count;
			$charge = $charge_per_tix * count($post['tickets']);
			$charge = $charge + $result2->charge_amount_voided;
			$this->db->set('charge_amount_voided', $charge);
			$this->db->set('date_modified', date("Y-m-d H:i:s"));
			$this->db->where('charge_transaction_id', $transID);
			$this->db->update('charges');
			
		} */ 
			
		
	}
	
	function insert_upgrade_tickets($upgrade_code, $transaction, $tickets){
		
		/* $this->db->select('ticket_section_id');
		$this->db->where('ticket_transaction_id', $transaction->transaction_id);
		$this->db->limit(1);
		$query = $this->db->get($this->tickets);
		$section = $query->row(); */
		
		$this->db->select('user_id');
		$this->db->where('username', $this->input->post('username'));
		$query = $this->db->get('users');
		$result = $query->row();
		$user_id = $result->user_id;
		$branch_id = ($this->session->userdata('user_branch_id')) ? $this->session->userdata('user_branch_id') : '';
		
		$ticket_ids = $this->input->post('tickets');
		
		// foreach($ticket_ids as $ticket_id){
			$fields = array(
				'upgrade_code'		=> $upgrade_code,				
				'transaction_id'	=> $transaction,				
				'branch_id'	=> $branch_id,				
				'user_id'	=> $user_id,				
				'ticket_ids'		=> implode(",", $ticket_ids)	
				);
				
				$this->db->set($fields);
				$this->db->insert('upgrade_tickets');
		// }
		
		/* if (count($section) > 0)
		{		
			$ticket_ids = $this->input->post('tickets');
			
			// void the tickets
			// $ticket_count = $this->update_status($ticket_ids, 'voided');
			
			// also void the transaction if all tickets are voided
			if(count($tickets) == $ticket_count)
			{
				$fields = array(
				'upgrade_code'		=> $upgrade_code,				
				'ticket_id'			=> $ticket_id			
				);
				
				$this->db->set($fields);
				$this->db->insert('upgrade_payments');
				
				// $this->db->where('transaction_id', $transaction->transaction_id);
				// $this->db->update($this->transactions, array('transaction_status' => 'voided'));
			}
			
			return array($section->ticket_section_id, $ticket_count);
		}
		else
		{
			return array(0,0);
		} */
		
		
		
				
	}
	
	function void_upgraded_tix($transaction_id,$tix_ids,$user_id,$branch_id)
	{
		// get the section id first
		$this->db->select('ticket_section_id');
		$this->db->where('ticket_transaction_id', $transaction_id);
		// $this->db->limit(1);
		$query = $this->db->get($this->tickets);
		$section = $query->row();
				
		
		$this->db->where('ticket_transaction_id', $transaction_id);
		$this->db->where('ticket_status', 'done');
		$counts = $this->db->count_all_results('tickets');
		
		// echo $this->db->last_query();
		
		$checked = explode(",",$tix_ids);
		count($checked);
		
		if($counts == (count($checked)-1) )
		{
			// echo 'yes';
			$fields = array(
				'transaction_status'	=> 'voided',
				'transaction_comment'	=> 'Upgrade',
				'transaction_details'	=> 'void transaction',
				'transaction_type'		=> 'void transaction',
			);
			$this->db->where('transaction_id', $transaction_id);
			$this->db->update($this->transactions, $fields);
		}
		
			// update transactions table
		// die();	
		// echo $this->db->last_query();
		// die();
		// $checked = $this->input->post('tickets_');
		$checked = explode(",",$tix_ids);
		
		// print_r($checked);
		// foreach($checked as $tickets_id => $value)
		// {
			// update tickets table
			// echo $tickets_id;
			$this->db->where_in('ticket_id', $checked);
			$this->db->update($this->tickets, array('ticket_status' => 'voided'));
		// }
		$ticket_count = $this->db->affected_rows();
		
		$this->copy_voided_tickets($tix_ids.'900', $user_id, $branch_id, 'voided');	
		$this->add_voided_details($transaction_id);
		
		// $this->void_payment($_POST,$transaction_id,$upgrade_code);	 
		return array($section->ticket_section_id, $ticket_count); 
	}
	
	
	function add_voided_details($transaction_id = false)
	{
		//$user_id = ($this->session->userdata('user_id')) ? $this->session->userdata('user_id') : '';
		$this->db->select('user_id');
		$this->db->where('username', $this->input->post('username'));
		$query = $this->db->get('users');
		$result = $query->row();
		$user_id = $result->user_id;
		$branch_id = ($this->session->userdata('user_branch_id')) ? $this->session->userdata('user_branch_id') : '';
		$ticket_ids = $this->input->post('tickets');
		$transaction_comment = $this->input->post('transaction_comment');
		
		$fields = array(
			'voided_transaction_id'				=> $transaction_id,
			'voided_date'						=> date("Y-m-d H:i:s"),
			'voided_user_id'					=> $user_id,
			'voided_branch_id'					=> $branch_id, 
			'voided_remarks'					=> "Upgrade", 
			'voided_details'					=> serialize($ticket_ids), 
		);
		
		// insert to db
		$this->db->set($fields);
		$this->db->insert('voided_transactions');
		$this->copy_voided_tickets($ticket_ids, $user_id, $branch_id, 'voided');		
		$this->void_trans($transaction_id);
		
		foreach($ticket_ids as $x){
			$fields = array(
			'voided_detail_transaction_id'		=> $transaction_id, 
			'voided_detail_ticket_id'			=> $x, 
			'voided_detail_user_id'				=> $user_id, 
			'voided_detail_branch_id'			=> $branch_id, 
		);
		
		
		
		// echo '<pre>';
		// print_r($ticket_ids);
		// echo '</pre>';
			// die();
		//insert into historical table 
		
		// for historical asr
		$this->db->set($fields);
		$this->db->insert('voided_transaction_details');
			
		}
	
		 
 	}
	
	function void_trans($transaction_id)
	{
		// get the section id first
		$this->db->select('ticket_section_id');
		// $this->db->where('ticket_transaction_id', $transaction_id);
		// $this->db->limit(1);
		// $query = $this->db->get($this->tickets);
		// $section = $query->row();
				
		
		$this->db->where('ticket_transaction_id', $transaction_id);
		$this->db->where_in('ticket_status', array('paid','done'));
		$query = $this->db->get('tickets');
		$counts = $query->num_rows();
		// $counts = $this->db->count_all_results('tickets');
		
		 if($counts > 0 )
		{
			
			$fields = array(
				'transaction_comment'	=> $this->input->post('transaction_comment'),
			);
			
		}
		else
		{	
			$fields = array(
				'transaction_status'	=> 'voided',
				'transaction_comment'	=> 'Upgrade',
				'transaction_details'	=> 'void transaction',
				'transaction_type'		=> 'void transaction',
			);
			
			$this->admin->copy_transactions($transaction_id,'voided');
			
		} 
		
		// $fields = array(
				// 'transaction_status'	=> 'voided',
				// 'transaction_comment'	=> 'Upgrade',
				// 'transaction_details'	=> 'void transaction',
				// 'transaction_type'		=> 'void transaction',
			// );
			
			// $this->admin->copy_transactions($transaction_id,'voided');
			// update transactions table
			$this->db->where('transaction_id', $transaction_id);
			$this->db->update($this->transactions, $fields);
			
	}
	
	function void_tickets($transaction, $ticket_ids)
	{
		// get the section id first
			$changes = array('ticket_status' => 'voided' );
			
			// update the status of the tickets
			$this->db->where_in('ticket_id', $ticket_ids);
			$this->db->update($this->tickets, $changes);
	}
	
	function code_mark_as_used($upgrade_code){
		$stat = array('voided_payment_status' => '1');
			
			// update the status of the tickets
		$this->db->where('voided_payment_code', $upgrade_code);
		$this->db->update('upgrade_payments', $stat);
		
		$this->mark_other_code($upgrade_code);
		
		// echo $this->db->last_query();
		// die();
	}
	
	function mark_other_code($upgrade_code){
		$this->db->select('voided_payment_transaction_id');
		$this->db->where('voided_payment_code', $upgrade_code);
		$query = $this->db->get('upgrade_payments');
		$query_res = $query->result();
		foreach($query_res as $req){
			$stat = array('voided_payment_status' => '1');
			
			// update the status of the tickets
			$this->db->where('voided_payment_transaction_id', $req->voided_payment_transaction_id);
			$this->db->update('upgrade_payments', $stat);
		
		}
		
	}
	
	
	function get($transaction_id)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->join($this->terminals, 't.transaction_terminal_id = te.terminal_id');
		$this->db->join($this->branches, 't.transaction_branch_id = b.branch_id');
		$this->db->join($this->users, 't.transaction_user_id = u.user_id');
		$this->db->join($this->customers, 't.transaction_customer_id = c.customer_id', 'left');
 		//$this->db->join($this->tickets, 't.transaction_id = ti.ticket_transaction_id', 'left');
		//$this->db->join($this->events, 'ti.ticket_event_id = e.event_id', 'left');
		$this->db->where('transaction_id', $transaction_id);
		$query = $this->db->get($this->transactions);
	
		return $query->row();		
	}
	
	
	
	function _prep_amount($str)
	{	
		return str_replace(',', '', $str);
	}	

	function upgrade_payments($upgrade_code,$type){
		$this->db->select('voided_payment_amount');	
  		$this->db->where('voided_payment_code', $upgrade_code); 
  		$this->db->where('voided_payment_type_id', $type); 
		$query = $this->db->get('upgrade_payments');
		$result = $query->num_rows();
		
		if($result==0){
			return "0";
		}else{
			return $query->row('voided_payment_amount');
		}
		
		
	}
	
	function get_upgrade_payments($upgrade_code){
		$this->db->select('voided_payment_amount, voided_payment_type_id,voided_payment_transaction_id');	
  		$this->db->where('voided_payment_code', $upgrade_code); 
  		// $this->db->where('voided_payment_type_id', $type); 
		$query = $this->db->get('upgrade_payments');
		return $query->result();
		
		// if($result==0){
			// return "0";
		// }else{
			// return $query->row('voided_payment_amount');
		// }
		
		
	}
	
	
	function insert_payment($transaction_id,$type,$payment_amount,$upgrade_code){

		$upgrade_payments_all = $this->get_upgrade_payments($upgrade_code);
		$upgrade_payments_ = $this->upgrade_payments($upgrade_code,$type);
		
		
		

		
		
		// $this->db->where('voided_payment_code', $upgrade_code);
		// $this->db->where('voided_payment_type_id', $type);
		// $row_count_ = $this->db->get('upgrade_payments')->num_rows();
		
		// if($row_count_<1){
			// $fields = array(
				// 'payment_transaction_id'	=> $transaction_id,
				// 'payment_payment_type_id'	=> $type,
				// 'payment_amount'			=> $payment_amount
				// );
				// $this->db->set($fields);
				// $this->db->insert('payments');
		// } 
		$this->db->where('payment_payment_type_id', $type);
		$this->db->where('payment_transaction_id', $transaction_id);
		$row_count = $this->db->get('payments')->num_rows();
		foreach($upgrade_payments_all as $upgrade_payment_all){
			
			
			$this->db->set('payment_amount_voided', $upgrade_payment_all->voided_payment_amount);
			$this->db->where('payment_payment_type_id', $upgrade_payment_all->voided_payment_type_id);
			$this->db->where('payment_transaction_id',$upgrade_payment_all->voided_payment_transaction_id);
			$this->db->update('payments'); 	
				
				
			
			if($row_count<1 && $upgrade_payment_all->voided_payment_type_id==$type){
				$this->delete_payments($type, $transaction_id);
				$fields = array(
				'payment_transaction_id'	=> $transaction_id,
				'payment_payment_type_id'	=> $type,
				'payment_amount'			=> $payment_amount + $upgrade_payment_all->voided_payment_amount
				);
				$this->db->set($fields);
				$this->db->insert('payments');
			}else if($row_count<1 && $upgrade_payment_all->voided_payment_type_id!=$type){
				$this->db->where('payment_payment_type_id', $upgrade_payment_all->voided_payment_type_id);
				$this->db->where('payment_transaction_id', $transaction_id);
				$row_count2 = $this->db->get('payments')->num_rows();
				if($row_count2 < 1 && $upgrade_payment_all->voided_payment_type_id!=$type){
					
					
					// $this->delete_payments($upgrade_payment_all->voided_payment_type_id, $transaction_id);
					
					$this->db->where('payment_payment_type_id', $type);
					$this->db->where('payment_transaction_id', $transaction_id);
					$row_count2_ = $this->db->get('payments')->num_rows();
					if($row_count2_ < 1){
						$fields = array(
						'payment_transaction_id'	=> $transaction_id,
						'payment_payment_type_id'	=> $upgrade_payment_all->voided_payment_type_id,
						'payment_amount'			=> $upgrade_payment_all->voided_payment_amount,
						);
						$this->db->set($fields);
						$this->db->insert('payments'); 
					}else{
					// $this->delete_payments($upgrade_payment_all->voided_payment_type_id, $transaction_id);
						// $fields = array(
						// 'payment_transaction_id'	=> $transaction_id,
						// 'payment_payment_type_id'	=> $type,
						// 'payment_amount'			=> $payment_amount,
						// );
						// $this->db->set($fields);
						// $this->db->insert('payments');
					}
					
					$this->db->where('payment_payment_type_id', $upgrade_payment_all->voided_payment_type_id);
					$this->db->where('payment_transaction_id', $transaction_id);
					$row_count2_ = $this->db->get('payments')->num_rows();
					if($row_count2_ < 1 && $type==$upgrade_payment_all->voided_payment_type_id){
						
						$this->db->where('payment_payment_type_id', $type);
						$this->db->where('payment_transaction_id', $transaction_id);
						$row_count6_ = $this->db->get('payments')->num_rows();
						
						if($row_count6_<1){
							$fields = array(
							'payment_transaction_id'	=> $transaction_id,
							'payment_payment_type_id'	=> $upgrade_payment_all->voided_payment_type_id,
							'payment_amount'			=> $upgrade_payment_all->voided_payment_amount,
							);
							$this->db->set($fields);
							$this->db->insert('payments'); 
						}
					}else{
					// $this->delete_payments($upgrade_payment_all->voided_payment_type_id, $transaction_id);
						// $fields = array(
						// 'payment_transaction_id'	=> $transaction_id,
						// 'payment_payment_type_id'	=> $type,
						// 'payment_amount'			=> $payment_amount,
						// );
						// $this->db->set($fields);
						// $this->db->insert('payments');
					}
					
					
					$this->db->where('payment_payment_type_id', $upgrade_payment_all->voided_payment_type_id);
					$this->db->where('payment_transaction_id', $transaction_id);
					$row_count2__ = $this->db->get('payments')->num_rows();
					if($row_count2__ < 1){
						$fields = array(
						'payment_transaction_id'	=> $transaction_id,
						'payment_payment_type_id'	=> $upgrade_payment_all->voided_payment_type_id,
						'payment_amount'			=> $upgrade_payment_all->voided_payment_amount,
						);
						$this->db->set($fields);
						$this->db->insert('payments'); 
					}else{
					// $this->delete_payments($upgrade_payment_all->voided_payment_type_id, $transaction_id);
						$fields = array(
						'payment_transaction_id'	=> $transaction_id,
						'payment_payment_type_id'	=> $type,
						'payment_amount'			=> $payment_amount,
						);
						$this->db->set($fields);
						$this->db->insert('payments');
					}
					
					
					
				}elseif($row_count2 < 1 && $upgrade_payment_all->voided_payment_type_id!=$upgrade_payment_all->voided_payment_type_id){
					
					
				}
				
				
				else{
					$this->db->where('payment_payment_type_id', $type);
					$this->db->where('payment_transaction_id', $transaction_id);
					$row_count__ = $this->db->get('payments')->num_rows();
					if($row_count__<1){
						$fields = array(
						'payment_transaction_id'	=> $transaction_id,
						'payment_payment_type_id'	=> $type,
						'payment_amount'			=> $payment_amount,
						);
						$this->db->set($fields);
						$this->db->insert('payments');
					}
					}
			
			}
			else {
				$this->db->where('payment_payment_type_id', $type);
				$this->db->where('payment_transaction_id', $transaction_id);
				$row_count3 = $this->db->get('payments')->num_rows();
				if($row_count3 < 1){
					
					
					$this->delete_payments($type, $transaction_id);
					$fields = array(
					'payment_transaction_id'	=> $transaction_id,
					'payment_payment_type_id'	=> $type,
					'payment_amount'			=> $payment_amount,
					);
					$this->db->set($fields);
					$this->db->insert('payments');
				}else{
					
					$this->db->where('payment_payment_type_id', $type);
					$this->db->where('payment_transaction_id', $transaction_id);
					$row_count4 = $this->db->get('payments')->num_rows();
					
					if($row_count4 < 1){
					$fields = array(
					'payment_transaction_id'	=> $transaction_id,
					'payment_payment_type_id'	=> $upgrade_payment_all->voided_payment_type_id,
					'payment_amount'			=> $upgrade_payment_all->voided_payment_amount,
					);
					$this->db->set($fields);
					$this->db->insert('payments');
					}else{
					$fields = array(
					'payment_transaction_id'	=> $transaction_id,
					'payment_payment_type_id'	=> $upgrade_payment_all->voided_payment_type_id,
					'payment_amount'			=> $upgrade_payment_all->voided_payment_amount,
					);
					$this->db->set($fields);
					$this->db->insert('payments');
					}
					
				}

				
				$this->db->where('payment_payment_type_id', $type);
				$this->db->where('payment_transaction_id', $transaction_id);
				$row_count_filter = $this->db->get('payments')->num_rows();
				
				if($row_count_filter<1){
					$fields = array(
					'payment_transaction_id'	=> $transaction_id,
					'payment_payment_type_id'	=> $type,
					'payment_amount'			=> $payment_amount
					);
					$this->db->set($fields);
					$this->db->insert('payments');
					
				}
				
				
				//check if existing
				

				// if($row_count < 1){


					// $fields = array(
					// 'payment_transaction_id'	=> $transaction_id,
					// 'payment_payment_type_id'	=> $upgrade_payment_all->voided_payment_type_id,
					// 'payment_amount'			=> $upgrade_payment_all->voided_payment_amount,
					// );
					// $this->db->set($fields);
					// $this->db->insert('payments');
				// }
				
			}
			
			$this->db->set('new_transaction_id', $transaction_id);
			$this->db->where('upgrade_code', $upgrade_code);
			$this->db->update('upgrade_tickets'); 
		}
		
		
		
		
		

		// $this->delete_payments($type,$transaction_id);
		
	}
	
	function delete_payments($type, $transaction_id){
		
		// $this->db->set('new_transaction_id', $transaction_id);
		// $this->db->where('upgrade_code', $upgrade_code);
		// $this->db->update('upgrade_tickets'); 
		
		$this->db->delete('payments', array('payment_transaction_id' => $transaction_id, 'payment_payment_type_id' => $type));
		return true;
		
	}
	/**
	 * add
	 *
	 */
	function add($customer_id,$upgrade_code)
	{
		
		// if($payment_type == 'cash'){
			// $type = 1;
		// }elseif($payment_type == 'eplus'){
			// $type = 36;  
		// }else{
		// $type = $this->input->post('transaction_'.$payment_type); 
		// }
		
		
		
		// $this->insert_payment(0, $type, $this->_prep_amount($this->input->post('transaction_payment_'.$payment_type, $upgrade_code)));	
		
		// $ucode_result = $this->get_upgrade_payments($upgrade_code);
		// $salessummary = array();
		// foreach($ucode_result as $ur){
			// if(!isset($salessummary[$ur->voided_payment_type_id]['type_id'])){
				// if($ur->voided_payment_type_id == $type){
					// $salessummary[$ur->voided_payment_type_id]['type_id']) = $ur->voided_payment_type_id;
					
				// $salessummary[$ur->voided_payment_type_id]['payment_amount'] = $ur->voided_payment_amount + $this->_prep_amount($this->input->post('transaction_payment_'.$payment_type; 
				// }
			
			
			// }
		// }
		
		// print_r($ucode_result);
		// die();
		$transaction_cc_reference = implode("|", array_filter(	$this->input->post("cc_refno")	)	);
		
		if($this->session->userdata('valid_date')){
			$v_date = $this->session->userdata('valid_date');
		}else{
			$v_date = NULL;
		}
		
		
		// add to transactions table
		$fields = array(
			'transaction_date'					=> date("Y-m-d H:i:s"),
			'transaction_date_validity'			=> $v_date,
			'transaction_user_id'				=> $this->session->userdata('user_id'),
			'transaction_customer_id'			=> $customer_id,
			'transaction_branch_id'				=> $this->session->userdata('user_branch_id'),
			'transaction_terminal_id'			=> $this->session->userdata('user_terminal_id'),
			'transaction_cash_change'			=> $this->_prep_amount($this->input->post('total_change')),
			'transaction_status'				=> 'paid',
			'transaction_cc_ref'				=> $transaction_cc_reference,
		);
		
		// insert to db
		$this->db->set($fields);
		$this->db->insert('transactions');
		
		// get transaction id
		// $transaction_id = $this->db->insert_id(); << this function sometimes returns 0.  do not use this anymore
		// got this solution from http://codeigniter.com/forums/viewthread/60170/
		$query = $this->db->query('SELECT LAST_INSERT_ID()');
		$row = $query->row_array();
		$transaction_id = $row['LAST_INSERT_ID()'];

		// check if it's the correct transaction
		$transaction = $this->get($transaction_id);
		if ($transaction->transaction_customer_id != $customer_id or $transaction->terminal_id != $this->session->userdata('user_terminal_id'))
		{
			return false;
		}
		
		// update tickets table, include the transaction id
		$this->db->where('ticket_status', 'selected');
		$this->db->where('ticket_session_id', $this->session->userdata('customer_session_id'));
		$this->db->update($this->tickets, array('ticket_transaction_id' => $transaction_id, 'ticket_status' => 'paid'));
		
		// get payment types
		$payment_types = $this->payment_types_model->get_payment_types();
		$payment_types = array('cash','eplus', 'credit_card_1', 'credit_card_2', 'debit_card', 'gift_check', 'reward_card', 'account', 'globe_reward_card');
		
		// add the payment
		// $upgrade_payments = $this->upgrade_payments($upgrade_code);
		// foreach(upgrade_payments as $upgrade_payment){
		foreach ($payment_types as $payment_type)
		{		
			if ($this->input->post('transaction_payment_'.$payment_type)){
				if($payment_type == 'globe_reward_card'){
					$type = 54;  
					$i = 0;
					foreach(	$this->input->post('transaction_payment_'.$payment_type)	as  $globe_payment_type){
						if($globe_payment_type){
						$this->insert_payment($transaction_id,	$type,	$this->_prep_amount(	$globe_payment_type),$upgrade_code);
							$codes_array = $this->input->post('globe_rewards');
							$gc_code = $codes_array[$i];
						$this->mark_as_used_gc($gc_code,"globe",$transaction_id);
						}
						$i = $i + 1;
					}
				}else{
					
					if($payment_type == 'cash'){
						$type = 1;
					}elseif($payment_type == 'eplus'){
						$type = 36;  
					}else{
						$type = $this->input->post('transaction_'.$payment_type); 
					}
					$this->db->where('voided_payment_code', $upgrade_code);
					$this->db->where('voided_payment_type_id', $type);
					$row_count_filter = $this->db->get('upgrade_payments')->num_rows();
					
					if($row_count_filter<1){
						/* $fields = array(
						'payment_transaction_id'	=> $transaction_id,
						'payment_payment_type_id'	=> $type,
						'payment_amount'			=> $this->_prep_amount($this->input->post('transaction_payment_'.$payment_type))
						);
						$this->db->set($fields);
						$this->db->insert('payments'); */
						
					}
					
					// if($upgrade_payment->voided_payment_type_id==$type){
						$this->insert_payment($transaction_id, $type, $this->_prep_amount($this->input->post('transaction_payment_'.$payment_type)), $upgrade_code);	
					// }else{
						// $this->insert_payment($transaction_id, $upgrade_payment->voided_payment_type_id, $this->_prep_amount($upgrade_payment->voided_payment_amount));	
					// }
				}	
			}
		}
		// }
		 
		$ticket = $this->session->userdata('ticket_senior');
		// if(isset($ticket)){
			// echo $ticket;
			// echo 'yes';
		// }else{
			// echo 'no';
		// }
		// die();
		$count = $this->session->userdata('tix_count');
		$senior = $this->session->userdata('senior');
		$seniorLName = $this->session->userdata('seniorLName');
		$seniorFName = $this->session->userdata('seniorFName');
		$seniorBdate = $this->session->userdata('seniorBdate');
 
		$p_count = $this->session->userdata('p_count');
		$pcode = $this->session->userdata('pcode');
 
	
		
		for ($i = 0; $i < $count; $i++)
		{
 			  
			//add to seniors table
			if($senior[$i]){
				$fields2['senior_ticket_id'] = $ticket[$i];   
				$fields2['senior_event_id'] = $this->session->userdata('cei');   
				$fields2['senior_id'] = $senior[$i];  
				$fields2['senior_lname'] = $seniorLName[$i];   
				$fields2['senior_fname'] = $seniorFName[$i];   
				$fields2['senior_bdate'] = $seniorBdate[$i];   
				$this->db->insert('senior_transactions', $fields2);
				
				unset($ticket[$i]);
				
			}
		}
		if($ticket!=""){
		$ticket = array_values($ticket);
		}
 
		
		//add to qrcode table
		for ($i = 0; $i < $p_count; $i++)
		{
 			  
 			if($pcode[$i] && $this->session->userdata('cei') != 3731){
				$fields3['qr_ticket_id'] = $ticket[$i];   
				$fields3['qr_transaction_id'] = $transaction_id;
				$this->db->where('qr_event_id', $this->session->userdata('cei'));   


				$this->db->where('qr_qrcode',$pcode[$i]);
				$this->db->update('qrcode', $fields3);
				 
			}
		}
		
		
		$this->session->unset_userdata('senior');
		$this->session->unset_userdata('seniorLName');
		$this->session->unset_userdata('seniorFName');
		$this->session->unset_userdata('seniorBdate');
		$this->session->unset_userdata('tix_count');
		$this->session->unset_userdata('ticket_senior');
		
		
		$this->session->unset_userdata('p_count');
		$this->session->unset_userdata('pcode');

		return $transaction_id;
		// die();
	}
	
	/**
	 * update
	 *
	 */
	function update($transaction_id, $reservation_fee = 0, $customer_id = false,$upgrade_code = false)
	{
	
		// echo '<pre>';
		// print_r($_POST);
		// echo '</pre>';
		// die();
		//add exo
		if($this->session->userdata('cei') == 6503){
			 
			$this->add_exo();
			
		}
		
		
	
	/*
		$this->db->select('branch_last_or_number');
		$this->db->where('branch_id', $this->session->userdata('user_branch_id'));
		$query = $this->db->get('branches');
		
		$or = $query->row();
	*/	
	//	$ornum = $or->branch_last_or_number;
		
		$branch = $this->branches_model->get($this->session->userdata('user_branch_id'));
		if (($branch->or_printing == 1) && ($reservation_fee > 0))
		{
			$newor = $this->branches_model->get_last_or_number($this->session->userdata('user_branch_id'));
		}
		else 
		{
			$newor = '';
		}
		
		// update transactions table
		$fields = array(
			'transaction_receipt_number'		=> str_pad($newor, 6, 0, STR_PAD_LEFT),
			'transaction_date'					=> date("Y-m-d H:i:s"),
			'transaction_user_id '				=> $this->session->userdata('user_id'),
			'transaction_customer_id'			=> $customer_id,
			'transaction_branch_id '			=> $this->session->userdata('user_branch_id'),
			'transaction_terminal_id '			=> $this->session->userdata('user_terminal_id'),
			'transaction_cash_change'			=> $this->_prep_amount($this->input->post('total_change')),
			'transaction_status'				=> 'paid',			
		);
		$this->db->where('transaction_id', $transaction_id);
		$this->db->update($this->transactions, $fields);
		
		// update the tickets table
		$fields = array(
			'ticket_user_id '					=> $this->session->userdata('user_id'),
			'ticket_branch_id '					=> $this->session->userdata('user_branch_id'),
			'ticket_terminal_id '				=> $this->session->userdata('user_terminal_id'),
			'ticket_status'						=> 'paid',			
		);
		
		$this->db->where_in('ticket_status', array('selected', 'reserved'));
		$this->db->where('ticket_transaction_id', $transaction_id);
		$this->db->update($this->tickets, $fields);
		
		// get payment types
		$payment_types = $this->payment_types_model->get_payment_types();
		$payment_types = array('cash', 'eplus', 'credit_card_1', 'credit_card_2', 'debit_card', 'gift_check', 'reward_card', 'account');
		
		 
		
		// add the payment
		foreach ($payment_types as $payment_type)
		{
			if ($this->input->post('transaction_payment_'.$payment_type))
			{
			
			
				if($payment_type == 'cash'){
					$type = 1;
				}elseif($payment_type == 'eplus'){
					$type = 36;  
				}else{
					$type = $this->input->post('transaction_'.$payment_type); 
				}
				
				
				/* $fields = array(
					'payment_transaction_id'	=> $transaction_id,
					'payment_payment_type_id'	=> $type,
					'payment_amount'			=> $this->_prep_amount($this->input->post('transaction_payment_'.$payment_type)),
				);

				// insert to db
				$this->db->set($fields);
				$this->db->insert('payments'); */
				
				$this->insert_payment($transaction_id, $type, $this->_prep_amount($this->input->post('transaction_payment_'.$payment_type)), $upgrade_code);	
			}
		}

		//discount ID
		$ticket = $this->session->userdata('ticket_senior');
		$count = $this->session->userdata('tix_count');
		$senior = $this->session->userdata('senior');
		$seniorLName = $this->session->userdata('seniorLName');
		$seniorFName = $this->session->userdata('seniorFName');
		$seniorBdate = $this->session->userdata('seniorBdate');
 
		$p_count = $this->session->userdata('p_count');
		$pcode = $this->session->userdata('pcode');
		
		for ($i = 0; $i < $count; $i++)
		{
 			  
			//add to seniors table
			if($senior[$i]){
				$fields2['senior_ticket_id'] = $ticket[$i];   
				$fields2['senior_event_id'] = $this->session->userdata('cei');   
				$fields2['senior_id'] = $senior[$i];  
				$fields2['senior_lname'] = $seniorLName[$i];   
				$fields2['senior_fname'] = $seniorFName[$i];   
				$fields2['senior_bdate'] = $seniorBdate[$i];   
				$this->db->insert('senior_transactions', $fields2);
				
				
				unset($ticket[$i]);
			}
		}
		
		$ticket = array_values($ticket);
		
 
		
		//add to qrcode table
		for ($i = 0; $i < $p_count; $i++)
		{
 			  
 			 if($pcode[$i] && $this->session->userdata('cei') != 3731){
				$fields3['qr_ticket_id'] = $ticket[$i];   
				$fields3['qr_transaction_id'] = $transaction_id;
				$this->db->where('qr_event_id', $this->session->userdata('cei'));   


				$this->db->where('qr_qrcode',$pcode[$i]);
				$this->db->update('qrcode', $fields3);
				 
			}
		}
		
		
		$this->session->unset_userdata('senior');
		$this->session->unset_userdata('seniorLName');
		$this->session->unset_userdata('seniorFName');
		$this->session->unset_userdata('seniorBdate');  
		$this->session->unset_userdata('tix_count');
		$this->session->unset_userdata('ticket_senior');
		 
		$this->session->unset_userdata('p_count');
		$this->session->unset_userdata('pcode');
		
		
		//for reservation charge
		$charge_amount = $reservation_fee * $this->session->userdata('tix_qty');
		if ($charge_amount > 0) {
			$charges_fields = array(
				'charge_datetime'					=> date("Y-m-d H:i:s"),
				'charge_transaction_id'				=> $transaction_id,
				'charge_amount'						=> $charge_amount,
				'charge_ticket_count'				=> $this->session->userdata('tix_qty'),
				'charge_type'						=> 'reserve',
			);
			
			$this->db->set($charges_fields);
			$this->db->insert('charges');
		}
		return $transaction_id;
	}
	
	function get_tickets_to_void($transaction_id)
	{
		$this->db->select('ti.*, tr.*, p.*, tt.ticket_type_discount_type, tt.ticket_type_discount, tt.ticket_type_name, tt.ticket_type_code, s.section_id, s.section_name, s.section_type, s.section_code');
		$this->db->where('ti.ticket_transaction_id', $transaction_id);	
		$this->db->where_in('ti.ticket_status', array('reserved','done','selected','paid','paid_online'));
		$this->db->join($this->sections, 's.section_id = ti.ticket_section_id', 'left');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left');
		$this->db->join($this->prices, 'p.price_id = ti.ticket_price_id', 'left');
		$this->db->join($this->transactions, 'tr.transaction_id = ti.ticket_transaction_id', 'left');
		$this->db->orderby('ti.ticket_system_row', 'asc');
		$this->db->orderby('ti.ticket_seat + 0', 'asc');
		$query = $this->db->get($this->tickets);
		
		return $query->result();
	}
	
		/**
	 * get_payment_types
	 *
	 * @access	public
	 */
 	function get_trans_payments($transaction_id){
		$this->db->where('payment_transaction_id', $transaction_id);
		$this->db->join($this->payment_types, 'payment_payment_type_id=payment_type_id','left');
		$this->db->join('transactions', 'transaction_id=payment_transaction_id','left');
		$this->db->order_by('payment_type_id', 'asc');
		$query = $this->db->get($this->payments);
		
		return $query->result();
	}	
	
	function get_upgrade_codes($searchkey=array(),$offset=false, $limit=false)
	{
		// $this->db->select('u.*');
		// $this->db->join('user_sessions us','us.user_id = u.user_id','left');
		if ($limit) $this->db->limit($limit);
		if ($offset) $this->db->offset($offset);

		if (! empty($searchkey) )
		{
			foreach ($searchkey as $key=>$value)
			{
				if ($value)
				switch ($key)
				{
					case 'voided_payment_code':
					//	$this->db->like('CONCAT(customer_lastname,customer_firstname)', $value);
						break;
					default:
  						$this->db->like($key, $value);
						break;
				}
			}
		}

		$this->db->order_by('voided_date','desc');
		$this->db->group_by('voided_payment_code');
		$query = $this->db->get('upgrade_payments');
		
		return $query->result();
	}
	
	function copy_voided_tickets($ticket_ids = false ,$user_id = false ,$branch_id = false , $status = false)
	{
		
		if(!$ticket_ids) return false;
		if(!$user_id) return false;
		if(!$branch_id) return false;
		if(!$status) return false;
		// $ticket_ids_ = $ticket_ids.'asad';
		// $tickets =  substr($ticket_ids, 0, -1);
		$checked = explode(",",$ticket_ids);
		//get last sync 
		// $last_sync =$this->_get_last_sync('historical_tickets');
		// echo $last_sync;
		// die();
		// copy the event
		$sql = "insert into historical_tickets(
 				ticket_id,
 				ticket_date_entered,
 				ticket_transaction_id,
 				ticket_session_id,
 				ticket_event_id,
 				ticket_section_id,
 				ticket_type_id,
 				ticket_price_id,
 				ticket_system_row,
 				ticket_system_col,
 				ticket_row,
 				ticket_seat,
 				ticket_reservation_expiry,
 				ticket_acknowledgment_receipt,
 				ticket_date_printed,
 				ticket_date_cancelled,
 				ticket_date_reserved,
 				ticket_date_refunded,
 				ticket_status,
 				ticket_user_id,
 				ticket_branch_id,
 				ticket_terminal_id,
 				ticket_barcode 
			) 

 

			select
				ticket_id,
 				?,
 				ticket_transaction_id,
 				ticket_session_id,
 				ticket_event_id,
 				ticket_section_id,
 				ticket_type_id,
 				ticket_price_id,
 				ticket_system_row,
 				ticket_system_col,
 				ticket_row,
 				ticket_seat,
 				ticket_reservation_expiry,
 				ticket_acknowledgment_receipt,
 				?,
 				ticket_date_cancelled,
 				ticket_date_reserved,
 				ticket_date_refunded,
 				?,
				?,
				?,
				ticket_terminal_id,
 				ticket_barcode 
				
				
			from tickets t
			where t.ticket_id in (".implode(',', $checked).")
			"; 
			
		$this->db->query($sql, array(date("Y-m-d H:i:s"),date("Y-m-d H:i:s"), $status , $user_id, $branch_id));
		
		// $new_event_id = $this->db->insert_id();
		
		// return $new_event_id;
	}
	
	function get_internet_sales_charge($event_id){
			$this->db->select('event_internet_sales_charge');
			$this->db->where('event_id', $event_id);
			$query = $this->db->get('events');
			return $event_internet_sales_charge = $query->row()->event_internet_sales_charge;
	}
	
	function get_branch_filter_reservation($event_id = false){
		$this->db->select('event_branch_filter_reservation');
		$this->db->where('events_config_eventid', $event_id);
		
		$query = $this->db->get('events_config');
		$row = $query->row();
		
		if(isset($row->event_branch_filter_reservation)){
			$event_branch_filter_reservation = $row->event_branch_filter_reservation;
			return $event_branch_filter_reservation;
		}else{
			return "";
		}
	
		
		// return $query->row()->event_branch_filter_reservation;
	}
	
}



// END reservations_model.php
/* Location: ./application/models/reservations_model.php */	
