<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Transactions_model extends CI_Model
{
	var $transactions = 'transactions t';
	var $tickets = 'tickets ti';
	var $customers = 'customers c';
	var $terminals = 'terminals te';
	var $branches = 'branches b';
	var $users = 'users u';
	var $events = 'events e';
	var $sections = 'sections s';
	var $prices = 'prices p';

	var $arrTListStat = array(); // status filter for TRANSACTION LISTING
	var $arrEventTListStat = array('reserved','unselected'); // status filter for EVENT TRANSACTION LISTING
	var $arrTicketStat = array('done','paid','selected','paid_online');
	// using constructor function, get value of $arrEventTlistStat to make filter for transaction listing the same

	public function __construct()
	{
		parent::__construct();
		$this->load->model('payment_types_model', 'payment_types_model');
		$this->load->model('branches_model', 'branches_model');
		$this->load->model('admin_model', 'admin');
		
		// same filter array. no reserve for display of TRANSACTION LISTING
		$this->arrTListStat = $this->arrEventTListStat;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get
	 *
	 * @access	public
	 */
	function get($transaction_id)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->join($this->terminals, 't.transaction_terminal_id = te.terminal_id');
		$this->db->join($this->branches, 't.transaction_branch_id = b.branch_id');
		$this->db->join($this->users, 't.transaction_user_id = u.user_id');
		$this->db->join($this->customers, 't.transaction_customer_id = c.customer_id', 'left');
 		//$this->db->join($this->tickets, 't.transaction_id = ti.ticket_transaction_id', 'left');
		//$this->db->join($this->events, 'ti.ticket_event_id = e.event_id', 'left');
		$this->db->where('transaction_id', $transaction_id);
		$query = $this->db->get($this->transactions);
	
		return $query->row();		
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_last_record
	 *
	 * @access	public
	 */
	function get_last_record()
	{
		
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->select_max('transaction_id');
		$this->db->where('transaction_status', 'done');
		$query = $this->db->get($this->transactions);
		$row = $query->row();
		return $row->transaction_id;
	}
	
	
	// --------------------------------------------------------------------
	
	/**
	 * get_transactions
	 *
	 * @access	public
	 */
	function get_transactions()
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->where('lower(transaction_status)', strtolower('done'));
		$this->db->like('c.customer_mobile', $this->input->post('mobile')); 
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left');
		$this->db->order_by('t.transaction_id', 'desc');
		//$this->db->join($this->tickets, 't.transaction_id = ti.ticket_transaction_id', 'left');
		$query = $this->db->get($this->transactions);
		
		return $query->result();
	}
		
		
	// --------------------------------------------------------------------
	
	/**
	 * get_terminal_transactions
	 *
	 * @access	public
	 */
	function get_terminal_transactions($transid, $name, $mobno, $offset = false, $limit = false)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		if(!empty($transid) || !empty($name) || !empty($mobno))
		{
			if(!empty($transid))
			{
				$this->db->where('t.transaction_id', $transid);
			}
			if (!empty($name))
			{
				$this->db->like('CONCAT(c.customer_firstname, " ", c.customer_lastname)', $name);
			}
			if (!empty($mobno))
			{
				$this->db->where('c.customer_mobile', $mobno);
			}
		}
		else
		{	
			if ($this->session->userdata('user_branch_id') != 1)
			{	
				$this->db->where('t.transaction_branch_id', $this->session->userdata('user_branch_id'));
			}
		}
		
		//$this->db->where('lower(transaction_status)', strtolower('done'));
		$this->db->select('
				t.transaction_id
				, t.transaction_date
				, t.transaction_branch_id
				, t.transaction_status
				, ti.ticket_branch_id
				, ti.ticket_event_id
				, c.customer_lastname
				, c.customer_firstname
				, c.customer_mobile
				, GROUP_CONCAT(DISTINCT ti.ticket_status) concat_tixstatus
				, COUNT(ti.ticket_id) count_ticket_id
 				, s.section_name
				, p.price_name
				, e.event_long_title
				, e.event_postponed_date
			');
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left');
		$this->db->join($this->tickets, 't.transaction_id = ti.ticket_transaction_id', 'left');
		$this->db->join($this->sections, 's.section_id = ti.ticket_section_id', 'left');
		$this->db->join($this->prices, 'p.price_id = ti.ticket_price_id', 'left');
		$this->db->join($this->events, 'e.event_id = ti.ticket_event_id', 'left');
		// $this->db->join('module_types mt', 'mt.module_type_transaction_id = t.transaction_id', 'left');
		$this->db->group_by('t.transaction_id');
		$this->db->order_by('t.transaction_id', 'desc');
		$this->db->where_not_in('t.transaction_status', $this->arrTListStat);
		// $this->db->where_in('ti.ticket_status', $this->arrTicketStat);

		if ($limit) $this->db->limit($limit);
		if ($offset) $this->db->offset($offset);
		$query = $this->db->get($this->transactions);
		return $query->result();
	}
	
	// --------------------------------------------------------------------
	
	function get_terminal_transactions_allcount($transid, $name, $mobno)
	{
		$this->db->select('t.transaction_id');
		if(!empty($transid) || !empty($name) || !empty($mobno))
		{
			if(!empty($transid))
			{
				$this->db->where('transaction_id', $transid);
			}
			if (!empty($name))
			{
				$this->db->like('CONCAT(customer_lastname,customer_firstname)', $name);
			}
			if (!empty($mobno))
			{
				$this->db->where('customer_mobile', $mobno);
			}
		}
		else
		{	
			if ($this->session->userdata('user_branch_id') != 1)
			{	
				$this->db->where('transaction_branch_id', $this->session->userdata('user_branch_id'));
			}
		}

		$this->db->select('
				t.transaction_id
				, t.transaction_date
				, t.transaction_branch_id
				, t.transaction_status
				, ti.ticket_branch_id
				, c.customer_lastname
				, c.customer_firstname
				, c.customer_mobile
			');
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left');
		$this->db->join($this->tickets, 't.transaction_id = ti.ticket_transaction_id', 'left');
		$this->db->group_by('ti.ticket_transaction_id');
		$this->db->order_by('t.transaction_id', 'desc');
		$this->db->where_not_in('t.transaction_status', $this->arrTListStat);

		$query = $this->db->get($this->transactions);
		return $result = $query->num_rows();

	}
	
	function get_terminal_transactions_allcount_alt($transid, $name, $mobno)
	{
		
		$this->db->query('set transaction isolation level read uncommitted');
		if(!empty($transid) || !empty($name) || !empty($mobno))
		{
			if(!empty($transid))
			{
				$this->db->where('transaction_id', $transid);
			}
			if (!empty($name))
			{
				$this->db->like('CONCAT(customer_lastname,customer_firstname)', $name);
			}
			if (!empty($mobno))
			{
				$this->db->where('customer_mobile', $mobno);
			}
		}
		else
		{	
			if ($this->session->userdata('user_branch_id') != 1)
			{	
				$this->db->where('transaction_branch_id', $this->session->userdata('user_branch_id'));
			}
		}

		$this->db->select('count(DISTINCT t.transaction_id) AS count_id'); 
		
		if (!empty($name)  ||  !empty($mobno)){
			$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left');
		}
		
		// $this->db->join($this->tickets, 't.transaction_id = ti.ticket_transaction_id', 'left');
		// $this->db->group_by('ti.ticket_transaction_id');
		// $this->db->order_by('t.transaction_id', 'desc');
		$this->db->where_not_in('t.transaction_status', $this->arrTListStat);
		
		$query = $this->db->get($this->transactions);
		$counter = 0;
		foreach($query->result() as $row) {
			$counter = $row->count_id;
		}
		return $counter;

	}
	
	/**
	 * get_terminal_transaction_count
	 *
	 * @access	public
	 */
	function get_terminal_transaction_count($searchkey=array(),$offset = false, $limit = false)
	{
		$this->db->select('count(*) as transaction_count');
		if (!in_array($this->session->userdata('user_type'), array('Admin','Super Admin','Admin2')))
		{
			$this->db->where('transaction_terminal_id', $this->session->userdata('user_terminal_id'));
			$this->db->where('transaction_branch_id', $this->session->userdata('user_branch_id'));
		}
		
		$this->db->where('lower(transaction_status)', strtolower('done'));
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left');

		if (! empty($searchkey) )
		{
			foreach ($searchkey as $key=>$value)
			{
				switch ($key)
				{
					case 'name':
						$this->db->like('CONCAT(customer_lastname,customer_firstname)', $value);
						break;
					default:
  					$this->db->like($key, $value);
						break;
				}
			}
		}
		
		$query = $this->db->get($this->transactions);
		
		$result = $query->row();
		
		return $result->transaction_count;
	}
	
	
	// --------------------------------------------------------------------

	/**
	 * get_event_transactions
	 *
	 * @access	public
	 */
	function get_event_transactions($event_id)
	{
		$this->db->select('count( * ) AS cnt, t.* ,c.*, ti.ticket_branch_id');
		$this->db->where('ticket_event_id', $event_id);
		$this->db->join( $this->tickets, 'ticket_transaction_id = transaction_id','left');
		$this->db->join( $this->customers, 'transaction_customer_id=customer_id','left');
		$this->db->group_by('transaction_id');
		$this->db->order_by('transaction_id', 'DESC');
		
		$query = $this->db->get( $this->transactions );
		return $query->result();
	}
	
	function get_event_transactions_rev($event_id, $searchkey)
	{
		if(count($searchkey) > 0) {
			foreach($searchkey as $key=>$val) 
			{
				if(($key == 'name') && !empty($val))
				{
					$this->db->like('CONCAT(c.customer_lastname, " ", c.customer_firstname)', $val);
				}
				if(($key == 'customer_mobile') && !empty($val))
				{
					$this->db->where('c.customer_mobile', $val);
				}
			}
		}
		
		
		$this->db->query('set transaction isolation level read uncommitted');
		//$this->db->where('lower(transaction_status)', strtolower('done'));
		$this->db->select('
				t.transaction_id
				, t.transaction_date
				, t.transaction_branch_id
				, t.transaction_status
				, ti.ticket_branch_id
				, c.customer_lastname
				, c.customer_firstname
				, c.customer_mobile
				, s.section_name
				, count(ti.ticket_id) as count_ticket_id
				, GROUP_CONCAT(DISTINCT ti.ticket_status) concat_tixstatus
			');
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left');
		$this->db->join($this->tickets, 't.transaction_id = ti.ticket_transaction_id', 'left');
		$this->db->join($this->sections, 's.section_id = ti.ticket_section_id', 'left');

		$this->db->where('ticket_event_id', $event_id);
		$this->db->group_by('t.transaction_id');
		$this->db->order_by('t.transaction_id', 'desc');
		$this->db->where_not_in('t.transaction_status', $this->arrEventTListStat); 
		// $this->db->limit(20);
		
		$query = $this->db->get($this->transactions);
		return $query->result();
	}
	
	// --------------------------------------------------------------------
	// --------------------------------------------------------------------
	
	/**
	 * get_by_barcode
	 *
	 * @access	public
	 */
	function get_by_barcode($barcode)
	{
		// $this->db->select('t.*, (select count(*) from tickets where ticket_transaction_id = transaction_id and ticket_status = "paid_online") as ticket_count');
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('t.*, count(tix.ticket_id) as ticket_count, max(tix.ticket_event_id) as ticket_event_id , cu.customer_block as blocked, card_number_value as card_num, card_number_expiration as expiration');
		
		$this->db->join('tickets tix', 't.transaction_id = tix.ticket_transaction_id', 'LEFT');
		$this->db->join('customers cu', 'cu.customer_id = t.transaction_customer_id', 'LEFT');
		$this->db->join('card_numbers cn', 'cn.card_number_transaction_id = t.transaction_id', 'LEFT');
		$this->db->where('t.transaction_barcode', $barcode);
		$this->db->where('t.transaction_status', 'paid_online');	
		$this->db->where('tix.ticket_status', 'paid_online');	
		$this->db->where('tix.ticket_event_id !=', '5803');	
		$this->db->where('tix.ticket_event_id !=', '7788');	//ytff		
		// $this->db->where('cu.customer_block !=', 1);
		$this->db->group_by('t.transaction_id');
		$query = $this->db->get($this->transactions);

		return $query->result();
	}
	
	function get_by_barcode_ticket_breakdown($barcode)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		// $this->db->select('t.*, (select count(*) from tickets where ticket_transaction_id = transaction_id and ticket_status = "paid_online") as ticket_count');
		$this->db->join('tickets tix', 't.transaction_id = tix.ticket_transaction_id', 'LEFT');
		$this->db->where('t.transaction_barcode', $barcode);
		$this->db->where('tix.ticket_status', 'done');	
		$this->db->where('tix.ticket_event_id !=', '5803');	
		$this->db->where('tix.ticket_event_id !=', '7788');	 //ytff		
		// $this->db->where('t.transaction_status', 'paid_online');
		$query = $this->db->get('transactions t');

		return $query->result();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * add
	 *
	 */
	function add($customer_id)
	{
		//$or = $this->branches->get_last_or_number($this->session->userdata('user_branch_id'));
		//add exo
		if($this->session->userdata('cei') == 6503){
			 
			$this->add_exo();
			
		}
		
		
		$transaction_cc_reference = implode("|", array_filter(	$this->input->post("cc_refno")	)	);
		
		if($this->session->userdata('valid_date')){
			$v_date = $this->session->userdata('valid_date');
		}else{
			$v_date = NULL;
		}
		
		
		// add to transactions table
		$fields = array(
			'transaction_date'					=> date("Y-m-d H:i:s"),
			'transaction_date_validity'			=> $v_date,
			'transaction_user_id'				=> $this->session->userdata('user_id'),
			'transaction_customer_id'			=> $customer_id,
			'transaction_branch_id'				=> $this->session->userdata('user_branch_id'),
			'transaction_terminal_id'			=> $this->session->userdata('user_terminal_id'),
			'transaction_cash_change'			=> $this->_prep_amount($this->input->post('total_change')),
			'transaction_status'				=> 'paid',
			'transaction_cc_ref'				=> $transaction_cc_reference,
		);
		
		// insert to db
		$this->db->set($fields);
		$this->db->insert('transactions');
		
		// get transaction id
		// $transaction_id = $this->db->insert_id(); << this function sometimes returns 0.  do not use this anymore
		// got this solution from http://codeigniter.com/forums/viewthread/60170/
		$query = $this->db->query('SELECT LAST_INSERT_ID()');
		$row = $query->row_array();
		$transaction_id = $row['LAST_INSERT_ID()'];

		// check if it's the correct transaction
		$transaction = $this->get($transaction_id);
		if ($transaction->transaction_customer_id != $customer_id or $transaction->terminal_id != $this->session->userdata('user_terminal_id'))
		{
			return false;
		}
		
		// update tickets table, include the transaction id
		$this->db->where('ticket_status', 'selected');
		$this->db->where('ticket_session_id', $this->session->userdata('customer_session_id'));
		$this->db->update($this->tickets, array('ticket_transaction_id' => $transaction_id, 'ticket_status' => 'paid'));
		
		// get payment types
		$payment_types = $this->payment_types_model->get_payment_types();
		$payment_types = array('cash','eplus', 'credit_card_1', 'credit_card_2', 'debit_card', 'gift_check', 'reward_card', 'account', 'globe_reward_card');
		
		// add the payment
		foreach ($payment_types as $payment_type)
		{		
			if ($this->input->post('transaction_payment_'.$payment_type)){
				if($payment_type == 'globe_reward_card'){
					$type = 54;  
					$i = 0;
					foreach(	$this->input->post('transaction_payment_'.$payment_type)	as  $globe_payment_type){
						if($globe_payment_type){
						$this->insert_payment($transaction_id,	$type,	$this->_prep_amount(	$globe_payment_type)	);
							$codes_array = $this->input->post('globe_rewards');
							$gc_code = $codes_array[$i];
						$this->mark_as_used_gc($gc_code,"globe",$transaction_id);
						}
						$i = $i + 1;
					}
				}else{
					
					if($payment_type == 'cash'){
						$type = 1;
					}elseif($payment_type == 'eplus'){
						$type = 36;  
					}else{
						$type = $this->input->post('transaction_'.$payment_type); 
					}
					$this->insert_payment($transaction_id, $type, $this->_prep_amount($this->input->post('transaction_payment_'.$payment_type)));	
				}	
			}
		}
		
		 
		$ticket = $this->session->userdata('ticket_senior');
		$count = $this->session->userdata('tix_count');
		$senior = $this->session->userdata('senior');
		$seniorLName = $this->session->userdata('seniorLName');
		$seniorFName = $this->session->userdata('seniorFName');
		$seniorBdate = $this->session->userdata('seniorBdate');
 
		$p_count = $this->session->userdata('p_count');
		$pcode = $this->session->userdata('pcode');
 
	
		
		for ($i = 0; $i < $count; $i++)
		{
 			  
			//add to seniors table
			if($senior[$i]){
				$fields2['senior_ticket_id'] = $ticket[$i];   
				$fields2['senior_event_id'] = $this->session->userdata('cei');   
				$fields2['senior_id'] = $senior[$i];  
				$fields2['senior_lname'] = $seniorLName[$i];   
				$fields2['senior_fname'] = $seniorFName[$i];   
				$fields2['senior_bdate'] = $seniorBdate[$i];   
				$this->db->insert('senior_transactions', $fields2);
				
				unset($ticket[$i]);
				
			}
		}
		
		
		$ticket = array_values($ticket);
		
 
		
		//add to qrcode table
		for ($i = 0; $i < $p_count; $i++)
		{
 			  
 			if($pcode[$i] && $this->session->userdata('cei') != 3731){
				$fields3['qr_ticket_id'] = $ticket[$i];   
				$fields3['qr_transaction_id'] = $transaction_id;
				$this->db->where('qr_event_id', $this->session->userdata('cei'));   


				$this->db->where('qr_qrcode',$pcode[$i]);
				$this->db->where('qr_type',1);
				$this->db->update('qrcode', $fields3);
				 
				 
				//tag pin 
				$data2 = array(
				'trans_id' => $transaction_id, 
				'promo_code' =>  $pcode[$i],
				);
				$this->db->insert('qrcode_tracking', $data2); 	
				
			}
		}
		
		 
		
		
		
		
		$this->session->unset_userdata('senior');
		$this->session->unset_userdata('seniorLName');
		$this->session->unset_userdata('seniorFName');
		$this->session->unset_userdata('seniorBdate');
		$this->session->unset_userdata('tix_count');
		$this->session->unset_userdata('ticket_senior');
		
		
		$this->session->unset_userdata('p_count');
		$this->session->unset_userdata('pcode');

		return $transaction_id;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * update
	 *
	 */
	function update($transaction_id, $reservation_fee = 0, $customer_id = false)
	{
	
		// echo '<pre>';
		// print_r($_POST);
		// echo '</pre>';
		// die();
		//add exo
		if($this->session->userdata('cei') == 6503){
			 
			$this->add_exo();
			
		}
		
		
	
	/*
		$this->db->select('branch_last_or_number');
		$this->db->where('branch_id', $this->session->userdata('user_branch_id'));
		$query = $this->db->get('branches');
		
		$or = $query->row();
	*/	
	//	$ornum = $or->branch_last_or_number;
		
		$branch = $this->branches_model->get($this->session->userdata('user_branch_id'));
		if (($branch->or_printing == 1) && ($reservation_fee > 0))
		{
			$newor = $this->branches_model->get_last_or_number($this->session->userdata('user_branch_id'));
		}
		else 
		{
			$newor = '';
		}
		
		// update transactions table
		$fields = array(
			'transaction_receipt_number'		=> str_pad($newor, 6, 0, STR_PAD_LEFT),
			'transaction_date'					=> date("Y-m-d H:i:s"),
			'transaction_user_id '				=> $this->session->userdata('user_id'),
			'transaction_customer_id'			=> $customer_id,
			'transaction_branch_id '			=> $this->session->userdata('user_branch_id'),
			'transaction_terminal_id '			=> $this->session->userdata('user_terminal_id'),
			'transaction_cash_change'			=> $this->_prep_amount($this->input->post('total_change')),
			'transaction_status'				=> 'paid',			
		);
		$this->db->where('transaction_id', $transaction_id);
		$this->db->update($this->transactions, $fields);
		
		// update the tickets table
		$fields = array(
			'ticket_user_id '					=> $this->session->userdata('user_id'),
			'ticket_branch_id '					=> $this->session->userdata('user_branch_id'),
			'ticket_terminal_id '				=> $this->session->userdata('user_terminal_id'),
			'ticket_status'						=> 'paid',			
		);
		
		$this->db->where_in('ticket_status', array('selected', 'reserved'));
		$this->db->where('ticket_transaction_id', $transaction_id);
		$this->db->update($this->tickets, $fields);
		
		// get payment types
		$payment_types = $this->payment_types_model->get_payment_types();
		$payment_types = array('cash', 'eplus', 'credit_card_1', 'credit_card_2', 'debit_card', 'gift_check', 'reward_card', 'account');
		
		 
		
		// add the payment
		foreach ($payment_types as $payment_type)
		{
			if ($this->input->post('transaction_payment_'.$payment_type))
			{
			
			
				if($payment_type == 'cash'){
					$type = 1;
				}elseif($payment_type == 'eplus'){
					$type = 36;  
				}else{
					$type = $this->input->post('transaction_'.$payment_type); 
				}
				
				
				$fields = array(
					'payment_transaction_id'	=> $transaction_id,
					'payment_payment_type_id'	=> $type,
					'payment_amount'			=> $this->_prep_amount($this->input->post('transaction_payment_'.$payment_type)),
					'date_modified'				=> date("Y-m-d H:i:s"),
				);

				// insert to db
				$this->db->set($fields);
				$this->db->insert('payments');
			}
		}

		//discount ID
		$ticket = $this->session->userdata('ticket_senior');
		$count = $this->session->userdata('tix_count');
		$senior = $this->session->userdata('senior');
		$seniorLName = $this->session->userdata('seniorLName');
		$seniorFName = $this->session->userdata('seniorFName');
		$seniorBdate = $this->session->userdata('seniorBdate');
 
		$p_count = $this->session->userdata('p_count');
		$pcode = $this->session->userdata('pcode');
		
		for ($i = 0; $i < $count; $i++)
		{
 			  
			//add to seniors table
			if($senior[$i]){
				$fields2['senior_ticket_id'] = $ticket[$i];   
				$fields2['senior_event_id'] = $this->session->userdata('cei');   
				$fields2['senior_id'] = $senior[$i];  
				$fields2['senior_lname'] = $seniorLName[$i];   
				$fields2['senior_fname'] = $seniorFName[$i];   
				$fields2['senior_bdate'] = $seniorBdate[$i];   
				$this->db->insert('senior_transactions', $fields2);
				
				
				unset($ticket[$i]);
			}
		}
		
		$ticket = array_values($ticket);
		
 
		
		//add to qrcode table
		for ($i = 0; $i < $p_count; $i++)
		{
 			  
 			 if($pcode[$i] && $this->session->userdata('cei') != 3731){
				$fields3['qr_ticket_id'] = $ticket[$i];   
				$fields3['qr_transaction_id'] = $transaction_id;
				$this->db->where('qr_event_id', $this->session->userdata('cei'));   


				$this->db->where('qr_qrcode',$pcode[$i]);
				$this->db->where('qr_type',1);
				$this->db->update('qrcode', $fields3);
				
				
				//tag pin 
				$data2 = array(
				'trans_id' => $transaction_id, 
				'promo_code' =>  $pcode[$i],
				);
				$this->db->insert('qrcode_tracking', $data2); 	
				 
				 
			}
		}
		
		
		$this->session->unset_userdata('senior');
		$this->session->unset_userdata('seniorLName');
		$this->session->unset_userdata('seniorFName');
		$this->session->unset_userdata('seniorBdate');  
		$this->session->unset_userdata('tix_count');
		$this->session->unset_userdata('ticket_senior');
		 
		$this->session->unset_userdata('p_count');
		$this->session->unset_userdata('pcode');
		
		
		//for reservation charge
		$charge_amount = $reservation_fee * $this->session->userdata('tix_qty');
		if ($charge_amount > 0) {
			$charges_fields = array(
				'charge_datetime'					=> date("Y-m-d H:i:s"),
				'charge_transaction_id'				=> $transaction_id,
				'charge_amount'						=> $charge_amount,
				'charge_ticket_count'				=> $this->session->userdata('tix_qty'),
				'charge_type'						=> 'reserve',
				'date_modified'						=> date("Y-m-d H:i:s"),
			);
			
			$this->db->set($charges_fields);
			$this->db->insert('charges');
		}
		return $transaction_id;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * transaction_done
	 *
	 */
	function transaction_done($transaction_id)
	{
	    
		// update the transactions table
		$this->db->where('transaction_id', $transaction_id);
		$this->db->update($this->transactions, array('transaction_status' =>'done'));
		
		// update the tickets table		
		$changes = array(
			'ticket_user_id '		=> $this->session->userdata('user_id'),
			'ticket_branch_id '		=> $this->session->userdata('user_branch_id'),
			'ticket_terminal_id '	=> $this->session->userdata('user_terminal_id'),
			'ticket_status'			=> 'done',
			'ticket_date_printed'	=> date('Y-m-d H:i:s'),
		);
		
		// update the status of the tickets
		$this->db->where_in('ticket_status', array('paid', 'paid_online'));
		$this->db->where('ticket_transaction_id', $transaction_id);
		$this->db->update($this->tickets, $changes);
		
		return true;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * update_receipt_number
	 *
	 */
	function update_receipt_number($transaction_id, $receipt_number)
	{
		// update the transactions table
		$this->db->where('transaction_id', $transaction_id);
		$this->db->update($this->transactions, array('transaction_receipt_number' => $receipt_number));
		
		return true;
	}

	// --------------------------------------------------------------------
	
	/**
	 * void
	 *
	 */
	function void($transaction_id)
	{
		// get the section id first
		$this->db->select('ticket_section_id');
		$this->db->where('ticket_transaction_id', $transaction_id);
		$this->db->limit(1);
		$query = $this->db->get($this->tickets);
		$section = $query->row();
				
		
		$this->db->where('ticket_transaction_id', $transaction_id);
		$this->db->where('ticket_status', 'paid');
		$counts = $this->db->count_all_results('tickets');
		
		if($counts >= 0 )
		{
			$fields = array(
				'transaction_comment'	=> $this->input->post('transaction_comment'),
			);
		}
		else
		{
			$fields = array(
				'transaction_status'	=> 'voided',
				'transaction_comment'	=> $this->input->post('transaction_comment'),
				'transaction_details'	=> 'void transaction',
				'transaction_type'		=> 'void transaction',
			);
		}
			// update transactions table
			$this->db->where('transaction_id', $transaction_id);
			$this->db->update($this->transactions, $fields);
		
		$checked = $this->input->post('tickets_');
		foreach($checked as $tickets_id => $value)
		{
			// update tickets table
			$this->db->where('ticket_id', $tickets_id);
			$this->db->update($this->tickets, array('ticket_status' => 'voided'));
		}
		$ticket_count = $this->db->affected_rows();
		
		$this->add_voided_details($transaction_id);
		
		$this->void_payment($_POST,$transaction_id);	 
		return array($section->ticket_section_id, $ticket_count);
	}	
	
	function refund($transaction_id)
	{
		// get the section id first
		$this->db->select('ticket_section_id');
		$this->db->where('ticket_transaction_id', $transaction_id);
		$this->db->limit(1);
		$query = $this->db->get($this->tickets);
		$section = $query->row();
				
		
		$this->db->where('ticket_transaction_id', $transaction_id);
		$this->db->where('ticket_status', 'paid');
		$counts = $this->db->count_all_results('tickets');
		
		if($counts >= 0 )
		{
			$fields = array(
				'transaction_comment'	=> $this->input->post('transaction_comment'),
			);
		}
		else
		{
			$fields = array(
				'transaction_status'	=> 'voided',
				'transaction_comment'	=> $this->input->post('transaction_comment'),
				'transaction_details'	=> 'void transaction',
				'transaction_type'		=> 'void transaction',
			);
		}
			// update transactions table
			$this->db->where('transaction_id', $transaction_id);
			$this->db->update($this->transactions, $fields);
		
		// $checked = $this->input->post('tickets_');
		// foreach($checked as $tickets_id => $value)
		// {
			// update tickets table
			$this->db->where('ticket_transaction_id', $transaction_id);
			$this->db->update($this->tickets, array('ticket_status' => 'voided', 'ticket_date_refunded' => date('Y-m-d')));
			
		// }
		// echo $this->db->last_query();
		// die();
		$ticket_count = $this->db->affected_rows();
		
		$this->add_voided_details($transaction_id);
		
		$this->void_payment($_POST,$transaction_id);	 
		return array($section->ticket_section_id, $ticket_count);
	}
		
	function void_transaction_only($transaction_id)
	{
		
		if($transaction_id > 0)
		{
			$fields = array(
				'transaction_status'	=> 'voided',
				'transaction_comment'	=> $this->input->post('transaction_comment'),
				'transaction_details'	=> 'void transaction',
				'transaction_type'		=> 'void transaction',
			);
			// update transactions table
			$this->db->where('transaction_id', $transaction_id);
			$this->db->update($this->transactions, $fields);
		}

		return($transaction_id > 0 );
	}	
		
	// --------------------------------------------------------------------
	
	/**
	 * add
	 *
	 */
	function customer_info($customer_id,$reservation_expire)
	{
		
		if($this->session->userdata('valid_date')){
			$v_date = $this->session->userdata('valid_date');
		}else{
			$v_date = NULL;
		}
			
			// add to transactions table
			$fields = array(
				'transaction_date'					=> date("Y-m-d H:i:s"),
				'transaction_date_validity'			=> $v_date,
				'transaction_user_id '				=> $this->session->userdata('user_id'),
				'transaction_customer_id '			=> $customer_id,
				'transaction_branch_id '			=> $this->session->userdata('user_branch_id'),
				'transaction_terminal_id '			=> $this->session->userdata('user_terminal_id'),
				'transaction_comment '				=> $this->input->post('customer_notes'),		
				'transaction_status'				=> 'reserved',
				'transaction_pin'					=> $this->randomKey(4),				
			);			
		
			// insert to db
			$this->db->set($fields);
			$this->db->insert('transactions');
			
			// get transaction id
			$transaction_id = $this->db->insert_id();
			
			// update selected seats in tickets table, include the transaction id
			$this->db->where('ticket_session_id', $this->session->userdata('customer_session_id'));
			$this->db->where('ticket_status', 'selected');
			$this->db->update($this->tickets, array('ticket_transaction_id' => $transaction_id));		
	
			$transaction_code =	sha1( $this->session->userdata('user_branch_id') . "-" . $transaction_id . "-"  . date("md"));
			$this->db->where('transaction_id',	$transaction_id );
			$this->db->update($this->transactions, array('transaction_code' => $transaction_code));	
			
			
			
		/*
			switch($reservation_expire)
			{
				case '1': $extend_date_ = date("Y-m-d", strtotime("+1 days")); break;
				case '2': $extend_date_ = date("Y-m-d", strtotime("+2 days")); break;
				case '3': $extend_date_ = date("Y-m-d", strtotime("+3 days")); break;
				case '4': $extend_date_ = date("Y-m-d", strtotime("+4 days")); break;
				case '5': $extend_date_ = date("Y-m-d", strtotime("+5 days")); break;
				case '6': $extend_date_ = date("Y-m-d", strtotime("+6 days")); break;
				case '7': $extend_date_ = date("Y-m-d", strtotime("+7 days")); break;
				case '8': $extend_date_ = date("Y-m-d", strtotime("+8 days")); break;
				case '9': $extend_date_ = date("Y-m-d", strtotime("+9 days")); break;
				case '10': $extend_date_ = date("Y-m-d", strtotime("+10 days")); break;
			}*/

			$extend_date = date("Y-m-d", strtotime("+$reservation_expire days"));
			
			$fields = array(
				'ticket_reservation_expiry'	=> $extend_date,
				'ticket_status'				=> 'reserved',
			);
						
			//update selected seats in tickets table with ticket_reservation_expiry and reserved status
			$this->db->where('ticket_transaction_id',$transaction_id);
			$this->db->where('ticket_status', 'selected');
			$this->db->update($this->tickets,$fields);
			
			$fields = array(
				'action_reference'			=> $transaction_id,
				'action_reftype'			=> 'transaction',
				'action_user_id'			=> $this->session->userdata('user_id'),
				'action_type'				=> 'reserve',
				'action_source'				=> 'normal',
				'action_datetime'			=> date("Y-m-d H:i:s"),
				'action_remarks'			=> '',
			);
			
			$this->db->set($fields);
			$this->db->insert('action_log');
			
		return $transaction_id;
	}	
	
	
	// --------------------------------------------------------------------
	
	/**
	 * _prep_amount
	 *
	 * @access	private
	 */
	function _prep_amount($str)
	{	
		return str_replace(',', '', $str);
	}	
	
	//---------------------------------------------------------------------
	
	/**
	 * _check_tix_stat
	 * 
	 * @access private
	 */
	
	function _check_tix_stat($session_id = false, $event_id = false, $stat = false, $tix_qty = false)
	{
		$this->db->query('set transaction isolation level read uncommitted');

		$this->db->select("ti.ticket_status");
		$this->db->where('ti.ticket_session_id', $session_id);
		$this->db->where_in('ti.ticket_status', $stat);
		$get_tix_stat = $this->db->get('tickets ti');
		
		/*$get_tix_stat = $this->db->query("
			select
				ti.ticket_status
			from
				tickets ti
			where
				ti.ticket_session_id = ?
			and
				ti.ticket_status in ?
		", array($session_id, $stat));*/
		
		/*echo "Session ID: $session_id <br />";
		echo "Status : $stat <br />";
		echo $get_tix_stat->num_rows();
		echo "<br /> qty $tix_qty";*/
		
		if ($get_tix_stat->num_rows() == $tix_qty)
		{
			return true;
		}
		else 
		{
			 
			$this->session->set_flashdata('message', assemble_error('Transaction corrupted. Please restart transaction from beginning.<br />'));
			redirect("/events/view/$event_id");
		}
	}
	
	//------------------------------------------------------------------------
	/**
	 * _get_num_of_reserved_tix
	 * 
	 * @access private
	 */
	
	function _get_num_of_reserved_tix($trans_id = false)
	{
	
		$this->db->query('set transaction isolation level read uncommitted');
		
		$this->db->select("ti.ticket_status");
		$this->db->where('ti.ticket_transaction_id', $trans_id);
		$this->db->where_in('ti.ticket_status', 'reserved');
		$query = $this->db->get('tickets ti');
		
		return $query->num_rows();
	}

	function add_voided_details($transaction_id = false)
	{
		//$user_id = ($this->session->userdata('user_id')) ? $this->session->userdata('user_id') : '';
		$this->db->select('user_id,user_branch_id');
		$this->db->where('username', $this->input->post('username'));
		$query = $this->db->get('users');
		$result = $query->row();
		$user_id = $result->user_id;
		$branch_id = $result->user_branch_id;
		// $branch_id = ($this->session->userdata('user_branch_id')) ? $this->session->userdata('user_branch_id') : '';
		$ticket_ids = $this->input->post('tickets');
		$transaction_comment = $this->input->post('transaction_comment');
		
		$fields = array(
			'voided_transaction_id'				=> $transaction_id,
			'voided_date'						=> date("Y-m-d H:i:s"),
			'voided_user_id'					=> $user_id,
			'voided_branch_id'					=> $branch_id, 
			'voided_remarks'					=> $transaction_comment, 
			'voided_details'					=> serialize($ticket_ids), 
		);
		
		// insert to db
		$this->db->set($fields);
		$this->db->insert('voided_transactions');
	
		foreach($ticket_ids as $x){
			$fields = array(
			'voided_detail_transaction_id'		=> $transaction_id, 
			'voided_detail_ticket_id'			=> $x, 
			'voided_detail_user_id'				=> $user_id, 
			'voided_detail_branch_id'			=> $branch_id, 
			);
		
		
		
			// echo '<pre>';
			// print_r($ticket_ids);
			// echo '</pre>';
				// die();
			
		
			// for historical asr
			$this->db->set($fields);
			$this->db->insert('voided_transaction_details');
			
		}
	
		//insert into historical table 
		$this->admin->copy_voided_tickets($ticket_ids, $user_id, $branch_id, 'voided');		
		 
 	}

		
			
	function insert_payment($transaction_id,$type,$payment_amount){

	
		$fields = array(
			'payment_transaction_id'	=> $transaction_id,
			'payment_payment_type_id'	=> $type,
			'payment_amount'			=> $payment_amount,
			'date_modified'				=> date("Y-m-d H:i:s"),
		);

		// insert to db
		$this->db->set($fields);
		$this->db->insert('payments');

	}
		
	function mark_as_used_gc($gc_code,$gc_set,$trans_id){
		
		$dbAccess = $this->load->database('pincodes',true);
		
		$data = array(
		'gc_last_date_used' =>  date("Y-m-d H:i:s"),
		'gc_reference_info' => $trans_id,
		'gc_status' => "used",
		);
		
		$dbAccess->where("gc_status",'selected');
		$dbAccess->where("gc_code",$gc_code);
		$dbAccess->update('gift_check_codes', $data); 
		
		
		return $dbAccess->affected_rows();	
	}
	
	
	
	//for add/edit remark wag mo patungan gabion!
	function get_remark($transaction_id = false)
	{
		$this->db->select('transaction_comment , transaction_id');	
  		$this->db->where('transaction_id', $transaction_id); 
		$query = $this->db->get($this->transactions);

		return $query->row();
	}
		
	function update_remarks()
	{
	
		  
		// check first if customer is existing
		$remarks = $this->input->post('remarks');
		$transaction_id = $this->input->post('transaction_id');
		
		$this->db->set('transaction_comment', $remarks);
		$this->db->where('transaction_id', $transaction_id);
		$this->db->update($this->transactions);
			
		 
		
		return true;
		
	}
		
	function void_payment($post, $transID){
		 
		$payments = array();
		foreach($post as $x=>$y){
			
			// echo "$x <br>";
			
			if (strpos($x, 'payment_') !== false) {
				// echo 'true';
				
				$p_name=  explode("_",$x);
				
				$payments[$p_name[1]] = $y;
			}
			
			
		} 
		
		// echo '<pre>';
		// print_r($payments);
		// echo '</pre>';
		
		
		$this->db->where('payment_transaction_id', $transID); 
 		$result = $this->db->get('payments')->result();
	
		$payment = array();
		foreach($result as $z){
			
			
			if($z->payment_payment_type_id == 36){
				
				// $voided_amount = $z->payment_amount_voided + $payments[$z->payment_payment_type_id]; 
				// $this->db->set('payment_amount_voided', $voided_amount);
				// $this->db->where('payment_payment_type_id', $z->payment_payment_type_id);
				// $this->db->where('payment_transaction_id', $transID);
				// $this->db->update('payments');
				
				
			}else{
				
				$voided_amount = $z->payment_amount_voided + $payments[$z->payment_id]; 
				$this->db->set('payment_amount_voided', $voided_amount);
				$this->db->set('date_modified', date("Y-m-d H:i:s"));
				$this->db->where('payment_id', $z->payment_id);
				$this->db->where('payment_transaction_id', $transID);
				$this->db->update('payments');
				
			}
			
			
			$this->db->select('user_branch_id');
			$this->db->where('username', $post['username']);
			$query = $this->db->get('users');
			$branch_id = $query->row()->user_branch_id;
			
			
			//for historical ATR sales 
			$voided_amount = $payments[$z->payment_id]; 
			$this->db->set('payment_id',$z->payment_id);
			$this->db->set('payment_amount', 0);
			$this->db->set('payment_amount_voided', $voided_amount);
			$this->db->set('payment_transaction_id', $transID);
			$this->db->set('payment_payment_type_id', $z->payment_payment_type_id);
			$this->db->set('payment_datetime', date("Y-m-d"));
			$this->db->set('payment_branch', $branch_id);

						
			$this->db->insert('historical_payments');
			
			
		}
		
			
				 
		//for online
	  	if($result[0]->payment_payment_type_id == 35){ 
		
			$this->db->where('charge_transaction_id', $transID); 
			$result2 = $this->db->get('charges')->row();
			// echo '<pre>';
			// print_r($post);
			// echo $result2->charge_amount;
			// die();
			
			$charge_per_tix = $result2->charge_amount / $result2->charge_ticket_count;
			$charge = $charge_per_tix * count($post['tickets']);
			$charge = $charge + $result2->charge_amount_voided;
			$this->db->set('charge_amount_voided', $charge);
			$this->db->set('date_modified', date("Y-m-d H:i:s"));
			$this->db->where('charge_transaction_id', $transID);
			$this->db->update('charges');
			
			
			//for historical ATR sales 
			$charge_per_tix = $result2->charge_amount / $result2->charge_ticket_count;
			$charge = $charge_per_tix * count($post['tickets']);
			// $charge = $charge + $result2->charge_amount_voided;
		 
			$this->db->set('charge_datetime', date("Y-m-d")); 
			$this->db->set('charge_transaction_id', $transID);
			$this->db->set('charge_amount', $result2->charge_amount);
			$this->db->set('charge_ticket_count', $result2->charge_ticket_count);
			$this->db->set('charge_type', 'convenience');
			$this->db->set('charge_amount_voided', $charge);
			$this->db->set('charge_branch', $branch_id);
			 
			$this->db->insert('historical_charges');
			
			
		} 
		
	
		
		// die();
		
	}
	
	function void2($transaction_id,$checked)
	{
		// get the section id first
		$this->db->select('ticket_section_id');
		$this->db->where('ticket_transaction_id', $transaction_id);
		$this->db->limit(1);
		$query = $this->db->get($this->tickets);
		$section = $query->row();
				
		
		$this->db->where('ticket_transaction_id', $transaction_id);
		$this->db->where('ticket_status', 'paid');
		$counts = $this->db->count_all_results('tickets');
		
		if($counts >= 0 )
		{
			$fields = array(
				'transaction_comment'	=> $this->input->post('transaction_comment'),
			);
		}
		else
		{
			$fields = array(
				'transaction_status'	=> 'voided',
				'transaction_comment'	=> $this->input->post('transaction_comment'),
				'transaction_details'	=> 'void transaction',
				'transaction_type'		=> 'void transaction',
			);
		}
			// update transactions table
			$this->db->where('transaction_id', $transaction_id);
			$this->db->update($this->transactions, $fields);
		
 		foreach($checked as $tickets_id => $value)
		{
			// update tickets table
			$this->db->where('ticket_id', $tickets_id);
			$this->db->update($this->tickets, array('ticket_status' => 'voided'));
		}
		$ticket_count = $this->db->affected_rows();
		
		$this->add_voided_details($transaction_id);
		
		// $this->void_payment($_POST,$transaction_id);	 
		return array($section->ticket_section_id, $ticket_count);
	}	
	
	function randomKey($length) {
		
		$pool = array_merge(range(0,9), range('a', 'z'));

		for($i=0; $i < $length; $i++) {
			$key .= $pool[mt_rand(0, count($pool) - 1)];
		}
		return $key;
	}
	
	function get_date_validity($transaction_id){
		
		$this->db->select('transaction_date_validity');	
  		$this->db->where('transaction_id', $transaction_id); 
		$query = $this->db->get($this->transactions);

		return $query->row()->transaction_date_validity;
	}
		
	function add_exo(){
		
		// $exo = $this->input->post('exo');
		$exo = $_POST['exo'];
		// echo '<pre>';
		// print_r($exo);
		// echo '</pre>';
		
		// die();
		foreach($exo as $x){
			
			$ex = explode(":",$x);
			
			$data = array(
			   'exo_ticket_id' => $ex[1],
			   'exo_design' => $ex[0] 
			);

			$this->db->insert('exo', $data); 
			
			
		}
		
		
		
		
		// die();
	}
	 
	
}
// END transactions_model.php
/* Location: ./application/models/transactions_model.php */		