<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Ticket_Types_Model extends CI_Model
{
	var $seatplans = 'seatplans s';
	var $venues = 'venues v';
	var $prices = 'prices pc';	
	var $ticket_types = 'ticket_types tt';	
	var $events = 'events e';		
	
	/**
	 * Constructor
	 *
	 * @access	public
	 */
	public function __construct()
	{
		parent::__construct();
	}
	// --------------------------------------------------------------------
	
	/**
	 * get_ticket_type
	 *
	 * @access	public
	 */
	function get($ticket_type_id)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->where('ticket_type_id', $ticket_type_id);
		$query = $this->db->get($this->ticket_types);
	
		return $query->row();
		
	}	
	// --------------------------------------------------------------------
	
	/**
	 * get_ticket_types
	 *
	 * @access	public
	 */
 	function get_ticket_types()
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->order_by('ticket_type_group, ticket_type_id');
		$query = $this->db->get($this->ticket_types);
		return $query->result();
	}
	
	function get_ticket_types_b()
	{
		$this->db->order_by('ticket_type_group, ticket_type_id');
		$this->db->where('ticket_type_active', 1);
		$query = $this->db->get($this->ticket_types);
		return $query->result();
	}


	
	function get_ticket_type_list()
	{
		$this->db->order_by('ticket_type_name, ticket_type_group, ticket_type_id');
		$this->db->where('ticket_type_active', 1);
		$query = $this->db->get($this->ticket_types);
		return $query->result();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_ticket_types_dropdown
	 *
	 * @access	public
	 */
	function get_ticket_types_dropdown()
	{
		// $this->db->order_by('ticket_type_group');
		$this->db->order_by('ticket_type_id');
		$this->db->where('ticket_type_active', 1); 
		$query = $this->db->get($this->ticket_types);
		
		$result = $query->result();
		if ($result)
		{
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->ticket_type_id] = $r->ticket_type_name;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}
	
	function get_ticket_types_details($event_ticket_types )
	{
		
		$this->db->order_by('ticket_type_id');
		$this->db->where_in('ticket_type_id', $event_ticket_types);
		$query = $this->db->get($this->ticket_types);
		
		$result = $query->result();
		if ($result)
		{
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->ticket_type_id] = $r->ticket_type_name;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}
	
	function get_ticket_types_discount($id)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->order_by('ticket_type_id');
		$this->db->where('ticket_type_id', $id);
		$query = $this->db->get($this->ticket_types);
		$result = $query->row();
		return array($result->ticket_type_discount,$result->ticket_type_discount_type);

	}
	
	// --------------------------------------------------------------------
	
	/**
	 * add
	 *
	 */
	function add()
	{
		$fields = array(
			'ticket_type_code'			=> $this->input->post('ticket_type_code'),
			'ticket_type_name'			=> $this->input->post('ticket_type_name'),
			'ticket_type_discount_type'	=> $this->input->post('ticket_type_discount_type'),
			'ticket_type_discount'		=> $this->input->post('ticket_type_discount'),
			'ticket_type_group'			=> $this->input->post('ticket_type_group'),
			'ticket_type_active'		=> $this->input->post('ticket_type_active'),
		);
		
		// insert to db
		$this->db->set($fields);
		$this->db->insert('ticket_types');
		
		return true;
	}		
	// --------------------------------------------------------------------
	
	/**
	 * edit
	 *
	 */
	function edit($ticket_type_id)
	{
		$fields = array(
			'ticket_type_code'			=> $this->input->post('ticket_type_code'),
			'ticket_type_name'			=> $this->input->post('ticket_type_name'),
			'ticket_type_discount_type'	=> $this->input->post('ticket_type_discount_type'),		
			'ticket_type_discount'		=> $this->input->post('ticket_type_discount'),
			'ticket_type_group'			=> $this->input->post('ticket_type_group'),					
			'ticket_type_active'		=> $this->input->post('ticket_type_active'),					
			'ticket_type_promo'			=> $this->input->post('ticket_type_promo'),					
			'ticket_type_color'			=> $this->input->post('ticket_type_color'),					
			'ticket_type_expiration'	=> $this->input->post('expiration'),					
		);
		
		// update db
		$this->db->where('ticket_type_id', $ticket_type_id);
		$this->db->update($this->ticket_types, $fields);
		
		return true;
	}		
	// --------------------------------------------------------------------
	
	/**
	 * delete
	 *
	 */
	function delete($ticket_type_id)
	{
		$this->db->delete('ticket_types', array('ticket_type_id' => $ticket_type_id));
		
		return true;
	}	
	
	function array_info($ticket_types) {
		$result = array();
		if (count($ticket_types) > 0) {
			$this->db->where_in('ticket_type_id', $ticket_types);
			$query = $this->db->get($this->ticket_types);
			foreach($query->result() as $row) {
				$result[$row->ticket_type_id] = $row->ticket_type_name . " (". $row->ticket_type_code . ")" ;
			}
		}
		/*
		if (count($result) > 0) {}
		else {$result["x"] = "--not available--";}
		*/
		return $result;
	}
	
	function get_ticket_types_dropdown_promo($ticket_types = false)
	{
		// $this->db->order_by('ticket_type_group');
		$this->db->order_by('ticket_type_id');
		$this->db->where('ticket_type_active', 1); 
		
		if($ticket_types)
		$this->db->where_in('ticket_type_id', unserialize($ticket_types));
		
		$query = $this->db->get($this->ticket_types);
		
		$result = $query->result();
		if ($result)
		{
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->ticket_type_id] = $r->ticket_type_name;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}
	
	function get_ticket_types_dropdown_sort()
	{
		// $this->db->order_by('ticket_type_group');
		$this->db->order_by('ticket_type_name');
		$this->db->where('ticket_type_active', 1); 
		$query = $this->db->get($this->ticket_types);
		
		$result = $query->result();
		if ($result)
		{
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->ticket_type_id] = $r->ticket_type_name;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}
	
	function get_ticket_types_seller()
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$today =  date("Y/m/d");
		$where_au = "(ticket_type_expiration >= '$today' OR ticket_type_expiration = '0000-00-00')";

	
		if (!in_array($this->session->userdata('user_type'), array('Admin','Super Admin','Admin2'))){
			$this->db->where('ticket_type_group', 0);
		}
		
		// limit for disney
		$this->db->where($where_au);
		
		//$this->session->userdata('user_branch_id') 
		$cebu = array(32,104,137);
		$davao = array(31,106);
 	    $user_branch = $this->session->userdata('user_branch_id');
		
		 
		if (!in_array($user_branch, $cebu) && $this->session->userdata('user_type') != 'Admin') {
			
			$this->db->where('ticket_type_id !=', 1017);
		}
		
		if (!in_array($user_branch, $davao) && !in_array($this->session->userdata('user_type'), array('Admin','Super Admin','Admin2'))) {
			
			$this->db->where('ticket_type_id !=', 1018);
		}
		
		
		
		 
		$price= $this->session->userdata('cpi');
		if(!in_array($this->session->userdata('user_type'), array('Admin','Super Admin','Admin2'))){
			
			
			//brave 
			if (in_array($price, array(43192, 43193, 43194))){
				    	
			}else{
				
				$this->db->where('ticket_type_id !=', 1363); 
				$this->db->where('ticket_type_id !=', 1364); 
				
			} 
			
			//brave 
			if (in_array($price, array(43193, 43194))){
				    	
			}else{
				
				$this->db->where('ticket_type_id !=', 1365);  
				
			} 
			
			
			//brave new
			if (in_array($price, array(43202, 43192, 43193,43194))){
				    	
			}else{
				
				$this->db->where('ticket_type_id !=', 1374);  
				$this->db->where('ticket_type_id !=', 1375);  
				
			} 
			
			
			
			//SMART/M5 discount
			if (in_array($price, array(40747, 40748))){
				    	
			}else{
				
				$this->db->where('ticket_type_id !=', 1367); 
				
			} 
			
			//DOI
			if (in_array($price, array(41805,41835, 41810, 41840,41807,41837))){
				    	
			}else{
				
				$this->db->where('ticket_type_id !=', 1307); 
				
			} 
			
			
			//ONE:HERO 
			
			//STANDARD DISCOUNT 15% OFF December 31 - January 20, 2019 
			//ONEHERO - 25% DISCOUNT December 10 - January 25, 2019
			//ONESTAFF - 25% DISCOUNT December 10 - January 25, 2019
			//FLASH January 16, 2019 0001H-2359H 
			//FLASH January 23, 2019 0001H-2359H
			if (in_array($price, array(43872,43873,43874))){ //CAT2-4
				   
				// $this->db->where('ticket_type_id !=', 1 );
				//$this->db->where('ticket_type_id !=', 2 );
			
			}else{
				
				$this->db->where('ticket_type_id !=', 1371 );
				$this->db->where('ticket_type_id !=', 996 );
				$this->db->where('ticket_type_id !=', 1333 );
				$this->db->where('ticket_type_id !=', 1382 );
				$this->db->where('ticket_type_id !=', 1295 );
				$this->db->where('ticket_type_id !=', 1294 ); 
				$this->db->where('ticket_type_id !=', 1080 );
				$this->db->where('ticket_type_id !=', 1233 ); 
				$this->db->where('ticket_type_id !=', 1378 ); 
				$this->db->where('ticket_type_id !=', 1379 ); 
				$this->db->where('ticket_type_id !=', 1380 ); 
				
				
			} 
			
			if (in_array($price, array(43872,43873,43874,43875))){ //CAT 2-5
				 
			
			}else{
				
				$this->db->where('ticket_type_id !=', 1246 );
				$this->db->where('ticket_type_id !=', 1256 );
				
				
			} 
			
			
			
			if (in_array($price, array(43871,43872,43873,43874,43875))){ //CAT 1-5
				   
				//$this->db->where('ticket_type_id !=', 1 );
				//$this->db->where('ticket_type_id !=', 2 );
			
			}else{
				
				$this->db->where('ticket_type_id !=', 1043 );
				
				
			} 
			
			if (in_array($price, array(43877, 43878,43879))){ //CAT 6-8
				   
				// $this->db->where('ticket_type_id ', 1 );
				
			} 
			 
			 
			//ONE:HERO ASCENT
			
			
			
			
			//doi 2018  
			if (in_array($price, array(41387,41389,41392,41393,41668,41670,41673,41674,41683,41685,41688,41689,41698,41700,41703,41704,41713,41715,41718,41719,41728,41730,41733,41734,41743,41745,41748,41749,41758,41760,41763,41764,41773,41775,41778,41779,41788,41790,41793,41794,41803,41805,41808,41809,41818,41820,41823,41824,41833,41835,41838,41839,41848,41850,41853,41854,41863,41865,41868,41869,41878,41880,41883,41884,41893,41895,41898,41899,41908,41910,41913,41914,41923,41925,41928,41929,41938,41940,41943,41944,41953,41955,41958,41959,41968,41970,41973,41974,41984,41986,41989,41990,41390,41671,41686,41701,41716,41731,41746,41761,41776,41791,41806,41821,41836,41851,41866,41881,41896,41911,41926,41941,41956,41971,41987))){
				   
			
				$this->db->where('ticket_type_id !=', 1313 ); 
			} 
			
			
			
			
			if (in_array($price, array(41386,41388,41391,41394,41667,41669,41672,41675,41682,41684,41687,41690,41697,41699,41702,41705,41712,41714,41717,41720,41727,41729,41732,41735,41742,41744,41747,41750,41757,41759,41762,41765,41772,41774,41777,41780,41787,41789,41792,41795,41802,41804,41807,41810,41817,41819,41822,41825,41832,41834,41837,41840,41847,41849,41852,41855,41862,41864,41867,41870,41877,41879,41882,41885,41892,41894,41897,41900,41907,41909,41912,41915,41922,41924,41927,41930,41937,41939,41942,41945,41952,41954,41957,41960,41967,41969,41972,41975,41983,41985,41988,41991))){
				   
			
				// $this->db->where('ticket_type_id !=', 1313 );
				//$this->db->where('ticket_type_id !=', 1 );
				//$this->db->where('ticket_type_id !=', 2 );
			} 
			
			
			 
			
			if (in_array($price, array(41802,41832,41870,41867,41862,41952))){
				   
			
			}else{
				
				$this->db->where('ticket_type_id !=', 1308 );
			} 
			
			
			//end of doi 2018
			
			
			
			//disney 2018
			
			if (in_array($price, array(41805,41810,41807,41835,41840,41837))){
				   
			
			}else{
				
				$this->db->where('ticket_type_id !=', 1307);
			}  
			//end of disney 2018
			
			
			//GNR 
			$gnr = array(38656,38923,38924,38649,38925,38652);
			
			 
			if (in_array($price, $gnr)){
				  
			}else{
				  
				$this->db->where('ticket_type_id !=', 1285);
 			}
			 
		 
			
		
			//in the mix bdo

			if($price == 32128){
				
				$this->db->where('ticket_type_id !=', 905);

			}elseif($price == 32133){
				
				$this->db->where('ticket_type_id !=', 905);

			}else{
				
				
			}
			
			 
			//unknown event
			$unknown = array(38260, 38259, 38258);
			if(in_array($price, $unknown)) {
			}else{
				
				$this->db->where('ticket_type_id !=', 98);
			}
			
			//pyro
			$pyro = array(35617 , 35624 , 35631 , 35638 , 35645 , 35652);
			if(in_array($price, $pyro)) {
			
				$this->db->where('ticket_type_id !=', 1005);
			
			}
			
			
			
			//chain globe
			$chain = array(32923 , 32926 , 32927 , 32949);
			if(in_array($price, $chain)) {
			
			$this->db->where('ticket_type_id !=', 902);
			
			}
			
			 
			 
			$michael_bulton = array(34347, 34355,34356);
			if (in_array($price, $michael_bulton)){
				
				 
				$this->db->where('ticket_type_id !=', 1191); 
				
			}
			
			
			//splash promo
			$splash_weekday = array(37632);
			$splash_weekend = array(36032);
			if (in_array($price, $splash_weekday)){
				 
			}else{
				
				$this->db->where('ticket_type_id !=', 1230);  
				 
			}
			
			if (in_array($price, $splash_weekend)){
				 
			}else{
				
				$this->db->where('ticket_type_id !=', 1231);  
				 
			}
			
			
			//PLAYBACK 35538 & 35534
			$playback = array(35538, 35534);
			if (!in_array($price, $playback)){
				
				 
				$this->db->where('ticket_type_id !=', 1220); 
				
			}
			
			
			//GNR
			$playback = array(35538, 35534);
			if ($price == 38654){
				
				 
			}else{
				
				
				$this->db->where('ticket_type_id !=', 1270); 
				$this->db->where('ticket_type_id !=', 1271); 
				$this->db->where('ticket_type_id !=', 1272); 
				$this->db->where('ticket_type_id !=', 1273); 
				
			}
			
			
			
			
	
				$this->db->where('ticket_type_id !=', 29); 
			//pdmn
			
			
			// 	"01/06/2018","01/13/2018","01/20/2018","01/27/2018","02/03/2018","02/10/2018","02/17/2018","02/24/2018","01/07/2018","01/14/2018","01/21/2018","01/28/2018","02/04/2018","02/11/2018","02/18/2018","02/25/2018"
			
			
			//Kidzania
			$kidzania = array("01/06/2018","01/13/2018","01/20/2018","01/27/2018","02/03/2018","02/10/2018","02/17/2018","02/24/2018","01/07/2018","01/14/2018","01/21/2018","01/28/2018","02/04/2018","02/11/2018","02/18/2018","02/25/2018");
			$valid_date = $this->session->userdata('valid_date');
			$valid_date = strtotime($valid_date); 
			$valid_date = date('m/d/Y',$valid_date);
 
			// echo $valid_date;
			
			if (!in_array($valid_date, $kidzania)){
				 
				$this->db->where('ticket_type_id !=', 1218 ); 
				
			}
			
		
	    }
	 
		// $this->db->where('t.transaction_date >=', $reports_date.' 00:00:01');
		
		$this->db->order_by('ticket_type_group, ticket_type_id');
		$query = $this->db->get($this->ticket_types);
		return $query->result();
	}
		

	
	function getTicketTypeByEvent($event_id )
	{
		$this->db->distinct();
		$this->db->select('tt.ticket_type_name, tt.ticket_type_id');
		$this->db->where('t.ticket_event_id', $event_id);
		$this->db->join('tickets t', 't.ticket_type_id = tt.ticket_type_id');
		$query = $this->db->get('ticket_types tt');
		return $query->result();
		
		
	}
	
		function getTicketTypeByEventLongTitle($event_long )
	{
		
		$this->db->select('event_id');
		$this->db->where('event_long_title', $event_long);
		$query_id = $this->db->get('events')->result_array();
		// echo $this->db->last_query();
		// return $query_id->result();
		// echo '<pre>';
		// print_r($query_id);
		// die();
		foreach($query_id as $k=>$v) {
		$event_ids[$k] = $v["event_id"];
		
		}
		$this->db->distinct();
		$this->db->select('tt.ticket_type_name, tt.ticket_type_id');
		$this->db->where_in('t.ticket_event_id', $event_ids);
		$this->db->where('tt.ticket_type_group', 0);
		$this->db->join('tickets t', 't.ticket_type_id = tt.ticket_type_id');
		$this->db->order_by('tt.ticket_type_id', 'ASC');
		$query = $this->db->get('ticket_types tt');
		return $query->result();
		// echo $this->db->last_query();
		// die();
		
		
	}

	
	function get_ticket_types_doi()
	{
		$this->db->query('set transaction isolation level read uncommitted');
		 
		$cei = $this->session->userdata('cei');
 		$price = $this->prices_model->get($this->session->userdata('cpi')); 
		$price_name = $price->price_name;
		
		
		$today =  date("Y/m/d");
		$where_au = "(ticket_type_expiration >= '$today' OR ticket_type_expiration = '0000-00-00')";

	
		if($this->session->userdata('user_type') != 'Admin'){
			$this->db->where('ticket_type_group', 0);
		}
		
		// limit for disney
		$this->db->where($where_au);
		
		//$this->session->userdata('user_branch_id') 
		$cebu = array(32,104,137);
		$davao = array(31,106);
 	    $user_branch = $this->session->userdata('user_branch_id');
		
		
		if (!in_array($user_branch, $cebu) && $this->session->userdata('user_type') != 'Admin') {
			
			$this->db->where('ticket_type_id !=', 1017);
		}
		
		if (!in_array($user_branch, $davao) && $this->session->userdata('user_type') != 'Admin') {
			
			$this->db->where('ticket_type_id !=', 1018);
		}
		

		
	 
		if($this->session->userdata('user_type') != 'Admin'){
			 
		    $doi_all = array(6162,6164,6165,6166,6167,6168,6169,6170,6171,6172,6173,6174,6175,6176,6177,6178,6179,6180);
		    $doi_sm_emp = array(6168,6169,6170,6171);
		    $doi_bulk = array(6162,6164,6165,6168,6169,6170,6175,6177,6178,6179,6180);
		    $doi_hotel = array(6162,6165,6168,6169,6170,6175,6177,6178,6179,6180);
		 
			if(in_array($cei,$doi_all)){
				if (strpos($price_name, 'BOX') !== false) {
					// echo 'true';
					
					
				}else{
					
					$this->db->where('ticket_type_id !=', 1021);
					$this->db->where('ticket_type_id !=', 1022);
					$this->db->where('ticket_type_id !=', 1205);
					$this->db->where('ticket_type_id !=', 1206);
					$this->db->where('ticket_type_id !=', 1214);
					$this->db->where('ticket_type_id !=', 1213);
					$this->db->where('ticket_type_id !=', 1215);
					$this->db->where('ticket_type_id !=', 1216);
					$this->db->where('ticket_type_id !=', 1031);
				 
  				}
				
			
			}
			
			if(in_array($cei,$doi_sm_emp)){
				if (strpos($price_name, 'BOX') !== false) {
					// echo 'true';
					
					
				}else{
					
					$this->db->where('ticket_type_id !=', 1019); 
				}
				
			
			}
			
			if(in_array($cei,$doi_bulk)){
				if (strpos($price_name, 'BOX') !== false) {
					// echo 'true';
					
					
				}else{
					
					$this->db->where('ticket_type_id !=', 1031); 
				}
				
			
			}
			
			if(in_array($cei,$doi_hotel)){
				if (strpos($price_name, 'BOX') !== false) {
					// echo 'true';
					
					
				}else{
					
					$this->db->where('ticket_type_id !=', 1204); 
				}
				
			
			}
			
			 
	    }
	 
		// $this->db->where('t.transaction_date >=', $reports_date.' 00:00:01');
		
		$this->db->order_by('ticket_type_group, ticket_type_id');
		$query = $this->db->get($this->ticket_types);
		return $query->result();
	}
		
 
	 
}
// END Ticket_Types_Model.php
/* Location: ./application/models/Ticket_Types_Model.php */		
