<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class TestModel_model extends CI_Model
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('customers_model', 'customers');
	}

	function post2mci($tid) 
	{
		$url = $this->config->item('mci_url');
		$token = $this->config->item('mci_token');
		$tracknum = $this->config->item('bdo_prefix').$tid;
		$data = array(
			'trackingnumber' => $tracknum,
			'token' => $token,
			'accesskey' => $this->customers->prep_password($tid.$this->config->item('encryption_key').$token),
		);
		
		return $this->do_http_post_request($url, $data);
		// return $this->do_post_request($url, http_build_query($data));
	}
	
	// --------------------------------------------------------------------


	// original code with thrown exception:
	function do_post_request($url, $data, $optional_headers = null)
	{
		$params = array('http' => array(
				  'method' => 'POST',
				  'content' => $data
				));
		if ($optional_headers !== null) {
			$params['http']['header'] = $optional_headers;
		}
// print_r($params);
		$ctx = stream_context_create($params);
		$fp = @fopen($url, 'rb', false, $ctx);
		if (!$fp) {
			throw new Exception("Problem with $url, $php_errormsg");
		}
		$response = @stream_get_contents($fp);
		if ($response === false) {
			throw new Exception("Problem reading data from $url, $php_errormsg");
		}
		return $response;
	}

	// modded/customized
	function do_web_requests($protocol, $url, $method, $data, $optional_headers = null)
	{
		if (strtoupper($method) == "GET") {
			$url = $url.http_build_query($data);
			$params = array($protocol => array(
					  'method' => strtoupper($method),
					));
		}
		else {
			$params = array($protocol => array(
					  'method' => strtoupper($method),
					  'content' => http_build_query($data)
					));
		}
		if ($optional_headers !== null) {
			$params['http']['header'] = $optional_headers;
		}
		print_r($params);
		$ctx = stream_context_create($params);
		$fp = @fopen($url, 'rb', false, $ctx);
		
		if (!$fp) {
			$response = false;
		}
		else {
			$response = @stream_get_contents($fp);
		}

echo "TEST=".$response;
		return $response;
	}	


	function do_http_post_request($url, $data, $optional_headers = null)
	{ 
		return $this->do_web_requests('http', $url, 'POST', $data, $optional_headers);
	}
	
	function do_https_post_request($url, $data, $optional_headers = null)
	{ 
		return $this->do_web_requests('https', $url, 'POST', $data, $optional_headers);
	}
	
	function do_http_get_request($url, $data, $optional_headers = null)
	{
		return $this->do_web_requests('http', $url, 'GET', $data, $optional_headers);
	}
	
	function do_https_get_request($url, $data, $optional_headers = null)
	{
		return $this->do_web_requests('https', $url, 'GET', $data, $optional_headers);
	}
	
	function get_bcode_transaction($bcode = '') {
		if (empty($bcode)) { return false; }
		
		$this->db->select('bcode_transaction_id');
		$this->db->where('bcode_value', $bcode);
		$query = $this->db->get('bcode');
		
		if ($query->num_rows() > 0)	{
			$row = $query->first_row();
			return $row->bcode_transaction_id;
		}
		else {
			return false;
		}
	}
}

