<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Special_model extends CI_Model
{
	
	public function __construct()
	{
		parent::__construct();
	}
	
	
	function sold_tickets_summary($event_id = false){
	
	$query = $this->db->query("
	SELECT 
		transaction_id,
		CONCAT(customer_firstname, ' ', customer_lastname) AS customer, 
		CONCAT(section_name,' ',GROUP_CONCAT(DISTINCT(ticket_row), '/', ticket_seat,' ' )) as sec_row_seat,
		COUNT(ticket_id) AS ticket_quantity,
		sum(price_price) as 'total_amount',
		branch_name
	
	FROM transactions
	INNER JOIN tickets ON tickets.ticket_transaction_id = transactions.transaction_id
	INNER JOIN customers ON customers.customer_id = transactions.transaction_customer_id
	INNER JOIN sections ON sections.section_id = tickets.ticket_section_id 
	INNER JOIN branches ON branches.branch_id = transactions.transaction_branch_id
	INNER JOIN ticket_types ON ticket_types.ticket_type_id = tickets.ticket_type_id
	INNER JOIN prices ON prices.price_id = tickets.ticket_price_id
	
	WHERE ticket_event_id = " . $event_id . " AND ticket_transaction_id != 0 AND transaction_status in('done','paid','paid_online')
	GROUP BY transaction_id
	
	");
	
	return $query->result();
	}
	
	function reserve_tickets_summary($event_id = false){
	
	$query = $this->db->query("

	SELECT 
		transaction_id as reservation_id,
		CONCAT(customer_firstname, ' ', customer_lastname) AS customer, 
		CONCAT(section_name,' ',GROUP_CONCAT( DISTINCT(ticket_row), '', ticket_seat,' ' )) as sec_row_seat,
		transaction_date as date_reserved,
	  	ticket_reservation_expiry as expiration_date,
		COUNT(ticket_id) AS ticket_quantity
	
	FROM transactions
	INNER JOIN tickets ON tickets.ticket_transaction_id = transactions.transaction_id
	INNER JOIN customers ON customers.customer_id = transactions.transaction_customer_id
	INNER JOIN sections ON sections.section_id = tickets.ticket_section_id 
	INNER JOIN branches ON branches.branch_id = transactions.transaction_branch_id
	
	WHERE ticket_event_id = ". $event_id . " AND ticket_transaction_id != 0 AND transaction_status in('reserved')
	GROUP BY transaction_id
	
	");
	
	return $query->result();
	}
	
	function get_event_details($event_id = false){
	
		$this->db->select('event_id,event_long_title as event_name');
		$this->db->where('event_id', $event_id);
		$query = $this->db->get('events');
		
		return $query->row();
	
	}
	
	function sold_tix_summary(){
	
	$query = $this->db->query("
	
	SELECT 
	Column1 as transaction_id,
	Column2 AS customer, 
	CONCAT(Column4,' ',GROUP_CONCAT(DISTINCT(Column5))) as sec_row_seat,
	COUNT(Column3) AS ticket_quantity,
	sum(Column10) as 'total_amount',
	Column9 as branch_name
	from tmp_data
	
	GROUP BY transaction_id
	");

	return $query->result();
	}
	
	function get_refund_list($event_id = false){
	
	$query = $this->db->query("
	
	select 
	tix.ticket_id,
	concat(cu.customer_firstname, ' ' ,cu.customer_lastname) as customer,
	tt.ticket_type_name,
	tix.ticket_status,
	br.branch_name
	from 
	tickets tix

	inner join transactions tr
	on tr.transaction_id = tix.ticket_transaction_id
	inner join customers cu
	on cu.customer_id = tr.transaction_customer_id
	inner join branches br
	on br.branch_id = tr.transaction_branch_id
	left join ticket_types tt
	on tt.ticket_type_id = tix.ticket_type_id


	where 
	tix.ticket_date_cancelled > '2012-10-22 00:00:00' 
	and tix.ticket_status = 'voided' 
	and tix.ticket_event_id = $event_id
	");

	return $query->result();
	
	} 

}	
// END reports_model.php
/* Location: ./application/models/reports_model.php */		