<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class SMBarcode_model extends CI_Model
{

	var $valid_ticket_status = array("paid", "paid_online");
	
	public function __construct()
	{
		parent::__construct();
	}


	function attach_smcode_to_transaction_tickets($transaction, $ticket_list, $online_claim = false) {
		$ticket_count = count($ticket_list);
		$attach_counter = 0;

		$transaction_id = $transaction->transaction_id;
		
		// prefix format = single-digit YEAR + three-digit DAY OF THE YEAR
		$prefix_yr = date("y")* 1000;
		$prefix_yr_day = date("z");
		$prefix = $prefix_yr + $prefix_yr_day;
		$prefix = $prefix % 10000;
		$oddeven = (date("H") % 2);
		$prefix = "$oddeven"."$prefix";
		$prefix_alt = ($prefix_yr_day + ($oddeven*366));
		

		if ($online_claim) {			 
			// $oddeven = date("H", strtotime($transaction->transaction_date));
			// $oddeven = ($oddeven % 2);
 			$prefix_alt = 1000 + ($prefix_yr_day + ($oddeven*366));
		}
		
		foreach($ticket_list as $tix) {
			$fields = array (
					'sm_prefix' => $prefix,
					'sm_prefix_alt' => $prefix_alt,
					'sm_transaction_id' => $transaction_id,
					'sm_ticket_id' => $tix->ticket_id,
				);

			if (in_array($tix->ticket_status, $this->valid_ticket_status)) {
				$this->db->insert('sm_barcode', $fields);
				$attach_counter += $this->db->affected_rows();
			}
		}
		// echo "$ticket_count == $attach_counter";
		$success = false;
		if (($ticket_count > 0) && ($ticket_count == $attach_counter)) {
			$success = true;
		} 
		
		return $success;
	}
	

	function mark_printer_for_online_ticket_claim($transaction_id)
	{
		// update the tickets table		
		$changes = array(
			'ticket_user_id '		=> $this->session->userdata('user_id'),
			'ticket_branch_id '		=> $this->session->userdata('user_branch_id'),
			'ticket_terminal_id '	=> $this->session->userdata('user_terminal_id'),
			'ticket_date_printed'	=> date('Y-m-d H:i:s'),
		);
		
		// update the status of the tickets
		$this->db->where_in('ticket_status', array('paid', 'paid_online'));
		$this->db->where('ticket_transaction_id', $transaction_id);
		$this->db->update("tickets", $changes);
		
		return true;
	}
	
}
