<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Sections_model extends CI_Model
{
	var $seatplans = 'seatplans s';
	var $venues = 'venues v';
	var $sections = 'sections se';
	var $prices = 'prices pc';
	var $tickets = 'tickets ti';
	
	/**
	 * Constructor
	 *
	 * @access	public
	 */
	public function __construct()
	{
		parent::__construct();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_venue
	 *
	 * @access	public
	 */
	function get($section_id)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->where('section_id', $section_id);
		$query = $this->db->get($this->sections);
		//echo $this->db->last_query();
		
		return $query->row();
	}
	
	// --------------------------------------------------------------------
		function get_latest_section($seatplan_id = false)
	{

		$this->db->order_by('section_id', 'desc'); 
		$this->db->limit(1);
		$this->db->where('section_seatplan_id', $seatplan_id);
		$query = $this->db->get($this->sections);
		return $query->row();
	}
	
	
	/**
	 * get_sections
	 *
	 * @access	public
	 */
	function get_sections($seatplan_id)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->where('section_seatplan_id', $seatplan_id);
		//$this->db->order_by('pc.price_price', 'desc'); 
		$this->db->order_by("section_name", "asc");
		$query = $this->db->get($this->sections);
		return $query->result();
	}
	
	function get_section_ids_array($seatplan_id)
	{
		$this->db->select('section_id'); 
		$this->db->where('section_seatplan_id', $seatplan_id);
		//$this->db->order_by('pc.price_price', 'desc'); 
		$this->db->order_by("section_name", "asc");
		$query = $this->db->get($this->sections)->result();
		$arr_sid = array();
		foreach($query as $section) {
			$arr_sid[] = $section->section_id;
		}
		// return $query->result_array();
		return $arr_sid;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_section_type
	 *
	 * @access	public
	 */
	function get_section_type($sections)
	{
		/*$this->db->where('section_seatplan_id', $seatplan_id);
		//$this->db->order_by('pc.price_price', 'desc'); 
		$this->db->order_by("section_name", "asc");
		$query = $this->db->get($this->sections);
		return $query->result();*/
		
		$sections = unserialize($sections);
		
		//print_array($sections);
		
		if (is_array($sections))
		{
			$section = $this->get($sections[0]);
			return $section->section_type;
		}
		else
			return false;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_sections_dropdown
	 *
	 * @access	public
	 */
	function get_sections_dropdown($seatplan_id)
	{
		$this->db->where('section_seatplan_id', $seatplan_id);
		$this->db->order_by("section_name", "asc");
		$query = $this->db->get($this->sections);
			
		$result = $query->result();

		if ($result)
		{
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->section_id] = $r->section_name;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}
	//Get all used sections
	function get_unique_sections_dropdown($seatplan_id=false, $used=false)
	{
		
		$this->db->where('section_seatplan_id', $seatplan_id);		
		if($used)
		$this->db->where_not_in('section_id', $used);
 		$this->db->order_by("section_name", "asc");
		$query = $this->db->get($this->sections);
			
		$result = $query->result();

		if ($result)
		{
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->section_id] = $r->section_name;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}	
	
	// --------------------------------------------------------------------
	
	/**
	 * get_available_tickets
	 *
	 * @access	public
	 */
	function get_available_tickets($sections)
	{
		$this->db->select('sum(section_available) as total_available');
		$this->db->where_in('section_id', unserialize($sections));
		$query = $this->db->get($this->sections);
		//echo $this->db->last_query();
		
		$row = $query->row();
		return $row->total_available;
	}
	
	function get_seat_type($sections, $unserialize = false)
	{
		if ($unserialize) {
			$arr_sections = unserialize($sections);
		} else {
			$arr_sections = array($sections);
		}
		
		if (is_array($arr_sections))
		{
			$section = $this->get($arr_sections[0]);
			// if (count($section) > 0) {
				return $section->section_type;
			// } else { return false; }
		}
		else
			return false;
	}
	
	
	function get_ticket_availability_sections($sections, $seatplan_id = false, $unserialize = false)
	{
		
		$this->db->query('set transaction isolation level read uncommitted');


		if ($unserialize) {
			$arr_sections = unserialize($sections);
		} else {
			$arr_sections = array($sections);
		}
		
		if (empty($arr_sections)) { return array(); }
		
		foreach($arr_sections as $section_id) {
			$price_section_info['used'][$section_id] = 0;
			$price_section_info['capacity'][$section_id] = 0;
			$price_section_info['available'][$section_id] = 0;
			$price_section_info['available_db'][$section_id] = 0;
			$price_section_info['reserved'][$section_id] = 0;
			$price_section_info['type'][$section_id] = "";
		}
		
		// get capacity and default availability
		$this->db->select('section_id, section_capacity, section_type, section_available');
		$this->db->where_in('section_id', $arr_sections);
		$this->db->where('section_seatplan_id', $seatplan_id);
		
		$query = $this->db->get($this->sections);

		// filter out non-existingg section_id
		$arr_sections = array();
		
		foreach($query->result() as $row) {
			$section_id = $row->section_id;
			$arr_sections[] = $section_id;
			$capacity = $row->section_capacity;
 			$price_section_info['capacity'][$section_id] = $capacity;
			
			// default value - if no seat is taken yet
			$price_section_info['available'][$section_id] = $capacity; 
			// $price_section_info['reserved'][$section_id] = $reserved; 
			$price_section_info['type'][$section_id] = $row->section_type; 
			$price_section_info['available_db'][$section_id] = $row->section_available;
		}
		
		if (!empty($arr_sections)) {
			$this->db->query('set transaction isolation level read uncommitted');
			// get taken value
			$this->db->select('ticket_id , ticket_section_id,ticket_status');
			$this->db->where_in('ticket_section_id', $arr_sections);
			$this->db->where_in('ticket_status', array('reserved','done','selected','paid','paid_online'));
			// $this->db->group_by('ticket_id');
			$query2 = $this->db->get($this->tickets);
			 
			foreach($query2->result() as $row) {
				$section_id = $row->ticket_section_id;
				$count_used = 1;
				$price_section_info['used'][$section_id] += $count_used;
				$total_capacity = $price_section_info['capacity'][$section_id]; 
				 
				//count reserved
				if($row->ticket_status == 'reserved'){
					 
				$section_id = $row->ticket_section_id;
				// $count_reserved += 1;
				$price_section_info['reserved'][$section_id] += 1;
				}
				
				
			}
			
			//update available
			foreach($query->result() as $row) {
			$section_id = $row->section_id; 
			// default value - if no seat is taken yet
			$price_section_info['available'][$section_id] =  $price_section_info['capacity'][$section_id] - $price_section_info['used'][$section_id];  
			}
			
			
			
			
   
			return $price_section_info;
			
			
		} else {
			return array();
		}

	}

	function get_ticket_availability($sections, $seatplan_id = false, $unserialize = false, $breakdown = false) {
		$ret = $this->get_ticket_availability_sections($sections, $seatplan_id, $unserialize);
		
		if (empty($ret)) { 
			return array(
					'total_capacity' => 0
					, 'total_used' => 0
					, 'total_reserved' => 0
					, 'total_available' => 0
					, 'total_available_db' => 0
					, 'type' => 'N/A'
				); 
		}

		$type = current($ret['type']);

		if ($breakdown) {
			$section_info = $ret;
		}
		
		$section_info['total_capacity'] = array_sum($ret['capacity']);
		$section_info['total_used'] = array_sum($ret['used']);
		$section_info['total_reserved'] = array_sum($ret['reserved']);
		$section_info['total_available'] = array_sum($ret['available']);
		$section_info['total_available_db'] = array_sum($ret['available_db']);
		$section_info['type'] = $type; 

		return $section_info;
	}
		// --------------------------------------------------------------------
	
	/**
	 * get_section_names
	 *
	 * @access	public
	 */
	function get_section_names($seatplan_id)
	{	
		$array = array();
		
		$this->db->where('section_seatplan_id', $seatplan_id);
		$query = $this->db->get($this->sections);
			
		$result = $query->result();

		if ($result)
		{
			foreach($result as $r)
				$array[$r->section_id] = $r->section_name;

			return $array;
		}
		else
			return false;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_selected_section_names
	 *
	 * @access	public
	 */
	function get_selected_section_names($seatplan_id, $sections)
	{	
		$array = array();
		
		if (!$sections)
		{
			return false;
		}
		
		$this->db->where('section_seatplan_id', $seatplan_id);
		$query = $this->db->get($this->sections);
			
		$result = $query->result();

		if ($result)
		{
			// transform result to csv
			$sections = unserialize($sections);

			if ($sections) 
			{
				foreach($result as $r)
				{
					if (in_array($r->section_id, $sections))
						$array[$r->section_id] = $r->section_name;
				}
				
				return $array;
			}
			else
				return false;
		}
		else
			return false;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * add
	 *
	 */
	function add($seatplan_id)
	{
		$fields = array(
			'section_code'				=> $this->input->post('section_code'),
			'section_name'				=> $this->input->post('section_name'),
			'section_type'				=> $this->input->post('section_type'),
			'section_seatplan_id'		=> $seatplan_id,
			'section_capacity'			=> $this->input->post('section_capacity'),
			'section_stage_location'	=> $this->input->post('section_stage_location'),
			'section_available'			=> $this->input->post('section_capacity'),
			'section_coords'			=> $this->input->post('section_coords'),
		);
		
		// insert to db
		$this->db->set($fields);
		$this->db->insert('sections');
		
		return true;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * edit
	 *
	 */
	function edit($section_id)
	{
		$fields = array(
			'section_code'				=> $this->input->post('section_code'),
			'section_name'				=> $this->input->post('section_name'),
			'section_type'				=> $this->input->post('section_type'),
			'section_capacity'			=> $this->input->post('section_capacity'),
			'section_stage_location'	=> $this->input->post('section_stage_location'),
			'section_available'			=> $this->input->post('section_available'),
			'section_coords'			=> $this->input->post('section_coords'),
		);
		
		// update db
		$this->db->where('section_id', $section_id);
		$this->db->update($this->sections, $fields);
		//echo $this->db->last_query();
		return true;
	}
	
	// --------------------------------------------------------------------


	/**
	 * generate section name
	 *
	 */
	function exec_query($querystring)
	{
		$query = $this->db->query($querystring);
				$row = $query->row();
	
	return $row->section_name;
	}
	
	function generate_section_name($section_id)
	{	
		$section_name = false;
		$new_section_name = false;
		$highest_section_name = false;	
		$increment = false;
		
		$section_name = $this->exec_query("SELECT section_name FROM (`sections` se)
										WHERE section_id = " . $section_id);
		
		if(substr($section_name,-2, -1) == "-")
		{
			$highest_section_name = $this->exec_query("SELECT section_name FROM (`sections` se)
									WHERE `section_name` LIKE '". substr($section_name,0,-3) ."%'
									ORDER BY section_name DESC
									LIMIT 1");
																		
			$increment = substr($highest_section_name,-1);
			$increment = $increment + 1;
			
		$new_section_name = substr($section_name,0,-2) . "-" . $increment;
		// $new_seatplan_name =  $counter + 1;
		//echo $new_section_name;
		}
		else
		{
			$highest_section_name = $this->exec_query("SELECT section_name FROM (`sections` se)
									WHERE `section_name` LIKE '". $section_name ."%'
									ORDER BY section_name DESC
									LIMIT 1");
				
				if(substr($highest_section_name,-2,-1) == "-")
				{
					$increment = substr($highest_section_name,-1);
					$increment = $increment + 1;
					$new_section_name = substr($highest_section_name,0,-2) . "-" . $increment;
				}
				else
				{
					$new_section_name = $section_name . "-1";
				}
		}
		return $new_section_name;
	}
	
	/**
	 * copy section function
	 *
	 */
	function copy_section($section_id)
	{	
		$section_new_name = $this->generate_section_name($section_id);
		
		// copy the duplicated section into sections db
		
		$new_section_id = $this->db->insert_id();
		$sql = "insert into sections(section_seatplan_id, section_code, section_name, section_type, section_stage_location, section_seat_config, 
									 section_row_from, section_row_to, section_row_increment, section_col_from, section_col_to,
									 section_col_increment, section_row_aisles, section_col_aisles, section_capacity,
									 section_available) 
									 SELECT section_seatplan_id, section_code, '". $section_new_name . "', section_type, section_stage_location, section_seat_config,
									 section_row_from, section_row_to, section_row_increment, section_col_from, section_col_to,
									 section_col_increment, section_row_aisles, section_col_aisles, section_capacity,
									 section_available
									 FROM sections
									 WHERE section_id = " .  $section_id;
		$this->db->query($sql, array($new_section_id, $section_id));
		return $new_section_id;
	}
	// --------------------------------------------------------------------
	
	// --------------------------------------------------------------------
	
	/**
	 * edit_seats
	 *
	 */
	function edit_seats($section_id)
	{
		// reconstruct the array
		foreach ($this->input->post('seat') as $seat_row => $seat_cols)
		{
			foreach ($seat_cols as $seat_col)
			{
				$values = explode('|', $seat_col);
				$seat_config[$seat_row]['C'.$values[0]] = $seat_row.'|C'.$seat_col;
			}
		}

		$fields = array(
			'section_seat_config'		=> serialize($seat_config),
			'section_row_from'			=> $this->input->post('row_from'),
			'section_row_to'			=> $this->input->post('row_to'),
			'section_row_increment'		=> $this->input->post('row_increment'),
			'section_col_from'			=> $this->input->post('col_from'),
			'section_col_to'			=> $this->input->post('col_to'),
			'section_col_increment'		=> $this->input->post('col_increment'),
			'section_row_aisles'			=> $this->input->post('row_aisles'),
			'section_col_aisles'			=> $this->input->post('col_aisles'),
		);
		
		// update db
		$this->db->where('section_id', $section_id);
		$this->db->update($this->sections, $fields);
		//echo $this->db->last_query();
		return true;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * edit_seat_names
	 *
	 */
 	function edit_seat_names($section_id)
	{
		$rheads = $this->input->post('row_heads');
		$cheads = $this->input->post('col_heads');
		// echo '<pre>';
		// print_r($cheads);
		// echo '</pre>';
		// die();
 		// echo '<pre>';
		// print_r($this->input->post('seat'));
		// echo '</pre>';
		// die();
		// reconstruct the array
		foreach ($this->input->post('seat') as $seat_row => $seat_cols)
		{
			foreach ($seat_cols as $seat_key => $seat_col)
			{
				if ($seat_col)
				{
				// echo $seat_col;
				// die();
					 
					$row = preg_replace('/[^0-9]/', '', $seat_row);
					$col = preg_replace('/[^0-9]/', '', $seat_col);
					// $col = explode('|', $seat_cols);
					// $col = preg_replace('/[^0-9]/', '', $seat_cols);
 					 
 					// echo '<pre>';
					// print_r($seat_key);
					// echo '</pre>';
					// echo $row;
					 	
					// die();
					
					
					$rhead = $rheads[$row];
					$chead = $cheads[$seat_key];
 					// echo '<pre>';
					// print_r($seat_col);
					// echo '</pre>';
					// die();
					
					//$seat_col = "$rhead|$chead"; 
					// echo $chead;
					// die();
					
					$seat_config[$seat_row]['C'.$seat_key] = "$seat_row|C$seat_key|$seat_col";
				}
			}
		}
		// print_array($seat_config); exit;
		$fields['section_seat_config'] = serialize($seat_config);
		
		// update db
		$this->db->where('section_id', $section_id);
		$this->db->update($this->sections, $fields);
		//echo $this->db->last_query();
		return true;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * edit_seat_heads
	 *
	 */
	function edit_seat_heads($section_id)
	{
		$heads = array(
			'col_heads' => $this->input->post('col_heads'),
			'row_heads' => $this->input->post('row_heads'),
		);
	
		// update db
		$fields['section_seat_heads'] = serialize($heads);
		$this->db->where('section_id', $section_id);
		$this->db->update($this->sections, $fields);
		//echo $this->db->last_query();
		return true;
	}
	
	
	// --------------------------------------------------------------------
	
	/**
	 * update_available
	 *
	 * @access	public
	 */
	function update_available($section_id, $type, $count)
	{
		// get last available tickets
		$this->db->select('section_available');
		$this->db->where('section_id', $section_id);
		$query = $this->db->get($this->sections);
		$row = $query->row();
		
		$new_available = ($type == 'increase') ? $row->section_available += $count : $row->section_available -= $count;
		
		// update last available tickets
		$this->db->where('section_id', $section_id);
		$this->db->update($this->sections, array('section_available' => $new_available));
		
		return true;
	}
	
	
	
	// --------------------------------------------------------------------
	
	/**
	 * delete
	 *
	 */
	function delete($section_id)
	{
		$this->db->delete('sections', array('section_id' => $section_id));
		
		return true;
	}


	function getSectionsWithEventID($event_id = false,$sectionid = false){
	
	if($sectionid){
		$section_id_string = $sectionid;
	}else{
		$this->db->select('pc.price_sections');
		if ($event_id)
			{
				$this->db->where('pc.price_event_id', $event_id);
			}
			
			$this->db->join($this->events, 'pc.price_event_id = e.event_id', 'left');
			$this->db->order_by('pc.price_price', 'desc'); 
			$query = $this->db->get($this->prices);
			
			$array = $query->result();
			$item = array();

			foreach($array as $a) {
				$item[] = implode(',',unserialize($a->price_sections));

			}
	$section_id_string = implode(',',$item);
	}

	$result = null;
	// if($section_id_string){
	
	// $queryString = "SELECT `e`.`event_id`, `s`.`section_id`, `s`.`section_name`, `s`.`section_type`, `s`.`section_seat_config`, `s`.`section_stage_location`, `s`.`section_capacity`, `s`.`section_col_aisles`, `s`.`section_row_from`, `s`.`section_row_to`, `s`.`section_row_increment`, `s`.`section_col_from`, `s`.`section_col_to`, `s`.`section_col_increment`, `s`.`section_coords`
					// FROM (`sections` s) JOIN `events` e ON `e`.`event_seatplan_id` = `s`.`section_seatplan_id` WHERE `s`.`section_id` IN ( $section_id_string ) ORDER BY `s`.`section_id` DESC";
	
	// $query = $this->db->query($queryString);
	// $result = $query->result(); 
	// }
	
	return  $this->db->last_query();
	}
	
	
	function getCustomerInfo($event_id,$price_id,$section_id,$row,$seat){
		
		$status = array('done','paid_online','paid','reserved');
		
		$this->db->select('ticket_transaction_id');
		$this->db->where('ticket_event_id', $event_id);
		$this->db->where('ticket_section_id', $section_id);
		$this->db->where('ticket_price_id', $price_id);
		$this->db->where('ticket_row', $row);
		$this->db->where('ticket_seat', $seat);
		
		$query = $this->db->get('tickets');
		// return $sections = $query->row()->ticket_transaction_id;
		
		 $num = $query->num_rows();
		
		
		if($num==0){
			return 0;
		}else{
		return $query->result();
		}
		
	}
	
	//for kidzania 
	function get_ticket_availability_sections_kid($date, $sections, $seatplan_id = false, $unserialize = false)
	{
		
		$this->db->query('set transaction isolation level read uncommitted');


		if ($unserialize) {
			$arr_sections = unserialize($sections);
		} else {
			$arr_sections = array($sections);
		}
		
		if (empty($arr_sections)) { return array(); }
		
		foreach($arr_sections as $section_id) {
			$price_section_info['used'][$section_id] = 0;
			$price_section_info['capacity'][$section_id] = 0;
			$price_section_info['available'][$section_id] = 0;
			$price_section_info['available_db'][$section_id] = 0;
			$price_section_info['reserved'][$section_id] = 0;
			$price_section_info['type'][$section_id] = "";
		}
		
		// get capacity and default availability
		$this->db->select('section_id, section_capacity, section_type, section_available');
		$this->db->where_in('section_id', $arr_sections);
		$this->db->where('section_seatplan_id', $seatplan_id);
		
		$query = $this->db->get($this->sections);

		// filter out non-existingg section_id
		$arr_sections = array();
		
		foreach($query->result() as $row) {
			$section_id = $row->section_id;
			$arr_sections[] = $section_id;
			$capacity = $row->section_capacity;
			$price_section_info['capacity'][$section_id] = $capacity;
			
			// default value - if no seat is taken yet
			$price_section_info['available'][$section_id] = $capacity; 
			$price_section_info['type'][$section_id] = $row->section_type; 
			$price_section_info['available_db'][$section_id] = $row->section_available;
		}
		
		if (!empty($arr_sections)) {
			$this->db->query('set transaction isolation level read uncommitted');
			// get taken value
			$this->db->select('ticket_id , ticket_section_id,ticket_status');
			$this->db->join('transactions tr', 'ti.ticket_transaction_id = tr.transaction_id');
			$this->db->where('transaction_date_validity', $date);
			$this->db->where_in('ticket_section_id', $arr_sections);
			$this->db->where_in('ticket_status', array('reserved','done','selected','paid','paid_online'));
			// $this->db->group_by('ticket_id');
			$query = $this->db->get($this->tickets);
			 
			foreach($query->result() as $row) {
				$section_id = $row->ticket_section_id;
				$count_used = 1;
				$price_section_info['used'][$section_id] += $count_used;
				$total_capacity = $price_section_info['capacity'][$section_id];
				// $price_section_info['available'][$section_id] = $total_capacity - $count_used;
				
				//count reserved
				if($row->ticket_status == 'reserved'){
					 
				$section_id = $row->ticket_section_id;
				// $count_reserved += 1;
				$price_section_info['reserved'][$section_id] += 1;
				}
				
				
			}
			
			
			//update available
			foreach($query->result() as $row) {
			// $section_id = $row->section_id; 
			$section_id = $row->ticket_section_id; 
			// default value - if no seat is taken yet
			$price_section_info['available'][$section_id] =  $price_section_info['capacity'][$section_id] - $price_section_info['used'][$section_id];  
			}
			
			
   
			return $price_section_info;
			
			
		} else {
			return array();
		}

	}

	 
	function get_ticket_availability_kid($date ,$sections, $seatplan_id = false, $unserialize = false, $breakdown = false) {
		$ret = $this->get_ticket_availability_sections_kid($date , $sections, $seatplan_id, $unserialize);
		
		if (empty($ret)) { 
			return array(
					'total_capacity' => 0
					, 'total_used' => 0
					, 'total_reserved' => 0
					, 'total_available' => 0
					, 'total_available_db' => 0
					, 'type' => 'N/A'
				); 
		}

		$type = current($ret['type']);

		if ($breakdown) {
			$section_info = $ret;
		}
		
		$section_info['total_capacity'] = array_sum($ret['capacity']);
		$section_info['total_used'] = array_sum($ret['used']);
		$section_info['total_reserved'] = array_sum($ret['reserved']);
		$section_info['total_available'] = array_sum($ret['available']);
		$section_info['total_available_db'] = array_sum($ret['available_db']);
		$section_info['type'] = $type; 

		return $section_info;
	}
		// --------------------------------------------------------------------
	
	//lite version for big events
	function get_ticket_availability_sections_lite($sections, $seatplan_id = false, $unserialize = false)
	{
		
		$this->db->query('set transaction isolation level read uncommitted');


		if ($unserialize) {
			$arr_sections = unserialize($sections);
		} else {
			$arr_sections = array($sections);
		}
		
		if (empty($arr_sections)) { return array(); }
		
		foreach($arr_sections as $section_id) {
			$price_section_info['used'][$section_id] = 0;
			$price_section_info['capacity'][$section_id] = 0;
			$price_section_info['available'][$section_id] = 0;
			$price_section_info['available_db'][$section_id] = 0;
			$price_section_info['reserved'][$section_id] = 0;
			$price_section_info['type'][$section_id] = "";
		}
		
		// get capacity and default availability
		$this->db->select('section_id, section_capacity, section_type, section_available,section_reserved');
		$this->db->where_in('section_id', $arr_sections);
		$this->db->where('section_seatplan_id', $seatplan_id);
		
		$query = $this->db->get($this->sections);

		// filter out non-existingg section_id
		$arr_sections = array();
		
		foreach($query->result() as $row) {
			$section_id = $row->section_id;
			$arr_sections[] = $section_id;
			$capacity = $row->section_capacity;
			$price_section_info['capacity'][$section_id] = $capacity;
			
			// default value - if no seat is taken yet
			$price_section_info['available'][$section_id] = $row->section_available; 
			$price_section_info['type'][$section_id] = $row->section_type; 
			$price_section_info['available_db'][$section_id] = $row->section_available;
			$price_section_info['reserved'][$section_id] = $row->section_reserved;
		}
		
	 
			return $price_section_info;
		 

	}

	function get_ticket_availability_lite($sections, $seatplan_id = false, $unserialize = false, $breakdown = false) {
		$ret = $this->get_ticket_availability_sections_lite($sections, $seatplan_id, $unserialize);
		
		if (empty($ret)) { 
			return array(
					'total_capacity' => 0
					, 'total_used' => 0
					, 'total_reserved' => 0
					, 'total_available' => 0
					, 'total_available_db' => 0
					, 'type' => 'N/A'
				); 
		}

		$type = current($ret['type']);

		if ($breakdown) {
			$section_info = $ret;
		}
		
		$section_info['total_capacity'] = array_sum($ret['capacity']);
		$section_info['total_used'] = array_sum($ret['used']);
		$section_info['total_reserved'] = array_sum($ret['reserved']);
		$section_info['total_available'] = array_sum($ret['available']);
		$section_info['total_available_db'] = array_sum($ret['available_db']);
		$section_info['type'] = $type; 

		return $section_info;
	}
		// --------------------------------------------------------------------
	
	
	//lite version for updating of availability
	function get_ticket_availability_sections_lite_v2($sections, $seatplan_id = false, $unserialize = false)
	{
		
		$this->db->query('set transaction isolation level read uncommitted');


		if ($unserialize) {
			$arr_sections = unserialize($sections);
		} else {
			$arr_sections = array($sections);
		}
		
		if (empty($arr_sections)) { return array(); }
		
		foreach($arr_sections as $section_id) { 
			$price_section_info[$section_id]['capacity'] = 0;
			$price_section_info[$section_id]['available'] = 0;
			$price_section_info[$section_id]['used'] = 0;
			$price_section_info[$section_id]['reserved'] = 0;
			$price_section_info[$section_id]['last_update'] = 0;
 		}
		
		// get capacity and default availability
		$this->db->select('section_id, section_capacity, section_type,date_modified');
		$this->db->where_in('section_id', $arr_sections);
		$this->db->where('section_seatplan_id', $seatplan_id);
		
		$query = $this->db->get($this->sections);

		// filter out non-existingg section_id
		$arr_sections = array();
		
		foreach($query->result() as $row) {
			$section_id = $row->section_id;
			$arr_sections[] = $section_id;
			$capacity = $row->section_capacity;
			$price_section_info[$section_id]['capacity'] = $capacity; 
			// $price_section_info[$section_id]['available'] = $row->section_available;
			// $price_section_info[$section_id]['reserved'] = $row->section_reserved;
			$price_section_info[$section_id]['last_update'] = $row->date_modified;
		}
		
	 
			return $price_section_info;
		 

	}

		
	function update_ticket_availability_sections($sections, $seatplan_id = false, $unserialize = false)
	{
	 
		$this->db->query('set transaction isolation level read uncommitted');


		if ($unserialize) {
			$arr_sections = unserialize($sections);
		} else {
			$arr_sections = array($sections);
		}
		
		if (empty($arr_sections)) { return false; }
		
		foreach($arr_sections as $section_id) {
			$price_section_info['used'][$section_id] = 0;
			$price_section_info['capacity'][$section_id] = 0;
			$price_section_info['available'][$section_id] = 0;
			$price_section_info['available_db'][$section_id] = 0;
			$price_section_info['reserved'][$section_id] = 0;
			$price_section_info['type'][$section_id] = "";
		}
		
		// get capacity and default availability
		$this->db->select('section_id, section_capacity, section_type, section_available, date_modified');
		$this->db->where_in('section_id', $arr_sections);
		$this->db->where('section_seatplan_id', $seatplan_id);
		
		$query = $this->db->get($this->sections);

		// filter out non-existingg section_id
		$arr_sections = array();
		$last_update = '';
		foreach($query->result() as $row) {
			$section_id = $row->section_id;
			$arr_sections[] = $section_id;
			$capacity = $row->section_capacity;
 			$price_section_info['capacity'][$section_id] = $capacity;
			
			// default value - if no seat is taken yet
			$price_section_info['available'][$section_id] = $capacity; 
			// $price_section_info['reserved'][$section_id] = $reserved; 
			$price_section_info['type'][$section_id] = $row->section_type; 
			$price_section_info['available_db'][$section_id] = $row->section_available;
		
		
			if($last_update){ 
				if($last_update <= $row->date_modified){
					
					
					$last_update = $row->date_modified;
				}
				
			}else{
				 
				$last_update = $row->date_modified;
				
			}
		
		
		}
		
		
		//set udpate expiration
		
		$minutes = 1;
		$now = strtotime(date("Y-m-d H:i:s"));
		$expire_time = date("Y-m-d H:i:s", strtotime(date("Y-m-d H:i:s"))-($minutes*60));
		
		$date = date('Y-m-d', strtotime($expire_time));
		$newdate = strtotime('-1 day' , strtotime($expire_time));
		$newdate = date ( 'Y-m-d H:i:s' , $newdate );
		
	 
		if($last_update <= $expire_time){
			 
			// echo 'updated!' . '<br>';
		}else{
			 
			 
			// echo 'not for update'  . '<br>';
			return false;
		 
		}
		
		
		
			 
			
		
		if (!empty($arr_sections)) {
			
			
		/* 
			$this->db->query('set transaction isolation level read uncommitted');
			// get taken value
			$this->db->select('ticket_id , ticket_section_id,ticket_status');
			$this->db->where_in('ticket_section_id', $arr_sections);
			$this->db->where_in('ticket_status', array('reserved','done','selected','paid','paid_online'));
			// $this->db->group_by('ticket_id');
			$query2 = $this->db->get($this->tickets);
			 
			foreach($query2->result() as $row) {
				$section_id = $row->ticket_section_id;
				$count_used = 1;
				$price_section_info['used'][$section_id] += $count_used;
				$total_capacity = $price_section_info['capacity'][$section_id]; 
				 
				//count reserved
				if($row->ticket_status == 'reserved'){
					 
				$section_id = $row->ticket_section_id;
				// $count_reserved += 1;
				$price_section_info['reserved'][$section_id] += 1;
				}
				
				
			}
			
			
		 */		
		 
			
			$this->db->query('set transaction isolation level read uncommitted');
			// get taken value
			$this->db->select('count(1) as qty , ticket_section_id,ticket_status');
			$this->db->where_in('ticket_section_id', $arr_sections);
			$this->db->where_in('ticket_status', array('reserved','done','selected','paid','paid_online'));
			$this->db->group_by('ticket_section_id, ticket_status');
			$query2 = $this->db->get($this->tickets);
			 
			foreach($query2->result() as $row) {
				if(!isset($price_section_info['used'][$section_id])) $price_section_info['used'][$section_id] = 0;
				if(!isset($price_section_info['reserved'][$section_id])) $price_section_info['reserved'][$section_id] = 0;
				
				$section_id = $row->ticket_section_id;
				$count_used = $row->qty;
				$price_section_info['used'][$section_id] += $count_used;
				$total_capacity = $price_section_info['capacity'][$section_id]; 
				 
				//count reserved
				if($row->ticket_status == 'reserved'){
					 
				$section_id = $row->ticket_section_id;
				// $count_reserved += 1;
				$price_section_info['reserved'][$section_id] += $row->qty;
				}
				
				
			}
			
		
			//update available
			foreach($query->result() as $row) {
			$section_id = $row->section_id; 
			// default value - if no seat is taken yet
			$price_section_info['available'][$section_id] =  $price_section_info['capacity'][$section_id] - $price_section_info['used'][$section_id];  
			$available = $price_section_info['available'][$section_id];
			$reserved = $price_section_info['reserved'][$section_id];
			
			$data = array(
				   'section_reserved' => $reserved,
				   'section_available' => $available,
				   'section_xmap_config' => $now,
				 
			);

			$this->db->where('section_id', $section_id);
			$this->db->update('sections', $data); 

			
			
			}
			
			 
			
			
		} else {
			return false;
		}

	}

		
	function update_ticket_availability_sections_per_event($sections, $seatplan_id = false, $unserialize = false)
	{
		
		 
		$this->db->query('set transaction isolation level read uncommitted');


		if ($unserialize) {
			$arr_sections = unserialize($sections);
		} else {
			$arr_sections = array($sections);
		}
		
		if (empty($arr_sections)) { return false; }
		
		foreach($arr_sections as $section_id) {
			$price_section_info['used'][$section_id] = 0;
			$price_section_info['capacity'][$section_id] = 0;
			$price_section_info['available'][$section_id] = 0;
			$price_section_info['available_db'][$section_id] = 0;
			$price_section_info['reserved'][$section_id] = 0;
			$price_section_info['type'][$section_id] = "";
		}
		
		// get capacity and default availability
		$this->db->select('section_id, section_capacity, section_type, section_available, date_modified');
		$this->db->where_in('section_id', $arr_sections);
		$this->db->where('section_seatplan_id', $seatplan_id);
		
		$query = $this->db->get($this->sections);

		// filter out non-existingg section_id
		$arr_sections = array();
		$last_update = '';
		foreach($query->result() as $row) {
			$section_id = $row->section_id;
			$arr_sections[] = $section_id;
			$capacity = $row->section_capacity;
 			$price_section_info['capacity'][$section_id] = $capacity;
			
			// default value - if no seat is taken yet
			$price_section_info['available'][$section_id] = $capacity; 
			// $price_section_info['reserved'][$section_id] = $reserved; 
			$price_section_info['type'][$section_id] = $row->section_type; 
			$price_section_info['available_db'][$section_id] = $row->section_available;
		
		
			if($last_update){ 
				if($last_update <= $row->date_modified){
					
					
					$last_update = $row->date_modified;
				}
				
			}else{
				 
				$last_update = $row->date_modified;
				
			}
		
		
		}
		
		
		//set udpate expiration
		
		$minutes = 1;
		$now = strtotime(date("Y-m-d H:i:s"));
		$expire_time = date("Y-m-d H:i:s", strtotime(date("Y-m-d H:i:s"))-($minutes*60));
		
		$date = date('Y-m-d', strtotime($expire_time));
		$newdate = strtotime('-1 day' , strtotime($expire_time));
		$newdate = date ( 'Y-m-d H:i:s' , $newdate );
		
	 
		if($last_update <= $expire_time){
			 
			// echo 'updated!' . '<br>';
		}else{
			 
			 
			// echo 'not for update'  . '<br>';
			// return false;
		 
		}
		
		
		
		
			
		
		if (!empty($arr_sections)) {
			
			/*
		 
			$this->db->query('set transaction isolation level read uncommitted');
			// get taken value
			$this->db->select('ticket_id , ticket_section_id,ticket_status');
			$this->db->where_in('ticket_section_id', $arr_sections);
			$this->db->where_in('ticket_status', array('reserved','done','selected','paid','paid_online'));
			// $this->db->group_by('ticket_id');
			$query2 = $this->db->get($this->tickets);
			 
			foreach($query2->result() as $row) {
				$section_id = $row->ticket_section_id;
				$count_used = 1;
				$price_section_info['used'][$section_id] += $count_used;
				$total_capacity = $price_section_info['capacity'][$section_id]; 
				 
				//count reserved
				if($row->ticket_status == 'reserved'){
					 
				$section_id = $row->ticket_section_id;
				// $count_reserved += 1;
				$price_section_info['reserved'][$section_id] += 1;
				}
				
				
			}
		 
				
			 */	
			
			$this->db->query('set transaction isolation level read uncommitted');
			// get taken value
			$this->db->select('count(1) as qty , ticket_section_id,ticket_status');
			$this->db->where_in('ticket_section_id', $arr_sections);
			$this->db->where_in('ticket_status', array('reserved','done','selected','paid','paid_online'));
			$this->db->group_by('ticket_section_id, ticket_status');
			$query2 = $this->db->get($this->tickets);
			 
			foreach($query2->result() as $row) {
				if(!isset($price_section_info['used'][$section_id])) $price_section_info['used'][$section_id] = 0;
				if(!isset($price_section_info['reserved'][$section_id])) $price_section_info['reserved'][$section_id] = 0;
				
				$section_id = $row->ticket_section_id;
				$count_used = $row->qty;
				$price_section_info['used'][$section_id] += $count_used;
				$total_capacity = $price_section_info['capacity'][$section_id]; 
				 
				//count reserved
				if($row->ticket_status == 'reserved'){
					 
				$section_id = $row->ticket_section_id;
				// $count_reserved += 1;
				$price_section_info['reserved'][$section_id] += $row->qty;
				}
				
				
			}
			
		
		 
		
			//update available
			foreach($query->result() as $row) {
			$section_id = $row->section_id; 
			// default value - if no seat is taken yet
			$price_section_info['available'][$section_id] =  $price_section_info['capacity'][$section_id] - $price_section_info['used'][$section_id];  
			$available = $price_section_info['available'][$section_id];
			$reserved = $price_section_info['reserved'][$section_id];
			
			
			echo "$section_id : $available <br>"; 
			
			$data = array(
				   'section_reserved' => $reserved,
				   'section_available' => $available,
				   'section_xmap_config' => $now,
				 
			);

			$this->db->where('section_id', $section_id);
			$this->db->update('sections', $data); 

			
			
			}
			
			 
			
			
		} else {
			return false;
		}

	}

	
}
// END sections_model.php
/* Location: ./application/models/sections_model.php */	

