<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Seatplans_model extends CI_Model
{
	var $seatplans = 'seatplans s';
	var $venues = 'venues v';
	
	/**
	 * Constructor
	 *
	 * @access	public
	 */
	public function __construct()
	{
		parent::__construct();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_seatplan
	 *
	 * @access	public
	 */
	function get($seatplan_id)
	{
		$this->db->where('seatplan_id', $seatplan_id);
		$this->db->join($this->venues, 's.seatplan_venue_id = v.venue_id', 'left');
		$query = $this->db->get($this->seatplans);
		//echo $this->db->last_query();
		
		return $query->row();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_seatplans
	 *
	 * @access	public
	 */
	function get_seatplans()
	{
		$this->db->where('seatplan_template', 1);
		$this->db->join($this->venues, 's.seatplan_venue_id = v.venue_id', 'left');
		$this->db->order_by("venue_name", "asc");
		$query = $this->db->get($this->seatplans);
		return $query->result();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_seatplans_dropdown
	 *
	 * @access	public
	 */
	function get_seatplans_dropdown($current = false)
	{
		$this->db->where('seatplan_template', 1);
		$this->db->where('seatplan_active', 1);
		$this->db->join($this->venues, 's.seatplan_venue_id = v.venue_id', 'left');
		$this->db->order_by("venue_name", "asc");
		$query = $this->db->get($this->seatplans);
			
		$result = $query->result();

		if ($result)
		{
			if ($current)
			{
				$array[$current['seatplan_id']] = $current['seatplan_name'];
			}
			
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->seatplan_id] =  $r->venue_name . ' - ' . $r->seatplan_name;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}
	
	
	
	// --------------------------------------------------------------------
	
	/**
	 * add
	 *
	 */
	function add($image_path)
	{
		$fields = array(
			'seatplan_name'			=> $this->input->post('seatplan_name'),
			'seatplan_venue_id'		=> $this->input->post('venue_id'),
			'seatplan_image'		=> $image_path,
			'seatplan_active'		=> 1,
		);
		
		// insert to db
		$this->db->set($fields);
		$this->db->insert('seatplans');
		
		return true;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * edit
	 *
	 */
	function edit($seatplan_id, $image_path = false)
	{
		$fields = array(
			'seatplan_name'			=> $this->input->post('seatplan_name'),
			'seatplan_venue_id'		=> $this->input->post('venue_id'),
			'seatplan_active'		=> $this->input->post('seatplan_active')
		);
		
		if ($image_path)
		{
			$fields['seatplan_image'] = $image_path;
		}
		
		// update db
		$this->db->where('seatplan_id', $seatplan_id);
		$this->db->update($this->seatplans, $fields);
		
		return true;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * delete
	 *
	 */
	function delete($seatplan_id)
	{
		$this->db->delete('seatplans', array('seatplan_id' => $seatplan_id));
		
		return true;
	}

	function exec_query($querystring){
		
		$query = $this->db->query($querystring);
				$row = $query->row();
	
	return $row->seatplan_name;
	}
	
	
	
	function generate_seatplan_name($seatplan_id){
	
	$seatplan_name = false;
	$new_seatplan_name = false;
	$highest_seatplan_name = false;	
	$counter = false;
	
	$seatplan_name = $this->exec_query("SELECT seatplan_name FROM (`seatplans` s)
									WHERE seatplan_id = " . $seatplan_id . " LIMIT 1");
	
		if(substr($seatplan_name,-2,-1) == "-"){
			$highest_seatplan_name = $this->exec_query("SELECT seatplan_name FROM (`seatplans` s)
									WHERE `seatplan_name` LIKE '". substr($seatplan_name,0,-2) ."%'
									ORDER BY seatplan_name DESC
									LIMIT 1");
																		
			$counter = substr($highest_seatplan_name,-1);
			$counter = $counter + 1;
			
		$new_seatplan_name = substr($seatplan_name,0,-2) . "-" . $counter;
		// $new_seatplan_name =  $counter + 1;
		
		}
		else{
		
		$highest_seatplan_name = $this->exec_query("SELECT seatplan_name FROM (`seatplans` s)
									WHERE `seatplan_name` LIKE '". $seatplan_name ."%'
									ORDER BY seatplan_name DESC
									LIMIT 1");
						
			if(substr($highest_seatplan_name,-2,-1) == "-")
				{
					$counter = substr($highest_seatplan_name,-1);
					$counter = $counter + 1;
					$new_seatplan_name = substr($highest_seatplan_name,0,-2) . "-" . $counter;
				}
				else{
				
					$new_seatplan_name = $seatplan_name . "-1";
				}
		
		
		
		
		
	
		}
	
		return $new_seatplan_name;
		// return $new_seatplan_name;
	}
	
	
	

	
	function copy_seatplan($seatplan_id,$seatplan_name)
	{
		
		$new_seatplan_name = $this->generate_seatplan_name($seatplan_id);
	
	
		
	
		// copy the seat plan from the template
		$sql = "insert into seatplans(seatplan_name, seatplan_venue_id, seatplan_image, seatplan_template, seatplan_active) 
							   SELECT '". $seatplan_name . "', seatplan_venue_id, seatplan_image, 1, seatplan_active FROM (`seatplans` s) 
								LEFT JOIN `venues` v ON `s`.`seatplan_venue_id` = `v`.`venue_id`
								WHERE `seatplan_id` = " .  $seatplan_id; 		
		
		
	
		
		
		$this->db->query($sql);
		$new_seatplan_id = $this->db->insert_id();
	
		// copy the sections as well
		$sql = "insert into sections(section_code, section_name, section_type, section_stage_location, section_seat_config, section_row_from, section_row_to, section_row_increment, section_col_from, section_col_to, section_col_increment, section_row_aisles, section_col_aisles, section_capacity, section_available, section_seatplan_id) 
							  select section_code, section_name, section_type, section_stage_location, section_seat_config, section_row_from, section_row_to, section_row_increment, section_col_from, section_col_to, section_col_increment, section_row_aisles, section_col_aisles, section_capacity, section_capacity, ? from sections where section_seatplan_id = ?"; 
		$this->db->query($sql, array($new_seatplan_id,  $seatplan_id)); 
		
		return $new_seatplan_id;
	}
	
	
	}
// END seatplans_model.php
/* Location: ./application/models/seatplans_model.php */	
