<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Reportss_Model extends CI_Model
{
	var $seatplans = 'seatplans s';
	var $venues = 'venues v';
	var $prices = 'prices pc';	
	var $ticket_types = 'ticket_types tt';
	var $tickets = 'tickets ti';	
	var $events = 'events e';	
	var $transactions = 'transactions t';	
	var $terminals = 'terminals te';
	var $users = 'users u';	
	var $customers = 'customers c';	
	//var $rowcount;
	
	/**
	 * Constructor
	 *
	 * @access	public
	 */
	public function __construct()
	{
		parent::__construct();
	}
	// --------------------------------------------------------------------
	
	/**
	 * get_reports
	 *
	 * @access	public
	 */
 	function get_report_audit_trail($startdate = false, $enddate = false, $terminalid = false, $sellerid = false, $eventid = false, $transactionnum = false, $ticket_type = false)
	{
	
		$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->join($this->terminals, 'te.terminal_id = t.transaction_terminal_id');
		$this->db->join($this->users, 'u.user_id = t.transaction_user_id');
		$this->db->join($this->events, 'e.event_id = ti.ticket_event_id');
		$this->db->join($this->prices, 'pc.price_id = ti.ticket_price_id');
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id');
		$this->db->select('te.terminal_code, u.username, e.event_code, t.transaction_receipt_number, t.transaction_date, tt.ticket_type_code, pc.price_price, tt.ticket_type_discount_type, tt.ticket_type_discount, t.transaction_cash_payment, t.transaction_card_payment, t.transaction_gc_sm_payment, t.transaction_gc_sodeho_payment, t.transaction_mc_payment, t.transaction_other_payment, e.event_reservation_fee, ti.ticket_reservation_expiry, e.event_interest_fee, c.customer_firstname, c.customer_lastname, t.transaction_status');
		if($startdate != '' and $enddate != '')
		{
			//$this->db->where('t.transaction_date', '2010-08-02 16:10:50');
			//$this->db->where('t.transaction_date <=', '2010-08-02 23:59:59');
		}
		if($terminalid)
		{
			$this->db->where('te.terminal_code', $terminalid);
		}
		if($sellerid)
		{
			$this->db->where('u.username', $sellerid);
		}
		if($eventid)
		{
			$this->db->where('e.event_code', $eventid);
		}
		if($transactionnum)
		{
			$this->db->where('t.transaction_receipt_number', $transactionnum);
		}
		if($ticket_type)
		{
			$this->db->where('tt.ticket_type_code', $ticket_type);
		}
		$this->db->group_by(array("t.transaction_date", "te.terminal_code", "u.username", "e.event_code", "t.transaction_receipt_number", "tt.ticket_type_code"));
		$this->db->order_by('t.transaction_date');
		$this->db->order_by('t.transaction_receipt_number');
		$query = $this->db->get($this->transactions);
		return $query->result();
	}
	
	function get_report_audit_trail2($startdate = false, $enddate = false, $terminalid = false, $sellerid = false, $eventid = false, $transactionnum = false, $ticket_type = false)
	{
	
		$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->join($this->terminals, 'te.terminal_id = t.transaction_terminal_id');
		$this->db->join($this->users, 'u.user_id = t.transaction_user_id');
		$this->db->join($this->events, 'e.event_id = ti.ticket_event_id');
		$this->db->join($this->prices, 'pc.price_id = ti.ticket_price_id');
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id');
		$this->db->select('te.terminal_code, u.username, e.event_code, t.transaction_receipt_number, t.transaction_date, tt.ticket_type_code, pc.price_price, tt.ticket_type_discount_type, tt.ticket_type_discount, t.transaction_cash_payment, t.transaction_card_payment, t.transaction_gc_sm_payment, t.transaction_gc_sodeho_payment, t.transaction_mc_payment, t.transaction_other_payment, e.event_reservation_fee, ti.ticket_reservation_expiry, e.event_interest_fee, c.customer_firstname, c.customer_lastname, t.transaction_status');
		if($startdate != '' and $enddate != '')
		{
			//$this->db->where('t.transaction_date between "' . $startdate . ' 00:00:01" and "' . $enddate . ' 23:59:59"');
			//$this->db->where('t.transaction_date', '2010-08-02 16:10:50');
			//$this->db->where('t.transaction_date <=', '2010-08-02 23:59:59');
		}
		if($terminalid)
		{
			$this->db->where('te.terminal_code', $terminalid);
		}
		if($sellerid)
		{
			$this->db->where('u.username', $sellerid);
		}
		if($eventid)
		{
			$this->db->where('e.event_code', $eventid);
		}
		if($transactionnum)
		{
			$this->db->where('t.transaction_receipt_number', $transactionnum);
		}
		if($ticket_type)
		{
			$this->db->where('tt.ticket_type_code', $ticket_type);
		}
		//$this->db->group_by(array("t.transaction_date", "te.terminal_code", "u.username", "e.event_code"));
		$this->db->order_by('t.transaction_date');
		$this->db->order_by('t.transaction_receipt_number');
		$query = $this->db->get($this->transactions);
		return $query->result();
	}
	
	/*
	function get_report_audit_trail_count($ticket_type)
	{	
		$this->db->join($this->tickets, 'ti.ticket_type_id = tt.ticket_type_id');
		$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id');
		$this->db->join($this->terminals, 'te.terminal_id = t.transaction_terminal_id');
		$this->db->where('tt.ticket_type_id', $ticket_type);
		$this->db->where('t.transaction_date between "2010-07-28 00:00:01" and "2010-07-28 23:59:59"');
		$this->db->where('te.terminal_id', '1');
		$this->db->where('u.user_id', '1');
		$this->db->where('e.event_id', '1');
		$query = $this->db->count_all_results('ticket_types');
		//$rowcount = $query->num_rows();
		return $query->row();
	}
	*/
}
// END Reportss_Model.php
/* Location: ./application/models/Reportss_Model.php */	