<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Reports_model extends CI_Model
{
	var $transactions = 'transactions t';
	var $tickets = 'tickets ti';
	var $customers = 'customers c';
	var $terminals = 'terminals te';
	var $prices = 'prices pr';
	var $ticket_types = 'ticket_types tt';
	var $events = 'events ev';
	var $venues = 'venues ve';
	var $promoters = 'promoters pro';
	var $users	=	'users u';
	var $branches = 'branches br';
	
	/**
	 * Constructor
	 *
	 * @access	public
	 */
	public function __construct()
	{
		parent::__construct();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_branch
	 *
	 * @access	public
	 */
 	function get_branch($branch_id)
	{
		$this->db->where('branch_id', $branch_id);
		$this->db->join($this->users, 'u.user_branch_id = br.branch_id');
		$this->db->join($this->terminals, 'te.terminal_id = u.user_terminal_id');
		$query = $this->db->get($this->branches);
		
		return $query->row();
	}
		
	
	// --------------------------------------------------------------------
	
	/**
	 * get_users
	 *
	 * @access	public
	 */
 	function get_users($user_id)
	{
		$this->db->where('u.user_id', $user_id);
		$this->db->join($this->branches, 'br.branch_id = u.user_branch_id');
		$this->db->join($this->terminals, 'te.terminal_id = u.user_terminal_id');
		$query = $this->db->get($this->users);
		
		return $query->row();
	}

	// --------------------------------------------------------------------
	
	/**
	 * get_users_by_branch_id
	 *
	 * @access	public
	 */
 	function get_users_by_branch()
	{
		
		//$this->db->where('br.branch_id', $branch_id);
		//$this->db->join($this->branches, 'br.branch_id = u.user_branch_id');
		$this->db->order_by('user_firstname');
		$query = $this->db->get($this->users);
		$result = $query->result();
		if ($result)
		{
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->user_id] = $r->user_firstname.' '.$r->user_lastname;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}	
	
	// --------------------------------------------------------------------
	
	/**
	 * get_terminal_by_branch_id
	 *
	 * @access	public
	 */
 	function get_terminal_by_branch($branch_id)
	{
		
		$this->db->where('br.branch_id', $branch_id);
		$this->db->join($this->branches, 'br.branch_id = te.terminal_branch_id');
		$query = $this->db->get($this->terminals);
		$result = $query->result();
		if ($result)
		{
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->terminal_id] = $r->terminal_name;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_event_title
	 *
	 * @access	public
	 */
 	function get_event_title()
	{
		$this->db->order_by('event_date_time');
		$query = $this->db->get($this->events);
		$result = $query->result();
		if ($result)
		{
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->event_id] = $r->event_title;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}		
		
	// --------------------------------------------------------------------
	
	/**
	 * get_events
	 *
	 * @access	public
	 */
 	function get_events($event_id)
	{
		$this->db->where('ev.event_id', $event_id);
		$this->db->join($this->venues, 've.venue_id = ev.event_venue_id', 'left');
		$this->db->join($this->promoters, 'pro.promoter_id = ev.event_promoter_id', 'left');
		$query = $this->db->get($this->events);
		
		return $query->row();
	}	
	
	// --------------------------------------------------------------------
	
	/**
	 * get_ticket_types
	 *
	 * @access	public
	 */
 	function get_ticket_types()
	{
		$this->db->where('ticket_type_group', 0);
		$query = $this->db->get($this->ticket_types);
		
		return $query->result();
	}

	// --------------------------------------------------------------------
	
	/**
	 * get_ticket_types_2
	 *
	 * @access	public
	 */
 	function get_ticket_types_2()
	{
		$this->db->where('ticket_type_group', 1);
		$query = $this->db->get($this->ticket_types);
		
		return $query->result();
	}	
		
	// --------------------------------------------------------------------
	
	/**
	 * get_prices
	 *
	 * @access	public
	 */
	function prices($event_id = false)
	{
		if ($event_id)
		{
			$this->db->where('pr.price_event_id', $event_id);
		}
		$this->db->join($this->events, 'pr.price_event_id = ev.event_id', 'left');
		$this->db->order_by('pr.price_price', 'desc'); 
		$query = $this->db->get($this->prices);
		//echo $this->db->last_query();
		
		return $query->result();
	}	
	
	// --------------------------------------------------------------------
	
	/**
	 * get
	 *
	 * @access	public
	 */
	function get_prices($ticket_type_name, $price_id)
	{
	/*	$this->db->select('pr.price_price - (pr.price_price * (tt.ticket_type_discount / 100)) as price');
		$this->db->join($this->tickets, 'ti.ticket_price_id = pr.price_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		//$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id');
		$this->db->where('tt.ticket_type_name', $ticket_type_name);
		$this->db->where('pr.price_id ', $price_id);
		//$this->db->where('t.transaction_user_id ', $seller_id);
		$this->db->where('tt.ticket_type_group', $status);
		$this->db->group_by("tt.ticket_type_id"); 
		$query = $this->db->get('prices pr');
		
		if ($query->row('price') == null)
        {
            $prices = 0;
        }
        else
        {
            $prices = $query->row('price');
            //$prc_new = 1;
        }*/
		$this->db->select('price_price as price');
		$this->db->where('price_id', $price_id);
		$query = $this->db->get('prices');
		
		$my_price = $query->row('price');
		
		$this->db->select('ticket_type_discount as discount');
		$this->db->where('ticket_type_name', $ticket_type_name);
		$query = $this->db->get('ticket_types');
		$my_discount = $query->row('discount');
		
		$my_discounted_price = $my_price - (($my_price * $my_discount) / 100);
		return array($my_discounted_price);
	}	
	
	// --------------------------------------------------------------------
	
	/**
	 * get
	 *
	 * @access	public
	 */
	function ticket_qty($ticket_type_name, $price_id, $event_id, $status, $seller_id, $reports_date)
	{
	 	$this->db->select('ti.ticket_id');
		$this->db->join($this->prices, 'ti.ticket_price_id = pr.price_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id');
		$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id');
		$this->db->where('tt.ticket_type_name', $ticket_type_name);
		$this->db->where('pr.price_id ', $price_id);
		$this->db->where('ev.event_id ', $event_id);
		$this->db->where('tt.ticket_type_group', $status);
		$this->db->where('t.transaction_user_id ', $seller_id);
		$this->db->where('t.transaction_date >=', $reports_date.' 00:00:01');
		$this->db->where('t.transaction_date <=', $reports_date.' 23:59:59');
		$this->db->where('ti.ticket_status', 'done');
		$query = $this->db->count_all_results('tickets ti');
		//$query = $this->db->get($this->tickets);
		return $query;		
	}	
	
	// --------------------------------------------------------------------
	
	/**
	 * get amount
	 *
	 * @access	public
	 */
	function prc_amt($ticket_type_name, $price_id, $event_id, $status, $seller_id, $reports_date)
	{

		$this->db->select('pr.price_price - (pr.price_price * (tt.ticket_type_discount / 100)) as price');
		$this->db->join($this->tickets, 'ti.ticket_price_id = pr.price_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id');
		$this->db->where('tt.ticket_type_name', $ticket_type_name);
		$this->db->where('pr.price_id ', $price_id);
		$this->db->where('tt.ticket_type_group', $status);
		$this->db->where('t.transaction_user_id ', $seller_id);
		$this->db->where('t.transaction_date >=', $reports_date.' 00:00:01');
		$this->db->where('t.transaction_date <=', $reports_date.' 23:59:59');
		$this->db->where('ti.ticket_status', 'done');
		$this->db->group_by("tt.ticket_type_id"); 
		$prc = $this->db->get('prices pr');
		

		$this->db->select('ti.ticket_id');
		$this->db->join($this->prices, 'ti.ticket_price_id = pr.price_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id');
		$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id');
		$this->db->where('tt.ticket_type_name', $ticket_type_name);
		$this->db->where('pr.price_id ', $price_id);
		$this->db->where('ev.event_id ', $event_id);
		$this->db->where('tt.ticket_type_group', $status);
		$this->db->where('t.transaction_user_id ', $seller_id);
		$this->db->where('t.transaction_date >=', $reports_date.' 00:00:01');
		$this->db->where('t.transaction_date <=', $reports_date.' 23:59:59');
		$this->db->where('ti.ticket_status', 'done');
		$qty = $this->db->count_all_results('tickets ti');
		//$query = $this->db->get($this->tickets);
		
		if ($prc->row('price') == null)
        {
            $prc_new = 0;
        }
        else
        {
            $prc_new = $prc->row('price');
            //$prc_new = 1;
        }
		
		return array($prc_new, $qty);		
	}	
	
	// --------------------------------------------------------------------
	
	/**
	 * total quantity
	 *
	 * @access	public
	 */
	function total_qty($price_id, $event_id, $status, $seller_id, $reports_date)
	{
	 	$this->db->select('ti.ticket_id');
		$this->db->join($this->prices, 'ti.ticket_price_id = pr.price_id');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id');
		$this->db->where('pr.price_id ', $price_id);
		$this->db->where('ev.event_id ', $event_id);
		$this->db->where('tt.ticket_type_group', $status);
		$this->db->where('t.transaction_user_id ', $seller_id);
		$this->db->where('t.transaction_date >=', $reports_date.' 00:00:01');
		$this->db->where('t.transaction_date <=', $reports_date.' 23:59:59');
		$this->db->where('ti.ticket_status', 'done');
		$query = $this->db->count_all_results('tickets ti');
		return $query;		
	}		
	
	// --------------------------------------------------------------------
	
	/**
	 * total amount
	 *
	 * @access	public
	 */
	function total_amount($ticket_type_name, $price_id, $event_id, $status)
	{
		$this->db->select('pr.price_price - (pr.price_price * (tt.ticket_type_discount / 100)) as price');
		$this->db->join($this->tickets, 'ti.ticket_price_id = pr.price_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->where('tt.ticket_type_name', $ticket_type_name);
		$this->db->where('pr.price_id ', $price_id);
		$this->db->where('tt.ticket_type_group', $status);
		$this->db->where('ti.ticket_status', 'done');
		$this->db->group_by("tt.ticket_type_id"); 
		$query = $this->db->get('prices pr');
		return $query->row();		
	}	
	
	// --------------------------------------------------------------------
	
	/**
	 * total sales quantity
	 *
	 * @access	public
	 */
	function total_sales_qty($ticket_type_name, $event_id, $status, $seller_id, $reports_date)
	{
	 	$this->db->select('ti.ticket_id');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id');
		$this->db->where('ev.event_id ', $event_id);
		$this->db->where('tt.ticket_type_name', $ticket_type_name);
		$this->db->where('tt.ticket_type_group', $status);
		$this->db->where('t.transaction_user_id ', $seller_id);
		$this->db->where('t.transaction_date >=', $reports_date.' 00:00:01');
		$this->db->where('t.transaction_date <=', $reports_date.' 23:59:59');
		$this->db->where('ti.ticket_status', 'done');
		$query = $this->db->count_all_results('tickets ti');
		return $query;		
	}	

	// --------------------------------------------------------------------
	
	/**
	 * total salesamount
	 *
	 * @access	public
	 */
	function total_sales_amount($ticket_type_name, $event_id, $status, $seller_id, $reports_date)
	{
		$this->db->select('sum(pr.price_price - ((pr.price_price * tt.ticket_type_discount)/100)) as price');
		$this->db->join($this->tickets, 'ti.ticket_price_id = pr.price_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id');
		$this->db->where('ti.ticket_event_id', $event_id);
		$this->db->where('tt.ticket_type_name', $ticket_type_name);
		$this->db->where('tt.ticket_type_group', $status);
		$this->db->where('t.transaction_user_id ', $seller_id);
		$this->db->where('t.transaction_date >=', $reports_date.' 00:00:01');
		$this->db->where('t.transaction_date <=', $reports_date.' 23:59:59');
		$this->db->where('ti.ticket_status', 'done');
		$query = $this->db->get('prices pr');
		
		if ($query->row('price') == null)
        {
            $querys = 0;
        }
        else
        {
            $querys = $query->row('price');
            //$prc_new = 1;
        }
		
		return array($querys);		
	}	

	// NEW SALES BREAKDOWN WITHOUT VOID--------------------------------------------------------------------
	
	/**
	 * total salesamount
	 *
	 * @access	public
	 */
	function sales_breakdown_amt($event_id, $seller_id, $reports_date, $action, $action2)
	{
		switch($action2)
		{
			case 'QTY':	{	
							$this->db->select('count(ti.ticket_id) as price');
							break;
						}
			case 'AMT':	{	
							$this->db->select('sum(pr.price_price - ((pr.price_price * tt.ticket_type_discount)/100)) as price');
							break;
						}
		}
		
		$this->db->join($this->tickets, 'ti.ticket_price_id = pr.price_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id');
		$this->db->where('ti.ticket_event_id', $event_id);
		//$this->db->where('tt.ticket_type_name', $ticket_type_name);
		$this->db->where('t.transaction_user_id ', $seller_id);
		$this->db->where('t.transaction_date >=', $reports_date.' 00:00:01');
		$this->db->where('t.transaction_date <=', $reports_date.' 23:59:59');
		$this->db->where('tt.ticket_type_group', '0');
		$this->db->where('ti.ticket_status', 'done');
		switch($action)
		{
			case 'CASH':{	$this->db->where('t.transaction_cash_payment >', 0);	break;}
			case 'CARD':{	$this->db->where('t.transaction_card_payment >', 0);	break;}			
		}
		
		
		$query = $this->db->get('prices pr');
		
		if ($query->row('price') == null)
        {
            $querys = 0;
        }
        else
        {
            $querys = $query->row('price');
            //$prc_new = 1;
        }
		
		return array($querys);		
	}
		
	// SALES BREAKDOWN
	// --------------------------------------------------------------------
	
	/**
	 * CASH,CARD,GC_SM,GC_SODEXHO
	 *
	 * @access	public
	 */
	function payment_type($event_id, $payment_type, $qty_amt, $seller_id, $reports_date)
	{
		switch($qty_amt)
		{
			case 'QTY':	{ $this->db->select('COUNT(ti.ticket_id) as payment_qty');	break;}
			case 'AMT':	{ 
							switch($payment_type)
							{
								case 'CASH':		{	$this->db->select('SUM(DISTINCT(t.transaction_cash_payment)) as payment_amt'); break;}
								case 'CARD':		{	$this->db->select('SUM(DISTINCT(t.transaction_card_payment)) as payment_amt'); break;}
								case 'GC-SM':		{	$this->db->select('SUM(DISTINCT(t.transaction_gc_sm_payment)) as payment_amt'); break;}
								case 'GC-SODEXHO':	{	$this->db->select('SUM(DISTINCT(t.transaction_gc_sodeho_payment)) as payment_amt'); break;}
								case 'OTHER_PAYMENTS':	{	$this->db->select('SUM(DISTINCT(t.transaction_other_payment )) as payment_amt'); break;}
							}
							break;
						}
		}
		
		$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id');
		//$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id');
		$this->db->where('ti.ticket_event_id', $event_id);
		$this->db->where('t.transaction_user_id ', $seller_id);
		$this->db->where('t.transaction_date >=', $reports_date.' 00:00:01');
		$this->db->where('t.transaction_date <=', $reports_date.' 23:59:59');
		
		switch($qty_amt)
		{
		case 'QTY' :
		  {
			switch($payment_type)
			{
				case 'CASH': 		{ 
										$this->db->where('t.transaction_cash_payment >', 0);	
										$this->db->where('t.transaction_card_payment ', 0);
										$this->db->where('t.transaction_gc_sodeho_payment ', 0);
										$this->db->where('t.transaction_gc_sodeho_payment ', 0);
										$this->db->where('t.transaction_other_payment ', 0);
										break;
									}
				case 'CARD': 		{ 
										$this->db->where('t.transaction_cash_payment ', 0);
										$this->db->where('t.transaction_card_payment >', 0);	
										$this->db->where('t.transaction_gc_sodeho_payment ', 0);
										$this->db->where('t.transaction_gc_sodeho_payment ', 0);
										$this->db->where('t.transaction_other_payment ', 0);
										break;
									}
				case 'GC-SM': 		{ $this->db->where('t.transaction_gc_sm_payment >', 0);	break;}
				case 'GC-SODEXHO': 	{ $this->db->where('t.transaction_gc_sodeho_payment >', 0);	break;}
				case 'OTHER_PAYMENTS': 	{ 
											$this->db->where('t.transaction_cash_payment ', 0);
											$this->db->where('t.transaction_card_payment ', 0);	
											$this->db->where('t.transaction_gc_sodeho_payment ', 0);
											$this->db->where('t.transaction_gc_sodeho_payment ', 0);
											$this->db->where('t.transaction_other_payment >', 0);	
										
											break;
										}
				case 'MULTI': 		{ 
										$this->db->where('t.transaction_cash_payment >', 0);
										$this->db->where('t.transaction_card_payment >', 0);	
										//$this->db->where('t.transaction_gc_sodeho_payment ', 0);
										//$this->db->where('t.transaction_gc_sodeho_payment ', 0);
										//$this->db->where('t.transaction_other_payment >', 0);
										break;
									}
		  	}
		   }
		case 'AMT':
		  {
		  	switch($payment_type)
			{
		  		case 'CASH': {	$this->db->where('t.transaction_cash_payment >', 0);	break;}
				case 'CARD': {	$this->db->where('t.transaction_card_payment >', 0);	break;}
				case 'GC-SM': 		{ $this->db->where('t.transaction_gc_sm_payment >', 0);	break;}
				case 'GC-SODEXHO': 	{ $this->db->where('t.transaction_gc_sodeho_payment >', 0);	break;}
				case 'OTHER_PAYMENTS':{	$this->db->where('t.transaction_other_payment >', 0);	break;}
		  	}
			break;
		  }
		}
		$this->db->where('ti.ticket_status', 'done');
		$query = $this->db->get('transactions t');
		return $query->row();		
	}	

	// --------------------------------------------------------------------
	
	/**
	 * OTHER INCOME (RESERVATION OR SERVICE) QTY
	 *
	 * @access	public
	 */
	function other_income_qty($event_id, $type, $seller_id, $reports_date)
	{
		$this->db->select('count( ti.ticket_id ) as other_income_qty');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id');
		$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id');
		$this->db->where('ti.ticket_event_id', $event_id);
		$this->db->where('t.transaction_user_id ', $seller_id);
		$this->db->where('t.transaction_date >=', $reports_date.' 00:00:01');
		$this->db->where('t.transaction_date <=', $reports_date.' 23:59:59');
		switch($type)
		{
			case 'R' : {	$this->db->where('ti.ticket_reservation_expiry !=', '0000-00-00'); break;}
			case 'S' : {	$this->db->where('ti.ticket_reservation_expiry  =', '0000-00-00'); break;}
		}
		$query = $this->db->get('tickets ti');
		return $query->row();		
	}	
	
	// --------------------------------------------------------------------
	
	/**
	 * OTHER INCOME (RESERVATION OR SERVICE) AMT
	 *
	 * @access	public
	 */
	function other_income_amt($event_id, $type)
	{
		switch($type)
		{
			case 'R':	{	$this->db->select('event_reservation_fee'); break;}
			case 'S':	{	$this->db->select('event_interest_fee'); break;}
		}
		$this->db->where('event_id', $event_id);
		$query = $this->db->get('events');
		return $query->row();		
	}	

	// --------------------------------------------------------------------
	
	/**
	 * FILTER REPORTS
	 *
	 * @access	public
	 */
	function reports_filter($reports)
	{
		switch($reports)
		{
		case 'SELLER':
			{
				$date = $this->input->post('reports_date');
				//$date = new DateTime($this->input->post('reports_date'));
				//date_time_set($date, 00,00,01);	
				$user_id = $this->input->post('user_id');
				$event_id = $this->input->post('event_id');
				//return array('reports_date' => date_format($date, 'Y-m-d'), 'user_id' => $user_id, 'event_id' => $event_id);
				return array('reports_date' => $date, 'user_id' => $user_id, 'event_id' => $event_id);
				break;
			}
		case 'AUDIT':
			{
				$date_to = $this->input->post('reports_date_to');
				//$date_to = new DateTime($this->input->post('reports_date_to'));
				//date_time_set($date_to, 00,00,01);	
				
				$date_from = $this->input->post('reports_date_from');
				//$date_from = new DateTime($this->input->post('reports_date_from'));
				//date_time_set($date_to, 00,00,01);	
				
				$user_id = $this->input->post('user_id');
				$event_id = $this->input->post('event_id');
				
				//return array('reports_date_to' => date_format($date_to, 'Y-m-d'),'reports_date_from' => date_format($date_from, 'Y-m-d'), 'user_id' => $user_id, 'event_id' => $event_id);
				return array('reports_date_to' => $date_to, 'reports_date_from' => $date_from, 'user_id' => $user_id, 'event_id' => $event_id);
				break;
			}	
		case 'ADVANCE':
			{
				$date_to = $this->input->post('reports_date_to');
				//$date_to = new DateTime($this->input->post('reports_date_to'));
				//date_time_set($date_to, 00,00,01);	
				
				$date_from = $this->input->post('reports_date_from');
				//$date_from = new DateTime($this->input->post('reports_date_from'));
				//date_time_set($date_to, 00,00,01);	
				
				$event_id = $this->input->post('event_id');
				
				//return array('reports_date_to' => date_format($date_to, 'Y-m-d'),'reports_date_from' => date_format($date_from, 'Y-m-d'), 'event_id' => $event_id);
				return array('reports_date_to' => $date_to, 'reports_date_from' => $date_from, 'event_id' => $event_id);
				break;
			}	
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * FILTER REPORTS
	 *
	 * @access	public
	 */
	function reports_filter2($reports)
	{
		switch($reports)
		{
		case 'SELLER':
			{
				$date = $this->input->post('reports_date');
				//$date = new DateTime($this->input->post('reports_date'));
				//date_time_set($date, 00,00,01);	
				$user_id = $this->input->post('user_id');
				$event_id = $this->input->post('event_id');
				//return array('reports_date' => date_format($date, 'Y-m-d'), 'user_id' => $user_id, 'event_id' => $event_id);
				return array('reports_date' => $date, 'user_id' => $user_id, 'event_id' => $event_id);
				break;
			}
		case 'AUDIT':
			{
				$date_to = $this->input->post('reports_date_to');
				//$date_to = new DateTime($this->input->post('reports_date_to'));
				//date_time_set($date_to, 00,00,01);	
				
				$date_from = $this->input->post('reports_date_from');
				//$date_from = new DateTime($this->input->post('reports_date_from'));
				//date_time_set($date_to, 00,00,01);	
				
				$branch_id = $this->input->post('branch_id');
				$event_id = $this->input->post('event_id');
				
				//return array('reports_date_to' => date_format($date_to, 'Y-m-d'),'reports_date_from' => date_format($date_from, 'Y-m-d'), 'user_id' => $user_id, 'event_id' => $event_id);
				return array('reports_date_to' => $date_to, 'reports_date_from' => $date_from, 'branch_id' => $branch_id, 'event_id' => $event_id);
				break;
			}	
		case 'ADVANCE':
			{
				$date_to = $this->input->post('reports_date_to');
				//$date_to = new DateTime($this->input->post('reports_date_to'));
				//date_time_set($date_to, 00,00,01);	
				
				$date_from = $this->input->post('reports_date_from');
				//$date_from = new DateTime($this->input->post('reports_date_from'));
				//date_time_set($date_to, 00,00,01);	
				
				$event_id = $this->input->post('event_id');
				
				//return array('reports_date_to' => date_format($date_to, 'Y-m-d'),'reports_date_from' => date_format($date_from, 'Y-m-d'), 'event_id' => $event_id);
				return array('reports_date_to' => $date_to, 'reports_date_from' => $date_from, 'event_id' => $event_id);
				break;
			}	
		}
	}	

	// --------------------------------------------------------------------
	
	/**
	 * number of tickets
	 *
	 * @access	public
	 */
	function no_of_tickets($event_id, $seller_id, $status, $seller_id, $reports_date)
	{
	 	$this->db->select('count(ti.ticket_id) as no_of_tickets');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id');
		$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id');
		$this->db->where('t.transaction_date >=', $reports_date.' 00:00:01');
		$this->db->where('t.transaction_date <=', $reports_date.' 23:59:59');
		$this->db->where('ev.event_id ', $event_id);
		
		
		switch($status)
		{
			case 'ALL': 	{	/*$this->db->where('ti.ticket_status', 'done')*/; break;}
			case 'VOID': 	{ 	$this->db->where('ti.ticket_status', 'voided');		break;}
			case 'CANCEL': 	{ 	$this->db->where('ti.ticket_status', 'cancelled');	break;}
		}
		
		$this->db->where('t.transaction_user_id ', $seller_id);
		$query = $this->db->get('tickets ti');
		return $query->row();		
	}	
		
	
	// --------------------------------------------------------------------
	
	/**
	 * number of transaction
	 *
	 * @access	public
	 */
	function no_of_tickets2($event_id, $seller_id, $status, $seller_id, $reports_date)
	{
		switch($status)
		{
			case 'ALL':	{	$this->db->select('count(distinct(t.transaction_id)) as no_of_tickets');	break;}
			case 'VOID':	{	$this->db->select('count(ti.ticket_id) as no_of_tickets');	break;}
		}
	 	
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id');
		$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id');
		$this->db->where('ev.event_id ', $event_id);
		$this->db->where('t.transaction_user_id ', $seller_id);
		$this->db->where('t.transaction_date >=', $reports_date.' 00:00:01');
		$this->db->where('t.transaction_date <=', $reports_date.' 23:59:59');
		
		switch($status)
		{
			case 'ALL': { $this->db->where('t.transaction_status', 'done');	break;}
			case 'VOID': { $this->db->where('ti.ticket_status', 'voided'); break;}
			//case 'CANCEL': { $this->db->where('t.transaction_status', 'cancelled'); break;}
		}
		
		$query = $this->db->get('tickets ti');
		return $query->row();		
	}

	// --------------------------------------------------------------------
	
	/**
	 * BLANK TICKET FROM SERIES
	 *
	 * @access	public
	 */
	function blank_ticket($seller_id, $reports_date)
	{
		$this->db->where('session_user_id', $seller_id);
		$this->db->where('session_date_time >=', $reports_date.' 00:00:01');
		$this->db->where('session_date_time <=', $reports_date.' 23:59:59');	
		$this->db->where('session_beginning_serial >', '0');
		$this->db->where('session_ending_serial >', '0');	
		$this->db->order_by('session_date_time', 'desc'); 
		$query = $this->db->get('sessions');
		
		
		return $query->result();		
	}			
	
//---------------------AUDIT TRAIL REPORTS

	// --------------------------------------------------------------------
	
	/**
	 * GET ALL AUDIT TRAIL REPORTS
	 *
	 * @access	public
	 */
	function get_audit_date($action, $date_from, $date_to, $seller)
	{
		//$q = 'DATE_FORMAT(t.transaction_date,%Y-%m-%d'.'')'';
		switch($action)
		{
			case 'GROUP':
				{
					$this->db->select('date(t.transaction_date) as trans_date, t.transaction_date, br.branch_name, u.user_id, te.terminal_name, u.user_firstname, u.user_lastname');
					break;
				}
		}
		
		$this->db->join($this->branches, 'br.branch_id = t.transaction_branch_id');
		$this->db->join($this->users, 'u.user_id = t.transaction_user_id');
		$this->db->join($this->terminals, 'te.terminal_id = t.transaction_terminal_id');
		$this->db->where('t.transaction_date >=', $date_from.' 00:00:01');
		$this->db->where('t.transaction_date <=', $date_to.' 23:59:59');
		$this->db->where('t.transaction_user_id', $seller); 
		switch($action)
		{
			case 'GROUP':
				{
					$this->db->group_by('trans_date');
					break;
				}
		}
		$this->db->order_by('t.transaction_date', 'asc');
		$query = $this->db->get('transactions t');
		return $query->result();		
	}		//select date(transaction_date) as trans_date from transactions group by (trans_date)
	
	// --------------------------------------------------------------------
	
	/**
	 * GET ALL AUDIT TRAIL REPORTS
	 *
	 * @access	public
	 */
<<<<<<< .mine
	function get_audit_date2($action, $date_from, $date_to, $branch)
	{
		//$q = 'DATE_FORMAT(t.transaction_date,%Y-%m-%d'.'')'';
		switch($action)
		{
			case 'GROUP':
				{
					$this->db->select('date(t.transaction_date) as trans_date, t.transaction_date, t.transaction_branch_id, t.transaction_user_id');
					break;
				}
		}
		
		//$this->db->join($this->branches, 'br.branch_id = t.transaction_branch_id');
		$this->db->join($this->users, 'u.user_id = t.transaction_user_id');
		$this->db->where('t.transaction_date >=', $date_from.' 00:00:01');
		$this->db->where('t.transaction_date <=', $date_to.' 23:59:59');
		$this->db->where('t.transaction_branch_id', $branch); 
		switch($action)
		{
			case 'GROUP':
				{
					$this->db->group_by(array("trans_date", "u.user_id"));
					break;
				}
		}
		$this->db->order_by('trans_date', 'asc');
		$query = $this->db->get('transactions t');
		return $query->result();		
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * GET ALL AUDIT TRAIL REPORTS
	 *
	 * @access	public
	 */
=======
	function get_audit_date2($action, $date_from, $date_to, $branch)
	{
		//$q = 'DATE_FORMAT(t.transaction_date,%Y-%m-%d'.'')'';
		switch($action)
		{
			case 'GROUP':
				{
					$this->db->select('date(t.transaction_date) as trans_date, t.transaction_date, br.branch_name, u.user_id, te.terminal_name, u.user_firstname, u.user_lastname');
					break;
				}
		}
		
		$this->db->join($this->branches, 'br.branch_id = t.transaction_branch_id');
		$this->db->join($this->users, 'u.user_id = t.transaction_user_id');
		$this->db->join($this->terminals, 'te.terminal_id = t.transaction_terminal_id');
		$this->db->where('t.transaction_date >=', $date_from.' 00:00:01');
		$this->db->where('t.transaction_date <=', $date_to.' 23:59:59');
		$this->db->where('br.branch_id', $branch); 
		switch($action)
		{
			case 'GROUP':
				{
					$this->db->group_by('trans_date');
					break;
				}
		}
		$this->db->order_by('t.transaction_date', 'asc');
		$query = $this->db->get('transactions t');
		return $query->result();		
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * GET ALL AUDIT TRAIL REPORTS
	 *
	 * @access	public
	 */
>>>>>>> .r281
	function get_audit_all_events($action, $date_from, $date_to, $seller_id, $event_id)
	{
		$this->db->join($this->branches, 'br.branch_id = t.transaction_branch_id');
		$this->db->join($this->users, 'u.user_id = t.transaction_user_id');
		$this->db->join($this->terminals, 'te.terminal_id = t.transaction_terminal_id');
		$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id');
		$this->db->where('t.transaction_user_id', $seller_id);	
		$this->db->where('t.transaction_date >=', $date_from.' 00:00:01');
		$this->db->where('t.transaction_date <=', $date_to.' 23:59:59');
		//$this->db->order_by('t.transaction_date', 'asc');
		switch($action)
		{
			case 'ALL': 
				{
					$this->db->where('ti.ticket_event_id', $event_id);
					//$this->db->group_by('ti.ticket_type_id');	
					$this->db->order_by('t.transaction_id', 'asc'); 
					break;
				}
			case 'GROUP': 
				{	
					$this->db->group_by('ti.ticket_event_id');	
					$this->db->order_by('ti.ticket_event_id', 'asc'); 
					break;
				}
		}
		
		
		$query = $this->db->get('transactions t');
		return $query->result();		
	}

	// --------------------------------------------------------------------
	
	/**
	 * GET ALL AUDIT TRAIL REPORTS
<<<<<<< .mine
	 *
	 * @access	public
	 */
	function get_audit_all_events2($action, $date_from, $date_to, $branch_id, $seller_id, $event_id)
	{
		$this->db->join($this->branches, 'br.branch_id = t.transaction_branch_id');
		$this->db->join($this->users, 'u.user_id = t.transaction_user_id');
		$this->db->join($this->terminals, 'te.terminal_id = t.transaction_terminal_id');
		$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id');
		$this->db->where('t.transaction_user_id', $seller_id);
		$this->db->where('br.branch_id', $branch_id);	
		$this->db->where('t.transaction_date >=', $date_from.' 00:00:01');
		$this->db->where('t.transaction_date <=', $date_to.' 23:59:59');
		//$this->db->order_by('t.transaction_date', 'asc');
		switch($action)
		{
			case 'ALL': 
				{
					$this->db->where('ti.ticket_event_id', $event_id);
					//$this->db->group_by('ti.ticket_type_id');	
					$this->db->order_by('t.transaction_id', 'asc'); 
					break;
				}
			case 'GROUP': 
				{	
					$this->db->group_by('ti.ticket_event_id');	
					$this->db->order_by('ti.ticket_event_id', 'asc'); 
					break;
				}
		}
		
		
		$query = $this->db->get('transactions t');
		return $query->result();		
	}

	// --------------------------------------------------------------------
	
	/**
	 * GET ALL AUDIT TRAIL REPORTS
	 *
	 * @access	public
	 */
	function get_audit_all_sellers($action, $date_from, $date_to, $branch_id, $seller_id)
	{
		$this->db->join($this->branches, 'br.branch_id = t.transaction_branch_id');
		$this->db->join($this->users, 'u.user_id = t.transaction_user_id');
		//$this->db->join($this->terminals, 'te.terminal_id = t.transaction_terminal_id');
		$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id');
		$this->db->where('u.user_id', $seller_id);
		$this->db->where('br.branch_id', $branch_id);	
		$this->db->where('t.transaction_date >=', $date_from.' 00:00:01');
		$this->db->where('t.transaction_date <=', $date_to.' 23:59:59');
		//$this->db->order_by('t.transaction_date', 'asc');
		switch($action)
		{
			case 'ALL': 
				{
					$this->db->where('t.transaction_user_id', $event_id);
					//$this->db->group_by('ti.ticket_type_id');	
					$this->db->order_by('t.transaction_user_id', 'asc'); 
					break;
				}
			case 'GROUP': 
				{	
					$this->db->group_by('u.user_id');	
					$this->db->order_by('u.user_id', 'asc'); 
					break;
				}
		}
		
		
		$query = $this->db->get('transactions t');
		return $query->result();		
	}

	// --------------------------------------------------------------------
	
	/**
	 * GET ALL AUDIT TRAIL REPORTS
=======
	 *
	 * @access	public
	 */
	function get_audit_all_events2($action, $date_from, $date_to, $branch_id, $seller_id, $event_id)
	{
		$this->db->join($this->branches, 'br.branch_id = t.transaction_branch_id');
		$this->db->join($this->users, 'u.user_id = t.transaction_user_id');
		$this->db->join($this->terminals, 'te.terminal_id = t.transaction_terminal_id');
		$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id');
		$this->db->where('t.transaction_user_id', $seller_id);
		$this->db->where('br.branch_id', $branch_id);	
		$this->db->where('t.transaction_date >=', $date_from.' 00:00:01');
		$this->db->where('t.transaction_date <=', $date_to.' 23:59:59');
		//$this->db->order_by('t.transaction_date', 'asc');
		switch($action)
		{
			case 'ALL': 
				{
					$this->db->where('ti.ticket_event_id', $event_id);
					//$this->db->group_by('ti.ticket_type_id');	
					$this->db->order_by('t.transaction_id', 'asc'); 
					break;
				}
			case 'GROUP': 
				{	
					$this->db->group_by('ti.ticket_event_id');	
					$this->db->order_by('ti.ticket_event_id', 'asc'); 
					break;
				}
		}
		
		
		$query = $this->db->get('transactions t');
		return $query->result();		
	}

	// --------------------------------------------------------------------
	
	/**
	 * GET ALL AUDIT TRAIL REPORTS
	 *
	 * @access	public
	 */
	function get_audit_all_sellers($action, $date_from, $date_to, $branch_id, $seller_id)
	{
		$this->db->join($this->branches, 'br.branch_id = t.transaction_branch_id');
		$this->db->join($this->users, 'u.user_id = t.transaction_user_id');
		$this->db->join($this->terminals, 'te.terminal_id = t.transaction_terminal_id');
		$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id');
		$this->db->where('u.user_id', $seller_id);
		$this->db->where('br.branch_id', $branch_id);	
		$this->db->where('t.transaction_date >=', $date_from.' 00:00:01');
		$this->db->where('t.transaction_date <=', $date_to.' 23:59:59');
		//$this->db->order_by('t.transaction_date', 'asc');
		switch($action)
		{
			case 'ALL': 
				{
					$this->db->where('t.transaction_user_id', $event_id);
					//$this->db->group_by('ti.ticket_type_id');	
					$this->db->order_by('t.transaction_user_id', 'asc'); 
					break;
				}
			case 'GROUP': 
				{	
					$this->db->group_by('t.transaction_user_id');	
					$this->db->order_by('t.transaction_user_id', 'asc'); 
					break;
				}
		}
		
		
		$query = $this->db->get('transactions t');
		return $query->result();		
	}

	// --------------------------------------------------------------------
	
	/**
	 * GET ALL AUDIT TRAIL REPORTS
>>>>>>> .r281
	 *	GET TRANSACTION GROUP BY TT
	 * @access	public
	 */
	function get_transaction_group_by_tt($transaction_id, $action, $ticket_type)
	{
		switch($action)
		{
			case 'COUNT':	{	$this->db->select('count(t.transaction_id) as qty'); break;}
			case 'AMOUNT':	{	$this->db->select('sum(pr.price_price - ((pr.price_price * tt.ticket_type_discount)/100)) as price'); break;}
		}
		$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->join($this->customers, 't.transaction_customer_id = c.customer_id');
		switch($action)
		{
			case 'AMOUNT':	{	$this->db->join($this->prices, 'pr.price_id = ti.ticket_price_id');break;}
			case 'COUNT':	{	$this->db->where('tt.ticket_type_code', $ticket_type);break;}
		}
		
		
		switch($action)
		{
			case 'AMOUNT':	{	$this->db->where('tt.ticket_type_code', $ticket_type);break;}
			case 'GROUP':	{	$this->db->group_by('tt.ticket_type_id'); break;}
			
			
		}	
		$this->db->where('ti.ticket_transaction_id', $transaction_id);		
		$this->db->where('ti.ticket_status', 'done');	
		$query = $this->db->get('transactions t');
		switch($action)
		{
			case 'GROUP': {		return $query->result();	break;}
			case 'COUNT': {		return $query->row();	break;}
			case 'AMOUNT': {	return $query->row();	break;}
		}
				
	}
		
	// --------------------------------------------------------------------
	
	/**
	 * GET ALL AUDIT TRAIL REPORTS
	 *	GET TRANSACTION PER DAY
	 * @access	public
	 */
	function get_transaction_per_day($date_from, $date_to, $seller_id, $event_id)
	{
		$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->where('ti.ticket_event_id', $event_id);
		$this->db->where('t.transaction_user_id', $seller_id);	
		$this->db->where('t.transaction_date >=', $date_from.' 00:00:01');
		$this->db->where('t.transaction_date <=', $date_to.' 23:59:59');	
		//$this->db->order_by('t.transaction_date', 'asc'); 
		$this->db->group_by('t.transaction_id');
		
		$query = $this->db->get('transactions t');
		return $query->result();			
	}


	// --------------------------------------------------------------------
	
	/**
	 * GET ALL AUDIT TRAIL REPORTS
	 *	GET NO. OF TICKETS
	 * @access	public
	 */
	function get_ticket_qty($transaction_id, $ticket_type_code)
	{
//		$this->db->join($this->branches, 'br.branch_id = t.transaction_branch_id');
//		$this->db->join($this->users, 'u.user_id = t.transaction_user_id');
//		$this->db->join($this->terminals, 'te.terminal_id = t.transaction_terminal_id');
		$this->db->select('count(t.transaction_id) as qty');
		$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->where('ti.ticket_transaction_id', $transaction_id);	
		$this->db->where('tt.ticket_type_code', $ticket_type_code);	
		//$this->db->order_by('t.transaction_date', 'asc'); 
//		$this->db->group_by('ti.ticket_type_id');
		$query = $this->db->get('transactions t');
		return $query->row();		
	}	
	
	// --------------------------------------------------------------------
	
	/**
	 * GET ALL AUDIT TRAIL REPORTS
	 *	AMOUNT
	 * @access	public
	 */
	function get_ticket_amount($transaction_id, $ticket_type_code)
	{
//		$this->db->select('sum(pr.price_price - ((pr.price_price * tt.ticket_type_discount)/100)) as price');
//		$this->db->join($this->branches, 'br.branch_id = t.transaction_branch_id');
//		$this->db->join($this->users, 'u.user_id = t.transaction_user_id');
//		$this->db->join($this->terminals, 'te.terminal_id = t.transaction_terminal_id');
		$this->db->select('sum(pr.price_price - ((pr.price_price * tt.ticket_type_discount)/100)) as price');
		$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->join($this->prices, 'pr.price_id = ti.ticket_price_id');
		$this->db->where('ti.ticket_transaction_id', $transaction_id);	
		$this->db->where('tt.ticket_type_code', $ticket_type_code);	
		//$this->db->order_by('t.transaction_date', 'asc'); 
//		$this->db->group_by('ti.ticket_type_id');
		$query = $this->db->get('transactions t');
		if ($query->row('price') == null)
        {
            $querys = 0;
        }
        else
        {
            $querys = $query->row('price');
            //$prc_new = 1;
        }
		
		return array($querys);		
	}		
		
	// --------------------------------------------------------------------
	
	/**
	 * GET ALL AUDIT TRAIL REPORTS
	 *	AMOUNT
	 * @access	public
	 */
	function get_total_amount_without_void($date, $user_id, $event_id, $action)
	{
//		$this->db->select('sum(pr.price_price - ((pr.price_price * tt.ticket_type_discount)/100)) as price');
//		$this->db->join($this->branches, 'br.branch_id = t.transaction_branch_id');
//		$this->db->join($this->users, 'u.user_id = t.transaction_user_id');
//		$this->db->join($this->terminals, 'te.terminal_id = t.transaction_terminal_id');
		switch($action)
		{
			case 'AMOUNT': {
							$this->db->select('sum(pr.price_price - ((pr.price_price * tt.ticket_type_discount)/100)) as price');
							break;}
			case 'QTY': {	
							$this->db->select('count(ti.ticket_id) as price');
			break;
			}
		}
		
		$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->join($this->prices, 'pr.price_id = ti.ticket_price_id');
		$this->db->where('t.transaction_user_id', $user_id);	
		$this->db->where('ti.ticket_status', 'done');
		$this->db->where('t.transaction_date >=', $date.' 00:00:01');
		$this->db->where('t.transaction_date <=', $date.' 23:59:59');
		$this->db->where('ev.event_id', $event_id);	
		//$this->db->order_by('t.transaction_date', 'asc'); 
//		$this->db->group_by('ti.ticket_type_id');
		$query = $this->db->get('transactions t');
		if ($query->row('price') == null)
        {
            $querys = 0;
        }
        else
        {
            $querys = $query->row('price');
            //$prc_new = 1;
        }
		
		return array($querys);		
	}		
	// --------------------------------------------------------------------
	
	/**
	 * GET ALL AUDIT TRAIL REPORTS
	 *	GET REMARKS GROUP BY TICKET TYPE
	 * @access	public
	 */
	function get_remarks($transaction_id, $ticket_type_code, $action)
	{
		switch($action)
		{
			case 'COUNT': {	$this->db->select('t.transaction_id');	break;}
			//case 'REMARK': { $this->db->select('ti.ticket_status');	break;}
		}
		
		$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->where('ti.ticket_transaction_id', $transaction_id);	
		$this->db->where('tt.ticket_type_code', $ticket_type_code);	
		switch($action)
		{
			case 'REMARK': {
						$this->db->where('ti.ticket_status', 'done');
						 $this->db->or_where('ti.ticket_status', 'voided');
						break;}
		}	
		//$this->db->order_by('t.transaction_date', 'asc'); 
		$this->db->group_by('ti.ticket_status');
		$query = $this->db->get('transactions t');
		//return $query->row();	
		switch($action)
		{
			case 'COUNT': {	$remarks = 	$query->num_rows(); 	break;}
			case 'REMARK': { $remarks = $query->row()->ticket_status; 	break;}
		}
		
		return array($remarks);
	}		
//--------------------ADVANCE SALES REPORTS

	// --------------------------------------------------------------------
	
	/**
	 * GET ALL ADVANCE SALES REPORTS
	 *	GET QTY OF TODAY SALES
	 * @access	public
	 */
	function get_today_sales_qty($action, $event_id, $price_id, $date_now)
	{
		switch($action)
		{
			CASE 'QTY': { $this->db->select('count(ti.ticket_id) as qty');	break;}
			CASE 'AMT': { $this->db->select('sum(pr.price_price - ((pr.price_price * tt.ticket_type_discount)/100)) as price');	break;}
		}
		
		$this->db->join($this->transactions, 'ti.ticket_transaction_id = t.transaction_id');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id');
		$this->db->join($this->prices, 'pr.price_id = ti.ticket_price_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->where('ev.event_id', $event_id);	
		$this->db->where('pr.price_id', $price_id);	
		$this->db->where('t.transaction_date >=', $date_now.' 00:00:01');
		$this->db->where('t.transaction_date <=', $date_now.' 23:59:59');
		$query = $this->db->get('tickets ti');
		return $query->row();		
	}		
}	
// END reports_model.php
/* Location: ./application/models/reports_model.php */		