<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Reports_model extends CI_Model
{
	var $transactions = 'transactions t';
	var $tickets = 'tickets ti';
	var $customers = 'customers c';
	var $terminals = 'terminals te';
	var $prices = 'prices pr';

	var $ticket_types = 'ticket_types tt';
	var $events = 'events ev';
	var $venues = 'venues ve';
	var $promoters = 'promoters pro';
	var $users	=	'users u';
	var $branches = 'branches br';
	var $payments = 'payments pay';
	var $payment_types = 'payment_types pt';

	// added for consolidated reports  BY JAIZON
	var $sections = 'sections sec';
	var $seatplans = 'seatplans sea';
	
	//added for convenience charge report BY KOREWA
	var $charges = 'charges ch';
	
	/**
	 * Constructor
	 *
	 * @access	public
	 */
	public function __construct()
	{
		parent::__construct();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_branch
	 *
	 * @access	public
	 */
 	function get_branch($branch_id)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->where('branch_id', $branch_id);
		$this->db->join($this->users, 'u.user_branch_id = br.branch_id');
		$this->db->join($this->terminals, 'te.terminal_id = u.user_terminal_id');
		$query = $this->db->get($this->branches);
		
		return $query->row();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_branches_dropdown_for_cc
	 *
	 * @access	public
	 */
	function get_branches_dropdown_for_cc()
	{
		
		$this->db->query('set transaction isolation level read uncommitted');
		//check if DS head office 
		if($this->session->userdata('user_branch_id') == 142){ 
			$this->db->where('branch_category','SM Dept. Store');
		}elseif ($this->session->userdata('user_branch_id') != 1)
		{
			$this->db->where('branch_id', $this->session->userdata('user_branch_id'));
		}
		$this->db->order_by('branch_name');
		$query = $this->db->get($this->branches);
			
		$result = $query->result();
		
		if ($result)
		{
			// add an empty array 
			if ($this->session->userdata('user_branch_id') == 1)
			{
				$array[''] = '';
			}
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->branch_id] = $r->branch_name;
			}
			return $array;
		}
		else
		{
			return $result;
		}

	}
	
	function get_events_dropdown_for_otc()
	{
		$this->db->query('set transaction isolation level read uncommitted');
		//$this->db->where('branch_id !=', 40);
		if($this->session->userdata('user_branch_id') == $this->config->item('melco_branch_id')){
		
			$this->db->where('event_cod', 1);
		}
		$this->db->order_by('event_title');
		$query = $this->db->get($this->events);
			
		$result = $query->result();

		if ($result)
		{
			// add an empty array 
			$array[''] = '';
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->event_id] = $r->event_title;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}
	
	function get_users_by_branch_otc($branch_id)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->where('user_branch_id', $branch_id);
		$this->db->order_by('user_firstname');
		$query = $this->db->get($this->users);
		$result = $query->result();
		if ($result)
		{
			$array[''] = '';
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->user_id] = $r->user_firstname.' '.$r->user_lastname;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_branch_details
	 *
	 * @access	public
	 */
 	function get_branch_details($branch_id)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('br.branch_id,br.branch_name, te.terminal_code, te.terminal_name');
		$this->db->where('branch_id', $branch_id);
		$this->db->join($this->users, 'u.user_branch_id = br.branch_id');
		$this->db->join($this->terminals, 'te.terminal_id = u.user_terminal_id');
		$query = $this->db->get('branches br');
		
		return $query->result();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_users
	 *
	 * @access	public
	 */
 	function get_users($user_id = false)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		if($user_id)
		{
		$this->db->where('u.user_id', $user_id);
		}
		$this->db->join($this->branches, 'br.branch_id = u.user_branch_id');
		$this->db->join($this->terminals, 'te.terminal_id = u.user_terminal_id');
		$query = $this->db->get($this->users);
		
		return $query->row();
	}
	
	function get_terminal_details($branch_id, $termid)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->where('terminal_id', $termid);
		$query = $this->db->get($this->terminals);
		
		return $query->row();
	}

	// --------------------------------------------------------------------
	
	/**
	 * get_users_by_branch_id
	 *
	 * @access	public
	 */
 	function get_users_by_branch()
	{
		$this->db->query('set transaction isolation level read uncommitted');
		//check if DS head office 
		if($this->session->userdata('user_branch_id') == 142){ 
			$this->db->where('branch_category','SM Dept. Store');
			$this->db->join($this->branches, 'br.branch_id = u.user_branch_id');
		}elseif ($this->session->userdata('user_branch_id') != 1)
		{
			$this->db->where('user_branch_id', $this->session->userdata('user_branch_id'));
		}
		
		//$this->db->where('br.branch_id', $branch_id);
		
		$this->db->order_by('user_firstname');
		$query = $this->db->get($this->users);
		$result = $query->result();
		if ($result)
		{
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->user_id] = $r->user_firstname.' '.$r->user_lastname;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}	
	
	// --------------------------------------------------------------------
	
	/**
	 * get_terminal_by_branch_id
	 *
	 * @access	public
	 */
 	function get_terminal_by_branch($branch_id)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->where('br.branch_id', $branch_id);
		$this->db->join($this->branches, 'br.branch_id = te.terminal_branch_id');
		$query = $this->db->get($this->terminals);
		$result = $query->result();
		if ($result)
		{
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->terminal_id] = $r->terminal_name;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_event_title
	 *
	 * @access	public
	 */
 	function get_event_title()
	{
		
		$this->db->query('set transaction isolation level read uncommitted'); 
		
		if($this->session->userdata('user_branch_id') == $this->config->item('melco_branch_id')){ 
			$this->db->where('event_cod', 1);
		}
		
		
		//cct
		$users = array(2639, 5708,1482);
		 			
		if (in_array($this->session->userdata('user_id'), $users)){
					$this->db->order_by('event_title', 'asc'); 
			
		}else{
					$this->db->order_by('event_date_time', 'desc');
 
		}
		
		if($this->session->userdata('user_branch_id') == 144){
			
			$this->db->where('event_id', 5645);
			
		}
		
		$query = $this->db->get($this->events);
		$result = $query->result();
		if ($result)
		{
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->event_id] = $r->event_title; 
			}
			
			if($this->session->userdata('user_branch_id') != 144){
			
			$array["0"] = "ALL EVENTS";
			
			}
			
			
			return $array;
		}
		else
		{
			return $result;
		}
	}

	function get_refund_event_title()
	{
		$this->db->query('set transaction isolation level read uncommitted');
		if($this->session->userdata('user_branch_id') == $this->config->item('melco_branch_id')){ 
			$this->db->where('event_cod', 1);
		}
		
		//cct
		$users = array(2639, 5708,1482);
		 
		if (in_array($this->session->userdata('user_id'), $users)){
			
			$this->db->order_by('event_title', 'asc'); 
			
		}else{
			$this->db->order_by('event_date_time', 'desc');
 
		}
		$this->db->where('event_postponed_date !=', '0000-00-00');
		$query = $this->db->get($this->events);
		$result = $query->result();
		if ($result)
		{
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->event_id] = $r->event_title; 
			}
			
			
			return $array;
		}
		else
		{
			return $result;
		}
	}	
		
	// --------------------------------------------------------------------
	
	/**
	 * get_events
	 *
	 * @access	public
	 */
 	function get_events($event_id)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->where('ev.event_id', $event_id);
		$this->db->join($this->venues, 've.venue_id = ev.event_venue_id', 'left');
		$this->db->join($this->promoters, 'pro.promoter_id = ev.event_promoter_id', 'left');
		$query = $this->db->get($this->events);
		
		return $query->row();
	}	
	
	// --------------------------------------------------------------------
	
	/**
	 * get_ticket_types
	 *
	 * @access	public
	 */
 	function get_ticket_types()
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->where('ticket_type_group', 0);
		$query = $this->db->get($this->ticket_types);
		
		return $query->result();
	}

	// --------------------------------------------------------------------
	
	/**
	 * get_ticket_types_2
	 *
	 * @access	public
	 */
 	function get_ticket_types_2()
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->where('ticket_type_group', 1);
		$query = $this->db->get($this->ticket_types);
		
		return $query->result();
	}	
		
	// --------------------------------------------------------------------
	
	/**
	 * get_prices
	 *
	 * @access	public
	 */
	function prices($event_id = false)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		//$this->db->select('pr.price_id, pr.price_event_id, pr.price_name, pr.price_price, sec.section_capacity, sec.section_available');
		if ($event_id)
		{
			$this->db->where('pr.price_event_id', $event_id);
		}
		$this->db->join($this->events, 'pr.price_event_id = ev.event_id');
		//$this->db->join($this->tickets, 'ti.ticket_event_id = ev.event_id');
		//$this->db->join($this->sections, 'sec.section_id = ti.ticket_section_id');
		$this->db->order_by('pr.price_price', 'desc');
		//$this->db->group_by('sec.section_id'); 
		//$this->db->group_by('ti.ticket_section_id');
		$query = $this->db->get($this->prices);
		//echo $this->db->last_query();
		
		return $query->result();
	}	
	
	// --------------------------------------------------------------------
	
	/**
	 * get
	 *
	 * @access	public
	 */
	function get_prices($ticket_type_name, $price_id)
	{
		$this->db->query('set transaction isolation level read uncommitted');
	/*	$this->db->select('pr.price_price - (pr.price_price * (tt.ticket_type_discount / 100)) as price');
		$this->db->join($this->tickets, 'ti.ticket_price_id = pr.price_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		//$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id');
		$this->db->where('tt.ticket_type_name', $ticket_type_name);
		$this->db->where('pr.price_id ', $price_id);
		//$this->db->where('t.transaction_user_id ', $seller_id);
		$this->db->where('tt.ticket_type_group', $status);
		$this->db->group_by("tt.ticket_type_id"); 
		$query = $this->db->get('prices pr');
		
		if ($query->row('price') == null)
        {
            $prices = 0;
        }
        else
        {
            $prices = $query->row('price');
            //$prc_new = 1;
        }*/
		$this->db->select('price_price as price');
		$this->db->where('price_id', $price_id);
		$query = $this->db->get('prices');
		
		$my_price = $query->row('price');
		
		$this->db->select('ticket_type_discount as discount, ticket_type_discount_type as dt');
		$this->db->where('ticket_type_name', $ticket_type_name);
		$query = $this->db->get('ticket_types');
		$my_discount = $query->row('discount');
		$my_dt = $query->row('dt');
		
		switch($my_dt)
		{
			case 'Percentage':
			{
				$my_discounted_price = ceil($my_price - (($my_price * $my_discount) / 100));
				break;
			}
			case 'Amount':
			{
				$my_discounted_price = $my_price - $my_discount;
				break;
			}
		}
		
		if($my_discounted_price < 0)
		{
			$my_discounted_price = 0;
		}
		
		return array($my_discounted_price);
	}	
	
	// --------------------------------------------------------------------
	
	/**
	 * get ticket quantity
	 *
	 * @access	public
	 */
	function ticket_qty($ticket_type_name, $price_id, $event_id, $status, $seller_id = false, $reports_date)
	{
		$this->db->query('set transaction isolation level read uncommitted');
	 	$this->db->select('ti.ticket_id');
		$this->db->join($this->prices, 'ti.ticket_price_id = pr.price_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id');
		$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id');
		$this->db->where('tt.ticket_type_name', $ticket_type_name);
		$this->db->where('pr.price_id ', $price_id);
		$this->db->where('ev.event_id ', $event_id);
		$this->db->where('tt.ticket_type_group', $status);
		if($seller_id)
		{
			$this->db->where('t.transaction_user_id ', $seller_id);
			$this->db->where('t.transaction_date >=', $reports_date.' 00:00:01');
		}
		$this->db->where('t.transaction_date <=', $reports_date.' 23:59:59');
		$this->db->where('ti.ticket_status', 'done');
		$query = $this->db->count_all_results('tickets ti');
		//$query = $this->db->get($this->tickets);
		return $query;		
	}	
	
	// --------------------------------------------------------------------
	
	/**
	 * get amount
	 *
	 * @access	public
	 */
	function prc_amt($ticket_type_name, $price_id, $event_id, $status, $seller_id = false, $reports_date)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('tt.ticket_type_discount_type as tttype');
		$this->db->where('tt.ticket_type_name', $ticket_type_name);
		$disc_type = $this->db->get('ticket_types tt');

		//echo $disc_type;
	
		if($disc_type->row('tttype') == 'Percentage')
		{
			$this->db->select('ceil(pr.price_price - (pr.price_price * (tt.ticket_type_discount / 100))) as price');
		}
		else
		{
			$this->db->select('ceil(pr.price_price - tt.ticket_type_discount) as price');
		}
		$this->db->join($this->tickets, 'ti.ticket_price_id = pr.price_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id');
		$this->db->where('tt.ticket_type_name', $ticket_type_name);
		$this->db->where('pr.price_id ', $price_id);
		$this->db->where('tt.ticket_type_group', $status);
		if($seller_id)
		{
			$this->db->where('t.transaction_user_id ', $seller_id);
			$this->db->where('t.transaction_date >=', $reports_date.' 00:00:01');
		}
		$this->db->where('t.transaction_date <=', $reports_date.' 23:59:59');
		$this->db->where('ti.ticket_status', 'done');
		$this->db->group_by("tt.ticket_type_id"); 
		$prc = $this->db->get('prices pr');
		

		$this->db->select('ti.ticket_id');
		$this->db->join($this->prices, 'ti.ticket_price_id = pr.price_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id');
		$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id');
		$this->db->where('tt.ticket_type_name', $ticket_type_name);
		$this->db->where('pr.price_id ', $price_id);
		$this->db->where('ev.event_id ', $event_id);
		$this->db->where('tt.ticket_type_group', $status);
		if($seller_id)
		{
			$this->db->where('t.transaction_user_id ', $seller_id);
			$this->db->where('t.transaction_date >=', $reports_date.' 00:00:01');
		}
		$this->db->where('t.transaction_date <=', $reports_date.' 23:59:59');
		$this->db->where('ti.ticket_status', 'done');
		$qty = $this->db->count_all_results('tickets ti');
		//$query = $this->db->get($this->tickets);
		
		if ($prc->row('price') == null)
        {
            $prc_new = 0;
        }
        else
        {
            $prc_new = $prc->row('price');
            //$prc_new = 1;
        }
		
		return array($prc_new, $qty);		
	}	
	
	// --------------------------------------------------------------------
	
	/**
	 * total quantity
	 *
	 * @access	public
	 */
	function total_qty($price_id, $event_id, $status, $seller_id = false, $reports_date)
	{
		$this->db->query('set transaction isolation level read uncommitted');
	 	$this->db->select('ti.ticket_id');
		$this->db->join($this->prices, 'ti.ticket_price_id = pr.price_id');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id');
		$this->db->where('pr.price_id ', $price_id);
		$this->db->where('ev.event_id ', $event_id);
		$this->db->where('tt.ticket_type_group', $status);
		if($seller_id)
		{
			$this->db->where('t.transaction_user_id ', $seller_id);
			$this->db->where('t.transaction_date >=', $reports_date.' 00:00:01');
		}
		$this->db->where('t.transaction_date <=', $reports_date.' 23:59:59');
		$this->db->where('ti.ticket_status', 'done');
		$query = $this->db->count_all_results('tickets ti');
		return $query;		
	}		
	
	// --------------------------------------------------------------------
	
	/**
	 * total amount
	 *
	 * @access	public
	 */
	function total_amount($ticket_type_name, $price_id, $event_id, $status)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('tt.ticket_type_discount_type as tttype');
		$this->db->where('tt.ticket_type_name', $ticket_type_name);
		$disc_type = $this->db->get('ticket_types tt');
		
		if($disc_type->row('tttype') == 'Percentage')
		{
			$this->db->select('ceil(pr.price_price - (pr.price_price * (tt.ticket_type_discount / 100))) as price');
		}
		else
		{
			$this->db->select('ceil(pr.price_price - tt.ticket_type_discount) as price');
		}
		$this->db->join($this->tickets, 'ti.ticket_price_id = pr.price_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->where('tt.ticket_type_name', $ticket_type_name);
		$this->db->where('pr.price_id ', $price_id);
		$this->db->where('tt.ticket_type_group', $status);
		$this->db->where('ti.ticket_status', 'done');
		$this->db->group_by("tt.ticket_type_id"); 
		$query = $this->db->get('prices pr');
		return $query->row();		
	}	
	
	// --------------------------------------------------------------------
	
	/**
	 * total sales quantity
	 *
	 * @access	public
	 */
	function total_sales_qty($ticket_type_name, $event_id, $status, $seller_id = false, $reports_date)
	{
		$this->db->query('set transaction isolation level read uncommitted');
	 	$this->db->select('ti.ticket_id');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id');
		$this->db->where('ev.event_id ', $event_id);
		$this->db->where('tt.ticket_type_name', $ticket_type_name);
		$this->db->where('tt.ticket_type_group', $status);
		if($seller_id)
		{
			$this->db->where('t.transaction_user_id ', $seller_id);
			$this->db->where('t.transaction_date >=', $reports_date.' 00:00:01');
		}
		$this->db->where('t.transaction_date <=', $reports_date.' 23:59:59');
		$this->db->where('ti.ticket_status', 'done');
		$query = $this->db->count_all_results('tickets ti');
		return $query;		
	}	
	
	// --------------------------------------------------------------------
	
	/**
	 * total sales quantity
	 *
	 * @access	public
	 */
	function total_sales_qty2($ticket_type_name, $event_id, $status, $seller_id = false, $reports_date)
	{
		$this->db->query('set transaction isolation level read uncommitted');
	 	$this->db->select('ti.ticket_id');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id');
		$this->db->where('ev.event_id ', $event_id);
		$this->db->where('tt.ticket_type_name', $ticket_type_name);
		$this->db->where('tt.ticket_type_group', $status);
		if($seller_id)
		{
			$this->db->where('t.transaction_user_id ', $seller_id);
			$this->db->where('t.transaction_date >=', $reports_date.' 00:00:01');
			$this->db->where('t.transaction_date <=', $reports_date.' 23:59:59');
		}
		$this->db->where('t.transaction_date >=', $reports_date.' 00:00:01');
		$this->db->where('t.transaction_date <=', $reports_date.' 23:59:59');
		$this->db->where('ti.ticket_status', 'done');
		$query = $this->db->count_all_results('tickets ti');
		return $query;		
	}

	// --------------------------------------------------------------------
	
	/**
	 * total salesamount
	 *
	 * @access	public
	 */
	function total_sales_amount($ticket_type_name, $event_id, $status, $seller_id = false, $reports_date)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('tt.ticket_type_discount_type as tttype');
		$this->db->where('tt.ticket_type_name', $ticket_type_name);
		$disc_type = $this->db->get('ticket_types tt');
		
		//echo $disc_type->row('tttype');

		if($disc_type->row('tttype') == 'Percentage')
		{
			$this->db->select('sum(ceil(pr.price_price - ((pr.price_price * tt.ticket_type_discount)/100))) as price');
		}
		else
		{
			$this->db->select('sum(ceil(pr.price_price - tt.ticket_type_discount)) as price');
		}
		
		$this->db->join($this->tickets, 'ti.ticket_price_id = pr.price_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id');
		$this->db->where('ti.ticket_event_id', $event_id);
		$this->db->where('tt.ticket_type_name', $ticket_type_name);
		$this->db->where('tt.ticket_type_group', $status);
		if($seller_id)
		{
			$this->db->where('t.transaction_user_id ', $seller_id);
			$this->db->where('t.transaction_date >=', $reports_date.' 00:00:01');
		}
		$this->db->where('t.transaction_date <=', $reports_date.' 23:59:59');
		$this->db->where('ti.ticket_status', 'done');
		$query = $this->db->get('prices pr');
		
		if ($query->row('price') == null)
        {
            $querys = 0;
        }
        else
        {
            $querys = $query->row('price');
            //$prc_new = 1;
        }
		
		return array($querys);		
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * total salesamount BY JAIZON
	 *
	 * @access	public
	 */
	function total_sales_amount_conso($ticket_type_name, $event_id, $status, $seller_id = false, $reports_date)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('tt.ticket_type_discount_type as tttype');
		$this->db->where('tt.ticket_type_name', $ticket_type_name);
		$disc_type = $this->db->get('ticket_types tt');
		
		//echo $disc_type->row('tttype');

		if($disc_type->row('tttype') == 'Percentage')
		{
			$this->db->select('sum(ceil(pr.price_price - ((pr.price_price * tt.ticket_type_discount)/100))) as price');
		}
		else
		{
			$this->db->select('sum(ceil(pr.price_price - tt.ticket_type_discount)) as price');
		}
		
		$this->db->join($this->tickets, 'ti.ticket_price_id = pr.price_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id');
		$this->db->where_in('ti.ticket_event_id', unserialize($event_id));
		$this->db->where('tt.ticket_type_name', $ticket_type_name);
		$this->db->where('tt.ticket_type_group', $status);
		if($seller_id)
		{
			$this->db->where('t.transaction_user_id ', $seller_id);
			$this->db->where('t.transaction_date >=', $reports_date.' 00:00:01');
		}
		$this->db->where('t.transaction_date <=', $reports_date.' 23:59:59');
		$this->db->where('ti.ticket_status', 'done');
		$query = $this->db->get('prices pr');
		
		if ($query->row('price') == null)
        {
            $querys = 0;
        }
        else
        {
            $querys = $query->row('price');
            //$prc_new = 1;
        }
		
		return array($querys);		
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * total salesamount BY JAIZON
	 *
	 * @access	public
	 */
	function total_sales_amount_branch($ticket_type_name, $event_id, $status, $seller_id = false, $reports_date, $branch_id)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('tt.ticket_type_discount_type as tttype');
		$this->db->where('tt.ticket_type_name', $ticket_type_name);
		$disc_type = $this->db->get('ticket_types tt');
		
		//echo $disc_type->row('tttype');

		if($disc_type->row('tttype') == 'Percentage')
		{
			$this->db->select('sum(ceil(pr.price_price - ((pr.price_price * tt.ticket_type_discount)/100))) as price');
		}
		else
		{
			$this->db->select('sum(ceil(pr.price_price - tt.ticket_type_discount)) as price');
		}
		
		$this->db->join($this->tickets, 'ti.ticket_price_id = pr.price_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id');
		$this->db->where('ti.ticket_event_id', $event_id);
		$this->db->where('tt.ticket_type_name', $ticket_type_name);
		$this->db->where('tt.ticket_type_group', $status);
		$this->db->where('t.transaction_branch_id', $branch_id);
		if($seller_id)
		{
			$this->db->where('t.transaction_user_id ', $seller_id);
			$this->db->where('t.transaction_date >=', $reports_date.' 00:00:01');
		}
		$this->db->where('t.transaction_date <=', $reports_date.' 23:59:59');
		$this->db->where('ti.ticket_status', 'done');
		$query = $this->db->get('prices pr');
		
		if ($query->row('price') == null)
        {
            $querys = 0;
        }
        else
        {
            $querys = $query->row('price');
            //$prc_new = 1;
        }
		
		return array($querys);		
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * total salesamount BY JAIZON
	 *
	 * @access	public
	 */
	function total_sales_amount_branch_conso($ticket_type_name, $event_id, $status, $seller_id = false, $reports_date, $branch_id)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('tt.ticket_type_discount_type as tttype');
		$this->db->where('tt.ticket_type_name', $ticket_type_name);
		$disc_type = $this->db->get('ticket_types tt');
		
		//echo $disc_type->row('tttype');

		if($disc_type->row('tttype') == 'Percentage')
		{
			$this->db->select('sum(ceil(pr.price_price - ((pr.price_price * tt.ticket_type_discount)/100))) as price');
		}
		else
		{
			$this->db->select('sum(ceil(pr.price_price - tt.ticket_type_discount)) as price');
		}
		
		$this->db->join($this->tickets, 'ti.ticket_price_id = pr.price_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id');
		$this->db->where_in('ti.ticket_event_id', unserialize($event_id));
		$this->db->where('tt.ticket_type_name', $ticket_type_name);
		$this->db->where('tt.ticket_type_group', $status);
		$this->db->where('t.transaction_branch_id', $branch_id);
		if($seller_id)
		{
			$this->db->where('t.transaction_user_id ', $seller_id);
			$this->db->where('t.transaction_date >=', $reports_date.' 00:00:01');
		}
		$this->db->where('t.transaction_date <=', $reports_date.' 23:59:59');
		$this->db->where('ti.ticket_status', 'done');
		$query = $this->db->get('prices pr');
		
		if ($query->row('price') == null)
        {
            $querys = 0;
        }
        else
        {
            $querys = $query->row('price');
            //$prc_new = 1;
        }
		
		return array($querys);		
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * total salesamount BY JAIZON
	 *
	 * @access	public
	 */
	function total_sales_amount_reserve($ticket_type_name, $event_id, $status, $seller_id = false, $reports_date)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('tt.ticket_type_discount_type as tttype');
		$this->db->where('tt.ticket_type_name', $ticket_type_name);
		$disc_type = $this->db->get('ticket_types tt');
		
		//echo $disc_type->row('tttype');

		if($disc_type->row('tttype') == 'Percentage')
		{
			$this->db->select('sum(ceil(pr.price_price - ((pr.price_price * tt.ticket_type_discount)/100))) as price');
		}
		else
		{
			$this->db->select('sum(ceil(pr.price_price - tt.ticket_type_discount)) as price');
		}
		
		$this->db->join($this->tickets, 'ti.ticket_price_id = pr.price_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id');
		$this->db->where('ti.ticket_event_id', $event_id);
		$this->db->where('tt.ticket_type_name', $ticket_type_name);
		$this->db->where('tt.ticket_type_group', $status);
		if($seller_id)
		{
			$this->db->where('t.transaction_user_id ', $seller_id);
			$this->db->where('t.transaction_date >=', $reports_date.' 00:00:01');
		}
		$this->db->where('t.transaction_date <=', $reports_date.' 23:59:59');
		$this->db->where('ti.ticket_status', 'reserved');
		$query = $this->db->get('prices pr');
		
		if ($query->row('price') == null)
        {
            $querys = 0;
        }
        else
        {
            $querys = $query->row('price');
            //$prc_new = 1;
        }
		
		return array($querys);		
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * total salesamount BY JAIZON
	 *
	 * @access	public
	 */
	function total_sales_amount_reserve_conso($ticket_type_name, $event_id, $status, $seller_id = false, $reports_date)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('tt.ticket_type_discount_type as tttype');
		$this->db->where('tt.ticket_type_name', $ticket_type_name);
		$disc_type = $this->db->get('ticket_types tt');
		
		//echo $disc_type->row('tttype');

		if($disc_type->row('tttype') == 'Percentage')
		{
			$this->db->select('sum(ceil(pr.price_price - ((pr.price_price * tt.ticket_type_discount)/100))) as price');
		}
		else
		{
			$this->db->select('sum(ceil(pr.price_price - tt.ticket_type_discount)) as price');
		}
		
		$this->db->join($this->tickets, 'ti.ticket_price_id = pr.price_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id');
		$this->db->where_in('ti.ticket_event_id', unserialize($event_id));
		$this->db->where('tt.ticket_type_name', $ticket_type_name);
		$this->db->where('tt.ticket_type_group', $status);
		if($seller_id)
		{
			$this->db->where('t.transaction_user_id ', $seller_id);
			$this->db->where('t.transaction_date >=', $reports_date.' 00:00:01');
		}
		$this->db->where('t.transaction_date <=', $reports_date.' 23:59:59');
		$this->db->where('ti.ticket_status', 'reserved');
		$query = $this->db->get('prices pr');
		
		if ($query->row('price') == null)
        {
            $querys = 0;
        }
        else
        {
            $querys = $query->row('price');
            //$prc_new = 1;
        }
		
		return array($querys);		
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * total salesamount BY JAIZON
	 *
	 * @access	public
	 */
	function total_sales_amount2($ticket_type_name, $event_id, $status, $seller_id = false, $reports_date)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('tt.ticket_type_discount_type as tttype');
		$this->db->where('tt.ticket_type_name', $ticket_type_name);
		$disc_type = $this->db->get('ticket_types tt');

		if($disc_type->row('tttype') == 'Percentage')
		{
			$this->db->select('sum(ceil(pr.price_price - ((pr.price_price * tt.ticket_type_discount)/100))) as price');
		}
		else
		{
			$this->db->select('sum(ceil(pr.price_price - tt.ticket_type_discount)) as price');
		}
		$this->db->join($this->tickets, 'ti.ticket_price_id = pr.price_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id');
		$this->db->where('ti.ticket_event_id', $event_id);
		$this->db->where('tt.ticket_type_name', $ticket_type_name);
		$this->db->where('tt.ticket_type_group', $status);
		if($seller_id)
		{
			$this->db->where('t.transaction_user_id ', $seller_id);
			$this->db->where('t.transaction_date >=', $reports_date.' 00:00:01');
			$this->db->where('t.transaction_date <=', $reports_date.' 23:59:59');
		}
		$this->db->where('t.transaction_date >=', $reports_date.' 00:00:01');
		$this->db->where('t.transaction_date <=', $reports_date.' 23:59:59');
		$this->db->where('ti.ticket_status', 'done');
		$query = $this->db->get('prices pr');
		
		if ($query->row('price') == null)
        {
            $querys = 0;
        }
        else
        {
            $querys = $query->row('price');
            //$prc_new = 1;
        }
		
		return array($querys);		
	}	

	// NEW SALES BREAKDOWN WITHOUT VOID--------------------------------------------------------------------
	
	/**
	 * total salesamount
	 *
	 * @access	public
	 */
	function sales_breakdown_amt($event_id, $seller_id = false, $reports_date, $action, $action2)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		switch($action2)
		{
			case 'QTY':	{	
							$this->db->select('count(ti.ticket_id) as price');
							break;
						}
			case 'AMT':	{	
							$this->db->select('tt.ticket_type_discount_type as tttype');
							$this->db->join($this->tickets, 'ti.ticket_price_id = pr.price_id');
							$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
							$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id');
							$this->db->where('ti.ticket_event_id', $event_id);
							//$this->db->where('tt.ticket_type_name', $ticket_type_name);
							if($seller_id)
							{
								$this->db->where('t.transaction_user_id ', $seller_id);
								$this->db->where('t.transaction_date >=', $reports_date.' 00:00:01');
							}
							$this->db->where('t.transaction_date <=', $reports_date.' 23:59:59');
							$this->db->where('tt.ticket_type_group', '0');
							$this->db->where('ti.ticket_status', 'done');
							switch($action)
							{
								case 'CASH':{	$this->db->where('t.transaction_cash_payment >', 0);	break;}
								case 'CARD':{	$this->db->where('t.transaction_card_payment >', 0);	break;}			
							}
							$query = $this->db->get('prices pr');
		
							/*$test = $query->row('tttype');
							echo $test;*/

							if($query->row('tttype') == 'Percentage')
							{
								$this->db->select('ceil(pr.price_price - ((pr.price_price * tt.ticket_type_discount)/100)) as prices');
							}
							else
							{
								$this->db->select('ceil(pr.price_price - tt.ticket_type_discount) as prices');
							}
							break;
						}
		}
		
		$this->db->join($this->tickets, 'ti.ticket_price_id = pr.price_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id');
		$this->db->join($this->payments, 'pay.payment_transaction_id = t.transaction_id');
		$this->db->join($this->payment_types, 'pt.payment_type_id = pay.payment_payment_type_id');
		$this->db->where('ti.ticket_event_id', $event_id);
		//$this->db->where('tt.ticket_type_name', $ticket_type_name);
		if($seller_id)
		{
			$this->db->where('t.transaction_user_id ', $seller_id);
			$this->db->where('t.transaction_date >=', $reports_date.' 00:00:01');
		}
		$this->db->where('t.transaction_date <=', $reports_date.' 23:59:59');
		$this->db->where('tt.ticket_type_group', '0');
		$this->db->where('ti.ticket_status', 'done');
		switch($action)
		{
			case 'CASH':
			{	
				$this->db->where('(t.transaction_cash_payment > 0 OR pay.payment_payment_type_id = 1)');
				//$this->db->where('pay.payment_payment_type_id = 1');	
				break;
			}
			case 'CARD':{	$this->db->where('(t.transaction_card_payment > 0 OR pay.payment_payment_type_id = 2)');	break;}			
		}
		
		
		$query = $this->db->get('prices pr');
		
		if ($query->row('price') == null)
        {
            $querys = 0;
        }
        else
        {
            $querys = $query->row('price');
            //$prc_new = 1;
        }
		
		switch($action2)
		{
			case 'QTY': {
							return array($querys);
							break;
						}
			case 'AMT': {
							return array($query);
							break;
						}
		}		
	}
	
	// GET ALL CARDS / CASH AMOUNT FOR SELLER FOR EVENT
	//---------------------------------------------------------------------
	
	/**25 November 2010 - updated by JAIZON
	 * used in cash breakdown before 09/17/2010. was not used because change was made to payment types before completion of this function. -- jaizon
	 *
	 * @access public
	 */
	 
	function get_all_amount_for_seller_for_event($event_id, $seller_id = false, $reports_date, $action, $action2, $payment_type_id = false)
	{	
		$this->db->query('set transaction isolation level read uncommitted');
		switch($action2)
		{
			case 'QTY' : { $this->db->select('ti.ticket_id, t.transaction_id, pay.payment_amount'); break; }
			case 'AMT' : { $this->db->select('tt.ticket_type_discount_type, pr.price_price, tt.ticket_type_discount, ti.ticket_id, t.transaction_id'); break; }
		}
		$this->db->join($this->prices, 'pr.price_id = ti.ticket_price_id');
		$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->join($this->payments, 'pay.payment_transaction_id = t.transaction_id');
		$this->db->join($this->payment_types, 'pt.payment_type_id = pay.payment_payment_type_id');
		$this->db->where('tt.ticket_type_group', '0');
		$this->db->where('ti.ticket_event_id', $event_id);
		if($seller_id)
		{
			$this->db->where('t.transaction_user_id ', $seller_id);
			$this->db->where('t.transaction_date >=', $reports_date.' 00:00:01');
		}
		$this->db->where('t.transaction_date <=', $reports_date.' 23:59:59');
		switch($payment_type_id)
		{
			case 1  :{	$this->db->where('(t.transaction_cash_payment > 0 OR pay.payment_payment_type_id = 1)');	break;}
			case 2  :{	$this->db->where('(t.transaction_card_payment > 0 OR pay.payment_payment_type_id = 2)');	break;}	
			default :{  $this->db->where('pay.payment_payment_type_id', $payment_type_id);                          break;}
			//case 'ALL':{ break; }		              
		}
		$this->db->where('t.transaction_status', 'done');
		$this->db->where('ti.ticket_status', 'done');
		//$this->db->group_by('t.transaction_id');
		$query = $this->db->get('tickets ti');
		
		return $query->result();
	}
	
	// GET ALL TRANSACTIONS FOR SELLER FOR EVENT WITHIN SELECTED DATE 09/17/2010
	// --------------------------------------------------------------------
	
	/**
	 * for cash breakdown on seller report (will try to use in advance sales report also) -- jaizon
	 *
	 * @access	public
	 */
	 
	 function get_all_trans_seller_event_date($event_id, $seller_id = false, $reports_date)
	 {
		 $this->db->query('set transaction isolation level read uncommitted');
	 	$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id');
		$this->db->where('ti.ticket_event_id', $event_id);
		if($seller_id)
		{
			$this->db->where('t.transaction_user_id ', $seller_id);
			$this->db->where('t.transaction_date >=', $reports_date.' 00:00:01');
		}
		$this->db->where('t.transaction_date <=', $reports_date.' 23:59:59');
		$this->db->where('t.transaction_status', 'done');
		$this->db->group_by('t.transaction_id');
		$query = $this->db->get('transactions t');
		
		return $query->result();
	 }
	 
	 //get transactions paid online 12/07/2010
	 
	 function online_transactions($date_from, $date_to, $action = false)
	 {
		 $this->db->query('set transaction isolation level read uncommitted');
	 	$online_branch_id = $this->reports->gbiddos();
	 	//$this->db->join($this->branches, 'br.branch_id = t.transaction_branch_id', 'left outer');
		if ($action == 'recap')
		{
			$this->db->select('t.transaction_id, pt.payment_type_id, pt.payment_type_name, c.customer_firstname, c.customer_lastname, pay.payment_amount, ev.event_internet_sales_charge, ev.event_reservation_fee');
		}
	 	$this->db->join($this->users, 'u.user_id = t.transaction_user_id', 'left outer');
		$this->db->join($this->terminals, 'te.terminal_id = t.transaction_terminal_id', 'left outer');
		$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id', 'left outer');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id', 'left outer');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left outer');
		$this->db->join($this->prices, 'pr.price_id = ti.ticket_price_id', 'left outer');
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left outer');
		$this->db->join($this->sections, 'sec.section_id = pr.price_sections', 'left outer');
		$this->db->join($this->payments, 't.transaction_id = pay.payment_transaction_id', 'left outer');
		$this->db->join($this->payment_types, 'pt.payment_type_id = pay.payment_payment_type_id');
		$this->db->where('t.transaction_date >=', $date_from.' 00:00:01');
		$this->db->where('t.transaction_date <=', $date_to.' 23:59:59');
		$this->db->where('t.transaction_branch_id', $online_branch_id->user_branch_id);
		$this->db->group_by('t.transaction_id');
		if ($action == 'recap')
		{
			$this->db->order_by('pt.payment_type_id', 'asc');
		}
		else
		{
			$this->db->order_by('t.transaction_date', 'asc');
		}
		
		
		$query = $this->db->get('transactions t');
		return $query->result();		
	}
	
	function onlineclaimed_transactions($date_from, $date_to, $eventid, $branchid, $seller)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		//$online_branch_id = $this->reports->gbiddos();
		$this->db->select('ev.event_title, ev.event_code, ev.event_internet_sales_charge, t.transaction_id, ti.ticket_transaction_id, c.customer_firstname, c.customer_lastname, tt.ticket_type_name');
		$this->db->join($this->users, 'u.user_id = t.transaction_user_id', 'left outer');
		$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id', 'left outer');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id', 'left outer');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left outer');
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left outer');
		$this->db->where('ti.ticket_date_printed >=', $date_from);
		$this->db->where('ti.ticket_date_printed <=', $date_to);
		$this->db->where('t.transaction_user_id', '1');
		$this->db->where('t.transaction_status', 'done');
		if (!empty($eventid))
		{
			$this->db->where('ev.event_id', $eventid);
		}
		if ($this->session->userdata('user_branch_id') == 1)
		{
			if (!empty($branchid))
			{
				$this->db->where('ti.ticket_branch_id', $branchid);
			}
		}
		else
		{
			$this->db->where('ti.ticket_branch_id', $this->session->userdata('user_branch_id'));
		}
		if (!empty($seller))
		{
			$this->db->where('ti.ticket_user_id', $seller);
		}
		
		$this->db->group_by('t.transaction_id'); 
		
		$query = $this->db->get('transactions t');
		return $query->result();
	}
	
	function total_transaction($date_from, $date_to, $eventid, $branchid, $seller)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('COUNT(t.transaction_id) as total_trasaction');
		$this->db->join($this->users, 'u.user_id = t.transaction_user_id', 'left');
		$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id', 'left');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id', 'left');
		$this->db->where('t.transaction_date >=', $date_from.' 00:00:01');
		$this->db->where('t.transaction_date <=', $date_to.' 23:59:59');
		$this->db->where('t.transaction_user_id', '1');
		$this->db->where('t.transaction_status', 'done');
		if (!empty($eventid))
		{
			$this->db->where('ev.event_id', $eventid);
		}
		if ($this->session->userdata('user_branch_id') == 1)
		{
			if (!empty($branchid))
			{
				$this->db->where('ti.ticket_branch_id', $branchid);
			}
		}
		else
		{
			$this->db->where('ti.ticket_branch_id', $this->session->userdata('user_branch_id'));
		}
		if (!empty($seller))
		{
			$this->db->where('ti.ticket_user_id', $seller);
		}	
		$this->db->group_by('t.transaction_id'); 
		
		$query = $this->db->get('transactions t');
		return $query->num_rows();
	}
	
	function count_online_transaction($transaction_id, $transaction_date = false)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('COUNT(ti.ticket_id) as qty');
		$this->db->join($this->transactions, 'ti.ticket_transaction_id = t.transaction_id', 'left outer');
		$this->db->where('ti.ticket_transaction_id =', $transaction_id);
		if ($transaction_date != '')
		{
			$this->db->where('t.transaction_date like', $transaction_date);
		}
		$query = $this->db->get('tickets ti');
		return $query->result();
	}
	
	function count_sales_transaction($ticket_id)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('COUNT(ticket_id) as qty');
		$this->db->where('ticket_id =', $ticket_id);

		$query = $this->db->get('tickets');
		return $query->result();
	}
	
	/** Summary of detailed Sales **/
	
	function sales_transactions($date_from, $date_to)
	 {
		 $this->db->query('set transaction isolation level read uncommitted');
		$this->db->select("t.transaction_id as temp_reservation_id, date(t.transaction_date) as temp_reservation_date
							, ti.ticket_acknowledgment_receipt, ti.ticket_status, c.customer_firstname
							, c.customer_lastname, c.customer_phone, c.customer_mobile, te.terminal_id, u.user_firstname
							, u.user_lastname, ev.event_title as event_name, sec.section_code as ticket_type_daw
							, ev.event_date_time, ti.ticket_status as temp_reservation_status, ti.ticket_row, ti.ticket_seat
							, ti.ticket_id, ev.event_service_charge as temp_con_charge, pr.price_price as ti_amt
							, tt.ticket_type_discount_type, tt.ticket_type_discount, ti.ticket_user_id
							, t.transaction_user_id, t.transaction_branch_id, pt.payment_type_type, ev.event_reservation_fee
							, ev.event_internet_sales_charge, ev.event_reservation_fee, ev.event_service_charge
							, ti.ticket_reservation_expiry, t.transaction_date");
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left outer');
		$this->db->join($this->users, 'u.user_id = t.transaction_user_id', 'left outer');
		$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id', 'left outer');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id', 'left outer');
		$this->db->join($this->sections, 'sec.section_id = ti.ticket_section_id', 'left outer');
		$this->db->join($this->prices, 'pr.price_id = ti.ticket_price_id', 'left outer');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left outer');
		$this->db->join($this->terminals, 'te.terminal_id = ti.ticket_terminal_id', 'left outer');
		$this->db->join($this->payments, 'pay.payment_transaction_id = t.transaction_id', 'left outer');
		$this->db->join($this->payment_types, 'pt.payment_type_id = pay.payment_payment_type_id', 'left outer');
		
		if($this->session->userdata('user_branch_id') == $this->config->item('melco_branch_id')){
		
			$this->db->where('ev.event_cod', 1);
		}
		
		$this->db->where('date(t.transaction_date) >=', $date_from);
		$this->db->where('date(t.transaction_date) <=', $date_to);
		$statuslist = array('selected', 'voided', 'expired', 'reservation_cancelled', 'unselected', 'reserved');
		$this->db->where_not_in('t.transaction_status', $statuslist );
		$this->db->where_not_in('ti.ticket_status', $statuslist );
		//$this->db->where('date(t.transaction_date) <=', $date_to);
		$this->db->group_by('ti.ticket_id');
		$this->db->order_by('t.transaction_date, t.transaction_id, ti.ticket_acknowledgment_receipt', 'asc');
		$query = $this->db->get('transactions t');
		return $query->result();
	}
	
	/*
	function get_user_details_by_ti_user_id($ticket_user_id = false)
	{
		$this->db->select('u.user_firstname, u.user_lastname');
		$this->db->where('u.user_id', $ticket_user_id);
		$query = $this->db->get('users u');
		
		return $query->row();
	}
	//*/
	
	// GET PAYMENT TYPES FOR TRANSACTION 09/17/2010
	// --------------------------------------------------------------------
	
	/**
	 * for cash breakdown on seller report (will try to use in advance sales report also) -- jaizon
	 *
	 * @access	public
	 */
	 
	 function get_payment_type($trans_id, $action, $pt_id = false)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		if($action == 'all')
		{
			$this->db->join($this->payment_types, 'pt.payment_type_id = pay.payment_payment_type_id');
		}
		$this->db->where('pay.payment_transaction_id', $trans_id);
		if($action == 'result')
		{
			$this->db->where('pay.payment_payment_type_id', $pt_id);
		}
		$query = $this->db->get('payments pay');

		switch($action)
		{
			case 'num_rows': { return $query->num_rows(); break; }
			case 'result'  : { return $query->result(); break; }
			case 'all'  : { return $query->result(); break; }
		}
	}
	 
	// GET PAYMENT AMOUNT FOR EVENT FOR SELLER FOR PAYMENT TYPE (PAYMENT TABLE) 10-27-10
	// --------------------------------------------------------------------
	
	/**25 November 2010 - updated by JAIZON
	 * for cash breakdown on seller report (will try to use in advance sales report also) -- jaizon
	 *
	 * @access	public
	 */
	 
	 function new_get_payment_amount($event_id, $seller_id = false, $reports_date, $payment_type_id = false)
	 {
		 $this->db->query('set transaction isolation level read uncommitted');
	 	$this->db->select('t.transaction_id, pay.payment_amount, t.transaction_cash_change');
		$this->db->join($this->transactions, 't.transaction_id = pay.payment_transaction_id');
		$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->where('ti.ticket_event_id', $event_id);
		if($seller_id)
		{
			$this->db->where('t.transaction_user_id ', $seller_id);
			$this->db->where('t.transaction_date >=', $reports_date.' 00:00:01');
		}
		$this->db->where('t.transaction_date <=', $reports_date.' 23:59:59');
		switch($payment_type_id)
		{
			case 1  :{	$this->db->where('(t.transaction_cash_payment > 0 OR pay.payment_payment_type_id = 1)');	break;}
			case 2  :{	$this->db->where('(t.transaction_card_payment > 0 OR pay.payment_payment_type_id = 2)');	break;}	
			default :{  $this->db->where('pay.payment_payment_type_id', $payment_type_id);                          break;}
			//case 'ALL':{ break; }		              
		}
		$this->db->where('t.transaction_status', 'done');
		$this->db->where('ti.ticket_status', 'done');
		$this->db->where('tt.ticket_type_group', 0);
		$this->db->group_by('t.transaction_id');
		
		$query = $this->db->get('payments pay');
		
		return $query->result();
	 }
	  
	// GET NO. OF TICKETS FOR TRANSACTION  09/17/2010
	// --------------------------------------------------------------------
	
	/**
	 * for cash breakdown on seller report (will try to use in advance sales report also) -- jaizon
	 *
	 * @access	public
	 */
	 
	 function get_no_of_tickets_for_trans($trans_id)
	 {
		 $this->db->query('set transaction isolation level read uncommitted');
	 	$this->db->select('ti.ticket_id');
	 	$this->db->where('ti.ticket_transaction_id', $trans_id);
		$query = $this->db->get('tickets ti');
		
		return $query->num_rows();
	 }
		
	// SALES BREAKDOWN
	// --------------------------------------------------------------------
	
	/**
	 * CASH,CARD,GC_SM,GC_SODEXHO
	 *
	 * @access	public
	 */
	function payment_type($event_id, $payment_type, $qty_amt, $seller_id, $reports_date)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		switch($qty_amt)
		{
			case 'QTY':	{ $this->db->select('COUNT(ti.ticket_id) as payment_qty');	break;}
			case 'AMT':	{ 
							switch($payment_type)
							{
								case 'CASH':		{	$this->db->select('SUM(DISTINCT(t.transaction_cash_payment)) as payment_amt'); break;}
								case 'CARD':		{	$this->db->select('SUM(DISTINCT(t.transaction_card_payment)) as payment_amt'); break;}
								case 'GC-SM':		{	$this->db->select('SUM(DISTINCT(t.transaction_gc_sm_payment)) as payment_amt'); break;}
								case 'GC-SODEXHO':	{	$this->db->select('SUM(DISTINCT(t.transaction_gc_sodeho_payment)) as payment_amt'); break;}
								case 'OTHER_PAYMENTS':	{	$this->db->select('SUM(DISTINCT(t.transaction_other_payment )) as payment_amt'); break;}
							}
							break;
						}
		}
		
		$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id');
		//$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id');
		$this->db->where('ti.ticket_event_id', $event_id);
		$this->db->where('t.transaction_user_id ', $seller_id);
		$this->db->where('t.transaction_date >=', $reports_date.' 00:00:01');
		$this->db->where('t.transaction_date <=', $reports_date.' 23:59:59');
		
		switch($qty_amt)
		{
		case 'QTY' :
		  {
			switch($payment_type)
			{
				case 'CASH': 		{ 
										$this->db->where('t.transaction_cash_payment >', 0);	
										$this->db->where('t.transaction_card_payment ', 0);
										$this->db->where('t.transaction_gc_sodeho_payment ', 0);
										$this->db->where('t.transaction_gc_sodeho_payment ', 0);
										$this->db->where('t.transaction_other_payment ', 0);
										break;
									}
				case 'CARD': 		{ 
										$this->db->where('t.transaction_cash_payment ', 0);
										$this->db->where('t.transaction_card_payment >', 0);	
										$this->db->where('t.transaction_gc_sodeho_payment ', 0);
										$this->db->where('t.transaction_gc_sodeho_payment ', 0);
										$this->db->where('t.transaction_other_payment ', 0);
										break;
									}
				case 'GC-SM': 		{ $this->db->where('t.transaction_gc_sm_payment >', 0);	break;}
				case 'GC-SODEXHO': 	{ $this->db->where('t.transaction_gc_sodeho_payment >', 0);	break;}
				case 'OTHER_PAYMENTS': 	{ 
											$this->db->where('t.transaction_cash_payment ', 0);
											$this->db->where('t.transaction_card_payment ', 0);	
											$this->db->where('t.transaction_gc_sodeho_payment ', 0);
											$this->db->where('t.transaction_gc_sodeho_payment ', 0);
											$this->db->where('t.transaction_other_payment >', 0);	
										
											break;
										}
				case 'MULTI': 		{ 
										$this->db->where('t.transaction_cash_payment >', 0);
										$this->db->where('t.transaction_card_payment >', 0);	
										//$this->db->where('t.transaction_gc_sodeho_payment ', 0);
										//$this->db->where('t.transaction_gc_sodeho_payment ', 0);
										//$this->db->where('t.transaction_other_payment >', 0);
										break;
									}
		  	}
		   }
		case 'AMT':
		  {
		  	switch($payment_type)
			{
		  		case 'CASH': {	$this->db->where('t.transaction_cash_payment >', 0);	break;}
				case 'CARD': {	$this->db->where('t.transaction_card_payment >', 0);	break;}
				case 'GC-SM': 		{ $this->db->where('t.transaction_gc_sm_payment >', 0);	break;}
				case 'GC-SODEXHO': 	{ $this->db->where('t.transaction_gc_sodeho_payment >', 0);	break;}
				case 'OTHER_PAYMENTS':{	$this->db->where('t.transaction_other_payment >', 0);	break;}
		  	}
			break;
		  }
		}
		$this->db->where('ti.ticket_status', 'done');
		$query = $this->db->get('transactions t');
		return $query->row();		
	}	

	// --------------------------------------------------------------------
	
	/**
	 * OTHER INCOME (RESERVATION OR SERVICE) QTY
	 *
	 * @access	public
	 */
	function other_income_qty($event_id, $type, $seller_id, $reports_date)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('count( ti.ticket_id ) as other_income_qty');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id');
		$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id');
		$this->db->where('ti.ticket_event_id', $event_id);
		$this->db->where('t.transaction_user_id ', $seller_id);
		$this->db->where('t.transaction_date >=', $reports_date.' 00:00:01');
		$this->db->where('t.transaction_date <=', $reports_date.' 23:59:59');
		switch($type)
		{
			case 'R' : {	$this->db->where('ti.ticket_reservation_expiry !=', '0000-00-00'); break;}
			case 'S' : {	$this->db->where('ti.ticket_reservation_expiry  =', '0000-00-00'); break;}
		}
		$query = $this->db->get('tickets ti');
		return $query->row();		
	}	
	
	// --------------------------------------------------------------------
	
	/**
	 * OTHER INCOME (RESERVATION OR SERVICE) AMT
	 *
	 * @access	public
	 */
	function other_income_amt($event_id, $type)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		switch($type)
		{
			case 'R':	{	$this->db->select('event_reservation_fee'); break;}
			case 'S':	{	$this->db->select('event_interest_fee'); break;}
		}
		$this->db->where('event_id', $event_id);
		$query = $this->db->get('events');
		return $query->row();		
	}	

	// --------------------------------------------------------------------
	
	/**
	 * FILTER REPORTS
	 *
	 * @access	public
	 */
	function reports_filter($reports)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		switch($reports)
		{
		case 'SELLER':
			{
				$date = $this->input->post('reports_date');
				//$date = new DateTime($this->input->post('reports_date'));
				//date_time_set($date, 00,00,01);	
				$user_id = $this->input->post('user_id');
				$event_id = $this->input->post('event_id');
				$view = $this->input->post('view');
				$dl = $this->input->post('dl');
				//$branch_id = $this->input->post('branch_id');
				//return array('reports_date' => date_format($date, 'Y-m-d'), 'user_id' => $user_id, 'event_id' => $event_id);
				return array('reports_date' => $date, 'user_id' => $user_id, 'event_id' => $event_id, 'report_view' => $view, 'report_dl' => $dl);
				break;
			}
		case 'AUDIT':
			{
				$date_to = $this->input->post('reports_date_to');
				//$date_to = new DateTime($this->input->post('reports_date_to'));
				//date_time_set($date_to, 00,00,01);	
				
				$date_from = $this->input->post('reports_date_from');
				//$date_from = new DateTime($this->input->post('reports_date_from'));
				//date_time_set($date_to, 00,00,01);	
				
				$user_id = $this->input->post('user_id');
				$event_id = $this->input->post('event_id');
				
				//return array('reports_date_to' => date_format($date_to, 'Y-m-d'),'reports_date_from' => date_format($date_from, 'Y-m-d'), 'user_id' => $user_id, 'event_id' => $event_id);
				return array('reports_date_to' => $date_to, 'reports_date_from' => $date_from, 'user_id' => $user_id, 'event_id' => $event_id);
				break;
			}	
		case 'ADVANCE':
			{
				$date = $this->input->post('reports_date');
				$date_from = $this->input->post('reports_date_from');
				$seller = $this->input->post('user_id');
				if($seller == "")
				{
					$seller = 1;
				}
				//$date_to = new DateTime($this->input->post('reports_date_to'));
				//date_time_set($date_to, 00,00,01);	
				$view = $this->input->post('view');
				$dl = $this->input->post('dl');
				
				//$date_from = $this->input->post('reports_date_from');
				//$date_from = new DateTime($this->input->post('reports_date_from'));
				//date_time_set($date_to, 00,00,01);	
				
				$event_id = $this->input->post('event_id');
				$event_long_title = $this->input->post('event_long_title');
				
				//return array('reports_date_to' => date_format($date_to, 'Y-m-d'),'reports_date_from' => date_format($date_from, 'Y-m-d'), 'event_id' => $event_id);
				return array('reports_date_from' => $date_from, 'reports_date' => $date, 'event_id' => $event_id, 'event_long_title' => $event_long_title, 'report_view' => $view, 'report_dl' => $dl, 'sellerr' => $seller);
				break;
			}
		case 'REPORTSOTC':
			{
				$date_from = $this->input->post('date_from');
				$date_to = $this->input->post('date_to');
				$event_id = $this->input->post('event_id');
				$branch_id = $this->input->post('branch_id');
				$user_id = $this->input->post('user_id');
				$event_long_title = $this->input->post('event_long_title');
				$view = $this->input->post('view');
				$dl = $this->input->post('dl');
				
				return array('date_from' => $date_from, 'date_to' => $date_to, 'event_id' => $event_id, 'branch_id' => $branch_id, 'user_id' => $user_id, 'event_long_title' => $event_long_title, 'report_view' => $view, 'report_dl' => $dl);
				break;
			}
		case 'NEWREPORTSCC':
			{
				$date_from = $this->input->post('date_from');
				$date_to = $this->input->post('date_to');
				
				$view = $this->input->post('view');
				$dl = $this->input->post('dl');
				$branch_id = $this->input->post('branch_id');
				if ($branch_id)
				{
					
				}
				else 
				{					
					$branch_id2 = $this->reports->gbiddos();
					//print_r($branch_id2);
					$branch_id = $branch_id2->user_branch_id;
				}
				
				return array('date_from' => $date_from, 'date_to' => $date_to, 'branch_id' => $branch_id, 'report_view' => $view, 'report_dl'=>$dl);
				break;
			}
		case 'NEWREPORTSSVS':
			{
				$view = $this->input->post('view');
                $dl = $this->input->post('dl');
				$date_from = $this->input->post('date_from');
				$date_to = $this->input->post('date_to');
				
				
				$branch_id = $this->input->post('branch_id');
				if ($branch_id)
				{
					
				}
				else 
				{					
					//$branch_id2 = $this->reports->gbiddos();
					//print_r($branch_id2);
					$branch_id = '';
				}
				
				return array('date_from' => $date_from, 'date_to' => $date_to, 'branch_id' => $branch_id, 'report_view' => $view, 'report_dl' => $dl);
				break;
			}
		case 'NEWREPORTSATR':
			{
				$date_from = $this->input->post('date_from');
				$date_to = $this->input->post('date_to');
				$view = $this->input->post('view');
				$dl = $this->input->post('dl');
				
				$branch_id = $this->input->post('branch_id');
				
				return array('date_from' => $date_from, 'date_to' => $date_to, 'branch_id' => $branch_id, 'report_view' => $view, 'report_dl' => $dl);
				break;
			}
		case 'NEWREPORTSTR':
			{
				$date_from = $this->input->post('date_from');
				$date_to = $this->input->post('date_to');
				$view = $this->input->post('view');
				$dl = $this->input->post('dl');
				
				//$branch_id = $this->input->post('branch_id');
				
				return array('date_from' => $date_from, 'date_to' => $date_to, 'report_view' => $view, 'report_dl' => $dl);
				break;
			}
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * FILTER REPORTS
	 *
	 * @access	public
	 */
	function reports_filter2($reports)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		switch($reports)
		{
		case 'SELLER':
			{
				$date = $this->input->post('reports_date');
				//$date = new DateTime($this->input->post('reports_date'));
				//date_time_set($date, 00,00,01);	
				$user_id = $this->input->post('user_id');
				$event_id = $this->input->post('event_id');
				//return array('reports_date' => date_format($date, 'Y-m-d'), 'user_id' => $user_id, 'event_id' => $event_id);
				return array('reports_date' => $date, 'user_id' => $user_id, 'event_id' => $event_id);
				break;
			}
		case 'AUDIT':
			{
				$date_to = $this->input->post('reports_date_to');
				//$date_to = new DateTime($this->input->post('reports_date_to'));
				//date_time_set($date_to, 00,00,01);	
				
				$date_from = $this->input->post('reports_date_from');
				//$date_from = new DateTime($this->input->post('reports_date_from'));
				//date_time_set($date_to, 00,00,01);	
				
				$branch_id = $this->input->post('branch_id');
				$event_id = $this->input->post('event_id');
				
				//return array('reports_date_to' => date_format($date_to, 'Y-m-d'),'reports_date_from' => date_format($date_from, 'Y-m-d'), 'user_id' => $user_id, 'event_id' => $event_id);
				return array('reports_date_to' => $date_to, 'reports_date_from' => $date_from, 'branch_id' => $branch_id, 'event_id' => $event_id);
				break;
			}	
		case 'ADVANCE':
			{
				$date_to = $this->input->post('reports_date_to');
				//$date_to = new DateTime($this->input->post('reports_date_to'));
				//date_time_set($date_to, 00,00,01);	
				
				$date_from = $this->input->post('reports_date_from');
				//$date_from = new DateTime($this->input->post('reports_date_from'));
				//date_time_set($date_to, 00,00,01);	
				
				$event_id = $this->input->post('event_id');
				
				//return array('reports_date_to' => date_format($date_to, 'Y-m-d'),'reports_date_from' => date_format($date_from, 'Y-m-d'), 'event_id' => $event_id);
				return array('reports_date_to' => $date_to, 'reports_date_from' => $date_from, 'event_id' => $event_id);
				break;
			}	
		}
	}	

	// --------------------------------------------------------------------
	
	/**
	 * number of tickets
	 *
	 * @access	public
	 */
	function no_of_tickets($event_id, $seller_id = false, $status, $seller_id = false, $reports_date)
	{
		$this->db->query('set transaction isolation level read uncommitted');
	 	$this->db->select('count(ti.ticket_id) as no_of_tickets');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id');
		$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id');
		$this->db->where('ev.event_id ', $event_id);
		if($seller_id)
		{
			$this->db->where('t.transaction_user_id ', $seller_id);
			$this->db->where('t.transaction_date >=', $reports_date.' 00:00:01');
		}
		$this->db->where('t.transaction_date <=', $reports_date.' 23:59:59');
		
		switch($status)
		{
			case 'ALL': 	{	/*$this->db->where('ti.ticket_status', 'done')*/; break;}
			case 'VOID': 	{ 	$this->db->where('ti.ticket_status', 'voided');		break;}
			case 'CANCEL': 	{ 	$this->db->where('ti.ticket_status', 'cancelled');	break;}
		}
		$query = $this->db->get('tickets ti');
		return $query->row();		
	}	
		
	
	// --------------------------------------------------------------------
	
	/**
	 * number of transaction
	 *
	 * @access	public
	 */
	function no_of_tickets2($event_id, $seller_id = false, $status, $seller_id = false, $reports_date)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		switch($status)
		{
			case 'ALL':	{	$this->db->select('count(distinct(t.transaction_id)) as no_of_tickets');	break;}
			case 'VOID':	{	$this->db->select('count(ti.ticket_id) as no_of_tickets');	break;}
		}
	 	
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id');
		$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->where_in('ev.event_id ', $event_id);
		if($seller_id)
		{
			$this->db->where('t.transaction_user_id ', $seller_id);
			$this->db->where('t.transaction_date >=', $reports_date.' 00:00:01');
		}
		else if(!$seller_id)
		{
			$this->db->where('tt.ticket_type_group < 1');
		}
		$this->db->where('t.transaction_date <=', $reports_date.' 23:59:59');
		
		switch($status)
		{
			case 'ALL': {
					 $this->db->where('t.transaction_status', 'done');
					 break;}
			case 'VOID': { $this->db->where('ti.ticket_status', 'voided'); break;}
			//case 'CANCEL': { $this->db->where('t.transaction_status', 'cancelled'); break;}
		}
		
		$query = $this->db->get('tickets ti');
		return $query->row();		
	}

	// --------------------------------------------------------------------
	
	/**
	 * BLANK TICKET FROM SERIES
	 *
	 * @access	public
	 */
	function blank_ticket($seller_id, $reports_date)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->where('session_user_id', $seller_id);
		$this->db->where('session_date_time >=', $reports_date.' 00:00:01');
		$this->db->where('session_date_time <=', $reports_date.' 23:59:59');	
		$this->db->where('session_beginning_serial >', '0');
		$this->db->where('session_ending_serial >', '0');	
		$this->db->order_by('session_date_time', 'desc'); 
		$query = $this->db->get('sessions');
		
		
		return $query->result();		
	}			
	
//---------------------AUDIT TRAIL REPORTS

	// --------------------------------------------------------------------
	
	/**
	 * GET ALL AUDIT TRAIL REPORTS
	 *
	 * @access	public
	 */
	function get_audit_date($action, $date_from, $date_to, $seller)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		//$q = 'DATE_FORMAT(t.transaction_date,%Y-%m-%d'.'')'';
		switch($action)
		{
			case 'GROUP':
				{
					$this->db->select('date(t.transaction_date) as trans_date, t.transaction_date, br.branch_name, u.user_id, te.terminal_name, u.user_firstname, u.user_lastname');
					break;
				}
		}
		
		$this->db->join($this->branches, 'br.branch_id = t.transaction_branch_id');
		$this->db->join($this->users, 'u.user_id = t.transaction_user_id');
		$this->db->join($this->terminals, 'te.terminal_id = t.transaction_terminal_id');
		$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id');
		$this->db->where('t.transaction_date >=', $date_from.' 00:00:01');
		$this->db->where('t.transaction_date <=', $date_to.' 23:59:59');
		$this->db->where('t.transaction_user_id', $seller); 
		$this->db->where('t.transaction_status', 'done');
		$this->db->where('ti.ticket_status', 'done');
		switch($action)
		{
			case 'GROUP':
				{
					$this->db->group_by('trans_date');
					break;
				}
		}
		$this->db->order_by('t.transaction_date', 'asc');
		$query = $this->db->get('transactions t');
		return $query->result();		
	}		//select date(transaction_date) as trans_date from transactions group by (trans_date)
	
//---------------------VOIDED TRANSACTIONS REPORT

	function get_voided_date_seller($action, $date_from, $date_to, $seller)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		//$q = 'DATE_FORMAT(t.transaction_date,%Y-%m-%d'.'')'';
		switch($action)
		{
			case 'GROUP':
				{
					$this->db->select('date(t.transaction_date) as trans_date, t.transaction_date, br.branch_name, u.user_id, te.terminal_name, u.user_firstname, u.user_lastname');
					break;
				}
		}
		
		$this->db->join($this->branches, 'br.branch_id = t.transaction_branch_id');
		$this->db->join($this->users, 'u.user_id = t.transaction_user_id');
		$this->db->join($this->terminals, 'te.terminal_id = t.transaction_terminal_id');
		$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id');
		$this->db->where('t.transaction_date >=', $date_from.' 00:00:01');
		$this->db->where('t.transaction_date <=', $date_to.' 23:59:59');
		$this->db->where('t.transaction_user_id', $seller); 
		$this->db->where('t.transaction_status', 'voided');
		$this->db->where('ti.ticket_status', 'voided');
		switch($action)
		{
			case 'GROUP':
				{
					$this->db->group_by('trans_date');
					break;
				}
		}
		$this->db->order_by('t.transaction_date', 'asc');
		$query = $this->db->get('transactions t');
		return $query->result();		
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * GET ALL VOIDED TRANSACTIONS REPORT
	 *
	 * @access	public
	 */
	function get_voided_date($action, $date_from, $date_to, $branch)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		//$q = 'DATE_FORMAT(t.transaction_date,%Y-%m-%d'.'')'';
		switch($action)
		{
			case 'GROUP':
				{
					$this->db->select('date(t.transaction_date) as trans_date, t.transaction_date, t.transaction_branch_id, u.user_id, t.transaction_user_id, u.user_firstname, u.user_lastname, u.username');
					break;
				}
		}
		
		//$this->db->join($this->branches, 'br.branch_id = t.transaction_branch_id');
		$this->db->join($this->users, 'u.user_id = t.transaction_user_id');
		$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id');
		$this->db->where('t.transaction_date >=', $date_from.' 00:00:01');
		$this->db->where('t.transaction_date <=', $date_to.' 23:59:59');
		if($branch)
		{
			$this->db->where('t.transaction_branch_id', $branch);
		} 
		$this->db->where('ti.ticket_status !=', 'done');
		$this->db->where('ti.ticket_status !=', 'reserved');
		$this->db->where('ti.ticket_status !=', 'selected');
		$this->db->where('ti.ticket_status !=', 'unselected');
		$this->db->where('ti.ticket_status !=', 'paid_online');
		switch($action)
		{
			case 'GROUP':
				{
					$this->db->group_by(array("trans_date", "u.user_id"));
					break;
				}
		}
		$this->db->order_by('trans_date', 'asc');
		$query = $this->db->get('transactions t');
		return $query->result();		
	}
	/*{
		//$q = 'DATE_FORMAT(t.transaction_date,%Y-%m-%d'.'')'';
		switch($action)
		{
			case 'GROUP':
				{
					$this->db->select('date(t.transaction_date) as trans_date, t.transaction_date, br.branch_name, u.user_id, te.terminal_name, u.user_firstname, u.user_lastname');
					break;
				}
		}
		
		$this->db->join($this->branches, 'br.branch_id = t.transaction_branch_id');
		$this->db->join($this->users, 'u.user_id = t.transaction_user_id');
		$this->db->join($this->terminals, 'te.terminal_id = t.transaction_terminal_id');
		$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id');
		$this->db->where('t.transaction_date >=', $date_from.' 00:00:01');
		$this->db->where('t.transaction_date <=', $date_to.' 23:59:59');
		$this->db->where('t.transaction_user_id', $seller); 
		//$this->db->where('t.transaction_status', 'voided');
		$this->db->where('ti.ticket_status !=', 'done');
		$this->db->where('ti.ticket_status !=', 'reserved');
		switch($action)
		{
			case 'GROUP':
				{
					$this->db->group_by('trans_date');
					break;
				}
		}
		$this->db->order_by('t.transaction_date', 'asc');
		$query = $this->db->get('transactions t');
		return $query->result();		
	}*/	
	
	// --------------------------------------------------------------------
	
	
	/**
	 * GET ALL AUDIT TRAIL REPORTS
	 *
	 * @access	public
	 */
	function get_audit_date2($action, $date_from, $date_to, $branch = false)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		//$q = 'DATE_FORMAT(t.transaction_date,%Y-%m-%d'.'')'';
		switch($action)
		{
			case 'GROUP':
				{
					$this->db->select('date(t.transaction_date) as trans_date, t.transaction_date, t.transaction_branch_id, t.transaction_user_id');
					break;
				}
		}
		
		//$this->db->join($this->branches, 'br.branch_id = t.transaction_branch_id');
		$this->db->join($this->users, 'u.user_id = t.transaction_user_id');
		$this->db->where('t.transaction_date >=', $date_from.' 00:00:01');
		$this->db->where('t.transaction_date <=', $date_to.' 23:59:59');
		if($branch)
		{
			$this->db->where('t.transaction_branch_id', $branch);
		} 
		$this->db->where('t.transaction_status !=', 'reservation_cancelled');
		switch($action)
		{
			case 'GROUP':
				{
					$this->db->group_by(array("trans_date", "u.user_id"));
					break;
				}
		}
		$this->db->order_by('trans_date', 'asc');
		$query = $this->db->get('transactions t');
		return $query->result();		
	}
	
	//---------------------------------------------------------------------
	/**
	 * GET ALL AUDIT TRAIL REPORTS BRANCHES
	 *
	 * @access	public
	 */
	 
	 function get_audit_all_branches($action, $date_from, $date_to)
	 {
		 $this->db->query('set transaction isolation level read uncommitted');
	 	//$q = 'DATE_FORMAT(t.transaction_date,%Y-%m-%d'.'')'';
		switch($action)
		{
			case 'GROUP':
				{
					$this->db->select('date(t.transaction_date) as trans_date, t.transaction_date, t.transaction_branch_id as branch, t.transaction_user_id');
					break;
				}
		}
		
		//$this->db->join($this->branches, 'br.branch_id = t.transaction_branch_id');
		$this->db->join($this->users, 'u.user_id = t.transaction_user_id');
		$this->db->where('t.transaction_date >=', $date_from.' 00:00:01');
		$this->db->where('t.transaction_date <=', $date_to.' 23:59:59');
		if($branch)
		{
			$this->db->where('t.transaction_branch_id', $branch);
		} 
		$this->db->where('t.transaction_status !=', 'reservation_cancelled');
		switch($action)
		{
			case 'GROUP':
				{
					$this->db->group_by(array("trans_date", "branch", "u.user_id"));
					break;
				}
		}
		$this->db->order_by('branch', 'asc');
		$query = $this->db->get('transactions t');
		return $query->result();
	 }
	 
	// --------------------------------------------------------------------
	
	/**
	 * GET ALL AUDIT TRAIL REPORTS
	 *
	 * @access	public
	 */
	function get_audit_all_events($action, $date_from, $date_to, $seller_id, $event_id)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->join($this->branches, 'br.branch_id = t.transaction_branch_id');
		$this->db->join($this->users, 'u.user_id = t.transaction_user_id');
		$this->db->join($this->terminals, 'te.terminal_id = t.transaction_terminal_id');
		$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id');
		$this->db->where('t.transaction_user_id', $seller_id);	
		$this->db->where('t.transaction_date >=', $date_from.' 00:00:01');
		$this->db->where('t.transaction_date <=', $date_to.' 23:59:59');
		$this->db->where('t.transaction_status', 'done');
		//$this->db->order_by('t.transaction_date', 'asc');
		switch($action)
		{
			case 'ALL': 
				{
					$this->db->where('ti.ticket_event_id', $event_id);
					//$this->db->group_by('ti.ticket_type_id');	
					$this->db->order_by('t.transaction_id', 'asc'); 
					break;
				}
			case 'GROUP': 
				{	
					$this->db->group_by('ti.ticket_event_id');	
					$this->db->order_by('ti.ticket_event_id', 'asc'); 
					break;
				}
		}
		
		
		$query = $this->db->get('transactions t');
		return $query->result();		
	}
	
	/**
	 * GET ALL VOIDED TRANSACTION BY SELLER REPORTS
	 *
	 * @access	public
	 */
	function get_voided_all_events_seller($action, $date_from, $date_to, $seller_id, $event_id)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->join($this->branches, 'br.branch_id = t.transaction_branch_id', 'left outer');
		$this->db->join($this->users, 'u.user_id = t.transaction_user_id', 'left outer');
		$this->db->join($this->terminals, 'te.terminal_id = t.transaction_terminal_id', 'left outer');
		$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id', 'left outer');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id', 'left outer');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left outer');
		$this->db->join($this->prices, 'pr.price_id = ti.ticket_price_id', 'left outer', 'left outer');
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left outer');
		$this->db->join($this->sections, 'sec.section_id = pr.price_sections', 'left outer');
		$this->db->where('t.transaction_user_id', $seller_id);	
		$this->db->where('t.transaction_date >=', $date_from.' 00:00:01');
		$this->db->where('t.transaction_date <=', $date_to.' 23:59:59');
		$this->db->where('ti.ticket_status !=', 'done');
		$this->db->where('ti.ticket_status !=', 'reserved');
		//$this->db->where('ti.ticket_status', 'voided');
		$this->db->order_by('t.transaction_date', 'asc');
		switch($action)
		{
			case 'ALL': 
				{
					$this->db->where('ti.ticket_event_id', $event_id);
					//$this->db->group_by('ti.ticket_type_id');	
					$this->db->order_by('t.transaction_id', 'asc'); 
					break;
				}
			//case 'GROUP': 
			//	{	
			//		$this->db->group_by('ti.ticket_event_id');	
			//		$this->db->order_by('ti.ticket_event_id', 'asc'); 
			//		break;
			//	}
		}
		
		
		$query = $this->db->get('transactions t');
		return $query->result();		
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * GET ALL VOIDED TRANSACTION REPORTS
	 *
	 * @access	public
	 */
	function get_voided_all_events($action, $date_from, $date_to, $branch_id, $seller_id, $event_id)//($action, $date_from, $date_to, $seller_id, $event_id)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->join($this->branches, 'br.branch_id = t.transaction_branch_id', 'left outer');
		$this->db->join($this->users, 'u.user_id = t.transaction_user_id', 'left outer');
		$this->db->join($this->terminals, 'te.terminal_id = t.transaction_terminal_id', 'left outer');
		$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id', 'left outer');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id', 'left outer');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left outer');
		$this->db->join($this->prices, 'pr.price_id = ti.ticket_price_id', 'left outer');
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left outer');
		$this->db->join($this->sections, 'sec.section_id = pr.price_sections', 'left outer');
		$this->db->where('t.transaction_user_id', $seller_id);	
		$this->db->where('t.transaction_date >=', $date_from.' 00:00:01');
		$this->db->where('t.transaction_date <=', $date_to.' 23:59:59');
		$this->db->where('ti.ticket_status !=', 'done');
		//$this->db->where('ti.ticket_status !=', 'paid');
		$this->db->where('ti.ticket_status !=', 'reserved');
		//$this->db->where('ti.ticket_status', 'voided');
		$this->db->order_by('t.transaction_date', 'asc');
		switch($action)
		{
			case 'ALL': 
				{
					$this->db->where('ti.ticket_event_id', $event_id);
					//$this->db->group_by('ti.ticket_type_id');	
					$this->db->order_by('t.transaction_id', 'asc'); 
					break;
				}
			//case 'GROUP': 
			//	{	
			//		$this->db->group_by('ti.ticket_event_id');	
			//		$this->db->order_by('ti.ticket_event_id', 'asc'); 
			//		break;
			//	}
		}
		
		
		$query = $this->db->get('transactions t');
		return $query->result();		
	}
	
	function get_section_name($section_id)
	{	
	$this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('section_name');
		$this->db->where('section_id', $section_id);
		$query = $this->db->get('sections');
		return $query->result();
	}

	// --------------------------------------------------------------------
	
	/**
	 * GET ALL AUDIT TRAIL REPORTS
<<<<<<< .mine
	 *
	 * @aelleress	public
	 */
	function get_audit_all_events2($action, $date_from, $date_to, $branch_id, $seller_id, $event_id)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->join($this->branches, 'br.branch_id = t.transaction_branch_id');
		$this->db->join($this->users, 'u.user_id = t.transaction_user_id');
		$this->db->join($this->terminals, 'te.terminal_id = t.transaction_terminal_id');
		$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id');
		$this->db->where('t.transaction_status !=', 'reservation_cancelled');
		$this->db->where('t.transaction_user_id', $seller_id);
		$this->db->where('br.branch_id', $branch_id);	
		$this->db->where('t.transaction_date >=', $date_from.' 00:00:01');
		$this->db->where('t.transaction_date <=', $date_to.' 23:59:59');
		//$this->db->order_by('t.transaction_date', 'asc');
		switch($action)
		{
			case 'ALL': 
				{
					$this->db->where('ti.ticket_event_id', $event_id);
					//$this->db->group_by('ti.ticket_type_id');	
					$this->db->order_by('t.transaction_id', 'asc'); 
					break;
				}
			case 'GROUP': 
				{	
					$this->db->group_by('ti.ticket_event_id');	
					$this->db->order_by('ti.ticket_event_id', 'asc'); 
					break;
				}
		}
		
		
		$query = $this->db->get('transactions t');
		return $query->result();		
	}

	// --------------------------------------------------------------------
	
	/**
	 * GET ALL AUDIT TRAIL REPORTS
	 *
	 * @access	public
	 */
	function get_audit_all_sellers($action, $date_from, $date_to, $branch_id, $seller_id)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->join($this->branches, 'br.branch_id = t.transaction_branch_id');
		$this->db->join($this->users, 'u.user_id = t.transaction_user_id');
		//$this->db->join($this->terminals, 'te.terminal_id = t.transaction_terminal_id');
		$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id');
		$this->db->where('t.transaction_status !=', 'reservation_cancelled');
		$this->db->where('u.user_id', $seller_id);
		$this->db->where('br.branch_id', $branch_id);	
		$this->db->where('t.transaction_date >=', $date_from.' 00:00:01');
		$this->db->where('t.transaction_date <=', $date_to.' 23:59:59');
		//$this->db->order_by('t.transaction_date', 'asc');
		switch($action)
		{
			case 'ALL': 
				{
					$this->db->where('t.transaction_user_id', $event_id);
					//$this->db->group_by('ti.ticket_type_id');	
					$this->db->order_by('t.transaction_user_id', 'asc'); 
					break;
				}
			case 'GROUP': 
				{	
					$this->db->group_by('u.user_id');	
					$this->db->order_by('u.user_id', 'asc'); 
					break;
				}
		}
		
		
		$query = $this->db->get('transactions t');
		return $query->result();		
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * GET ALL AUDIT TRAIL REPORTS
>>>>>>> .r281
	 *	GET TRANSACTION GROUP BY TT
	 * @access	public
	 */
	function get_transaction_group_by_tt($transaction_id, $action, $ticket_type)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		switch($action)
		{
			case 'COUNT':	{	$this->db->select('count(t.transaction_id) as qty'); break;}
			case 'AMOUNT':	{	
								$this->db->select('tt.ticket_type_discount_type as tttype');
								$this->db->where('tt.ticket_type_code', $ticket_type);
								$disc_type = $this->db->get('ticket_types tt');
		
								if($disc_type->row('tttype') == 'Percentage')
								{
									$this->db->select('sum(ceil(pr.price_price - ((pr.price_price * tt.ticket_type_discount)/100))) as price');
								}
								else
								{
									$this->db->select('sum(ceil(pr.price_price - tt.ticket_type_discount)) as price');
								} 
								break;
							}
		}
		$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->join($this->customers, 't.transaction_customer_id = c.customer_id');
		$this->db->join($this->sections, 'sec.section_id = ti.ticket_section_id');
		$this->db->join($this->prices, 'pr.price_id = ti.ticket_price_id');
		switch($action)
		{
			//case 'AMOUNT':	{	$this->db->join($this->prices, 'pr.price_id = ti.ticket_price_id');break;}
			case 'COUNT':	{	$this->db->where('tt.ticket_type_code', $ticket_type);break;}
		}
		
		
		switch($action)
		{
			case 'AMOUNT':	{	$this->db->where('tt.ticket_type_code', $ticket_type);break;}
			case 'GROUP':	{	$this->db->group_by('tt.ticket_type_id'); break;}
			
			
		}	
		$this->db->where('ti.ticket_transaction_id', $transaction_id);		
		$this->db->where('ti.ticket_status', 'done');	
		$query = $this->db->get('transactions t');
		switch($action)
		{
			case 'GROUP': {		return $query->result();	break;}
			case 'COUNT': {		return $query->row();	break;}
			case 'AMOUNT': {	return $query->row();	break;}
		}
				
	}

	// --------------------------------------------------------------------
	
	/**
	 * GET ALL VOIDED TRANSACTIONS REPORTS
>>>>>>> .r281
	 *	GET TRANSACTION GROUP BY TT
	 * @access	public
	 */
	function get_voided_group_by_tt($transaction_id, $action, $ticket_type, $ticket_acknowledgment_receipt)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		switch($action)
		{
			case 'COUNT':	
			{	
				$this->db->select('ti.ticket_row as row, ti.ticket_seat as seat'); 
				break;
			}
			case 'AMOUNT':	
			{	
				$this->db->select('tt.ticket_type_discount_type');
				$this->db->where('tt.ticket_type_code', $ticket_type);
				//$this->db->where('pr.price_price > 0');
				$disc_type = $this->db->get('ticket_types tt');
				//echo $disc_type->row('tttype');
				/*if($disc_type->row('tttype') == 'Percentage')
				{
					$this->db->select('ceil(pr.price_price - ((pr.price_price * tt.ticket_type_discount)/100)) as price');
				}
				else
				{
					if ($disc_type->row('tt.ticket_type_discount') != "0")
					{						 
						$this->db->select('ceil(pr.price_price - tt.ticket_type_discount) as price');
					}
					else
					{
						$this->db->select('ceil(pr.price_price) as price');
					}
				} */
				break;
			}
		}
		$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->join($this->customers, 't.transaction_customer_id = c.customer_id', 'left outer');
		switch($action)
		{
			case 'AMOUNT':	{	$this->db->join($this->prices, 'pr.price_id = ti.ticket_price_id');break;}
			case 'COUNT':	{	$this->db->where('tt.ticket_type_code', $ticket_type);
								$this->db->where('ti.ticket_acknowledgment_receipt', $ticket_acknowledgment_receipt);break;}
		}
		
		
		switch($action)
		{
			case 'AMOUNT':	{	$this->db->where('tt.ticket_type_code', $ticket_type);break;}
			case 'GROUP':	{	$this->db->group_by('ti.ticket_id'); break;}
			
			
		}	
		$this->db->where('ti.ticket_transaction_id', $transaction_id);		
		$this->db->where('ti.ticket_status', 'voided');	
		$query = $this->db->get('transactions t');
		switch($action)
		{
			case 'GROUP': {		return $query->result();	break;}
			case 'COUNT': {		return $query->row();	break;}
			case 'AMOUNT': {	return $query->row();	break;}
		}
				
	}
		
	// --------------------------------------------------------------------
	
	/**
	 * GET ALL AUDIT TRAIL REPORTS
	 *	GET TRANSACTION PER DAY
	 * @access	public
	 */
	function get_transaction_per_day($date_from, $date_to, $seller_id, $event_id)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->where('ti.ticket_event_id', $event_id);
		$this->db->where('t.transaction_user_id', $seller_id);	
		$this->db->where('t.transaction_date >=', $date_from.' 00:00:01');
		$this->db->where('t.transaction_date <=', $date_to.' 23:59:59');	
		$this->db->where('t.transaction_status', 'done');
		//$this->db->order_by('t.transaction_date', 'asc'); 
		$this->db->group_by('t.transaction_id');
		
		$query = $this->db->get('transactions t');
		return $query->result();			
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * GET ALL VOIDED TRANSACTIONS REPORT
	 *	GET TRANSACTION PER DAY
	 * @access	public
	 */
	function get_voided_transaction_per_day($date_from, $date_to, $seller_id, $event_id)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->where('ti.ticket_event_id', $event_id);
		$this->db->where('t.transaction_user_id', $seller_id);	
		$this->db->where('t.transaction_date >=', $date_from.' 00:00:01');
		$this->db->where('t.transaction_date <=', $date_to.' 23:59:59');	
		$this->db->where('t.transaction_status', 'voided');
		//$this->db->order_by('t.transaction_date', 'asc'); 
		$this->db->group_by('t.transaction_id');
		
		$query = $this->db->get('transactions t');
		return $query->result();			
	}


	// --------------------------------------------------------------------
	
	/**
	 * GET ALL AUDIT TRAIL REPORTS
	 *	GET NO. OF TICKETS
	 * @access	public
	 */
	function get_ticket_qty($transaction_id, $ticket_type_code)
	{
		$this->db->query('set transaction isolation level read uncommitted');
//		$this->db->join($this->branches, 'br.branch_id = t.transaction_branch_id');
//		$this->db->join($this->users, 'u.user_id = t.transaction_user_id');
//		$this->db->join($this->terminals, 'te.terminal_id = t.transaction_terminal_id');
		$this->db->select('count(t.transaction_id) as qty');
		$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->where('ti.ticket_transaction_id', $transaction_id);	
		$this->db->where('tt.ticket_type_code', $ticket_type_code);	
		//$this->db->order_by('t.transaction_date', 'asc'); 
//		$this->db->group_by('ti.ticket_type_id');
		$query = $this->db->get('transactions t');
		return $query->row();		
	}	
	
	// --------------------------------------------------------------------
	
	/**
	 * GET ALL AUDIT TRAIL REPORTS
	 *	AMOUNT
	 * @access	public
	 */
	function get_ticket_amount($transaction_id, $ticket_type_code)
	{
		$this->db->query('set transaction isolation level read uncommitted');
//		$this->db->select('sum(pr.price_price - ((pr.price_price * tt.ticket_type_discount)/100)) as price');
//		$this->db->join($this->branches, 'br.branch_id = t.transaction_branch_id');
//		$this->db->join($this->users, 'u.user_id = t.transaction_user_id');
//		$this->db->join($this->terminals, 'te.terminal_id = t.transaction_terminal_id');
		$this->db->select('tt.ticket_type_discount_type as tttype');
		$this->db->where('tt.ticket_type_code', $ticket_type_code);
		$disc_type = $this->db->get('ticket_types tt');
		
		if($disc_type->row('tttype') == 'Percentage')
		{
			$this->db->select('sum(ceil(pr.price_price - ((pr.price_price * tt.ticket_type_discount)/100))) as price');
		}
		else
		{
			$this->db->select('sum(ceil(pr.price_price - tt.ticket_type_discount)) as price');
		}
		$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->join($this->prices, 'pr.price_id = ti.ticket_price_id');
		$this->db->where('ti.ticket_transaction_id', $transaction_id);	
		$this->db->where('tt.ticket_type_code', $ticket_type_code);	
		//$this->db->order_by('t.transaction_date', 'asc'); 
//		$this->db->group_by('ti.ticket_type_id');
		$query = $this->db->get('transactions t');
		if ($query->row('price') == null)
        {
            $querys = 0;
        }
        else
        {
            $querys = $query->row('price');
            //$prc_new = 1;
        }
		
		return array($querys);		
	}		
		
	// --------------------------------------------------------------------
	
	/**
	 * GET ALL AUDIT TRAIL REPORTS
	 *	AMOUNT
	 * @access	public
	 */
	function get_total_amount_without_void($date, $user_id, $event_id, $action)
	{
		$this->db->query('set transaction isolation level read uncommitted');
//		$this->db->select('sum(pr.price_price - ((pr.price_price * tt.ticket_type_discount)/100)) as price');
//		$this->db->join($this->branches, 'br.branch_id = t.transaction_branch_id');
//		$this->db->join($this->users, 'u.user_id = t.transaction_user_id');
//		$this->db->join($this->terminals, 'te.terminal_id = t.transaction_terminal_id');
		switch($action)
		{
			case 'AMOUNT': {
								$this->db->select('tt.ticket_type_discount_type as tttype');
								$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id');
								$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id');
								$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
								$this->db->join($this->prices, 'pr.price_id = ti.ticket_price_id');
								$this->db->where('t.transaction_user_id', $user_id);	
								$this->db->where('ti.ticket_status', 'done');
								$this->db->where('t.transaction_date >=', $date.' 00:00:01');
								$this->db->where('t.transaction_date <=', $date.' 23:59:59');
								$this->db->where('ev.event_id', $event_id);
								$disc_type = $this->db->get('transactions t');
		
								if($disc_type->row('tttype') == 'Percentage')
								{
									$this->db->select('sum(ceil(pr.price_price - ((pr.price_price * tt.ticket_type_discount)/100))) as price');
								}
								else
								{
									$this->db->select('sum(ceil(pr.price_price - tt.ticket_type_discount)) as price');
								}
							break;}
			case 'QTY': {	
							$this->db->select('count(ti.ticket_id) as price');
			break;
			}
		}
		
		$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->join($this->prices, 'pr.price_id = ti.ticket_price_id');
		$this->db->where('t.transaction_user_id', $user_id);	
		$this->db->where('ti.ticket_status', 'done');
		$this->db->where('t.transaction_date >=', $date.' 00:00:01');
		$this->db->where('t.transaction_date <=', $date.' 23:59:59');
		$this->db->where('ev.event_id', $event_id);	
		//$this->db->order_by('t.transaction_date', 'asc'); 
//		$this->db->group_by('ti.ticket_type_id');
		$query = $this->db->get('transactions t');
		if ($query->row('price') == null)
        {
            $querys = 0;
        }
        else
        {
            $querys = $query->row('price');
            //$prc_new = 1;
        }
		
		return array($querys);		
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * GET ALL VOIDED TRANSACTIONS REPORTS
	 *	AMOUNT
	 * @access	public
	 */
	function get_total_amount_with_void($date, $user_id, $event_id, $action)
	{
		$this->db->query('set transaction isolation level read uncommitted');
//		$this->db->select('sum(pr.price_price - ((pr.price_price * tt.ticket_type_discount)/100)) as price');
//		$this->db->join($this->branches, 'br.branch_id = t.transaction_branch_id');
//		$this->db->join($this->users, 'u.user_id = t.transaction_user_id');
//		$this->db->join($this->terminals, 'te.terminal_id = t.transaction_terminal_id');
		switch($action)
		{
			case 'AMOUNT': {
								$this->db->select('tt.ticket_type_discount_type as tttype');
								$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id');
								$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id');
								$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
								$this->db->join($this->prices, 'pr.price_id = ti.ticket_price_id');
								$this->db->where('t.transaction_user_id', $user_id);	
								$this->db->where('ti.ticket_status', 'voided');
								$this->db->where('t.transaction_date >=', $date.' 00:00:01');
								$this->db->where('t.transaction_date <=', $date.' 23:59:59');
								$this->db->where('ev.event_id', $event_id);
								$disc_type = $this->db->get('transactions t');
		
								if($disc_type->row('tttype') == 'Percentage')
								{
									$this->db->select('sum(ceil(pr.price_price - ((pr.price_price * tt.ticket_type_discount)/100))) as price');
								}
								else
								{
									$this->db->select('sum(ceil(pr.price_price - tt.ticket_type_discount)) as price');
								}
							break;}
			case 'QTY': {	
							$this->db->select('count(ti.ticket_id) as price');
			break;
			}
		}
		
		$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->join($this->prices, 'pr.price_id = ti.ticket_price_id');
		$this->db->where('t.transaction_user_id', $user_id);	
		$this->db->where('ti.ticket_status', 'voided');
		$this->db->where('t.transaction_date >=', $date.' 00:00:01');
		$this->db->where('t.transaction_date <=', $date.' 23:59:59');
		$this->db->where('ev.event_id', $event_id);	
		//$this->db->order_by('t.transaction_date', 'asc'); 
//		$this->db->group_by('ti.ticket_type_id');
		$query = $this->db->get('transactions t');
		if ($query->row('price') == null)
        {
            $querys = 0;
        }
        else
        {
            $querys = $query->row('price');
            //$prc_new = 1;
        }
		
		return array($querys);		
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * GET ALL AUDIT TRAIL REPORTS
	 *	AMOUNT
	 * @access	public
	 */
	 
	 function get_all_amt_without_void($date, $user_id, $event_id, $action)
	 {
		 $this->db->query('set transaction isolation level read uncommitted');
	 	$this->db->select('tt.ticket_type_discount_type, pr.price_price, tt.ticket_type_discount');
		$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id');
		$this->db->join($this->prices, 'pr.price_id = ti.ticket_price_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id');
		$this->db->where('tt.ticket_type_group < 1');
		$this->db->where('t.transaction_user_id', $user_id);	
		$this->db->where('ti.ticket_status', 'done');
		$this->db->where('t.transaction_date >=', $date.' 00:00:01');
		$this->db->where('t.transaction_date <=', $date.' 23:59:59');
		$this->db->where('ev.event_id', $event_id);
		$query = $this->db->get('transactions t');
		return $query->result();
	 }
	 
	 // --------------------------------------------------------------------
	
	/**
	 * GET ALL AUDIT TRAIL REPORTS
	 *	AMOUNT
	 * @access	public
	 */
	 
	 function get_all_amt_with_void($date, $user_id, $event_id, $action)
	 {
		 $this->db->query('set transaction isolation level read uncommitted');
	 	$this->db->select('tt.ticket_type_discount_type, pr.price_price, tt.ticket_type_discount');
		$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id');
		$this->db->join($this->prices, 'pr.price_id = ti.ticket_price_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id');
		$this->db->where('tt.ticket_type_group < 1');
		$this->db->where('t.transaction_user_id', $user_id);	
		$this->db->where('ti.ticket_status', 'voided');
		$this->db->where('t.transaction_date >=', $date.' 00:00:01');
		$this->db->where('t.transaction_date <=', $date.' 23:59:59');
		$this->db->where('ev.event_id', $event_id);
		$query = $this->db->get('transactions t');
		return $query->result();
	 }
			
	// --------------------------------------------------------------------
	
	/**
	 * GET ALL AUDIT TRAIL REPORTS
	 *	GET REMARKS GROUP BY TICKET TYPE
	 * @access	public
	 */
	function get_remarks($transaction_id, $ticket_type_code, $action)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		switch($action)
		{
			case 'COUNT': {	$this->db->select('t.transaction_id');	break;}
			//case 'REMARK': { $this->db->select('ti.ticket_status');	break;}
		}
		
		$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->where('ti.ticket_transaction_id', $transaction_id);	
		$this->db->where('tt.ticket_type_code', $ticket_type_code);	
		switch($action)
		{
			case 'REMARK': {
						$this->db->where('ti.ticket_status', 'done');
						 $this->db->or_where('ti.ticket_status', 'voided');
						break;}
		}	
		//$this->db->order_by('t.transaction_date', 'asc'); 
		$this->db->group_by('ti.ticket_status');
		$query = $this->db->get('transactions t');
		//return $query->row();	
		switch($action)
		{
			case 'COUNT': {	$remarks = 	$query->num_rows(); 	break;}
			case 'REMARK': { $remarks = $query->row()->ticket_status; 	break;}
		}
		
		return array($remarks);
	}		
//--------------------ADVANCE SALES REPORTS

	// --------------------------------------------------------------------
	
	/**
	 * GET ALL ADVANCE SALES REPORTS
	 *	GET QTY OF TODAY SALES
	 * @access	public
	 */
	function get_today_sales_qty($action, $event_id, $price_id, $date_now)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		switch($action)
		{
			CASE 'QTY': { $this->db->select('count(ti.ticket_id) as qty');	break;}
			CASE 'AMT': { $this->db->select('sum(pr.price_price - ((pr.price_price * tt.ticket_type_discount)/100)) as price');	break;}
		}
		
		$this->db->join($this->transactions, 'ti.ticket_transaction_id = t.transaction_id');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id');
		$this->db->join($this->prices, 'pr.price_id = ti.ticket_price_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->where('ev.event_id', $event_id);	
		$this->db->where('pr.price_id', $price_id);	
		$this->db->where('t.transaction_date >=', $date_now.' 00:00:01');
		$this->db->where('t.transaction_date <=', $date_now.' 23:59:59');
		$query = $this->db->get('tickets ti');
		return $query->row();		
	}		
	// --------------------------------------------------------------------
	// ---------------
	
	// --------------------------------------------------------------------
	/**
	 * New Report Convenience and Other Charge(s)
	 *
	 * @access	public
	 */
	
	function con_charge_report($branch_id = false, $date_from = false, $date_to = false)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$get_online_branch_id = $this->reports->gbiddos();
		$online_branch_id = $get_online_branch_id->user_branch_id;
		
		$this->db->select('c.customer_firstname,c.customer_lastname, c.customer_address1,t.transaction_id,t.transaction_date,ch.charge_amount, t.transaction_id as temp_ar, COUNT(ti.ticket_id) AS tqty, ev.event_service_charge AS temp_con_charge, ev.event_internet_sales_charge AS total_con_charge, group_concat(ti.ticket_acknowledgment_receipt) as ar_no, t.transaction_receipt_number, t.transaction_status');

		$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id', 'left outer');
		$this->db->join($this->charges, 'ti.ticket_transaction_id = ch.charge_transaction_id', 'left outer');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id', 'left outer');
		$this->db->join($this->branches, 't.transaction_branch_id = br.branch_id', 'left outer');
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'inner');
		$this->db->where('date(t.transaction_date) >=', $date_from);
		$this->db->where('date(t.transaction_date) <=', $date_to);
		if ($branch_id != $online_branch_id)
		{
			$this->db->where('ti.ticket_branch_id', $branch_id);
		}
		else 
		{
			$this->db->where('t.transaction_branch_id', $branch_id);
		}
		
		if ($this->input->post('status') != 'voided')
		{
			$this->db->where_in('t.transaction_status', array('done','paid_online','paid'));
		}else{
			
			$this->db->where('t.transaction_status', 'voided');
			
		}
		
		
		//$this->db->where("(t.transaction_status = 'done' or t.transaction_status = 'paid_online')");
		$this->db->group_by('t.transaction_id');

 		$query = $this->db->get('transactions t');
		return $query->result();
	}
	
	// --------------------------------------------------------------------
	/**
	 * New Report Ticket Reservation
	 *
	 * @access	public
	 */
	function ticket_reservation_report($date_from = false, $date_to = false)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$get_online_branch_id = $this->reports->gbiddos();
		$online_branch_id = $get_online_branch_id->user_branch_id;
		
		$this->db->select("t.transaction_id as temp_reservation_id, date(t.transaction_date) as temp_reservation_date, c.customer_firstname, c.customer_lastname, c.customer_phone, c.customer_mobile, c.customer_email, u.user_firstname, u.user_lastname, ev.event_title as event_name, sec.section_code as ticket_type_daw, ev.event_date_time, ti.ticket_status as temp_reservation_status, ti.ticket_row, ti.ticket_seat, ev.event_reservation_fee as temp_con_charge, pr.price_price as ti_amt, tt.ticket_type_discount_type, tt.ticket_type_discount, ti.ticket_user_id, t.transaction_user_id, t.transaction_status, t.transaction_branch_id, ti.ticket_branch_id");
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left outer');
		$this->db->join($this->users, 'u.user_id = t.transaction_user_id', 'left outer');
		$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id', 'left outer');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id', 'left outer');
		$this->db->join($this->sections, 'sec.section_id = ti.ticket_section_id', 'left outer');
		$this->db->join($this->prices, 'pr.price_id = ti.ticket_price_id', 'left outer');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left outer');
		// $this->db->where("(date(t.transaction_date) between '".$date_from."' and '".$date_to."') and (t.transaction_status = 'paid_online')");
		$this->db->where("(date(t.transaction_date) between '".$date_from."' and '".$date_to."')");
		$this->db->where("date(ti.ticket_reservation_expiry) > '0000-00-00'");
		
		
		if($this->session->userdata('user_branch_id') == $this->config->item('melco_branch_id')){
		
			$this->db->where('ev.event_cod', 1);
		}
		
		
		$this->db->group_by('ti.ticket_id');
		$this->db->order_by('t.transaction_id, ti.ticket_row, ti.ticket_seat');
		$query = $this->db->get('transactions t');
		return $query->result();
	}
	
	// --------------------------------------------------------------------
	/**
	 * For Ticket Reservation Report --> Get user details (user_firstname, user_lastname as of 12-09-2010)
	 *
	 * @access	public
	 */
	function get_user_details_by_ti_user_id($ticket_user_id = false)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('u.user_firstname, u.user_lastname');
		$this->db->where('u.user_id', $ticket_user_id);
		$query = $this->db->get('users u');
		
		return $query->row();
	}
	// --------------------------------------------------------------------
	/**
	 * For Ticket Reservation Report --> Get transaction status (as of 12-15-2010)
	 *
	 * @access	public
	 */
	 /*
	function get_transaction_status($transaction_id = false)
	{
		$this->db->select('u.user_firstname, u.user_lastname');
		$this->db->where('u.user_id', $ticket_user_id);
		$query = $this->db->get('users u');
		
		return $query->row();
	}
	*/
	
// --------------------------------------------------------------------
	/*
	 * GET TRANSACTION STATUS AND GROUP CONCAT TICKET STATUS
	 * get_statuses
	 * @access public
	 */
	function get_statuses($transaction_id, $tt_code)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('t.transaction_status, group_concat(ti.ticket_status) as ti_status');
		$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db->where('ti.ticket_transaction_id', $transaction_id);	
		$this->db->where('tt.ticket_type_code', $tt_code);
		$this->db->where('ti.ticket_status', 'done');
		//$this->db->or_where('ti.ticket_status', 'voided');
		$this->db->group_by('ti.ticket_status');
		$query = $this->db->get('transactions t');
		
		return $query->result();
	}
	
	//----------------------------------------------------------------
	/*
	 * GET THE BRANCH ID OF THE DEFAULT ONLINE SELLER FROM CUSTOM
	 * get_branch_id_of_default_online_seller (gbiddos)
	 * @access public
	 */
	
	function gbiddos()
	{
		$this->db->query('set transaction isolation level read uncommitted');
		//print_r($this->config->item('online_seller_id'));
		$online_seller_id = $this->config->item('online_seller_id');
		//$branch_id = $this->db->query('select user_branch_id from users where user_id = "$online_seller_id"');
		
		$this->db->select('user_branch_id');
		$this->db->where('user_id', $online_seller_id);
		$branch_query = $this->db->get('users');
					
		return $branch_query->row();	
	}
	
	//-----------------------------------------------------------------
	/*
	 * NEW AUDIT TRAIL REPORT QUERY
	 * new_audit_trail
	 * @access public
	 */
	
	function new_audit_trail($date_to, $date_from, $branch_id = false, $action = false)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$get_online_branch_id = $this->reports->gbiddos();
		$online_branch_id = $get_online_branch_id->user_branch_id;
		
		$this->db->select('if((date(t.transaction_date) < ti.ticket_date_printed)
							, ti.ticket_date_printed, date(t.transaction_date)) as testdate
							, date(t.transaction_date) as trans_date
							, t.transaction_user_id
							, ti.ticket_event_id
							, t.transaction_id
							, ti.ticket_id
							, t.transaction_date
							, ti.ticket_section_id
							, ti.ticket_price_id
							, t.transaction_customer_id
							, ti.ticket_user_id
							, ti.ticket_branch_id
							, ti.ticket_acknowledgment_receipt
							, t.transaction_branch_id
							, t.transaction_receipt_number
							, t.transaction_status
							, ti.ticket_status
							, ti.ticket_reservation_expiry
							, ti.ticket_date_printed
							, ti.ticket_type_id
							
						');
		$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id', 'left outer');
		//$this->db->join($this->users, 'u.user_id = t.transaction_user_id', 'left outer');
		//$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id', 'left outer');
		//$this->db->join($this->sections, 'sec.section_id = ti.ticket_section_id', 'left outer');
		//$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left outer');
		//$this->db->join($this->prices, 'pr.price_id = ti.ticket_price_id', 'left outer');
		//$this->db->join($this->payments, 'pay.payment_transaction_id = t.transaction_id', 'left outer');
		//$this->db->join($this->payment_types, 'pt.payment_type_id = pay.payment_payment_type_id', 'left outer');
		//$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left outer');
		$this->db->where('((date(t.transaction_date) >= "' . $date_from . '"');
		$this->db->where('date(t.transaction_date) <= "' . $date_to . '")');
		$this->db->or_where('(date(ti.ticket_date_printed) >="' . $date_from . '"');
		$this->db->where('date(ti.ticket_date_printed) <= "' . $date_to . '"))');
		//$this->db->where('pay.payment_amount_type', 'tickets');
		if ($action == 'svspb')
		{
			$this->db->where('ti.ticket_status in("voided", "cancelled", "expired")');
		}
		elseif ($action == 'dsso')
		{
			$this->db->where('ti.ticket_status in("done", "paid_online")');
		}
		else
		{
			$this->db->where('ti.ticket_status in("done", "paid_online", "paid")');
		}
		if($branch_id == $online_branch_id)
		{
			$this->db->where("((t.transaction_branch_id = $branch_id) OR (ti.ticket_branch_id = $branch_id))");
			$this->db->order_by('date(t.transaction_date), t.transaction_user_id, t.transaction_id, ti.ticket_acknowledgment_receipt');
		}
		else
		{
			$this->db->where('ti.ticket_branch_id', $branch_id);
			$this->db->order_by('date(t.transaction_date), ti.ticket_user_id, t.transaction_id, ti.ticket_acknowledgment_receipt');
		}
		$query = $this->db->get('tickets ti');
		
		return $query->result();
	}
		
		
	function detailed_sales_summary($date_to, $date_from, $branch_id = false)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$online_seller = 1;
		
		$this->db->select('if((date(t.transaction_date) < ti.ticket_date_printed)
							, ti.ticket_date_printed, date(t.transaction_date)) as testdate
							, date(t.transaction_date) as trans_date
							, t.transaction_user_id
							, ti.ticket_event_id
							, t.transaction_id
							, ti.ticket_id
							, t.transaction_date
							, ti.ticket_section_id
							, ti.ticket_price_id
							, t.transaction_customer_id
							, ti.ticket_user_id
							, ti.ticket_branch_id
							, ti.ticket_acknowledgment_receipt
							, t.transaction_branch_id
							, t.transaction_receipt_number
							, t.transaction_status
							, ti.ticket_status
							, ti.ticket_reservation_expiry
							, ti.ticket_date_printed
							, ti.ticket_type_id
							
						');
		$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id', 'left outer');
		
		if($this->session->userdata('user_branch_id') == $this->config->item('melco_branch_id')){
		
			$this->db->join('events e', 'e.event_id = ti.ticket_event_id', 'left outer');
			$this->db->where('event_cod', 1);
		}
		
		$this->db->where("t.transaction_date >= '$date_from 00:00:00'");
		$this->db->where("t.transaction_date <= '$date_to 23:59:59'");
		$this->db->where('t.transaction_user_id ', $online_seller);
		$this->db->where_in('t.transaction_status', array("done", "paid_online"));
		$this->db->where_in('ti.ticket_status', array("done", "paid_online"));
		$query = $this->db->get('tickets ti');
		return $query->result();
	}
	
	function new_audit_trail_seller($date_to, $date_from, $seller_id = false, $action = false)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$get_online_branch_id = $this->reports->gbiddos();
		$online_branch_id = $get_online_branch_id->user_branch_id;
		
		$this->db->select('date(t.transaction_date) as trans_date, u.user_id, u.user_firstname, u.user_lastname, ev.event_title, t.transaction_id, t.transaction_date, sec.section_code, tt.ticket_type_name, pr.price_price, ev.event_internet_sales_charge, c.customer_firstname, c.customer_lastname, ti.ticket_user_id, ti.ticket_branch_id, ti.ticket_acknowledgment_receipt, t.transaction_branch_id, t.transaction_receipt_number, t.transaction_status, ti.ticket_status, ti.ticket_reservation_expiry, ti.ticket_date_printed, tt.ticket_type_discount_type, tt.ticket_type_discount, tt.ticket_type_group');
		$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id', 'left outer');
		$this->db->join($this->users, 'u.user_id = t.transaction_user_id', 'left outer');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id', 'left outer');
		$this->db->join($this->sections, 'sec.section_id = ti.ticket_section_id', 'left outer');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left outer');
		$this->db->join($this->prices, 'pr.price_id = ti.ticket_price_id', 'left outer');
		//$this->db->join($this->payments, 'pay.payment_transaction_id = t.transaction_id', 'left outer');
		//$this->db->join($this->payment_types, 'pt.payment_type_id = pay.payment_payment_type_id', 'left outer');
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left outer');
		$this->db->where('(date(t.transaction_date) >= "' . $date_from . '"');
		$this->db->where('date(t.transaction_date) <= "' . $date_to . '"');
		$this->db->or_where('date(ti.ticket_date_printed) >="' . $date_from . '"');
		$this->db->where('date(ti.ticket_date_printed) <= "' . $date_to . '")');
		//$this->db->where('pay.payment_amount_type', 'tickets');
		$this->db->where("(t.transaction_user_id = $seller_id OR ti.tickets_userid = $seller_id)");
		$this->db->order_by('date(t.transaction_date), ti.ticket_user_id, ev.event_id, t.transaction_id, tt.ticket_type_id');
		$query = $this->db->get('tickets ti');
		
		return $query->result();
	}
	
	function new_audit_trail_all($date_to, $date_from, $action = false, $get_online_branch_id =false)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		// $get_online_branch_id = $this->reports->gbiddos();
		$online_branch_id = $get_online_branch_id->user_branch_id;
		
		$this->db->select('date(t.transaction_date) as trans_date
						 , t.transaction_user_id as user_id
						 , ti.ticket_event_id as event_id
						 , ti.ticket_type_id
						 , t.transaction_id
						 , t.transaction_date
						 , ep.eplus_payment_printed_card_num
						 , sec.section_code
						 , pr.price_price
						 , c.customer_firstname
						 , c.customer_lastname
						 , ti.ticket_id
						 , ti.ticket_user_id
						 , ti.ticket_branch_id
						 , ti.ticket_acknowledgment_receipt
						 , t.transaction_branch_id
						 , t.transaction_receipt_number
						 , t.transaction_status
						 , ti.ticket_status
						 , ti.ticket_reservation_expiry
						 , ti.ticket_date_printed
						 , tt.ticket_type_name
						 , tt.ticket_type_discount_type
						 , tt.ticket_type_discount
						 , (CASE WHEN ti.ticket_branch_id IS NULL THEN t.transaction_branch_id ELSE ti.ticket_branch_id END) as branch_id
						 ');
		
		$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id', 'left outer');
		$this->db->join($this->sections, 'sec.section_id = ti.ticket_section_id', 'left outer');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left outer');
		$this->db->join($this->prices, 'pr.price_id = ti.ticket_price_id', 'left outer');
		$this->db->join('eplus_payments ep', 'ep.eplus_payment_order_id = ti.ticket_session_id', 'left outer');
		// if ($action == 'online' || $action == 'online_void')
		// {
			// $this->db->join($this->branches, 'br.branch_id = t.transaction_branch_id', 'left outer');
		// }
		// else 
		// {
			// $this->db->join($this->branches, 'br.branch_id = ti.ticket_branch_id', 'left outer');
		// }
		//$this->db->join($this->payments, 'pay.payment_transaction_id = t.transaction_id', 'left outer');
		//$this->db->join($this->payment_types, 'pt.payment_type_id = pay.payment_payment_type_id', 'left outer');
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left outer');
	 
		if($this->session->userdata('user_id') == 1482){
			
			 // $this->db->where('t.transaction_id <=', 2067242);
	// $this->db->where('t.transaction_id >=', 2067163);
			// $this->db->where('tix.ticket_event_id =', 6770);
			// $this->db->where('p.payment_payment_type_id', 1);
				// $this->db->where('t.transaction_id <=', 1779327);
				// $this->db->where('t.transaction_id >', 1730990); 
		}
	
	 

		$this->db->where('(((date(t.transaction_date) >= "' . $date_from . '") AND (date(t.transaction_date) <= "' . $date_to . '")) OR ((date(ti.ticket_date_printed) >="' . $date_from . '") AND (date(ti.ticket_date_printed) <= "' . $date_to . '")))');
		//$this->db->where('pay.payment_amount_type', 'tickets');
		if ($action == false || $action == 'online_void' || $action == 'void')
		{
			//$this->db->where('t.transaction_branch_id !=', $online_branch_id);
			//$this->db->where('ti.ticket_branch_id !=', $online_branch_id);
		}
		else 
		{
			$this->db->where('t.transaction_branch_id', $online_branch_id);
		}
		if ($action == 'online_void' || $action == 'void')
		{
			$this->db->where('ti.ticket_status in("voided", "cancelled", "reservation_cancelled", "expired")');
		}
		else
		{
			$this->db->where('ti.ticket_status in("done", "paid_online", "paid")');
		}
		$this->db->order_by('(CASE WHEN t.transaction_branch_id IS NULL THEN ti.ticket_branch_id ELSE t.transaction_branch_id END)
							, date(t.transaction_date), t.transaction_user_id, ti.ticket_event_id, t.transaction_id, ti.ticket_acknowledgment_receipt, ti.ticket_type_id');
		
		$query = $this->db->get('tickets ti');
		
		return $query->result();
	}
		
	function new_audit_trail_per_branch($date_to, $date_from, $branch_id = false, $get_online_branch_id=false)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		// $get_online_branch_id = $this->reports->gbiddos();
		$online_branch_id = $get_online_branch_id->user_branch_id;
		$this->db->select('date(t.transaction_date) as trans_date
						, t.transaction_user_id as user_id
						, ti.ticket_event_id as event_id
						, t.transaction_id
						, t.transaction_date
						, sec.section_code
						, tt.ticket_type_name
						, pr.price_price
						, c.customer_firstname
						, c.customer_lastname
						, ti.ticket_id
						, ti.ticket_user_id
						, ti.ticket_branch_id
						 , ep.eplus_payment_printed_card_num 
						, ti.ticket_acknowledgment_receipt
						, t.transaction_branch_id, t.transaction_receipt_number, t.transaction_status, ti.ticket_status, ti.ticket_reservation_expiry, ti.ticket_date_printed, tt.ticket_type_discount_type, tt.ticket_type_discount, tt.ticket_type_group
						, (CASE WHEN ti.ticket_branch_id IS NULL THEN t.transaction_branch_id ELSE ti.ticket_branch_id END) as branch_id
						');
		
		
		
		$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id', 'left outer');
		$this->db->join($this->sections, 'sec.section_id = ti.ticket_section_id', 'left outer');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left outer');
		$this->db->join($this->prices, 'pr.price_id = ti.ticket_price_id', 'left outer');
		$this->db->join('eplus_payments ep', 'ep.eplus_payment_order_id = ti.ticket_session_id', 'left outer');
		// $this->db->join($this->branches, 'br.branch_id = ti.ticket_branch_id', 'left outer');
		//$this->db->join($this->payments, 'pay.payment_transaction_id = t.transaction_id', 'left outer');
		//$this->db->join($this->payment_types, 'pt.payment_type_id = pay.payment_payment_type_id', 'left outer');
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left outer');
		$this->db->where('(((date(t.transaction_date) >= "' . $date_from . '") AND (date(t.transaction_date) <= "' . $date_to . '")) OR ((date(ti.ticket_date_printed) >="' . $date_from . '") AND (date(ti.ticket_date_printed) <= "' . $date_to . '")))');
		//$this->db->where('pay.payment_amount_type', 'tickets');
		// if($this->session->userdata('user_id') == 5532){
			// $this->db->where('t.transaction_id <=', 2067242);
		// }
		if($this->session->userdata('user_id') == 1482){
			
			 // $this->db->where('t.transaction_id <=', 2067242);
	// $this->db->where('t.transaction_id >=', 2067163);
			// $this->db->where('ti.ticket_event_id =', 6770);
			// $this->db->where('p.payment_payment_type_id', 1);
				// $this->db->where('t.transaction_id <=', 1779327);
				// $this->db->where('t.transaction_id >', 1730990); 
		}
		// $this->db->where('t.transaction_branch_id', $online_branch_id);

		$this->db->where('ti.ticket_status in("done", "paid_online", "paid")');
		$this->db->where('ti.ticket_branch_id', $branch_id);
		

		$this->db->order_by('(CASE WHEN t.transaction_branch_id IS NULL THEN ti.ticket_branch_id ELSE t.transaction_branch_id END)
							, date(t.transaction_date), t.transaction_user_id, ti.ticket_event_id, t.transaction_id, ti.ticket_acknowledgment_receipt, tt.ticket_type_id');
		
		$query = $this->db->get('tickets ti');
		
		// echo '<pre>';
		// print_r($query->result());
		// echo '</pre>';
		
		return $query->result();
	}
	
	function new_audit_trail_void($date_to, $date_from, $branch_id = false, $action = false)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$get_online_branch_id = $this->reports->gbiddos();
		$online_branch_id = $get_online_branch_id->user_branch_id;
		
		$this->db->select('if((date(t.transaction_date) < ti.ticket_date_printed)
							, ti.ticket_date_printed, date(t.transaction_date)) as testdate
							, date(t.transaction_date) as trans_date
							, t.transaction_user_id
							, ti.ticket_event_id
							, t.transaction_id
							, ti.ticket_id
							, t.transaction_date
							, ti.ticket_section_id
							, ti.ticket_price_id
							, t.transaction_customer_id
							, ti.ticket_user_id
							, ti.ticket_branch_id
							, ti.ticket_acknowledgment_receipt
							, ti.ticket_date_cancelled
							, t.transaction_branch_id
							, t.transaction_receipt_number
							, t.transaction_status
							, ti.ticket_status
							, ti.ticket_reservation_expiry
							, ti.ticket_date_printed
							, ti.ticket_type_id
							, u.user_firstname
							, u.user_lastname
							, b.branch_name
							, e.eplus_payment_printed_card_num
							, vt.voided_date
							, vt.voided_remarks
							
						');
		$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id', 'left outer');
		$this->db->join('voided_transactions vt', 'vt.voided_transaction_id = t.transaction_id', 'left outer');
		$this->db->join('users u', 'u.user_id = vt.voided_user_id', 'left outer');
		$this->db->join('branches b', 'b.branch_id = vt.voided_branch_id', 'left outer');
		$this->db->join('eplus_payments e', 'e.eplus_payment_transaction_id = ti.ticket_transaction_id', 'left');
		//$this->db->join($this->users, 'u.user_id = t.transaction_user_id', 'left outer');
		//$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id', 'left outer');
		//$this->db->join($this->sections, 'sec.section_id = ti.ticket_section_id', 'left outer');
		//$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left outer');
		//$this->db->join($this->prices, 'pr.price_id = ti.ticket_price_id', 'left outer');
		//$this->db->join($this->payments, 'pay.payment_transaction_id = t.transaction_id', 'left outer');
		//$this->db->join($this->payment_types, 'pt.payment_type_id = pay.payment_payment_type_id', 'left outer');
		//$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left outer');
		$this->db->where('((date(t.transaction_date) >= "' . $date_from . '"');
		$this->db->where('date(t.transaction_date) <= "' . $date_to . '")');
		$this->db->or_where('(date(ti.ticket_date_printed) >="' . $date_from . '"');
		$this->db->where('date(ti.ticket_date_printed) <= "' . $date_to . '"))');
		//$this->db->where('pay.payment_amount_type', 'tickets');
		if ($action == 'svspb')
		{
			$this->db->where('ti.ticket_status in("voided", "cancelled", "expired")');
		}
		elseif ($action == 'dsso')
		{
			$this->db->where('ti.ticket_status in("done", "paid_online")');
		}
		else
		{
			$this->db->where('ti.ticket_status in("done", "paid_online", "paid")');
		}
		if($branch_id == $online_branch_id)
		{
			$this->db->where("((t.transaction_branch_id = $branch_id) OR (ti.ticket_branch_id = $branch_id))");
			$this->db->order_by('date(t.transaction_date), t.transaction_user_id, t.transaction_id, ti.ticket_acknowledgment_receipt');
		}
		else
		{
			$this->db->where('ti.ticket_branch_id', $branch_id);
			$this->db->order_by('date(t.transaction_date), ti.ticket_user_id, t.transaction_id, ti.ticket_acknowledgment_receipt');
		}
		
		$this->db->group_by('ti.ticket_id');
		$query = $this->db->get('tickets ti');
		
		return $query->result();
	}
	 
	function new_audit_trail_all_void($date_to, $date_from, $action = false, $get_online_branch_id =false)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		// $get_online_branch_id = $this->reports->gbiddos();
		$online_branch_id = $get_online_branch_id->user_branch_id;
		
		$this->db->select('date(t.transaction_date) as trans_date
						 , t.transaction_user_id as user_id
						 , ti.ticket_event_id as event_id
						 , ti.ticket_type_id
						 , t.transaction_id
						 , t.transaction_date
						 , sec.section_code
						 , pr.price_price
						 , c.customer_firstname
						 , c.customer_lastname
						 , ti.ticket_id
						 , ti.ticket_user_id
						 , ti.ticket_branch_id
						 , ti.ticket_acknowledgment_receipt
						 , t.transaction_branch_id
						 , t.transaction_receipt_number
						 , t.transaction_status
						 , ti.ticket_status
						 , ti.ticket_reservation_expiry
						 , ti.ticket_date_cancelled
						 , ti.ticket_date_printed
						 , tt.ticket_type_name
						 , tt.ticket_type_discount_type
						 , tt.ticket_type_discount
						 , u.user_firstname
						 , u.user_lastname
						 , b.branch_name
						 , ep.eplus_payment_printed_card_num
						 , vt.voided_date
						 , vt.voided_remarks
						 , (CASE WHEN ti.ticket_branch_id IS NULL THEN t.transaction_branch_id ELSE ti.ticket_branch_id END) as branch_id
						 ');
		
		$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id', 'left outer');
		$this->db->join($this->sections, 'sec.section_id = ti.ticket_section_id', 'left outer');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left outer');
		$this->db->join($this->prices, 'pr.price_id = ti.ticket_price_id', 'left outer');
		$this->db->join('voided_transactions vt', 'vt.voided_transaction_id = t.transaction_id', 'left outer');
		$this->db->join('eplus_payments ep', 'ep.eplus_payment_order_id = ti.ticket_session_id', 'left outer');
		$this->db->join('users u', 'u.user_id = vt.voided_user_id', 'left outer');
		$this->db->join('branches b', 'b.branch_id = vt.voided_branch_id', 'left outer');
		// if ($action == 'online' || $action == 'online_void')
		// {
			// $this->db->join($this->branches, 'br.branch_id = t.transaction_branch_id', 'left outer');
		// }
		// else 
		// {
			// $this->db->join($this->branches, 'br.branch_id = ti.ticket_branch_id', 'left outer');
		// }
		//$this->db->join($this->payments, 'pay.payment_transaction_id = t.transaction_id', 'left outer');
		//$this->db->join($this->payment_types, 'pt.payment_type_id = pay.payment_payment_type_id', 'left outer');
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left outer');
		$this->db->where('(((date(t.transaction_date) >= "' . $date_from . '") AND (date(t.transaction_date) <= "' . $date_to . '")) OR ((date(ti.ticket_date_printed) >="' . $date_from . '") AND (date(ti.ticket_date_printed) <= "' . $date_to . '")))');
		//$this->db->where('pay.payment_amount_type', 'tickets');
		if ($action == false || $action == 'online_void' || $action == 'void')
		{
			//$this->db->where('t.transaction_branch_id !=', $online_branch_id);
			//$this->db->where('ti.ticket_branch_id !=', $online_branch_id);
		}
		else 
		{
			$this->db->where('t.transaction_branch_id', $online_branch_id);
		}
		if ($action == 'online_void' || $action == 'void')
		{
			$this->db->where('ti.ticket_status in("voided", "cancelled", "reservation_cancelled", "expired")');
		}
		else
		{
			$this->db->where('ti.ticket_status in("done", "paid_online", "paid")');
		}
		$this->db->order_by('(CASE WHEN t.transaction_branch_id IS NULL THEN ti.ticket_branch_id ELSE t.transaction_branch_id END)
							, date(t.transaction_date), t.transaction_user_id, ti.ticket_event_id, t.transaction_id, ti.ticket_acknowledgment_receipt, ti.ticket_type_id');
		
		$this->db->group_by('ti.ticket_id');
		$query = $this->db->get('tickets ti');
		
		return $query->result();
	}
	
	function get_branches_dropdown_for_ds()
	{
		$this->db->query('set transaction isolation level read uncommitted');
		//$this->db->where('branch_id !=', 40);
		if ($this->session->userdata('user_branch_id') != 1 && $this->session->userdata('user_branch_id') != 142)
		{
			$this->db->where('branch_id', $this->session->userdata('user_branch_id'));
		}
		$this->db->like('branch_name', 'DS-SM');
		$this->db->order_by('branch_name');
		$query = $this->db->get($this->branches);
			
		$result = $query->result();
		
		if ($result)
		{
			// add an empty array 
			if ($this->session->userdata('user_branch_id') == 1)
			{
				$array[''] = '';
			}
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->branch_id] = $r->branch_name;
			}
			return $array;
		}
		else
		{
			return $result;
		}

	}	
	
	
	function get_branches_dropdown_for_mw()
	{
		$this->db->query('set transaction isolation level read uncommitted');
		//$this->db->where('branch_id !=', 40);
		if ($this->session->userdata('user_branch_id') != 1)
		{
			$this->db->where('branch_id', $this->session->userdata('user_branch_id'));
		}
		$this->db->like('branch_name', 'MW-');
		$this->db->order_by('branch_name');
		$query = $this->db->get($this->branches);
			
		$result = $query->result();
		
		if ($result)
		{
			// add an empty array 
			if ($this->session->userdata('user_branch_id') == 1)
			{
				$array[''] = '';
			}
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->branch_id] = $r->branch_name;
			}
			return $array;
		}
		else
		{
			return $result;
		}

	}
		
	//-----------------------------------------------------------------
	/*
	 * GET PAYMENT TYPE NAME VIA TRANSACTION ID
	 * get_ptname
	 * @access public
	 */
	
	/*function get_ptname($transaction_id)
	{
		$this->db->select('group_concat(pt.payment_type_name) as grouped_ptname');
		$this->db->join($this->payment_types, 'pt.payment_type_id = pay.payment_payment_type_id');
		$this->db->where('pay.payment_transaction_id', $transaction_id);
		$this->db->where('pay.payment_amount_type', 'tickets');
		$this->db->group_by('pay.payment_transaction_id');
		$query = $this->db->get('payments pay');
		
		return $query->row();
	}*/
	
	
	function get_bir_reports(){
		$this->db->query('set transaction isolation level read uncommitted');
		$status = array('paid_online','paid','done');
		$date_from = $this->input->post('date_from');
		$date_to = $this->input->post('date_to');
		
		
		$this->db->where('t.transaction_date >=', $date_from.' 00:00:01'); 
		$this->db->where('t.transaction_date <=', $date_to.' 23:59:59');
		$this->db->where('t.transaction_date <=', $date_to.' 23:59:59');
		$this->db->where_in('t.transaction_status', $status);
		$this->db->where('t.transaction_branch_id', 90);
		$this->db->join('charges c', 'c.charge_transaction_id = t.transaction_id');
		
		$query = $this->db->get('transactions t');
		return $query->result();
		
		
	}
	
	function invoicing_report($branch_id = false, $date_from = false, $date_to = false)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$get_online_branch_id = $this->reports->gbiddos();
		$online_branch_id = $get_online_branch_id->user_branch_id;
		
		$this->db->select('c.customer_firstname,c.customer_lastname, c.customer_address1,t.transaction_id,p.payment_datetime,ch.charge_amount, t.transaction_id as temp_ar, COUNT(ti.ticket_id) AS tqty, ev.event_service_charge AS temp_con_charge, ev.event_internet_sales_charge AS total_con_charge, group_concat(ti.ticket_acknowledgment_receipt) as ar_no, t.transaction_receipt_number, t.transaction_status');

		$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id', 'left outer');
		$this->db->join($this->charges, 'ti.ticket_transaction_id = ch.charge_transaction_id', 'left outer');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id', 'left outer');
		$this->db->join($this->branches, 't.transaction_branch_id = br.branch_id', 'left outer');
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'inner');
		$this->db->join('payments p', 'p.payment_transaction_id = t.transaction_id', 'inner');
		$this->db->where('date(p.payment_datetime) >=', $date_from);
		$this->db->where('date(p.payment_datetime) <=', $date_to);
		if ($branch_id != $online_branch_id)
		{
			$this->db->where('ti.ticket_branch_id', $branch_id);
		}
		else 
		{
			$this->db->where('t.transaction_branch_id', $branch_id);
		}
		
		if ($this->input->post('status') != 'voided')
		{
			$this->db->where_in('t.transaction_status', array('done','paid_online','paid'));
		}else{
			
			$this->db->where('t.transaction_status', 'voided');
			
		}
		
		
		//$this->db->where("(t.transaction_status = 'done' or t.transaction_status = 'paid_online')");
		$this->db->group_by('t.transaction_id');
		$this->db->order_by('t.transaction_receipt_number','asc');
		$query = $this->db->get('transactions t');
		return $query->result();
	}
	
	function get_event_dates(){
		
		$this->db->where('events_config_eventid', 5572);
		$query =$this->db->get('events_config');
		$dates =  $query->row()->events_valid_dates;
		$dates = explode(',', $dates);
		$date_array = array();
		$date_array[] = '';
		foreach($dates as $x){
			
			$x=date_create($x);
			$x = date_format($x,"Y-m-d");
			
			$date_array[$x] = $x;
			
			
		}
		// $date_array = sort($date_array);
		return $date_array;
	} 

	
		
	function new_audit_trail_all_harry($date_to, $date_from, $action = false, $get_online_branch_id =false)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		// $get_online_branch_id = $this->reports->gbiddos();
		$online_branch_id = $get_online_branch_id->user_branch_id;
		
		$this->db->select('date(claim_date_time) as trans_date
						 ,claim_user_id as user_id
						 , ti.ticket_event_id as event_id
						 , ti.ticket_type_id
						 , t.transaction_id
						 , claim_date_time as transaction_date
						 , ep.eplus_payment_printed_card_num
						 , sec.section_code
						 , pr.price_price
						 , c.customer_firstname
						 , c.customer_lastname
						 , ti.ticket_id
						 , claim_user_id as ticket_user_id
						 , claim_branch_id as ticket_branch_id
						 , ti.ticket_acknowledgment_receipt
						 , claim_branch_id as transaction_branch_id
						 , t.transaction_receipt_number
						 , t.transaction_status
						 , ti.ticket_status
						 , ti.ticket_reservation_expiry
						 , claim_date_time as ticket_date_printed
						 , tt.ticket_type_name
						 , tt.ticket_type_discount_type
						 , tt.ticket_type_discount
						 , (CASE WHEN claim_branch_id IS NULL THEN claim_branch_id ELSE claim_branch_id END) as branch_id
						 ');
		
		$this->db->join('claims', 'claim_transaction_id = ti.ticket_transaction_id', 'inner');
		
		$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id', 'left outer');
		$this->db->join($this->sections, 'sec.section_id = ti.ticket_section_id', 'left outer');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left outer');
		$this->db->join($this->prices, 'pr.price_id = ti.ticket_price_id', 'left outer');
		$this->db->join('eplus_payments ep', 'ep.eplus_payment_order_id = ti.ticket_session_id', 'left outer');
		// if ($action == 'online' || $action == 'online_void')
		// {
			// $this->db->join($this->branches, 'br.branch_id = t.transaction_branch_id', 'left outer');
		// }
		// else 
		// {
			// $this->db->join($this->branches, 'br.branch_id = ti.ticket_branch_id', 'left outer');
		// }
		//$this->db->join($this->payments, 'pay.payment_transaction_id = t.transaction_id', 'left outer');
		//$this->db->join($this->payment_types, 'pt.payment_type_id = pay.payment_payment_type_id', 'left outer');
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left outer');
	 
		if($this->session->userdata('user_id') == 1482){
			
			 
				
				// $this->db->where('t.transaction_id <=', 1779327);
				// $this->db->where('t.transaction_id >', 1730990); 
		}
	
	 

		$this->db->where('((date(claim_date_time) >= "' . $date_from . '") AND (date(claim_date_time) <= "' . $date_to . '")) ');
		//$this->db->where('pay.payment_amount_type', 'tickets');
		if ($action == false || $action == 'online_void' || $action == 'void')
		{
			//$this->db->where('t.transaction_branch_id !=', $online_branch_id);
			//$this->db->where('ti.ticket_branch_id !=', $online_branch_id);
		}
		else 
		{
			$this->db->where('claim_branch_id', $online_branch_id);
		}
		if ($action == 'online_void' || $action == 'void')
		{
			$this->db->where('ti.ticket_status in("voided", "cancelled", "reservation_cancelled", "expired")');
		}
		else
		{
			$this->db->where('ti.ticket_status in("done", "paid_online", "paid")');
		}
		$this->db->order_by('(CASE WHEN claim_branch_id IS NULL THEN claim_branch_id ELSE claim_branch_id END)
							, date(claim_date_time), claim_user_id, ti.ticket_event_id, t.transaction_id, ti.ticket_acknowledgment_receipt, ti.ticket_type_id');
		
		$query = $this->db->get('tickets ti');
		
		return $query->result();
	}
		
	function new_audit_trail_per_branch_harry($date_to, $date_from, $branch_id = false, $get_online_branch_id=false)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		// $get_online_branch_id = $this->reports->gbiddos();
		$online_branch_id = $get_online_branch_id->user_branch_id;
		$this->db->select('date(claim_date_time) as trans_date
						, claim_user_id as user_id
						, ti.ticket_event_id as event_id
						, t.transaction_id
						, claim_date_time as transaction_date
						, sec.section_code
						, tt.ticket_type_name
						, pr.price_price
						, c.customer_firstname
						, c.customer_lastname
						, ti.ticket_id
						, claim_user_id as ticket_user_id
						, claim_branch_id as ticket_branch_id
						 , ep.eplus_payment_printed_card_num 
						, ti.ticket_acknowledgment_receipt
						, claim_branch_id as transaction_branch_id, t.transaction_receipt_number, t.transaction_status, ti.ticket_status, ti.ticket_reservation_expiry, claim_date_time as ticket_date_printed, tt.ticket_type_discount_type, tt.ticket_type_discount, tt.ticket_type_group
						, (CASE WHEN claim_branch_id IS NULL THEN claim_branch_id ELSE claim_branch_id END) as branch_id
						');
		
		$this->db->join('claims', 'claim_transaction_id = ti.ticket_transaction_id', 'inner');
		
		$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id', 'left outer');
		$this->db->join($this->sections, 'sec.section_id = ti.ticket_section_id', 'left outer');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left outer');
		$this->db->join($this->prices, 'pr.price_id = ti.ticket_price_id', 'left outer');
		$this->db->join('eplus_payments ep', 'ep.eplus_payment_order_id = ti.ticket_session_id', 'left outer');
		// $this->db->join($this->branches, 'br.branch_id = ti.ticket_branch_id', 'left outer');
		//$this->db->join($this->payments, 'pay.payment_transaction_id = t.transaction_id', 'left outer');
		//$this->db->join($this->payment_types, 'pt.payment_type_id = pay.payment_payment_type_id', 'left outer');
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left outer');
		$this->db->where('((date(claim_date_time) >= "' . $date_from . '") AND (date(claim_date_time) <= "' . $date_to . '"))');
		//$this->db->where('pay.payment_amount_type', 'tickets');

		// $this->db->where('t.transaction_branch_id', $online_branch_id);

		$this->db->where('ti.ticket_status in("done", "paid_online", "paid")');
		$this->db->where('claim_branch_id', $branch_id);
		

		$this->db->order_by('(CASE WHEN claim_branch_id IS NULL THEN claim_branch_id ELSE claim_branch_id END)
							, date(claim_date_time), claim_user_id, ti.ticket_event_id, t.transaction_id, ti.ticket_acknowledgment_receipt, tt.ticket_type_id');
		
		$query = $this->db->get('tickets ti');
		
		// echo '<pre>';
		// print_r($query->result());
		// echo '</pre>';
		
		return $query->result();
	}
	 
	
	function new_audit_trail_all_sap($date_to, $date_from, $action = false, $get_online_branch_id =false)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		// $get_online_branch_id = $this->reports->gbiddos();
		$online_branch_id = $get_online_branch_id->user_branch_id;
		
		$this->db->select('date(ti.ticket_date_entered) as trans_date
						 , t.transaction_user_id as user_id
						 , ti.ticket_event_id as event_id
						 , ti.ticket_type_id
						 , t.transaction_id
						 , ti.ticket_date_entered as transaction_date
						 , til.ticket_date_entered as original_date_voided
						 , ep.eplus_payment_printed_card_num
						 , sec.section_code 
						 ,(CASE WHEN ti.ticket_status = "voided" THEN pr.price_price * -1 ELSE pr.price_price END) as price_price
						 , c.customer_firstname
						 , c.customer_lastname
						 , ti.ticket_id
						 , b.branch_name
						 , u.user_firstname
						 , u.user_lastname
						 , ti.ticket_user_id
						 , ti.ticket_branch_id
						 , ti.ticket_acknowledgment_receipt
						 , t.transaction_branch_id
						 , t.transaction_receipt_number
						 , t.transaction_status
						 , ti.ticket_status
						 , ti.ticket_reservation_expiry
						 , ti.ticket_date_printed
						 , tt.ticket_type_name
						 , tt.ticket_type_discount_type
						 , tt.ticket_type_discount
						 , (CASE WHEN ti.ticket_branch_id IS NULL THEN t.transaction_branch_id ELSE ti.ticket_branch_id END) as branch_id
						 ');
		
		$this->db->join('historical_transactions t', 't.transaction_id = ti.ticket_transaction_id', 'left outer');
		$this->db->join($this->sections, 'sec.section_id = ti.ticket_section_id', 'left outer');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left outer');
		$this->db->join($this->prices, 'pr.price_id = ti.ticket_price_id', 'left outer');
		$this->db->join('eplus_payments ep', 'ep.eplus_payment_order_id = ti.ticket_session_id', 'left outer');
		// $this->db->join('branches b', 'b.branch_id = ti.ticket_branch_id', 'left outer');
		// $this->db->join('users u', 'u.user_id = ti.ticket_user_id', 'left outer');
		
		$this->db->join('tickets til', 'til.ticket_id = ti.ticket_id', 'left outer');
		$this->db->join('users u', 'u.user_id = til.ticket_user_id', 'left outer');
		$this->db->join('branches b', 'b.branch_id = til.ticket_branch_id', 'left outer');
		
		
		// if ($action == 'online' || $action == 'online_void')
		// {
			// $this->db->join($this->branches, 'br.branch_id = t.transaction_branch_id', 'left outer');
		// }
		// else 
		// {
			// $this->db->join($this->branches, 'br.branch_id = ti.ticket_branch_id', 'left outer');
		// }
		//$this->db->join($this->payments, 'pay.payment_transaction_id = t.transaction_id', 'left outer');
		//$this->db->join($this->payment_types, 'pt.payment_type_id = pay.payment_payment_type_id', 'left outer');
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left outer');
	 
		if($this->session->userdata('user_id') == 1482){
			
			 // $this->db->where('t.transaction_id <=', 2067242);
	// $this->db->where('t.transaction_id >=', 2067163);
			// $this->db->where('tix.ticket_event_id =', 6770);
			// $this->db->where('p.payment_payment_type_id', 1);
				// $this->db->where('t.transaction_id <=', 1779327);
				// $this->db->where('t.transaction_id >', 1730990); 
		}
	
		$this->db->where('date(ti.ticket_date_entered) >=',$date_from); 
		$this->db->where('date(ti.ticket_date_entered) <=',$date_to); 

		// $this->db->where('(((date(t.transaction_date) >= "' . $date_from . '") AND (date(t.transaction_date) <= "' . $date_to . '")) OR ((date(ti.ticket_date_printed) >="' . $date_from . '") AND (date(ti.ticket_date_printed) <= "' . $date_to . '")))');
		
		
		//$this->db->where('pay.payment_amount_type', 'tickets');
		if ($action == false || $action == 'online_void' || $action == 'void')
		{
			//$this->db->where('t.transaction_branch_id !=', $online_branch_id);
			//$this->db->where('ti.ticket_branch_id !=', $online_branch_id);
		}
		else 
		{
			$this->db->where('t.transaction_branch_id', $online_branch_id);
		}
		if ($action == 'online_void' || $action == 'void')
		{
			$this->db->where('ti.ticket_status in("voided", "cancelled", "reservation_cancelled", "expired")');
		}
		else
		{
			$this->db->where('ti.ticket_status in("done", "paid_online", "paid", "voided")');
		}
		$this->db->order_by('(CASE WHEN t.transaction_branch_id IS NULL THEN ti.ticket_branch_id ELSE t.transaction_branch_id END)
							, date(t.transaction_date), t.transaction_user_id, ti.ticket_event_id, t.transaction_id, ti.ticket_acknowledgment_receipt, ti.ticket_type_id');
		
		$query = $this->db->get('historical_tickets ti');
		
		return $query->result();
	}
		
	function new_audit_trail_per_branch_sap($date_to, $date_from, $branch_id = false, $get_online_branch_id=false)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		// $get_online_branch_id = $this->reports->gbiddos();
		$online_branch_id = $get_online_branch_id->user_branch_id;
		$this->db->select('date(ti.ticket_date_entered) as trans_date
						, tr.transaction_date as  orig_trans_date
						, t.transaction_user_id as user_id
						, ti.ticket_event_id as event_id
						, t.transaction_id
						, ti.ticket_date_entered as transaction_date
						, til.ticket_date_entered as original_date_voided
						, sec.section_code
						, tt.ticket_type_name 
						,(CASE WHEN ti.ticket_status = "voided" THEN pr.price_price * -1 ELSE pr.price_price END) as price_price
						, c.customer_firstname
						, c.customer_lastname
						, b.branch_name
						, u.user_firstname
						, u.user_lastname
						, ti.ticket_id
						, ti.ticket_user_id
						, ti.ticket_branch_id
						 , ep.eplus_payment_printed_card_num 
						, ti.ticket_acknowledgment_receipt
						, t.transaction_branch_id, t.transaction_receipt_number, t.transaction_status, ti.ticket_status, ti.ticket_reservation_expiry, ti.ticket_date_printed, tt.ticket_type_discount_type, tt.ticket_type_discount, tt.ticket_type_group
						, (CASE WHEN ti.ticket_branch_id IS NULL THEN t.transaction_branch_id ELSE ti.ticket_branch_id END) as branch_id
						');
		
		
		
		$this->db->join('historical_transactions t', 't.transaction_id = ti.ticket_transaction_id', 'left outer');
		$this->db->join('transactions tr', 'tr.transaction_id = ti.ticket_transaction_id', 'left outer');
		$this->db->join($this->sections, 'sec.section_id = ti.ticket_section_id', 'left outer');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left outer');
		$this->db->join($this->prices, 'pr.price_id = ti.ticket_price_id', 'left outer');
		$this->db->join('eplus_payments ep', 'ep.eplus_payment_order_id = ti.ticket_session_id', 'left outer');
		$this->db->join('tickets til', 'til.ticket_id = ti.ticket_id', 'left outer');
		$this->db->join('users u', 'u.user_id = til.ticket_user_id', 'left outer');
		$this->db->join('branches b', 'b.branch_id = til.ticket_branch_id', 'left outer');
		// $this->db->join($this->branches, 'br.branch_id = ti.ticket_branch_id', 'left outer');
		//$this->db->join($this->payments, 'pay.payment_transaction_id = t.transaction_id', 'left outer');
		//$this->db->join($this->payment_types, 'pt.payment_type_id = pay.payment_payment_type_id', 'left outer');
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left outer');
		// $this->db->where('(((date(t.transaction_date) >= "' . $date_from . '") AND (date(t.transaction_date) <= "' . $date_to . '")) OR ((date(ti.ticket_date_printed) >="' . $date_from . '") AND (date(ti.ticket_date_printed) <= "' . $date_to . '")))');
		//$this->db->where('pay.payment_amount_type', 'tickets');
		// if($this->session->userdata('user_id') == 5532){
			// $this->db->where('t.transaction_id <=', 2067242);
		// }
		
		$this->db->where('date(ti.ticket_date_entered) >=',$date_from); 
		$this->db->where('date(ti.ticket_date_entered) <=',$date_to); 

		
		if($this->session->userdata('user_id') == 1482){
			
			 // $this->db->where('t.transaction_id <=', 2067242);
	// $this->db->where('t.transaction_id >=', 2067163);
			// $this->db->where('ti.ticket_event_id =', 6770);
			// $this->db->where('p.payment_payment_type_id', 1);
				// $this->db->where('t.transaction_id <=', 1779327);
				// $this->db->where('t.transaction_id >', 1730990); 
		}
		// $this->db->where('t.transaction_branch_id', $online_branch_id);

		$this->db->where('ti.ticket_status in("done", "paid_online", "paid", "voided")');
		$this->db->where('ti.ticket_branch_id', $branch_id);
		

		$this->db->order_by('(CASE WHEN t.transaction_branch_id IS NULL THEN ti.ticket_branch_id ELSE t.transaction_branch_id END)
							, date(t.transaction_date), t.transaction_user_id, ti.ticket_event_id, t.transaction_id, ti.ticket_acknowledgment_receipt, tt.ticket_type_id');
		
		$query = $this->db->get('historical_tickets ti');
		
		// echo '<pre>';
		// print_r($query->result());
		// echo '</pre>';
		// echo $this->db->last_query();
		// die();
		
		return $query->result();
	}
	
	//additional report requested by audit
	function new_audit_trail_all_void2($date_to, $date_from, $action = false, $get_online_branch_id =false, $branch_id=false)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		
		$this->db->select('date(t.transaction_date) as trans_date
						 , ut.ticket_ids
						 , t.transaction_id
						 ');
		
		$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id', 'left outer');
		$this->db->join('upgrade_tickets ut', 'ut.transaction_id = t.transaction_id');
		$this->db->join('upgrade_payments up', 'up.voided_payment_transaction_id = t.transaction_id');
		$this->db->join('voided_transactions vt', 'vt.voided_transaction_id = t.transaction_id', 'left outer');
		$this->db->join($this->branches, 'br.branch_id = t.transaction_branch_id', 'left outer');

		$this->db->where('(((date(vt.voided_date) >= "' . $date_from . '") AND (date(vt.voided_date) <= "' . $date_to . '")) OR ((date(vt.voided_date) >="' . $date_from . '") AND (date(vt.voided_date) <= "' . $date_to . '")))');

		if($branch_id!=""){
			$this->db->where('t.transaction_branch_id =', $branch_id);
		}
		
			$this->db->where('ti.ticket_status in("voided")');
			$this->db->where('up.voided_payment_status ', '1');
		// $this->db->where('t.transaction_comment', 'Upgrade');
		$this->db->order_by('(CASE WHEN t.transaction_branch_id IS NULL THEN ti.ticket_branch_id ELSE t.transaction_branch_id END), date(t.transaction_date), t.transaction_user_id, ti.ticket_event_id, t.transaction_id, ti.ticket_acknowledgment_receipt, ti.ticket_type_id');
		
		$this->db->group_by('t.transaction_id');
		$query = $this->db->get('tickets ti');
		
		$ticket_ids = $query->result();
		
		
		// echo $this->db->last_query();
		
		// die();
		$ticket_ids_ = "";
		foreach($ticket_ids as $ticket_id){
			// echo $ticket_id->ticket_ids;
			$ticket_ids_ .= $ticket_id->ticket_ids.',';
		}
		
		$tickets = explode(',',substr($ticket_ids_, 0, -1));
		
		// $get_online_branch_id = $this->reports->gbiddos();
		$online_branch_id = $get_online_branch_id->user_branch_id;
		
		$this->db->select('date(t.transaction_date) as trans_date
						 , t.transaction_user_id as user_id
						 , ti.ticket_event_id as event_id
						 , ti.ticket_type_id
						 , charge_amount
						 , event_internet_sales_charge
						 , t.transaction_id
						 , t.transaction_date
						 , sec.section_code
						 , pr.price_price
						 , c.customer_firstname
						 , c.customer_lastname
						 , ti.ticket_id
						 , ti.ticket_user_id
						 , ti.ticket_branch_id
						 , ti.ticket_acknowledgment_receipt
						 , t.transaction_branch_id
						 , t.transaction_receipt_number
						 , t.transaction_status
						 , ti.ticket_status
						 , ti.ticket_reservation_expiry
						 , ti.ticket_date_cancelled
						 , ti.ticket_date_printed
						 , tt.ticket_type_name
						 , tt.ticket_type_discount_type
						 , tt.ticket_type_discount
						 , u.user_firstname
						 , u.user_lastname
						 , b.branch_name
						 , ep.eplus_payment_printed_card_num
						 , vt.voided_date
						 , vt.voided_remarks
						 , (CASE WHEN ti.ticket_branch_id IS NULL THEN t.transaction_branch_id ELSE ti.ticket_branch_id END) as branch_id
						 ');
		
		$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id', 'left outer');
		$this->db->join($this->charges, 'ch.charge_transaction_id = t.transaction_id', 'left outer');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id', 'left outer');
		
		$this->db->join($this->sections, 'sec.section_id = ti.ticket_section_id', 'left outer');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left outer');
		$this->db->join($this->prices, 'pr.price_id = ti.ticket_price_id', 'left outer');
		$this->db->join('voided_transactions vt', 'vt.voided_transaction_id = t.transaction_id', 'left outer');
		$this->db->join('eplus_payments ep', 'ep.eplus_payment_order_id = ti.ticket_session_id', 'left outer');
		// $this->db->join('users u', 'u.user_id = vt.voided_user_id', 'left outer');
		$this->db->join('users u', 'u.user_id = ti.ticket_user_id', 'left outer');
		// $this->db->join('branches b', 'b.branch_id = vt.voided_branch_id', 'left outer');
		$this->db->join('branches b', 'b.branch_id = ti.ticket_branch_id', 'left outer');
		// if ($action == 'online' || $action == 'online_void')
		// {
			// $this->db->join($this->branches, 'br.branch_id = t.transaction_branch_id', 'left outer');
		// }
		// else 
		// {
			// $this->db->join($this->branches, 'br.branch_id = ti.ticket_branch_id', 'left outer');
		// }
		//$this->db->join($this->payments, 'pay.payment_transaction_id = t.transaction_id', 'left outer');
		//$this->db->join($this->payment_types, 'pt.payment_type_id = pay.payment_payment_type_id', 'left outer');
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left outer');
		$this->db->where('(((date(vt.voided_date) >= "' . $date_from . '") AND (date(vt.voided_date) <= "' . $date_to . '")) OR ((date(vt.voided_date) >="' . $date_from . '") AND (date(vt.voided_date) <= "' . $date_to . '")))');
		//$this->db->where('pay.payment_amount_type', 'tickets');
		if($branch_id!=""){
			$this->db->where('t.transaction_branch_id =', $branch_id);
		}
		
		if ($action == false || $action == 'online_void' || $action == 'void')
		{
			//$this->db->where('t.transaction_branch_id !=', $online_branch_id);
			//$this->db->where('ti.ticket_branch_id !=', $online_branch_id);
		}
		else 
		{
			$this->db->where('t.transaction_branch_id', $online_branch_id);
		}
		if ($action == 'online_void' || $action == 'void')
		{
			$this->db->where('ti.ticket_status in("voided", "cancelled", "reservation_cancelled", "expired")');
		}
		else
		{
			$this->db->where('ti.ticket_status in("done", "paid_online", "paid")');
		}
		$this->db->where_not_in('ti.ticket_id', $tickets);
		$this->db->order_by('(CASE WHEN t.transaction_branch_id IS NULL THEN ti.ticket_branch_id ELSE t.transaction_branch_id END)
							, date(t.transaction_date), t.transaction_user_id, ti.ticket_event_id, t.transaction_id, ti.ticket_acknowledgment_receipt, ti.ticket_type_id');
		
		$this->db->group_by('ti.ticket_id');
		// $query = $this->db->get('tickets ti');
		$query = $this->db->get('historical_tickets ti');
		// echo $this->db->last_query();
		
		// die();
		return $query->result();
	}
	 
	function new_audit_trail_all_upgrade_tickets($date_to, $date_from, $action = false, $get_online_branch_id =false, $branch_id)
	{
		
		$this->db->query('set transaction isolation level read uncommitted');
		// $get_online_branch_id = $this->reports->gbiddos();
		$online_branch_id = $get_online_branch_id->user_branch_id;
		
		
		$this->db->select('date(t.transaction_date) as trans_date
						 , ut.ticket_ids
						 , t.transaction_id
						 ');
		
		$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id', 'left outer');
		$this->db->join('upgrade_tickets ut', 'ut.transaction_id = t.transaction_id');
		$this->db->join('upgrade_payments up', 'up.voided_payment_transaction_id = t.transaction_id');
		$this->db->join('voided_transactions vt', 'vt.voided_transaction_id = t.transaction_id', 'left outer');
		$this->db->join($this->branches, 'br.branch_id = t.transaction_branch_id', 'left outer');

		$this->db->where('(((date(vt.voided_date) >= "' . $date_from . '") AND (date(vt.voided_date) <= "' . $date_to . '")) OR ((date(vt.voided_date) >="' . $date_from . '") AND (date(vt.voided_date) <= "' . $date_to . '")))');

		if($branch_id!=""){
			$this->db->where('t.transaction_branch_id =', $branch_id);
		}
		
			$this->db->where('ti.ticket_status in("voided")');
			$this->db->where('up.voided_payment_status ', '1');
		// $this->db->where('t.transaction_comment', 'Upgrade');
		$this->db->order_by('(CASE WHEN t.transaction_branch_id IS NULL THEN ti.ticket_branch_id ELSE t.transaction_branch_id END), date(t.transaction_date), t.transaction_user_id, ti.ticket_event_id, t.transaction_id, ti.ticket_acknowledgment_receipt, ti.ticket_type_id');
		
		$this->db->group_by('t.transaction_id');
		$query = $this->db->get('tickets ti');
		
		$ticket_ids = $query->result();
		
		
		// echo $this->db->last_query();
		
		// die();
		$ticket_ids_ = "";
		foreach($ticket_ids as $ticket_id){
			// echo $ticket_id->ticket_ids;
			$ticket_ids_ .= $ticket_id->ticket_ids.',';
		}
		
		
		
		$tickets = explode(',',substr($ticket_ids_, 0, -1));
		// echo '<pre>';
		// print_r($ticket_ids);
		
		// echo $ticket_ids_;
		// die();
		$this->db->query('set transaction isolation level read uncommitted');
		// $get_online_branch_id = $this->reports->gbiddos();
		$online_branch_id = $get_online_branch_id->user_branch_id;
		
		$this->db->select('date(t.transaction_date) as trans_date
						 , t.transaction_user_id as user_id
						 , ti.ticket_event_id as event_id
						 , ti.ticket_type_id
						 , t.transaction_id
						 , t.transaction_date
						 , sec.section_code
						 , pr.price_price
						 , c.customer_firstname
						 , c.customer_lastname
						 , ti.ticket_id
						 , ti.ticket_user_id
						 , hit.ticket_branch_id
						 , ti.ticket_acknowledgment_receipt
						 , (CASE WHEN t.transaction_branch_id = 90 THEN hit.ticket_branch_id ELSE t.transaction_branch_id END) as transaction_branch_id
						 , t.transaction_receipt_number
						 , t.transaction_status
						 , ti.ticket_status
						 , ti.ticket_reservation_expiry
						 , ti.ticket_date_cancelled
						 , ti.ticket_date_printed
						 , tt.ticket_type_name
						 , tt.ticket_type_discount_type
						 , tt.ticket_type_discount
						 , u.user_firstname
						 , u.user_lastname
						 , b.branch_name
						 , ep.eplus_payment_printed_card_num
						 , vt.voided_date
						 , ut.upgrade_code
						 , ut.new_transaction_id
						 , (CASE WHEN ti.ticket_branch_id IS NULL THEN t.transaction_branch_id ELSE ti.ticket_branch_id END) as branch_id
						 ');
		
		$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id', 'left outer');
		$this->db->join($this->sections, 'sec.section_id = ti.ticket_section_id', 'left outer');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left outer');
		$this->db->join($this->prices, 'pr.price_id = ti.ticket_price_id', 'left outer');
		$this->db->join('payments p', 'p.payment_transaction_id = t.transaction_id', 'left outer');
		$this->db->join('voided_transactions vt', 'vt.voided_transaction_id = t.transaction_id', 'left outer');
		$this->db->join('upgrade_tickets ut', 'ut.transaction_id = t.transaction_id', 'left outer');
		$this->db->join('eplus_payments ep', 'ep.eplus_payment_order_id = ti.ticket_session_id', 'left outer');
		
		$this->db->join('historical_tickets hit', 'hit.ticket_id = ti.ticket_id', 'left outer');
		$this->db->join('users u', 'u.user_id = hit.ticket_user_id', 'left outer');
		$this->db->join('branches b', 'b.branch_id = hit.ticket_branch_id', 'left outer');
		
		// if ($action == 'online' || $action == 'online_void')
		// {
			// $this->db->join($this->branches, 'br.branch_id = t.transaction_branch_id', 'left outer');
		// }
		// else 
		// {
			// $this->db->join($this->branches, 'br.branch_id = ti.ticket_branch_id', 'left outer');
		// }
		//$this->db->join($this->payments, 'pay.payment_transaction_id = t.transaction_id', 'left outer');
		//$this->db->join($this->payment_types, 'pt.payment_type_id = pay.payment_payment_type_id', 'left outer');
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left outer');
		$this->db->where('(((date(vt.voided_date) >= "' . $date_from . '") AND (date(vt.voided_date) <= "' . $date_to . '")) OR ((date(vt.voided_date) >="' . $date_from . '") AND (date(vt.voided_date) <= "' . $date_to . '")))');
		//$this->db->where('pay.payment_amount_type', 'tickets');
		/* if ($action == false || $action == 'online_void' || $action == 'void')
		{
			//$this->db->where('t.transaction_branch_id !=', $online_branch_id);
			//$this->db->where('ti.ticket_branch_id !=	', $online_branch_id);
		}
		else 
		{
			$this->db->where('t.transaction_branch_id', $online_branch_id);
		}
		if ($action == 'online_void' || $action == 'void')
		{
			$this->db->where('ti.ticket_status in("voided", "cancelled", "reservation_cancelled", "expired")');
		}
		else
		{
			$this->db->where('ti.ticket_status in("done", "paid_online", "paid")');
		} */
		$this->db->where('hit.ticket_status', 'voided');
		$this->db->where('ut.new_transaction_id !=', '');
		$this->db->where_in('ti.ticket_id', $tickets);
		$this->db->order_by('(CASE WHEN t.transaction_branch_id IS NULL THEN ti.ticket_branch_id ELSE t.transaction_branch_id END), date(t.transaction_date), t.transaction_user_id, ti.ticket_event_id, t.transaction_id, ti.ticket_acknowledgment_receipt, ti.ticket_type_id');
		
		$this->db->group_by('ti.ticket_id');
		// $query = $this->db->get('tickets ti');
		$query = $this->db->get('tickets ti');
		// echo $this->db->last_query();
		
		// die();
		return $query->result();
	}
	
}		
// END reports_model.php
/* Location: ./application/models/reports_model.php */		
