<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class promo_codes_model extends CI_Model
{
	var $seatplans = 'seatplans s';
	var $venues = 'venues v';
	var $prices = 'prices pc';
	var $events = 'events e';	 
	
	/**
	 * Constructor
	 *
	 * @access	public
	 */
	public function __construct()
	{
		parent::__construct();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_prices
	 *
	 * @access	public
	 */
	function get_promo_codes($event_id = false)
	{
		if ($event_id)
		{
			$this->db->where('pc.promo_code_event_id', $event_id);
		}
 		$this->db->order_by('pc.promo_code_name', 'desc'); 
		$query = $this->db->get('promo_codes pc');
		//echo $this->db->last_query();
		
		return $query->result();
	}
	
   
 	function add($event_id = false)
	{
		$fields = array(
			'promo_code_event_id'			=> $event_id,
			'promo_code_name'				=> $this->input->post('promo_code_name'),
			'promo_code_code'				=> $this->input->post('promo_code_code'),
			'promo_code_qty'				=> $this->input->post('promo_code_qty'),
			'promo_code_ticket_type'		=> $this->input->post('ticket_type'),
			'promo_code_prices'				=> serialize($this->input->post('promo_code_prices')),
			'promo_code_date_from'			=> $this->input->post('date_from'),
			'promo_code_date_to'			=> $this->input->post('date_to'),
		);
		
		// insert to db
		$this->db->set($fields);
		$this->db->insert('promo_codes');
		
		return true;
	}
	
	function edit($promo_code_id = false)
	{
		$fields = array(
 			'promo_code_name'				=> $this->input->post('promo_code_name'),
			'promo_code_code'				=> $this->input->post('promo_code_code'),
			'promo_code_qty'				=> $this->input->post('promo_code_qty'),
			'promo_code_ticket_type'		=> $this->input->post('ticket_type'),
			'promo_code_prices'				=> serialize($this->input->post('promo_code_prices')),
			'promo_code_date_from'			=> $this->input->post('date_from'),
			'promo_code_date_to'			=> $this->input->post('date_to'),
		);
		
		// update db
		$this->db->where('promo_code_id', $promo_code_id);
		$this->db->update('promo_codes', $fields);
		
		return true;
	}
 
 	function get($promo_code_id = false)
	{
		$this->db->where('promo_code_id', $promo_code_id);
		$this->db->join($this->events, 'pc.promo_code_event_id = e.event_id', 'left');
		$query = $this->db->get('promo_codes pc');
		//echo $this->db->last_query();
		
		return $query->row();
	}
  
	function delete($promo_code_id = false)
	{
		$this->db->delete('promo_codes', array('promo_code_id' => $promo_code_id));
		
		return true;
	}

}
// END prices_model.php
/* Location: ./application/models/prices_model.php */		
