<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Prices_model extends CI_Model
{
	var $seatplans = 'seatplans s';
	var $venues = 'venues v';
	var $prices = 'prices pc';
	var $events = 'events e';	
	
	/**
	 * Constructor
	 *
	 * @access	public
	 */
	public function __construct()
	{
		parent::__construct();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_prices
	 *
	 * @access	public
	 */
	function get_prices($event_id = false)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		if ($event_id)
		{
			$this->db->where('pc.price_event_id', $event_id);
		}
		$this->db->join($this->events, 'pc.price_event_id = e.event_id', 'left');
		$this->db->order_by('pc.price_price', 'desc'); 
		$query = $this->db->get($this->prices);
		//echo $this->db->last_query();
		
		return $query->result();
	}
	
	function get_prices_compact($event_id = false)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('pc.price_id,pc.price_name, pc.price_sections, pc.price_price');
		if ($event_id)
		{
			$this->db->where('pc.price_event_id', $event_id);
		}
		
		if (!in_array($this->session->userdata('user_type'), array('Admin','Super Admin','Admin2'))){
			$this->db->where('pc.price_hidden_otc ', 0);
			
		}
		
		
		$this->db->join($this->events, 'pc.price_event_id = e.event_id', 'left');
		$this->db->order_by('pc.price_price', 'desc'); 
		$query = $this->db->get($this->prices);
		//echo $this->db->last_query();
		
		return $query->result();
	}
	
		function get_used_sections($event_id = false,$price_id=false)
	{
		$this->db->select('pc.price_sections');
		if ($event_id)
		{
			$this->db->where('pc.price_event_id', $event_id);
		}	
		if ($price_id)
		{
			$this->db->where('pc.price_id <>', $price_id);
		}
		$this->db->join($this->events, 'pc.price_event_id = e.event_id', 'left');
		$this->db->order_by('pc.price_price', 'desc'); 
		$query = $this->db->get($this->prices);

		//echo $this->db->last_query();
		$UsedSections = $query->result();		
		
		
		$newArr = array();
		$arrayMerge = array();
		foreach ($UsedSections as $value)
		  {
			$newArr[] = unserialize($value->price_sections);
		  }
		  for($i=0;$i< count($newArr);$i++){			  
		  $arrayMerge = array_merge($arrayMerge,$newArr[$i]);
		  
		  }
		return $arrayMerge;
	}	
	
	
	function get_prices_tiny($event_id = false)
	{
		$this->db->select('pc.price_name');
		if ($event_id)
		{
			$this->db->where('pc.price_event_id', $event_id);
		}
		$this->db->join($this->events, 'pc.price_event_id = e.event_id', 'left');
		$this->db->order_by('pc.price_price', 'desc'); 
		$query = $this->db->get($this->prices);
		//echo $this->db->last_query();
		
		return $query->result();
	}
	
	
	// --------------------------------------------------------------------
	
	/**
	 * get_price_id
	 *
	 * @access	public
	 */
	function get_price_id($event_id, $section_id)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->where('price_event_id', $event_id);
		$query = $this->db->get($this->prices);
		$prices = $query->result();
		foreach ($prices as $price)
		{
			$sections = unserialize($price->price_sections);
			if (in_array($section_id, $sections))
			{
				return $price->price_id;
			}
		}
		return false;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_prices
	 *
	 * @access	public
	 */
	function count_prices($event_id = false)
	{
	$this->db->count_all_results();
		if ($event_id)
		{
			$this->db->where('pc.price_event_id', $event_id);
		}
		$this->db->join($this->events, 'pc.price_event_id = e.event_id', 'left');
		$this->db->order_by('pc.price_price', 'desc'); 
		
		
		$query = $this->db->get($this->prices);
		//echo $this->db->last_query();
		
		return $query;
	}
		
	// --------------------------------------------------------------------
	
	/**
	 * get_price_category
	 *
	 * @access	public
	 */
	function get($price_id)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->where('price_id', $price_id);
		$this->db->join($this->events, 'pc.price_event_id = e.event_id', 'left');
		$query = $this->db->get($this->prices);
		//echo $this->db->last_query();
		
		return $query->row();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_price_category
	 *
	 * @access	public
	 */
	function get2($price_id)
	{
		$this->db->where('price_event_id', $price_id);
		$this->db->join($this->events, 'pc.price_event_id = e.event_id', 'left');
		$query = $this->db->get($this->prices);
		//echo $this->db->last_query();
		
		return $query->row();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_prices_dropdown
	 *
	 * @access	public
	 */
	function get_prices_dropdown()
	{
		$query = $this->db->get($this->prices);
			
		$result = $query->result();

		if ($result)
		{
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->price_id] = $r->price_name . ' (' . $r->price_price . ')';
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}
	
	function get_prices_dropdown_for_promo($event_id = false)
	{
		$this->db->where('price_event_id', $event_id);
		$query = $this->db->get($this->prices);
			
		$result = $query->result();

		if ($result)
		{
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->price_id] = $r->price_name;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_serial_number
	 *
	 * @access	public
	 */
	function get_serial_number($price_id)
	{
		// get last serial number
		$this->db->select('price_serial_last');
		$this->db->where('price_id', $price_id);
		$query = $this->db->get($this->prices);
		$row = $query->row();
		
		$next_serial_number = $row->price_serial_last += 1;
		
		// update last serial number
		$this->db->where('price_id', $price_id);
		$this->db->update($this->prices, array('price_serial_last' => $next_serial_number));
		
		return $next_serial_number;
	}
	
	
	// --------------------------------------------------------------------
	
	/**
	 * add
	 *
	 */
	function add($event_id)
	{
		$fields = array(
			'price_event_id'	=> $event_id,
			'price_name'		=> $this->input->post('price_name'),
			'price_price'		=> $this->input->post('price_price'),
			'price_package'		=> $this->input->post('price_package'),
			'price_sections'	=> serialize($this->input->post('price_sections')),
		);
		
		// insert to db
		$this->db->set($fields);
		$this->db->insert('prices');
		
		return true;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * edit
	 *
	 */
	function edit($price_id)
	{
		$fields = array(
			'price_name'		=> $this->input->post('price_name'),
			'price_price'		=> $this->input->post('price_price'),
			'price_package'		=> $this->input->post('price_package'),
			'price_sections'	=> serialize($this->input->post('price_sections')),
			'price_hidden_online' => $this->input->post('price_hidden_online'),
			'price_hidden_otc' => $this->input->post('price_hidden_otc')
		);
		
		// update db
		$this->db->where('price_id', $price_id);
		$this->db->update($this->prices, $fields);
		
		return true;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * delete
	 *
	 */
	function delete($price_id)
	{
		$this->db->delete('prices', array('price_id' => $price_id));
		
		return true;
	}

	function get_array($event_id = 0)
	{
		$result = array();

		if ($event_id > 0)
		{
			$this->db->where('pc.price_event_id', $event_id);
			// $this->db->join($this->events, 'pc.price_event_id = e.event_id', 'left');
			$this->db->order_by('pc.price_price', 'desc'); 
			$query = $this->db->get($this->prices);
			
			// transform result into an associative array
			foreach($query->result() as $r)
			{
				$result[$r->price_id] = $r->price_name . ' (' . $r->price_price . ' pesos)';
				}
		}
		return $result;
	}
	
	function get_selected_price_names($event_id, $prices)
	{	
		$array = array();
		
		if (!$prices)
		{
			return false;
		}
		
		$this->db->where('price_event_id', $event_id);
		$query = $this->db->get('prices');
			
		$result = $query->result();

		if ($result)
		{
			// transform result to csv
			$prices = unserialize($prices);

			if ($prices) 
			{
				foreach($result as $r)
				{
					if (in_array($r->price_id, $prices))
						$array[$r->price_id] = $r->price_name;
				}
				
				return $array;
			}
			else
				return false;
		}
		else
			return false;
	}
	
	function get_used_dates($event_id,$price_date_id=false){
		
		$array = '';
		$this->db->select('price_event_date_dates');
		if($price_date_id){$this->db->where('price_event_date_id !=', $price_date_id);}
		$this->db->where('price_event_date_event_id', $event_id);
		// $this->db->where('price_event_date_status', 1);
		$query = $this->db->get('price_event_dates');
			
		$count = $query->num_rows();
		
		if($count == 1){
			$result = $query->row();
			return $result->price_event_date_dates;
		}else if($count > 1){
			$result = $query->result();
			foreach($result as $r){
				if($array == ''){
					$array = $r->price_event_date_dates;
				}else{
					$array = $array . "," . $r->price_event_date_dates;
				}
				
			}
			return $array;
		}else{
			return false;
		}
		
	}
	
	function add_price_date($event_id){
		
		$fields = array(
			'price_event_date_event_id'	=> $event_id,
			'price_event_date_name'		=> $this->input->post('price_event_date_name'),
			'price_event_date_price_id'	=> serialize($this->input->post('price_event_date_price_id')),
			'price_event_date_dates'	=> $this->input->post('price_event_date_date'),
			'price_event_date_status'	=> '1',
			
		);
		
		// insert to db
		$this->db->set($fields);
		$this->db->insert('price_event_dates');
		
		return true;
	}
	
	function edit_price_date($event_id,$price_date_id){
		
		$dates = explode(",",$this->input->post('price_event_date_date'));
		
		foreach ($dates as $i => $d){
			if(strtotime($d) < strtotime(date("m/d/Y"))){
				unset($dates[$i]);
			}
		}
		
		$fields = array(
			'price_event_date_event_id'	=> $event_id,
			'price_event_date_name'		=> $this->input->post('price_event_date_name'),
			'price_event_date_price_id'	=> serialize($this->input->post('price_event_date_price_id')),
			'price_event_date_dates'	=> implode(",",$dates)
			
		);
		
		// update db	
		$this->db->where('price_event_date_id', $price_date_id);
		$this->db->update('price_event_dates', $fields);
		
		return true;
	}
	
	function get_price_dates($event_id,$event_date=false)
	{
		$this->db->query('set transaction isolation level read uncommitted');	
		if ($event_id)
		{
			$this->db->where('ped.price_event_date_event_id', $event_id);
		}
		if($event_date){
			$this->db->like('ped.price_event_date_dates',$event_date);
			$this->db->where('ped.price_event_date_status',1);
		}
		// $this->db->join($this->events, 'ped.price_event_date_event_id = e.event_id', 'left');
		$this->db->order_by('ped.price_event_date_name', 'asc'); 
		$query = $this->db->get('price_event_dates ped');
		//echo $this->db->last_query();
		
		if($query->result()){
			return $query->result();
		}else{
			return false;
		}
		
	}
	
	function edit_status($status,$price_dates_id){
		
		if($status == TRUE){
			$change = '0';
		}else{
			$change = '1';
		}
		
		$fields = array(
			'price_event_date_status'	=> $change,
		);
		
		// update db
		$this->db->where('price_event_date_id', $price_dates_id);
		$this->db->update('price_event_dates', $fields);
		
		return true;
	}

	function get_price_date_info($price_date_id){
		
		$this->db->where('ped.price_event_date_id', $price_date_id);
		$query = $this->db->get('price_event_dates ped');
		//echo $this->db->last_query();
		
		return $query->row();
	}
	
	function delete_price_date($price_date_id){
		
		$this->db->delete('price_event_dates', array('price_event_date_id' => $price_date_id));
		
		return true;
	}
	
	
	function get_prices_compact2($event_id = false)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('pc.price_id,pc.price_name, pc.price_sections, pc.price_price');
		if ($event_id)
		{
			$this->db->where('pc.price_event_id', $event_id);
		}
		
		// if (!in_array($this->session->userdata('user_type'), array('Admin','Super Admin','Admin2'))){
			// $this->db->where('pc.price_hidden_otc ', 0);
			
		// }
		
		
		$this->db->join($this->events, 'pc.price_event_id = e.event_id', 'left');
		$this->db->order_by('pc.price_price', 'desc'); 
		$query = $this->db->get($this->prices);
		//echo $this->db->last_query();
		
		return $query->result();
	}
	
}
// END prices_model.php
/* Location: ./application/models/prices_model.php */		

