<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Poster_model extends CI_Model
{
	
	var $users = 'users u';
	var $promoters = 'promoters p';
	var $venues = 'venues v';
	var $branches = 'branches o';
	var $poster = 'poster pr';
		
	
	/**
	 * Constructor
	 *
	 * @access	public
	 */
	public function __construct()
	{
		parent::__construct();
	}

	// --------------------------------------------------------------------
	
	/**
	 * get_logos
	 *
	 * @access	public
	 */
	function get_poster_active()
	{
		$this->db->where('poster_status','yes');
		$query = $this->db->get($this->poster);
		
		return $query->result();
	}
	
	function get_poster_inactive()
	{
		$this->db->where('poster_status','no');
		$query = $this->db->get($this->poster);
		
		return $query->result();
	}
	
	function get_poster()
	{
		$query = $this->db->get($this->poster);
		
		return $query->result();
	}
		
	// --------------------------------------------------------------------
	
	/**
	 * get_logos_dropdown
	 *
	 * @access	public
	 */
	function get_poster_dropdown()
	{
		$query = $this->db->get($this->poster);
			
		$result = $query->result();

		if ($result)
		{
			// transform result into an associative array
			$array[0] = 'None';
			foreach($result as $r)
			{
				$array[$r->poster_id] = $r->event_title;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * upload
	 *
	 */
	function upload($filename, $image_path, $filewh, $filesize)
	{
		$fields = array(
			'poster_path'		=> $image_path,
			'poster_filename'	=> $filename,
			'poster_wh'			=> $filewh,
			'poster_filesize'	=> $filesize,
			'event_title'		=> $this->input->post('event_title'),
		);
		
		// insert to db
		$this->db->set($fields);
		$this->db->insert('poster');
		
		return true;
	}	
	
	// --------------------------------------------------------------------
	
	/**
	 * delete
	 *
	 */
	function delete($poster_id)
	{
		$this->db->where('poster_id', $poster_id);
      	$this->db->select('poster_path');
      	$query = $this->db->get('poster');
      	foreach($query->result() as $item)  
      	{
      		$old_image_path =$item->poster_path;
      	}
      	unlink('./uploads/'.$old_image_path);
      	$this->db->where('poster_id', $poster_id);
		$this->db->delete('poster', array('poster_id' => $poster_id));
		return true;
	}	
	
	/**
	 * recommend
	 *
	 */
	function active($poster_id)
	{
		$this->db->where('poster_id', $poster_id);
		$this->db->update($this->poster, array('poster_status'=>'yes') );
		
		return true;
	}
	
	/**
	 * recommend
	 *
	 */
	function inactive($poster_id)
	{
		$this->db->where('poster_id', $poster_id);
		$this->db->update($this->poster, array('poster_status'=>'no') );
		
		return true;
	}
}

// END logos_model.php
/* Location: ./application/models/logos_model.php */	